# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class ActivationProperties(_serialization.Model):
    """The activation properties of the connected registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The activation status of the connected registry. Known values are: "Active" and
     "Inactive".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ActivationStatus
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.ActivationStatus"]] = None


class ActiveDirectoryObject(_serialization.Model):
    """The Active Directory Object that will be used for authenticating the token of a container
    registry.

    :ivar object_id: The user/group/application object ID for Active Directory Object that will be
     used for authenticating the token of a container registry.
    :vartype object_id: str
    :ivar tenant_id: The tenant ID of user/group/application object Active Directory Object that
     will be used for authenticating the token of a container registry.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "object_id": {"key": "objectId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, object_id: Optional[str] = None, tenant_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword object_id: The user/group/application object ID for Active Directory Object that will
         be used for authenticating the token of a container registry.
        :paramtype object_id: str
        :keyword tenant_id: The tenant ID of user/group/application object Active Directory Object that
         will be used for authenticating the token of a container registry.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class Actor(_serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization
    context of the request.

    :ivar name: The subject or username associated with the request context that generated the
     event.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The subject or username associated with the request context that generated the
         event.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags
        self.system_data: Optional["_models.SystemData"] = None


class AgentPool(Resource):
    """The agentpool that has the ARM resource and properties.
    The agentpool will have all information to create an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar count: The count of agent machine.
    :vartype count: int
    :ivar tier: The Tier of agent machine.
    :vartype tier: str
    :ivar os: The OS of agent machine. Known values are: "Windows" and "Linux".
    :vartype os: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OS
    :ivar virtual_network_subnet_resource_id: The Virtual Network Subnet Resource Id of the agent
     machine.
    :vartype virtual_network_subnet_resource_id: str
    :ivar provisioning_state: The provisioning state of this agent pool. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "count": {"key": "properties.count", "type": "int"},
        "tier": {"key": "properties.tier", "type": "str"},
        "os": {"key": "properties.os", "type": "str"},
        "virtual_network_subnet_resource_id": {"key": "properties.virtualNetworkSubnetResourceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        count: Optional[int] = None,
        tier: Optional[str] = None,
        os: Optional[Union[str, "_models.OS"]] = None,
        virtual_network_subnet_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword count: The count of agent machine.
        :paramtype count: int
        :keyword tier: The Tier of agent machine.
        :paramtype tier: str
        :keyword os: The OS of agent machine. Known values are: "Windows" and "Linux".
        :paramtype os: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OS
        :keyword virtual_network_subnet_resource_id: The Virtual Network Subnet Resource Id of the
         agent machine.
        :paramtype virtual_network_subnet_resource_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.count = count
        self.tier = tier
        self.os = os
        self.virtual_network_subnet_resource_id = virtual_network_subnet_resource_id
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class AgentPoolListResult(_serialization.Model):
    """The collection of agent pools.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentPool]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AgentPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AgentPool"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentPool]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AgentPoolQueueStatus(_serialization.Model):
    """The QueueStatus of Agent Pool.

    :ivar count: The number of pending runs in the queue.
    :vartype count: int
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword count: The number of pending runs in the queue.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class AgentPoolUpdateParameters(_serialization.Model):
    """The parameters for updating an agent pool.

    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar count: The count of agent machine.
    :vartype count: int
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "count": {"key": "properties.count", "type": "int"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword count: The count of agent machine.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.count = count


class AgentProperties(_serialization.Model):
    """The properties that determine the run agent configuration.

    :ivar cpu: The CPU configuration in terms of number of cores required for the run.
    :vartype cpu: int
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "int"},
    }

    def __init__(self, *, cpu: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: The CPU configuration in terms of number of cores required for the run.
        :paramtype cpu: int
        """
        super().__init__(**kwargs)
        self.cpu = cpu


class ProxyResource(_serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class Archive(ProxyResource):
    """An object that represents a archive for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar package_source: The package source of the archive.
    :vartype package_source:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchivePackageSourceProperties
    :ivar published_version: The published version of the archive.
    :vartype published_version: str
    :ivar repository_endpoint_prefix:
    :vartype repository_endpoint_prefix: str
    :ivar repository_endpoint:
    :vartype repository_endpoint: str
    :ivar provisioning_state: The provisioning state of the archive at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "repository_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "package_source": {"key": "properties.packageSource", "type": "ArchivePackageSourceProperties"},
        "published_version": {"key": "properties.publishedVersion", "type": "str"},
        "repository_endpoint_prefix": {"key": "properties.repositoryEndpointPrefix", "type": "str"},
        "repository_endpoint": {"key": "properties.repositoryEndpoint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_source: Optional["_models.ArchivePackageSourceProperties"] = None,
        published_version: Optional[str] = None,
        repository_endpoint_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_source: The package source of the archive.
        :paramtype package_source:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchivePackageSourceProperties
        :keyword published_version: The published version of the archive.
        :paramtype published_version: str
        :keyword repository_endpoint_prefix:
        :paramtype repository_endpoint_prefix: str
        """
        super().__init__(**kwargs)
        self.package_source = package_source
        self.published_version = published_version
        self.repository_endpoint_prefix = repository_endpoint_prefix
        self.repository_endpoint: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ArchiveListResult(_serialization.Model):
    """The result of a request to list archives for a container registry.

    :ivar value: The list of archives. Since this list may be incomplete, the nextLink field should
     be used to request the next list of distributions.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Archive]
    :ivar next_link: The URI that can be used to request the next list of archives.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Archive]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Archive"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of archives. Since this list may be incomplete, the nextLink field
         should be used to request the next list of distributions.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Archive]
        :keyword next_link: The URI that can be used to request the next list of archives.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ArchivePackageSourceProperties(_serialization.Model):
    """The properties of the archive package source.

    :ivar type: The type of package source for a archive. "remote"
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PackageSourceType
    :ivar url: The external repository url.
    :vartype url: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "url": {"key": "url", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.PackageSourceType"]] = None,
        url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of package source for a archive. "remote"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PackageSourceType
        :keyword url: The external repository url.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.url = url


class ArchiveProperties(_serialization.Model):
    """The properties of a archive.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar package_source: The package source of the archive.
    :vartype package_source:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchivePackageSourceProperties
    :ivar published_version: The published version of the archive.
    :vartype published_version: str
    :ivar repository_endpoint_prefix:
    :vartype repository_endpoint_prefix: str
    :ivar repository_endpoint:
    :vartype repository_endpoint: str
    :ivar provisioning_state: The provisioning state of the archive at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "repository_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "package_source": {"key": "packageSource", "type": "ArchivePackageSourceProperties"},
        "published_version": {"key": "publishedVersion", "type": "str"},
        "repository_endpoint_prefix": {"key": "repositoryEndpointPrefix", "type": "str"},
        "repository_endpoint": {"key": "repositoryEndpoint", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_source: Optional["_models.ArchivePackageSourceProperties"] = None,
        published_version: Optional[str] = None,
        repository_endpoint_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_source: The package source of the archive.
        :paramtype package_source:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchivePackageSourceProperties
        :keyword published_version: The published version of the archive.
        :paramtype published_version: str
        :keyword repository_endpoint_prefix:
        :paramtype repository_endpoint_prefix: str
        """
        super().__init__(**kwargs)
        self.package_source = package_source
        self.published_version = published_version
        self.repository_endpoint_prefix = repository_endpoint_prefix
        self.repository_endpoint: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ArchiveUpdateParameters(_serialization.Model):
    """The parameters for updating a archive.

    :ivar published_version: The published version of the archive.
    :vartype published_version: str
    """

    _attribute_map = {
        "published_version": {"key": "properties.publishedVersion", "type": "str"},
    }

    def __init__(self, *, published_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword published_version: The published version of the archive.
        :paramtype published_version: str
        """
        super().__init__(**kwargs)
        self.published_version = published_version


class ArchiveVersion(ProxyResource):
    """An object that represents an export pipeline for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar provisioning_state: The provisioning state of the archive at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar archive_version_error_message: The detailed error message for the archive version in the
     case of failure.
    :vartype archive_version_error_message: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "archive_version_error_message": {"key": "properties.archiveVersionErrorMessage", "type": "str"},
    }

    def __init__(self, *, archive_version_error_message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword archive_version_error_message: The detailed error message for the archive version in
         the case of failure.
        :paramtype archive_version_error_message: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.archive_version_error_message = archive_version_error_message


class ArchiveVersionListResult(_serialization.Model):
    """The result of a request to list export pipelines for a container registry.

    :ivar value: The list of export pipelines. Since this list may be incomplete, the nextLink
     field should be used to request the next list of export pipelines.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchiveVersion]
    :ivar next_link: The URI that can be used to request the next list of pipeline runs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ArchiveVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ArchiveVersion"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of export pipelines. Since this list may be incomplete, the nextLink
         field should be used to request the next list of export pipelines.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchiveVersion]
        :keyword next_link: The URI that can be used to request the next list of pipeline runs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Argument(_serialization.Model):
    """The properties of a run argument.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the argument. Required.
    :vartype name: str
    :ivar value: The value of the argument. Required.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :vartype is_secret: bool
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "is_secret": {"key": "isSecret", "type": "bool"},
    }

    def __init__(self, *, name: str, value: str, is_secret: bool = False, **kwargs: Any) -> None:
        """
        :keyword name: The name of the argument. Required.
        :paramtype name: str
        :keyword value: The value of the argument. Required.
        :paramtype value: str
        :keyword is_secret: Flag to indicate whether the argument represents a secret and want to be
         removed from build logs.
        :paramtype is_secret: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.is_secret = is_secret


class AuthCredential(_serialization.Model):
    """Authentication credential stored for an upstream.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential. "Credential1"
    :vartype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialName
    :ivar username_secret_identifier: KeyVault Secret URI for accessing the username.
    :vartype username_secret_identifier: str
    :ivar password_secret_identifier: KeyVault Secret URI for accessing the password.
    :vartype password_secret_identifier: str
    :ivar credential_health: This provides data pertaining to the health of the auth credential.
    :vartype credential_health:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialHealth
    """

    _validation = {
        "credential_health": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "username_secret_identifier": {"key": "usernameSecretIdentifier", "type": "str"},
        "password_secret_identifier": {"key": "passwordSecretIdentifier", "type": "str"},
        "credential_health": {"key": "credentialHealth", "type": "CredentialHealth"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.CredentialName"]] = None,
        username_secret_identifier: Optional[str] = None,
        password_secret_identifier: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the credential. "Credential1"
        :paramtype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialName
        :keyword username_secret_identifier: KeyVault Secret URI for accessing the username.
        :paramtype username_secret_identifier: str
        :keyword password_secret_identifier: KeyVault Secret URI for accessing the password.
        :paramtype password_secret_identifier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.username_secret_identifier = username_secret_identifier
        self.password_secret_identifier = password_secret_identifier
        self.credential_health: Optional["_models.CredentialHealth"] = None


class AuthInfo(_serialization.Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to server.

    :ivar token_type: The type of Auth token. Required. Known values are: "PAT" and "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenType
    :ivar token: The access token used to access the source control provider. Required.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    _validation = {
        "token_type": {"required": True},
        "token": {"required": True},
    }

    _attribute_map = {
        "token_type": {"key": "tokenType", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "expires_in": {"key": "expiresIn", "type": "int"},
    }

    def __init__(
        self,
        *,
        token_type: Union[str, "_models.TokenType"],
        token: str,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword token_type: The type of Auth token. Required. Known values are: "PAT" and "OAuth".
        :paramtype token_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenType
        :keyword token: The access token used to access the source control provider. Required.
        :paramtype token: str
        :keyword refresh_token: The refresh token used to refresh the access token.
        :paramtype refresh_token: str
        :keyword scope: The scope of the access token.
        :paramtype scope: str
        :keyword expires_in: Time in seconds that the token remains valid.
        :paramtype expires_in: int
        """
        super().__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class AuthInfoUpdateParameters(_serialization.Model):
    """The authorization properties for accessing the source code repository.

    :ivar token_type: The type of Auth token. Known values are: "PAT" and "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenType
    :ivar token: The access token used to access the source control provider.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    _attribute_map = {
        "token_type": {"key": "tokenType", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "expires_in": {"key": "expiresIn", "type": "int"},
    }

    def __init__(
        self,
        *,
        token_type: Optional[Union[str, "_models.TokenType"]] = None,
        token: Optional[str] = None,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword token_type: The type of Auth token. Known values are: "PAT" and "OAuth".
        :paramtype token_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenType
        :keyword token: The access token used to access the source control provider.
        :paramtype token: str
        :keyword refresh_token: The refresh token used to refresh the access token.
        :paramtype refresh_token: str
        :keyword scope: The scope of the access token.
        :paramtype scope: str
        :keyword expires_in: Time in seconds that the token remains valid.
        :paramtype expires_in: int
        """
        super().__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class AzureADAuthenticationAsArmPolicy(_serialization.Model):
    """The policy for using ARM audience token for a container registry.

    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AzureADAuthenticationAsArmPolicyStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, status: Union[str, "_models.AzureADAuthenticationAsArmPolicyStatus"] = "enabled", **kwargs: Any
    ) -> None:
        """
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AzureADAuthenticationAsArmPolicyStatus
        """
        super().__init__(**kwargs)
        self.status = status


class BaseImageDependency(_serialization.Model):
    """Properties that describe a base image dependency.

    :ivar type: The type of the base image dependency. Known values are: "BuildTime" and "RunTime".
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageDependencyType
    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "registry": {"key": "registry", "type": "str"},
        "repository": {"key": "repository", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "digest": {"key": "digest", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.BaseImageDependencyType"]] = None,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the base image dependency. Known values are: "BuildTime" and
         "RunTime".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageDependencyType
        :keyword registry: The registry login server.
        :paramtype registry: str
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword digest: The sha256-based digest of the image manifest.
        :paramtype digest: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class BaseImageTrigger(_serialization.Model):
    """The trigger based on base image dependency.

    All required parameters must be populated in order to send to server.

    :ivar base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Required. Known values are: "All" and "Runtime".
    :vartype base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTriggerType
    :ivar update_trigger_endpoint: The endpoint URL for receiving update triggers.
    :vartype update_trigger_endpoint: str
    :ivar update_trigger_payload_type: Type of Payload body for Base image update triggers. Known
     values are: "Default" and "Token".
    :vartype update_trigger_payload_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.UpdateTriggerPayloadType
    :ivar status: The current status of trigger. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    _validation = {
        "base_image_trigger_type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "base_image_trigger_type": {"key": "baseImageTriggerType", "type": "str"},
        "update_trigger_endpoint": {"key": "updateTriggerEndpoint", "type": "str"},
        "update_trigger_payload_type": {"key": "updateTriggerPayloadType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        base_image_trigger_type: Union[str, "_models.BaseImageTriggerType"],
        name: str,
        update_trigger_endpoint: Optional[str] = None,
        update_trigger_payload_type: Optional[Union[str, "_models.UpdateTriggerPayloadType"]] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base_image_trigger_type: The type of the auto trigger for base image dependency
         updates. Required. Known values are: "All" and "Runtime".
        :paramtype base_image_trigger_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTriggerType
        :keyword update_trigger_endpoint: The endpoint URL for receiving update triggers.
        :paramtype update_trigger_endpoint: str
        :keyword update_trigger_payload_type: Type of Payload body for Base image update triggers.
         Known values are: "Default" and "Token".
        :paramtype update_trigger_payload_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.UpdateTriggerPayloadType
        :keyword status: The current status of trigger. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        :keyword name: The name of the trigger. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.base_image_trigger_type = base_image_trigger_type
        self.update_trigger_endpoint = update_trigger_endpoint
        self.update_trigger_payload_type = update_trigger_payload_type
        self.status = status
        self.name = name


class BaseImageTriggerUpdateParameters(_serialization.Model):
    """The properties for updating base image dependency trigger.

    All required parameters must be populated in order to send to server.

    :ivar base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Known values are: "All" and "Runtime".
    :vartype base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTriggerType
    :ivar update_trigger_endpoint: The endpoint URL for receiving update triggers.
    :vartype update_trigger_endpoint: str
    :ivar update_trigger_payload_type: Type of Payload body for Base image update triggers. Known
     values are: "Default" and "Token".
    :vartype update_trigger_payload_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.UpdateTriggerPayloadType
    :ivar status: The current status of trigger. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "base_image_trigger_type": {"key": "baseImageTriggerType", "type": "str"},
        "update_trigger_endpoint": {"key": "updateTriggerEndpoint", "type": "str"},
        "update_trigger_payload_type": {"key": "updateTriggerPayloadType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        base_image_trigger_type: Optional[Union[str, "_models.BaseImageTriggerType"]] = None,
        update_trigger_endpoint: Optional[str] = None,
        update_trigger_payload_type: Optional[Union[str, "_models.UpdateTriggerPayloadType"]] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base_image_trigger_type: The type of the auto trigger for base image dependency
         updates. Known values are: "All" and "Runtime".
        :paramtype base_image_trigger_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTriggerType
        :keyword update_trigger_endpoint: The endpoint URL for receiving update triggers.
        :paramtype update_trigger_endpoint: str
        :keyword update_trigger_payload_type: Type of Payload body for Base image update triggers.
         Known values are: "Default" and "Token".
        :paramtype update_trigger_payload_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.UpdateTriggerPayloadType
        :keyword status: The current status of trigger. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        :keyword name: The name of the trigger. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.base_image_trigger_type = base_image_trigger_type
        self.update_trigger_endpoint = update_trigger_endpoint
        self.update_trigger_payload_type = update_trigger_payload_type
        self.status = status
        self.name = name


class CacheRule(ProxyResource):
    """An object that represents a cache rule for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar credential_set_resource_id: The ARM resource ID of the credential store which is
     associated with the cache rule.
    :vartype credential_set_resource_id: str
    :ivar source_repository: Source repository pulled from upstream.
    :vartype source_repository: str
    :ivar target_repository: Target repository specified in docker pull command.
     Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
    :vartype target_repository: str
    :ivar creation_date: The creation date of the cache rule.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "credential_set_resource_id": {"key": "properties.credentialSetResourceId", "type": "str"},
        "source_repository": {"key": "properties.sourceRepository", "type": "str"},
        "target_repository": {"key": "properties.targetRepository", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        credential_set_resource_id: Optional[str] = None,
        source_repository: Optional[str] = None,
        target_repository: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword credential_set_resource_id: The ARM resource ID of the credential store which is
         associated with the cache rule.
        :paramtype credential_set_resource_id: str
        :keyword source_repository: Source repository pulled from upstream.
        :paramtype source_repository: str
        :keyword target_repository: Target repository specified in docker pull command.
         Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
        :paramtype target_repository: str
        """
        super().__init__(**kwargs)
        self.credential_set_resource_id = credential_set_resource_id
        self.source_repository = source_repository
        self.target_repository = target_repository
        self.creation_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class CacheRulesListResult(_serialization.Model):
    """The result of a request to list cache rules for a container registry.

    :ivar value: The list of cache rules.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.CacheRule]
    :ivar next_link: If provided, client must use NextLink URI to request next list of cache rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CacheRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CacheRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of cache rules.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.CacheRule]
        :keyword next_link: If provided, client must use NextLink URI to request next list of cache
         rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CacheRuleUpdateParameters(_serialization.Model):
    """The parameters for updating a cache rule.

    :ivar credential_set_resource_id: The ARM resource ID of the credential store which is
     associated with the Cache rule.
    :vartype credential_set_resource_id: str
    """

    _attribute_map = {
        "credential_set_resource_id": {"key": "properties.credentialSetResourceId", "type": "str"},
    }

    def __init__(self, *, credential_set_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword credential_set_resource_id: The ARM resource ID of the credential store which is
         associated with the Cache rule.
        :paramtype credential_set_resource_id: str
        """
        super().__init__(**kwargs)
        self.credential_set_resource_id = credential_set_resource_id


class CallbackConfig(_serialization.Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to server.

    :ivar service_uri: The service URI for the webhook to post notifications. Required.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    """

    _validation = {
        "service_uri": {"required": True},
    }

    _attribute_map = {
        "service_uri": {"key": "serviceUri", "type": "str"},
        "custom_headers": {"key": "customHeaders", "type": "{str}"},
    }

    def __init__(self, *, service_uri: str, custom_headers: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword service_uri: The service URI for the webhook to post notifications. Required.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        """
        super().__init__(**kwargs)
        self.service_uri = service_uri
        self.custom_headers = custom_headers


class ConnectedRegistry(ProxyResource):
    """An object that represents a connected registry for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar mode: The mode of the connected registry resource that indicates the permissions of the
     registry. Known values are: "ReadWrite", "ReadOnly", "Registry", and "Mirror".
    :vartype mode: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectedRegistryMode
    :ivar version: The current version of ACR runtime on the connected registry.
    :vartype version: str
    :ivar connection_state: The current connection state of the connected registry. Known values
     are: "Online", "Offline", "Syncing", and "Unhealthy".
    :vartype connection_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectionState
    :ivar last_activity_time: The last activity time of the connected registry.
    :vartype last_activity_time: ~datetime.datetime
    :ivar activation: The activation properties of the connected registry.
    :vartype activation:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ActivationProperties
    :ivar parent: The parent of the connected registry.
    :vartype parent: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ParentProperties
    :ivar client_token_ids: The list of the ACR token resource IDs used to authenticate clients to
     the connected registry.
    :vartype client_token_ids: list[str]
    :ivar login_server: The login server properties of the connected registry.
    :vartype login_server:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LoginServerProperties
    :ivar logging: The logging properties of the connected registry.
    :vartype logging: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LoggingProperties
    :ivar status_details: The list of current statuses of the connected registry.
    :vartype status_details:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.StatusDetailProperties]
    :ivar notifications_list: The list of notifications subscription information for the connected
     registry.
    :vartype notifications_list: list[str]
    :ivar garbage_collection: The garbage collection properties of the connected registry.
    :vartype garbage_collection:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.GarbageCollectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "version": {"readonly": True},
        "connection_state": {"readonly": True},
        "last_activity_time": {"readonly": True},
        "activation": {"readonly": True},
        "status_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "connection_state": {"key": "properties.connectionState", "type": "str"},
        "last_activity_time": {"key": "properties.lastActivityTime", "type": "iso-8601"},
        "activation": {"key": "properties.activation", "type": "ActivationProperties"},
        "parent": {"key": "properties.parent", "type": "ParentProperties"},
        "client_token_ids": {"key": "properties.clientTokenIds", "type": "[str]"},
        "login_server": {"key": "properties.loginServer", "type": "LoginServerProperties"},
        "logging": {"key": "properties.logging", "type": "LoggingProperties"},
        "status_details": {"key": "properties.statusDetails", "type": "[StatusDetailProperties]"},
        "notifications_list": {"key": "properties.notificationsList", "type": "[str]"},
        "garbage_collection": {"key": "properties.garbageCollection", "type": "GarbageCollectionProperties"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.ConnectedRegistryMode"]] = None,
        parent: Optional["_models.ParentProperties"] = None,
        client_token_ids: Optional[List[str]] = None,
        login_server: Optional["_models.LoginServerProperties"] = None,
        logging: Optional["_models.LoggingProperties"] = None,
        notifications_list: Optional[List[str]] = None,
        garbage_collection: Optional["_models.GarbageCollectionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: The mode of the connected registry resource that indicates the permissions of
         the registry. Known values are: "ReadWrite", "ReadOnly", "Registry", and "Mirror".
        :paramtype mode: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectedRegistryMode
        :keyword parent: The parent of the connected registry.
        :paramtype parent: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ParentProperties
        :keyword client_token_ids: The list of the ACR token resource IDs used to authenticate clients
         to the connected registry.
        :paramtype client_token_ids: list[str]
        :keyword login_server: The login server properties of the connected registry.
        :paramtype login_server:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LoginServerProperties
        :keyword logging: The logging properties of the connected registry.
        :paramtype logging: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LoggingProperties
        :keyword notifications_list: The list of notifications subscription information for the
         connected registry.
        :paramtype notifications_list: list[str]
        :keyword garbage_collection: The garbage collection properties of the connected registry.
        :paramtype garbage_collection:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.GarbageCollectionProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.mode = mode
        self.version: Optional[str] = None
        self.connection_state: Optional[Union[str, "_models.ConnectionState"]] = None
        self.last_activity_time: Optional[datetime.datetime] = None
        self.activation: Optional["_models.ActivationProperties"] = None
        self.parent = parent
        self.client_token_ids = client_token_ids
        self.login_server = login_server
        self.logging = logging
        self.status_details: Optional[List["_models.StatusDetailProperties"]] = None
        self.notifications_list = notifications_list
        self.garbage_collection = garbage_collection


class ConnectedRegistryListResult(_serialization.Model):
    """The result of a request to list connected registries for a container registry.

    :ivar value: The list of connected registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of connected registries.
    :vartype value:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectedRegistry]
    :ivar next_link: The URI that can be used to request the next list of connected registries.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectedRegistry]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConnectedRegistry"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of connected registries. Since this list may be incomplete, the
         nextLink field should be used to request the next list of connected registries.
        :paramtype value:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectedRegistry]
        :keyword next_link: The URI that can be used to request the next list of connected registries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectedRegistryUpdateParameters(_serialization.Model):
    """The parameters for updating a connected registry.

    :ivar sync_properties: The sync properties of the connected registry with its parent.
    :vartype sync_properties:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SyncUpdateProperties
    :ivar logging: The logging properties of the connected registry.
    :vartype logging: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LoggingProperties
    :ivar client_token_ids: The list of the ACR token resource IDs used to authenticate clients to
     the connected registry.
    :vartype client_token_ids: list[str]
    :ivar notifications_list: The list of notifications subscription information for the connected
     registry.
    :vartype notifications_list: list[str]
    :ivar garbage_collection: The garbage collection properties of the connected registry.
    :vartype garbage_collection:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.GarbageCollectionProperties
    """

    _attribute_map = {
        "sync_properties": {"key": "properties.syncProperties", "type": "SyncUpdateProperties"},
        "logging": {"key": "properties.logging", "type": "LoggingProperties"},
        "client_token_ids": {"key": "properties.clientTokenIds", "type": "[str]"},
        "notifications_list": {"key": "properties.notificationsList", "type": "[str]"},
        "garbage_collection": {"key": "properties.garbageCollection", "type": "GarbageCollectionProperties"},
    }

    def __init__(
        self,
        *,
        sync_properties: Optional["_models.SyncUpdateProperties"] = None,
        logging: Optional["_models.LoggingProperties"] = None,
        client_token_ids: Optional[List[str]] = None,
        notifications_list: Optional[List[str]] = None,
        garbage_collection: Optional["_models.GarbageCollectionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sync_properties: The sync properties of the connected registry with its parent.
        :paramtype sync_properties:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SyncUpdateProperties
        :keyword logging: The logging properties of the connected registry.
        :paramtype logging: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LoggingProperties
        :keyword client_token_ids: The list of the ACR token resource IDs used to authenticate clients
         to the connected registry.
        :paramtype client_token_ids: list[str]
        :keyword notifications_list: The list of notifications subscription information for the
         connected registry.
        :paramtype notifications_list: list[str]
        :keyword garbage_collection: The garbage collection properties of the connected registry.
        :paramtype garbage_collection:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.GarbageCollectionProperties
        """
        super().__init__(**kwargs)
        self.sync_properties = sync_properties
        self.logging = logging
        self.client_token_ids = client_token_ids
        self.notifications_list = notifications_list
        self.garbage_collection = garbage_collection


class CredentialHealth(_serialization.Model):
    """The health of the auth credential.

    :ivar status: The health status of credential. Known values are: "Healthy" and "Unhealthy".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialHealthStatus
    :ivar error_code: Error code representing the health check error.
    :vartype error_code: str
    :ivar error_message: Descriptive message representing the health check error.
    :vartype error_message: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.CredentialHealthStatus"]] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The health status of credential. Known values are: "Healthy" and "Unhealthy".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialHealthStatus
        :keyword error_code: Error code representing the health check error.
        :paramtype error_code: str
        :keyword error_message: Descriptive message representing the health check error.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.error_code = error_code
        self.error_message = error_message


class Credentials(_serialization.Model):
    """The parameters that describes a set of credentials that will be used when a run is invoked.

    :ivar source_registry: Describes the credential parameters for accessing the source registry.
    :vartype source_registry:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceRegistryCredentials
    :ivar custom_registries: Describes the credential parameters for accessing other custom
     registries. The key
     for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the registry.
    :vartype custom_registries: dict[str,
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CustomRegistryCredentials]
    """

    _attribute_map = {
        "source_registry": {"key": "sourceRegistry", "type": "SourceRegistryCredentials"},
        "custom_registries": {"key": "customRegistries", "type": "{CustomRegistryCredentials}"},
    }

    def __init__(
        self,
        *,
        source_registry: Optional["_models.SourceRegistryCredentials"] = None,
        custom_registries: Optional[Dict[str, "_models.CustomRegistryCredentials"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_registry: Describes the credential parameters for accessing the source
         registry.
        :paramtype source_registry:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceRegistryCredentials
        :keyword custom_registries: Describes the credential parameters for accessing other custom
         registries. The key
         for the dictionary item will be the registry login server (myregistry.azurecr.io) and
         the value of the item will be the registry credentials for accessing the registry.
        :paramtype custom_registries: dict[str,
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CustomRegistryCredentials]
        """
        super().__init__(**kwargs)
        self.source_registry = source_registry
        self.custom_registries = custom_registries


class CredentialSet(ProxyResource):
    """An object that represents a credential set resource for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar identity: Identities associated with the resource. This is used to access the KeyVault
     secrets.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar login_server: The credentials are stored for this upstream or login server.
    :vartype login_server: str
    :ivar auth_credentials: List of authentication credentials stored for an upstream.
     Usually consists of a primary and an optional secondary credential.
    :vartype auth_credentials:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthCredential]
    :ivar creation_date: The creation date of credential store resource.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "login_server": {"key": "properties.loginServer", "type": "str"},
        "auth_credentials": {"key": "properties.authCredentials", "type": "[AuthCredential]"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        login_server: Optional[str] = None,
        auth_credentials: Optional[List["_models.AuthCredential"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identities associated with the resource. This is used to access the KeyVault
         secrets.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword login_server: The credentials are stored for this upstream or login server.
        :paramtype login_server: str
        :keyword auth_credentials: List of authentication credentials stored for an upstream.
         Usually consists of a primary and an optional secondary credential.
        :paramtype auth_credentials:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthCredential]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.login_server = login_server
        self.auth_credentials = auth_credentials
        self.creation_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class CredentialSetListResult(_serialization.Model):
    """The result of a request to list credential sets for a container registry.

    :ivar value: The list of credential sets. Since this list may be incomplete, the nextLink field
     should be used to request the next list of credential sets.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialSet]
    :ivar next_link: The URI that can be used to request the next list of credential sets.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CredentialSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CredentialSet"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of credential sets. Since this list may be incomplete, the nextLink
         field should be used to request the next list of credential sets.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.CredentialSet]
        :keyword next_link: The URI that can be used to request the next list of credential sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CredentialSetUpdateParameters(_serialization.Model):
    """The parameters for updating a credential set.

    :ivar identity: Identities associated with the resource. This is used to access the KeyVault
     secrets.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar auth_credentials: List of authentication credentials stored for an upstream.
     Usually consists of a primary and an optional secondary credential.
    :vartype auth_credentials:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthCredential]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "auth_credentials": {"key": "properties.authCredentials", "type": "[AuthCredential]"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        auth_credentials: Optional[List["_models.AuthCredential"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identities associated with the resource. This is used to access the KeyVault
         secrets.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword auth_credentials: List of authentication credentials stored for an upstream.
         Usually consists of a primary and an optional secondary credential.
        :paramtype auth_credentials:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthCredential]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.auth_credentials = auth_credentials


class CustomRegistryCredentials(_serialization.Model):
    """Describes the credentials that will be used to access a custom registry during a run.

    :ivar user_name: The username for logging into the custom registry.
    :vartype user_name: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SecretObject
    :ivar password: The password for logging into the custom registry. The password is a secret
     object that allows multiple ways of providing the value for it.
    :vartype password: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SecretObject
    :ivar identity: Indicates the managed identity assigned to the custom credential. If a
     user-assigned identity
     this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
     the case of a system-assigned identity, the Client ID will be determined by the runner. This
     identity may be used to authenticate to key vault to retrieve credentials or it may be the only
     source of authentication used for accessing the registry.
    :vartype identity: str
    """

    _attribute_map = {
        "user_name": {"key": "userName", "type": "SecretObject"},
        "password": {"key": "password", "type": "SecretObject"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_name: Optional["_models.SecretObject"] = None,
        password: Optional["_models.SecretObject"] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: The username for logging into the custom registry.
        :paramtype user_name: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SecretObject
        :keyword password: The password for logging into the custom registry. The password is a secret
         object that allows multiple ways of providing the value for it.
        :paramtype password: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SecretObject
        :keyword identity: Indicates the managed identity assigned to the custom credential. If a
         user-assigned identity
         this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
         the case of a system-assigned identity, the Client ID will be determined by the runner. This
         identity may be used to authenticate to key vault to retrieve credentials or it may be the only
         source of authentication used for accessing the registry.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.identity = identity


class DebianArchivePackageSourceProperties(ArchivePackageSourceProperties):
    """The properties of the archive package source.

    :ivar type: The type of package source for a archive. "remote"
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PackageSourceType
    :ivar url: The external repository url.
    :vartype url: str
    :ivar distribution_name: Upstream Debian distribution Name.
    :vartype distribution_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "distribution_name": {"key": "distributionName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.PackageSourceType"]] = None,
        url: Optional[str] = None,
        distribution_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of package source for a archive. "remote"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PackageSourceType
        :keyword url: The external repository url.
        :paramtype url: str
        :keyword distribution_name: Upstream Debian distribution Name.
        :paramtype distribution_name: str
        """
        super().__init__(type=type, url=url, **kwargs)
        self.distribution_name = distribution_name


class DebianArchiveProperties(ArchiveProperties):
    """The properties of the Debian package Archive.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar package_source: The package source of the archive.
    :vartype package_source:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchivePackageSourceProperties
    :ivar published_version: The published version of the archive.
    :vartype published_version: str
    :ivar repository_endpoint_prefix:
    :vartype repository_endpoint_prefix: str
    :ivar repository_endpoint:
    :vartype repository_endpoint: str
    :ivar provisioning_state: The provisioning state of the archive at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar distribution_name: Debian distribution Name.
    :vartype distribution_name: str
    """

    _validation = {
        "repository_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "package_source": {"key": "packageSource", "type": "ArchivePackageSourceProperties"},
        "published_version": {"key": "publishedVersion", "type": "str"},
        "repository_endpoint_prefix": {"key": "repositoryEndpointPrefix", "type": "str"},
        "repository_endpoint": {"key": "repositoryEndpoint", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "distribution_name": {"key": "distributionName", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_source: Optional["_models.ArchivePackageSourceProperties"] = None,
        published_version: Optional[str] = None,
        repository_endpoint_prefix: Optional[str] = None,
        distribution_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_source: The package source of the archive.
        :paramtype package_source:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ArchivePackageSourceProperties
        :keyword published_version: The published version of the archive.
        :paramtype published_version: str
        :keyword repository_endpoint_prefix:
        :paramtype repository_endpoint_prefix: str
        :keyword distribution_name: Debian distribution Name.
        :paramtype distribution_name: str
        """
        super().__init__(
            package_source=package_source,
            published_version=published_version,
            repository_endpoint_prefix=repository_endpoint_prefix,
            **kwargs
        )
        self.distribution_name = distribution_name


class RunRequest(_serialization.Model):
    """The request parameters for scheduling a run.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildRequest, EncodedTaskRunRequest, FileTaskRunRequest, TaskRunRequest

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the run request. Required.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "agent_pool_name": {"key": "agentPoolName", "type": "str"},
        "log_template": {"key": "logTemplate", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "DockerBuildRequest": "DockerBuildRequest",
            "EncodedTaskRunRequest": "EncodedTaskRunRequest",
            "FileTaskRunRequest": "FileTaskRunRequest",
            "TaskRunRequest": "TaskRunRequest",
        }
    }

    def __init__(
        self,
        *,
        is_archive_enabled: bool = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.is_archive_enabled = is_archive_enabled
        self.agent_pool_name = agent_pool_name
        self.log_template = log_template


class DockerBuildRequest(RunRequest):
    """The parameters for a docker quick build.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the run request. Required.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source location. Required.
    :vartype docker_file_path: str
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar arguments: The collection of override arguments to be used when executing the run.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the run has to happen. Required.
    :vartype platform: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
    """

    _validation = {
        "type": {"required": True},
        "docker_file_path": {"required": True},
        "timeout": {"maximum": 28800, "minimum": 300},
        "platform": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "agent_pool_name": {"key": "agentPoolName", "type": "str"},
        "log_template": {"key": "logTemplate", "type": "str"},
        "image_names": {"key": "imageNames", "type": "[str]"},
        "is_push_enabled": {"key": "isPushEnabled", "type": "bool"},
        "no_cache": {"key": "noCache", "type": "bool"},
        "docker_file_path": {"key": "dockerFilePath", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "arguments": {"key": "arguments", "type": "[Argument]"},
        "timeout": {"key": "timeout", "type": "int"},
        "platform": {"key": "platform", "type": "PlatformProperties"},
        "agent_configuration": {"key": "agentConfiguration", "type": "AgentProperties"},
        "source_location": {"key": "sourceLocation", "type": "str"},
        "credentials": {"key": "credentials", "type": "Credentials"},
    }

    def __init__(
        self,
        *,
        docker_file_path: str,
        platform: "_models.PlatformProperties",
        is_archive_enabled: bool = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: bool = True,
        no_cache: bool = False,
        target: Optional[str] = None,
        arguments: Optional[List["_models.Argument"]] = None,
        timeout: int = 3600,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["_models.Credentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: The Docker file path relative to the source location. Required.
        :paramtype docker_file_path: str
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        :keyword arguments: The collection of override arguments to be used when executing the run.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword platform: The platform properties against which the run has to happen. Required.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
        :keyword source_location: The URL(absolute or relative) of the source context. It can be an URL
         to a tar or git repository.
         If it is relative URL, the relative path should be obtained from calling
         listBuildSourceUploadUrl API.
        :paramtype source_location: str
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
        """
        super().__init__(
            is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs
        )
        self.type: str = "DockerBuildRequest"
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.target = target
        self.arguments = arguments
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials


class TaskStepProperties(_serialization.Model):
    """Base properties for any task step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildStep, EncodedTaskStep, FileTaskStep

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    """

    _validation = {
        "type": {"required": True},
        "base_image_dependencies": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "base_image_dependencies": {"key": "baseImageDependencies", "type": "[BaseImageDependency]"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
    }

    _subtype_map = {"type": {"Docker": "DockerBuildStep", "EncodedTask": "EncodedTaskStep", "FileTask": "FileTaskStep"}}

    def __init__(
        self, *, context_path: Optional[str] = None, context_access_token: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.base_image_dependencies: Optional[List["_models.BaseImageDependency"]] = None
        self.context_path = context_path
        self.context_access_token = context_access_token


class DockerBuildStep(TaskStepProperties):
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source context. Required.
    :vartype docker_file_path: str
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar arguments: The collection of override arguments to be used when executing this build
     step.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
    """

    _validation = {
        "type": {"required": True},
        "base_image_dependencies": {"readonly": True},
        "docker_file_path": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "base_image_dependencies": {"key": "baseImageDependencies", "type": "[BaseImageDependency]"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
        "image_names": {"key": "imageNames", "type": "[str]"},
        "is_push_enabled": {"key": "isPushEnabled", "type": "bool"},
        "no_cache": {"key": "noCache", "type": "bool"},
        "docker_file_path": {"key": "dockerFilePath", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "arguments": {"key": "arguments", "type": "[Argument]"},
    }

    def __init__(
        self,
        *,
        docker_file_path: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: bool = True,
        no_cache: bool = False,
        target: Optional[str] = None,
        arguments: Optional[List["_models.Argument"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: The Docker file path relative to the source context. Required.
        :paramtype docker_file_path: str
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        :keyword arguments: The collection of override arguments to be used when executing this build
         step.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
        """
        super().__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type: str = "Docker"
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.target = target
        self.arguments = arguments


class TaskStepUpdateParameters(_serialization.Model):
    """Base properties for updating any task step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildStepUpdateParameters, EncodedTaskStepUpdateParameters, FileTaskStepUpdateParameters

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "Docker": "DockerBuildStepUpdateParameters",
            "EncodedTask": "EncodedTaskStepUpdateParameters",
            "FileTask": "FileTaskStepUpdateParameters",
        }
    }

    def __init__(
        self, *, context_path: Optional[str] = None, context_access_token: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.context_path = context_path
        self.context_access_token = context_access_token


class DockerBuildStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating a docker build step.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source context.
    :vartype docker_file_path: str
    :ivar arguments: The collection of override arguments to be used when executing this build
     step.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
        "image_names": {"key": "imageNames", "type": "[str]"},
        "is_push_enabled": {"key": "isPushEnabled", "type": "bool"},
        "no_cache": {"key": "noCache", "type": "bool"},
        "docker_file_path": {"key": "dockerFilePath", "type": "str"},
        "arguments": {"key": "arguments", "type": "[Argument]"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        docker_file_path: Optional[str] = None,
        arguments: Optional[List["_models.Argument"]] = None,
        target: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: The Docker file path relative to the source context.
        :paramtype docker_file_path: str
        :keyword arguments: The collection of override arguments to be used when executing this build
         step.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        """
        super().__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type: str = "Docker"
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.arguments = arguments
        self.target = target


class EncodedTaskRunRequest(RunRequest):
    """The parameters for a quick task run request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the run request. Required.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
     Required.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the run has to happen. Required.
    :vartype platform: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
    """

    _validation = {
        "type": {"required": True},
        "encoded_task_content": {"required": True},
        "timeout": {"maximum": 28800, "minimum": 300},
        "platform": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "agent_pool_name": {"key": "agentPoolName", "type": "str"},
        "log_template": {"key": "logTemplate", "type": "str"},
        "encoded_task_content": {"key": "encodedTaskContent", "type": "str"},
        "encoded_values_content": {"key": "encodedValuesContent", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
        "timeout": {"key": "timeout", "type": "int"},
        "platform": {"key": "platform", "type": "PlatformProperties"},
        "agent_configuration": {"key": "agentConfiguration", "type": "AgentProperties"},
        "source_location": {"key": "sourceLocation", "type": "str"},
        "credentials": {"key": "credentials", "type": "Credentials"},
    }

    def __init__(
        self,
        *,
        encoded_task_content: str,
        platform: "_models.PlatformProperties",
        is_archive_enabled: bool = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        timeout: int = 3600,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["_models.Credentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword encoded_task_content: Base64 encoded value of the template/definition file content.
         Required.
        :paramtype encoded_task_content: str
        :keyword encoded_values_content: Base64 encoded value of the parameters/values file content.
        :paramtype encoded_values_content: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword platform: The platform properties against which the run has to happen. Required.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
        :keyword source_location: The URL(absolute or relative) of the source context. It can be an URL
         to a tar or git repository.
         If it is relative URL, the relative path should be obtained from calling
         listBuildSourceUploadUrl API.
        :paramtype source_location: str
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
        """
        super().__init__(
            is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs
        )
        self.type: str = "EncodedTaskRunRequest"
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials


class EncodedTaskStep(TaskStepProperties):
    """The properties of a encoded task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
     Required.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    """

    _validation = {
        "type": {"required": True},
        "base_image_dependencies": {"readonly": True},
        "encoded_task_content": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "base_image_dependencies": {"key": "baseImageDependencies", "type": "[BaseImageDependency]"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
        "encoded_task_content": {"key": "encodedTaskContent", "type": "str"},
        "encoded_values_content": {"key": "encodedValuesContent", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
    }

    def __init__(
        self,
        *,
        encoded_task_content: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword encoded_task_content: Base64 encoded value of the template/definition file content.
         Required.
        :paramtype encoded_task_content: str
        :keyword encoded_values_content: Base64 encoded value of the parameters/values file content.
        :paramtype encoded_values_content: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        """
        super().__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type: str = "EncodedTask"
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values


class EncodedTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating encoded task step.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
        "encoded_task_content": {"key": "encodedTaskContent", "type": "str"},
        "encoded_values_content": {"key": "encodedValuesContent", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        encoded_task_content: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword encoded_task_content: Base64 encoded value of the template/definition file content.
        :paramtype encoded_task_content: str
        :keyword encoded_values_content: Base64 encoded value of the parameters/values file content.
        :paramtype encoded_values_content: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        """
        super().__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type: str = "EncodedTask"
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values


class EncryptionProperty(_serialization.Model):
    """EncryptionProperty.

    :ivar status: Indicates whether or not the encryption is enabled for container registry. Known
     values are: "enabled" and "disabled".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EncryptionStatus
    :ivar key_vault_properties: Key vault properties.
    :vartype key_vault_properties:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.KeyVaultProperties
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.EncryptionStatus"]] = None,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether or not the encryption is enabled for container registry.
         Known values are: "enabled" and "disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EncryptionStatus
        :keyword key_vault_properties: Key vault properties.
        :paramtype key_vault_properties:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.KeyVaultProperties
        """
        super().__init__(**kwargs)
        self.status = status
        self.key_vault_properties = key_vault_properties


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventInfo(_serialization.Model):
    """The basic information of an event.

    :ivar id: The event ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The event ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Event(EventInfo):
    """The event for a webhook.

    :ivar id: The event ID.
    :vartype id: str
    :ivar event_request_message: The event request message sent to the service URI.
    :vartype event_request_message:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EventRequestMessage
    :ivar event_response_message: The event response message received from the service URI.
    :vartype event_response_message:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EventResponseMessage
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "event_request_message": {"key": "eventRequestMessage", "type": "EventRequestMessage"},
        "event_response_message": {"key": "eventResponseMessage", "type": "EventResponseMessage"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        event_request_message: Optional["_models.EventRequestMessage"] = None,
        event_response_message: Optional["_models.EventResponseMessage"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The event ID.
        :paramtype id: str
        :keyword event_request_message: The event request message sent to the service URI.
        :paramtype event_request_message:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EventRequestMessage
        :keyword event_response_message: The event response message received from the service URI.
        :paramtype event_response_message:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EventResponseMessage
        """
        super().__init__(id=id, **kwargs)
        self.event_request_message = event_request_message
        self.event_response_message = event_response_message


class EventContent(_serialization.Model):
    """The content of the event request message.

    :ivar id: The event ID.
    :vartype id: str
    :ivar timestamp: The time at which the event occurred.
    :vartype timestamp: ~datetime.datetime
    :ivar action: The action that encompasses the provided event.
    :vartype action: str
    :ivar target: The target of the event.
    :vartype target: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Target
    :ivar request: The request that generated the event.
    :vartype request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Request
    :ivar actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :vartype actor: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Actor
    :ivar source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :vartype source: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Source
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "action": {"key": "action", "type": "str"},
        "target": {"key": "target", "type": "Target"},
        "request": {"key": "request", "type": "Request"},
        "actor": {"key": "actor", "type": "Actor"},
        "source": {"key": "source", "type": "Source"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["_models.Target"] = None,
        request: Optional["_models.Request"] = None,
        actor: Optional["_models.Actor"] = None,
        source: Optional["_models.Source"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The event ID.
        :paramtype id: str
        :keyword timestamp: The time at which the event occurred.
        :paramtype timestamp: ~datetime.datetime
        :keyword action: The action that encompasses the provided event.
        :paramtype action: str
        :keyword target: The target of the event.
        :paramtype target: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Target
        :keyword request: The request that generated the event.
        :paramtype request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Request
        :keyword actor: The agent that initiated the event. For most situations, this could be from the
         authorization context of the request.
        :paramtype actor: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Actor
        :keyword source: The registry node that generated the event. Put differently, while the actor
         initiates the event, the source generates it.
        :paramtype source: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Source
        """
        super().__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target
        self.request = request
        self.actor = actor
        self.source = source


class EventListResult(_serialization.Model):
    """The result of a request to list events for a webhook.

    :ivar value: The list of events. Since this list may be incomplete, the nextLink field should
     be used to request the next list of events.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Event]
    :ivar next_link: The URI that can be used to request the next list of events.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Event]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Event"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of events. Since this list may be incomplete, the nextLink field
         should be used to request the next list of events.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Event]
        :keyword next_link: The URI that can be used to request the next list of events.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventRequestMessage(_serialization.Model):
    """The event request message sent to the service URI.

    :ivar content: The content of the event request message.
    :vartype content: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EventContent
    :ivar headers: The headers of the event request message.
    :vartype headers: dict[str, str]
    :ivar method: The HTTP method used to send the event request message.
    :vartype method: str
    :ivar request_uri: The URI used to send the event request message.
    :vartype request_uri: str
    :ivar version: The HTTP message version.
    :vartype version: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "EventContent"},
        "headers": {"key": "headers", "type": "{str}"},
        "method": {"key": "method", "type": "str"},
        "request_uri": {"key": "requestUri", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        content: Optional["_models.EventContent"] = None,
        headers: Optional[Dict[str, str]] = None,
        method: Optional[str] = None,
        request_uri: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content: The content of the event request message.
        :paramtype content: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EventContent
        :keyword headers: The headers of the event request message.
        :paramtype headers: dict[str, str]
        :keyword method: The HTTP method used to send the event request message.
        :paramtype method: str
        :keyword request_uri: The URI used to send the event request message.
        :paramtype request_uri: str
        :keyword version: The HTTP message version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.method = method
        self.request_uri = request_uri
        self.version = version


class EventResponseMessage(_serialization.Model):
    """The event response message received from the service URI.

    :ivar content: The content of the event response message.
    :vartype content: str
    :ivar headers: The headers of the event response message.
    :vartype headers: dict[str, str]
    :ivar reason_phrase: The reason phrase of the event response message.
    :vartype reason_phrase: str
    :ivar status_code: The status code of the event response message.
    :vartype status_code: str
    :ivar version: The HTTP message version.
    :vartype version: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "headers": {"key": "headers", "type": "{str}"},
        "reason_phrase": {"key": "reasonPhrase", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
        reason_phrase: Optional[str] = None,
        status_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content: The content of the event response message.
        :paramtype content: str
        :keyword headers: The headers of the event response message.
        :paramtype headers: dict[str, str]
        :keyword reason_phrase: The reason phrase of the event response message.
        :paramtype reason_phrase: str
        :keyword status_code: The status code of the event response message.
        :paramtype status_code: str
        :keyword version: The HTTP message version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.reason_phrase = reason_phrase
        self.status_code = status_code
        self.version = version


class ExportPipeline(ProxyResource):
    """An object that represents an export pipeline for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar location: The location of the export pipeline.
    :vartype location: str
    :ivar identity: The identity of the export pipeline.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar target: The target properties of the export pipeline.
    :vartype target:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPipelineTargetProperties
    :ivar options: The list of all options configured for the pipeline.
    :vartype options: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineOptions]
    :ivar provisioning_state: The provisioning state of the pipeline at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "target": {"key": "properties.target", "type": "ExportPipelineTargetProperties"},
        "options": {"key": "properties.options", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        target: Optional["_models.ExportPipelineTargetProperties"] = None,
        options: Optional[List[Union[str, "_models.PipelineOptions"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the export pipeline.
        :paramtype location: str
        :keyword identity: The identity of the export pipeline.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword target: The target properties of the export pipeline.
        :paramtype target:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPipelineTargetProperties
        :keyword options: The list of all options configured for the pipeline.
        :paramtype options: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineOptions]
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.target = target
        self.options = options
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ExportPipelineListResult(_serialization.Model):
    """The result of a request to list export pipelines for a container registry.

    :ivar value: The list of export pipelines. Since this list may be incomplete, the nextLink
     field should be used to request the next list of export pipelines.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPipeline]
    :ivar next_link: The URI that can be used to request the next list of pipeline runs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExportPipeline]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExportPipeline"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of export pipelines. Since this list may be incomplete, the nextLink
         field should be used to request the next list of export pipelines.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPipeline]
        :keyword next_link: The URI that can be used to request the next list of pipeline runs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExportPipelineTargetProperties(_serialization.Model):
    """The properties of the export pipeline target.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of target for the export pipeline.
    :vartype type: str
    :ivar uri: The target uri of the export pipeline.
     When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName".
    :vartype uri: str
    :ivar key_vault_uri: They key vault secret uri to obtain the target storage SAS token.
     Required.
    :vartype key_vault_uri: str
    """

    _validation = {
        "key_vault_uri": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
    }

    def __init__(
        self, *, key_vault_uri: str, type: Optional[str] = None, uri: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of target for the export pipeline.
        :paramtype type: str
        :keyword uri: The target uri of the export pipeline.
         When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
         When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName".
        :paramtype uri: str
        :keyword key_vault_uri: They key vault secret uri to obtain the target storage SAS token.
         Required.
        :paramtype key_vault_uri: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.uri = uri
        self.key_vault_uri = key_vault_uri


class ExportPolicy(_serialization.Model):
    """The export policy for a container registry.

    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPolicyStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Union[str, "_models.ExportPolicyStatus"] = "enabled", **kwargs: Any) -> None:
        """
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPolicyStatus
        """
        super().__init__(**kwargs)
        self.status = status


class FileTaskRunRequest(RunRequest):
    """The request parameters for a scheduling run against a task file.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the run request. Required.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar task_file_path: The template/definition file path relative to the source. Required.
    :vartype task_file_path: str
    :ivar values_file_path: The values/parameters file path relative to the source.
    :vartype values_file_path: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the run has to happen. Required.
    :vartype platform: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
    """

    _validation = {
        "type": {"required": True},
        "task_file_path": {"required": True},
        "timeout": {"maximum": 28800, "minimum": 300},
        "platform": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "agent_pool_name": {"key": "agentPoolName", "type": "str"},
        "log_template": {"key": "logTemplate", "type": "str"},
        "task_file_path": {"key": "taskFilePath", "type": "str"},
        "values_file_path": {"key": "valuesFilePath", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
        "timeout": {"key": "timeout", "type": "int"},
        "platform": {"key": "platform", "type": "PlatformProperties"},
        "agent_configuration": {"key": "agentConfiguration", "type": "AgentProperties"},
        "source_location": {"key": "sourceLocation", "type": "str"},
        "credentials": {"key": "credentials", "type": "Credentials"},
    }

    def __init__(
        self,
        *,
        task_file_path: str,
        platform: "_models.PlatformProperties",
        is_archive_enabled: bool = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        timeout: int = 3600,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["_models.Credentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword task_file_path: The template/definition file path relative to the source. Required.
        :paramtype task_file_path: str
        :keyword values_file_path: The values/parameters file path relative to the source.
        :paramtype values_file_path: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword platform: The platform properties against which the run has to happen. Required.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
        :keyword source_location: The URL(absolute or relative) of the source context. It can be an URL
         to a tar or git repository.
         If it is relative URL, the relative path should be obtained from calling
         listBuildSourceUploadUrl API.
        :paramtype source_location: str
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
        """
        super().__init__(
            is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs
        )
        self.type: str = "FileTaskRunRequest"
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials


class FileTaskStep(TaskStepProperties):
    """The properties of a task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar task_file_path: The task template/definition file path relative to the source context.
     Required.
    :vartype task_file_path: str
    :ivar values_file_path: The task values/parameters file path relative to the source context.
    :vartype values_file_path: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    """

    _validation = {
        "type": {"required": True},
        "base_image_dependencies": {"readonly": True},
        "task_file_path": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "base_image_dependencies": {"key": "baseImageDependencies", "type": "[BaseImageDependency]"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
        "task_file_path": {"key": "taskFilePath", "type": "str"},
        "values_file_path": {"key": "valuesFilePath", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
    }

    def __init__(
        self,
        *,
        task_file_path: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword task_file_path: The task template/definition file path relative to the source context.
         Required.
        :paramtype task_file_path: str
        :keyword values_file_path: The task values/parameters file path relative to the source context.
        :paramtype values_file_path: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        """
        super().__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type: str = "FileTask"
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values


class FileTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties of updating a task step.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar task_file_path: The task template/definition file path relative to the source context.
    :vartype task_file_path: str
    :ivar values_file_path: The values/parameters file path relative to the source context.
    :vartype values_file_path: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "context_path": {"key": "contextPath", "type": "str"},
        "context_access_token": {"key": "contextAccessToken", "type": "str"},
        "task_file_path": {"key": "taskFilePath", "type": "str"},
        "values_file_path": {"key": "valuesFilePath", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        task_file_path: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword task_file_path: The task template/definition file path relative to the source context.
        :paramtype task_file_path: str
        :keyword values_file_path: The values/parameters file path relative to the source context.
        :paramtype values_file_path: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        """
        super().__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type: str = "FileTask"
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values


class GarbageCollectionProperties(_serialization.Model):
    """The garbage collection properties of the connected registry.

    :ivar enabled: Indicates whether garbage collection is enabled for the connected registry.
    :vartype enabled: bool
    :ivar schedule: The cron expression indicating the schedule that the connected registry will
     run garbage collection.
    :vartype schedule: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "schedule": {"key": "schedule", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, schedule: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Indicates whether garbage collection is enabled for the connected registry.
        :paramtype enabled: bool
        :keyword schedule: The cron expression indicating the schedule that the connected registry will
         run garbage collection.
        :paramtype schedule: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.schedule = schedule


class GenerateCredentialsParameters(_serialization.Model):
    """The parameters used to generate credentials for a specified token or user of a container
    registry.

    :ivar token_id: The resource ID of the token for which credentials have to be generated.
    :vartype token_id: str
    :ivar expiry: The expiry date of the generated credentials after which the credentials become
     invalid.
    :vartype expiry: ~datetime.datetime
    :ivar name: Specifies name of the password which should be regenerated if any -- password1 or
     password2. Known values are: "password1" and "password2".
    :vartype name: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPasswordName
    """

    _attribute_map = {
        "token_id": {"key": "tokenId", "type": "str"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        token_id: Optional[str] = None,
        expiry: Optional[datetime.datetime] = None,
        name: Optional[Union[str, "_models.TokenPasswordName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword token_id: The resource ID of the token for which credentials have to be generated.
        :paramtype token_id: str
        :keyword expiry: The expiry date of the generated credentials after which the credentials
         become invalid.
        :paramtype expiry: ~datetime.datetime
        :keyword name: Specifies name of the password which should be regenerated if any -- password1
         or password2. Known values are: "password1" and "password2".
        :paramtype name: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPasswordName
        """
        super().__init__(**kwargs)
        self.token_id = token_id
        self.expiry = expiry
        self.name = name


class GenerateCredentialsResult(_serialization.Model):
    """The response from the GenerateCredentials operation.

    :ivar username: The username for a container registry.
    :vartype username: str
    :ivar passwords: The list of passwords for a container registry.
    :vartype passwords:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "passwords": {"key": "passwords", "type": "[TokenPassword]"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        passwords: Optional[List["_models.TokenPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: The username for a container registry.
        :paramtype username: str
        :keyword passwords: The list of passwords for a container registry.
        :paramtype passwords:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPassword]
        """
        super().__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class IdentityProperties(_serialization.Model):
    """Managed identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.UserIdentityProperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity
         dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
             providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ImageDescriptor(_serialization.Model):
    """Properties for a registry image.

    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    _attribute_map = {
        "registry": {"key": "registry", "type": "str"},
        "repository": {"key": "repository", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "digest": {"key": "digest", "type": "str"},
    }

    def __init__(
        self,
        *,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registry: The registry login server.
        :paramtype registry: str
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword digest: The sha256-based digest of the image manifest.
        :paramtype digest: str
        """
        super().__init__(**kwargs)
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ImageUpdateTrigger(_serialization.Model):
    """The image update trigger that caused a build.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar timestamp: The timestamp when the image update happened.
    :vartype timestamp: ~datetime.datetime
    :ivar images: The list of image updates that caused the build.
    :vartype images: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageDescriptor]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "images": {"key": "images", "type": "[ImageDescriptor]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        timestamp: Optional[datetime.datetime] = None,
        images: Optional[List["_models.ImageDescriptor"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The unique ID of the trigger.
        :paramtype id: str
        :keyword timestamp: The timestamp when the image update happened.
        :paramtype timestamp: ~datetime.datetime
        :keyword images: The list of image updates that caused the build.
        :paramtype images:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageDescriptor]
        """
        super().__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.images = images


class ImportImageParameters(_serialization.Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to server.

    :ivar source: The source of the image. Required.
    :vartype source: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportSource
    :ivar target_tags: List of strings of the form repo[:tag]. When tag is omitted the source will
     be used (or 'latest' if source tag is also omitted).
    :vartype target_tags: list[str]
    :ivar untagged_target_repositories: List of strings of repository names to do a manifest only
     copy. No tag will be created.
    :vartype untagged_target_repositories: list[str]
    :ivar mode: When Force, any existing target tags will be overwritten. When NoForce, any
     existing target tags will fail the operation before any copying begins. Known values are:
     "NoForce" and "Force".
    :vartype mode: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportMode
    """

    _validation = {
        "source": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ImportSource"},
        "target_tags": {"key": "targetTags", "type": "[str]"},
        "untagged_target_repositories": {"key": "untaggedTargetRepositories", "type": "[str]"},
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: "_models.ImportSource",
        target_tags: Optional[List[str]] = None,
        untagged_target_repositories: Optional[List[str]] = None,
        mode: Union[str, "_models.ImportMode"] = "NoForce",
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the image. Required.
        :paramtype source: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportSource
        :keyword target_tags: List of strings of the form repo[:tag]. When tag is omitted the source
         will be used (or 'latest' if source tag is also omitted).
        :paramtype target_tags: list[str]
        :keyword untagged_target_repositories: List of strings of repository names to do a manifest
         only copy. No tag will be created.
        :paramtype untagged_target_repositories: list[str]
        :keyword mode: When Force, any existing target tags will be overwritten. When NoForce, any
         existing target tags will fail the operation before any copying begins. Known values are:
         "NoForce" and "Force".
        :paramtype mode: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportMode
        """
        super().__init__(**kwargs)
        self.source = source
        self.target_tags = target_tags
        self.untagged_target_repositories = untagged_target_repositories
        self.mode = mode


class ImportPipeline(ProxyResource):
    """An object that represents an import pipeline for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar location: The location of the import pipeline.
    :vartype location: str
    :ivar identity: The identity of the import pipeline.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar source: The source properties of the import pipeline.
    :vartype source:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportPipelineSourceProperties
    :ivar trigger: The properties that describe the trigger of the import pipeline.
    :vartype trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineTriggerProperties
    :ivar options: The list of all options configured for the pipeline.
    :vartype options: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineOptions]
    :ivar provisioning_state: The provisioning state of the pipeline at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "source": {"key": "properties.source", "type": "ImportPipelineSourceProperties"},
        "trigger": {"key": "properties.trigger", "type": "PipelineTriggerProperties"},
        "options": {"key": "properties.options", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        source: Optional["_models.ImportPipelineSourceProperties"] = None,
        trigger: Optional["_models.PipelineTriggerProperties"] = None,
        options: Optional[List[Union[str, "_models.PipelineOptions"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the import pipeline.
        :paramtype location: str
        :keyword identity: The identity of the import pipeline.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword source: The source properties of the import pipeline.
        :paramtype source:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportPipelineSourceProperties
        :keyword trigger: The properties that describe the trigger of the import pipeline.
        :paramtype trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineTriggerProperties
        :keyword options: The list of all options configured for the pipeline.
        :paramtype options: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineOptions]
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.source = source
        self.trigger = trigger
        self.options = options
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ImportPipelineListResult(_serialization.Model):
    """The result of a request to list import pipelines for a container registry.

    :ivar value: The list of import pipelines. Since this list may be incomplete, the nextLink
     field should be used to request the next list of import pipelines.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportPipeline]
    :ivar next_link: The URI that can be used to request the next list of pipeline runs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ImportPipeline]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ImportPipeline"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of import pipelines. Since this list may be incomplete, the nextLink
         field should be used to request the next list of import pipelines.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportPipeline]
        :keyword next_link: The URI that can be used to request the next list of pipeline runs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImportPipelineSourceProperties(_serialization.Model):
    """The properties of the import pipeline source.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of source for the import pipeline. "AzureStorageBlobContainer"
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineSourceType
    :ivar uri: The source uri of the import pipeline.
     When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName".
    :vartype uri: str
    :ivar key_vault_uri: They key vault secret uri to obtain the source storage SAS token.
     Required.
    :vartype key_vault_uri: str
    """

    _validation = {
        "key_vault_uri": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault_uri: str,
        type: Union[str, "_models.PipelineSourceType"] = "AzureStorageBlobContainer",
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of source for the import pipeline. "AzureStorageBlobContainer"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineSourceType
        :keyword uri: The source uri of the import pipeline.
         When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
         When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName".
        :paramtype uri: str
        :keyword key_vault_uri: They key vault secret uri to obtain the source storage SAS token.
         Required.
        :paramtype key_vault_uri: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.uri = uri
        self.key_vault_uri = key_vault_uri


class ImportSource(_serialization.Model):
    """ImportSource.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: The resource identifier of the source Azure Container Registry.
    :vartype resource_id: str
    :ivar registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
    :vartype registry_uri: str
    :ivar credentials: Credentials used when importing from a registry uri.
    :vartype credentials:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportSourceCredentials
    :ivar source_image: Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123'). Required.
    :vartype source_image: str
    """

    _validation = {
        "source_image": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "registry_uri": {"key": "registryUri", "type": "str"},
        "credentials": {"key": "credentials", "type": "ImportSourceCredentials"},
        "source_image": {"key": "sourceImage", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_image: str,
        resource_id: Optional[str] = None,
        registry_uri: Optional[str] = None,
        credentials: Optional["_models.ImportSourceCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource identifier of the source Azure Container Registry.
        :paramtype resource_id: str
        :keyword registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
        :paramtype registry_uri: str
        :keyword credentials: Credentials used when importing from a registry uri.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportSourceCredentials
        :keyword source_image: Repository name of the source image.
         Specify an image by repository ('hello-world'). This will use the 'latest' tag.
         Specify an image by tag ('hello-world:latest').
         Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123'). Required.
        :paramtype source_image: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.registry_uri = registry_uri
        self.credentials = credentials
        self.source_image = source_image


class ImportSourceCredentials(_serialization.Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to server.

    :ivar username: The username to authenticate with the source registry.
    :vartype username: str
    :ivar password: The password used to authenticate with the source registry. Required.
    :vartype password: str
    """

    _validation = {
        "password": {"required": True},
    }

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, password: str, username: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: The username to authenticate with the source registry.
        :paramtype username: str
        :keyword password: The password used to authenticate with the source registry. Required.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class IPRule(_serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to server.

    :ivar action: The action of IP ACL rule. "Allow"
    :vartype action: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Action
    :ivar ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
     allowed. Required.
    :vartype ip_address_or_range: str
    """

    _validation = {
        "ip_address_or_range": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "ip_address_or_range": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, ip_address_or_range: str, action: Union[str, "_models.Action"] = "Allow", **kwargs: Any
    ) -> None:
        """
        :keyword action: The action of IP ACL rule. "Allow"
        :paramtype action: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Action
        :keyword ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
         allowed. Required.
        :paramtype ip_address_or_range: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.ip_address_or_range = ip_address_or_range


class KeyVaultProperties(_serialization.Model):
    """KeyVaultProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_identifier: Key vault uri to access the encryption key.
    :vartype key_identifier: str
    :ivar versioned_key_identifier: The fully qualified key identifier that includes the version of
     the key that is actually used for encryption.
    :vartype versioned_key_identifier: str
    :ivar identity: The client id of the identity which will be used to access key vault.
    :vartype identity: str
    :ivar key_rotation_enabled: Auto key rotation status for a CMK enabled registry.
    :vartype key_rotation_enabled: bool
    :ivar last_key_rotation_timestamp: Timestamp of the last successful key rotation.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    """

    _validation = {
        "versioned_key_identifier": {"readonly": True},
        "key_rotation_enabled": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "versioned_key_identifier": {"key": "versionedKeyIdentifier", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
        "key_rotation_enabled": {"key": "keyRotationEnabled", "type": "bool"},
        "last_key_rotation_timestamp": {"key": "lastKeyRotationTimestamp", "type": "iso-8601"},
    }

    def __init__(self, *, key_identifier: Optional[str] = None, identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_identifier: Key vault uri to access the encryption key.
        :paramtype key_identifier: str
        :keyword identity: The client id of the identity which will be used to access key vault.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.key_identifier = key_identifier
        self.versioned_key_identifier: Optional[str] = None
        self.identity = identity
        self.key_rotation_enabled: Optional[bool] = None
        self.last_key_rotation_timestamp: Optional[datetime.datetime] = None


class LoggingProperties(_serialization.Model):
    """The logging properties of the connected registry.

    :ivar log_level: The verbosity of logs persisted on the connected registry. Known values are:
     "Debug", "Information", "Warning", "Error", and "None".
    :vartype log_level: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LogLevel
    :ivar audit_log_status: Indicates whether audit logs are enabled on the connected registry.
     Known values are: "Enabled" and "Disabled".
    :vartype audit_log_status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuditLogStatus
    """

    _attribute_map = {
        "log_level": {"key": "logLevel", "type": "str"},
        "audit_log_status": {"key": "auditLogStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        log_level: Union[str, "_models.LogLevel"] = "Information",
        audit_log_status: Union[str, "_models.AuditLogStatus"] = "Disabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword log_level: The verbosity of logs persisted on the connected registry. Known values
         are: "Debug", "Information", "Warning", "Error", and "None".
        :paramtype log_level: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LogLevel
        :keyword audit_log_status: Indicates whether audit logs are enabled on the connected registry.
         Known values are: "Enabled" and "Disabled".
        :paramtype audit_log_status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuditLogStatus
        """
        super().__init__(**kwargs)
        self.log_level = log_level
        self.audit_log_status = audit_log_status


class LoginServerProperties(_serialization.Model):
    """The login server properties of the connected registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar host: The host of the connected registry. Can be FQDN or IP.
    :vartype host: str
    :ivar tls: The TLS properties of the connected registry login server.
    :vartype tls: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TlsProperties
    """

    _validation = {
        "host": {"readonly": True},
        "tls": {"readonly": True},
    }

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "tls": {"key": "tls", "type": "TlsProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.host: Optional[str] = None
        self.tls: Optional["_models.TlsProperties"] = None


class NetworkRuleSet(_serialization.Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to server.

    :ivar default_action: The default action of allow or deny when no other rules match. Known
     values are: "Allow" and "Deny".
    :vartype default_action: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.DefaultAction
    :ivar ip_rules: The IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.IPRule]
    """

    _validation = {
        "default_action": {"required": True},
    }

    _attribute_map = {
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "_models.DefaultAction"] = "Allow",
        ip_rules: Optional[List["_models.IPRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_action: The default action of allow or deny when no other rules match. Known
         values are: "Allow" and "Deny".
        :paramtype default_action: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.DefaultAction
        :keyword ip_rules: The IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.IPRule]
        """
        super().__init__(**kwargs)
        self.default_action = default_action
        self.ip_rules = ip_rules


class OperationDefinition(_serialization.Model):
    """The definition of a container registry operation.

    :ivar origin: The origin information of the container registry operation.
    :vartype origin: str
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The display information for the container registry operation.
    :vartype display:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationDisplayDefinition
    :ivar is_data_action: This property indicates if the operation is an action or a data action
     ref:
     https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#management-and-data-operations.
    :vartype is_data_action: bool
    :ivar service_specification: The definition of Azure Monitoring service.
    :vartype service_specification:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplayDefinition"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "service_specification": {
            "key": "properties.serviceSpecification",
            "type": "OperationServiceSpecificationDefinition",
        },
    }

    def __init__(
        self,
        *,
        origin: Optional[str] = None,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplayDefinition"] = None,
        is_data_action: Optional[bool] = None,
        service_specification: Optional["_models.OperationServiceSpecificationDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword origin: The origin information of the container registry operation.
        :paramtype origin: str
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The display information for the container registry operation.
        :paramtype display:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationDisplayDefinition
        :keyword is_data_action: This property indicates if the operation is an action or a data action
         ref:
         https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#management-and-data-operations.
        :paramtype is_data_action: bool
        :keyword service_specification: The definition of Azure Monitoring service.
        :paramtype service_specification:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationServiceSpecificationDefinition
        """
        super().__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.is_data_action = is_data_action
        self.service_specification = service_specification


class OperationDisplayDefinition(_serialization.Model):
    """The display information for a container registry operation.

    :ivar provider: The resource provider name: Microsoft.ContainerRegistry.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The resource provider name: Microsoft.ContainerRegistry.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """The result of a request to list container registry operations.

    :ivar value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :vartype value:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationDefinition]
    :ivar next_link: The URI that can be used to request the next list of container registry
     operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.OperationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of container registry operations. Since this list may be incomplete,
         the nextLink field should be used to request the next list of operations.
        :paramtype value:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationDefinition]
        :keyword next_link: The URI that can be used to request the next list of container registry
         operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationLogSpecificationDefinition(_serialization.Model):
    """The definition of Azure Monitoring log.

    :ivar name: Log name.
    :vartype name: str
    :ivar display_name: Log display name.
    :vartype display_name: str
    :ivar blob_duration: Log blob duration.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Log name.
        :paramtype name: str
        :keyword display_name: Log display name.
        :paramtype display_name: str
        :keyword blob_duration: Log blob duration.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class OperationMetricSpecificationDefinition(_serialization.Model):
    """The definition of Azure Monitoring metric.

    :ivar name: Metric name.
    :vartype name: str
    :ivar display_name: Metric display name.
    :vartype display_name: str
    :ivar display_description: Metric description.
    :vartype display_description: str
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar aggregation_type: Metric aggregation type.
    :vartype aggregation_type: str
    :ivar internal_metric_name: Internal metric name.
    :vartype internal_metric_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        internal_metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Metric name.
        :paramtype name: str
        :keyword display_name: Metric display name.
        :paramtype display_name: str
        :keyword display_description: Metric description.
        :paramtype display_description: str
        :keyword unit: Metric unit.
        :paramtype unit: str
        :keyword aggregation_type: Metric aggregation type.
        :paramtype aggregation_type: str
        :keyword internal_metric_name: Internal metric name.
        :paramtype internal_metric_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.internal_metric_name = internal_metric_name


class OperationServiceSpecificationDefinition(_serialization.Model):
    """The definition of Azure Monitoring list.

    :ivar metric_specifications: A list of Azure Monitoring metrics definition.
    :vartype metric_specifications:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationMetricSpecificationDefinition]
    :ivar log_specifications: A list of Azure Monitoring log definitions.
    :vartype log_specifications:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationLogSpecificationDefinition]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[OperationMetricSpecificationDefinition]"},
        "log_specifications": {"key": "logSpecifications", "type": "[OperationLogSpecificationDefinition]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.OperationMetricSpecificationDefinition"]] = None,
        log_specifications: Optional[List["_models.OperationLogSpecificationDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: A list of Azure Monitoring metrics definition.
        :paramtype metric_specifications:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationMetricSpecificationDefinition]
        :keyword log_specifications: A list of Azure Monitoring log definitions.
        :paramtype log_specifications:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.OperationLogSpecificationDefinition]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class OverrideTaskStepProperties(_serialization.Model):
    """OverrideTaskStepProperties.

    :ivar context_path: The source context against which run has to be queued.
    :vartype context_path: str
    :ivar file: The file against which run has to be queued.
    :vartype file: str
    :ivar arguments: Gets or sets the collection of override arguments to be used when
     executing a build step.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar values: The collection of overridable values that can be passed when running a Task.
    :vartype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
    :ivar update_trigger_token: Base64 encoded update trigger token that will be attached with the
     base image trigger webhook.
    :vartype update_trigger_token: str
    """

    _attribute_map = {
        "context_path": {"key": "contextPath", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "arguments": {"key": "arguments", "type": "[Argument]"},
        "target": {"key": "target", "type": "str"},
        "values": {"key": "values", "type": "[SetValue]"},
        "update_trigger_token": {"key": "updateTriggerToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        file: Optional[str] = None,
        arguments: Optional[List["_models.Argument"]] = None,
        target: Optional[str] = None,
        values: Optional[List["_models.SetValue"]] = None,
        update_trigger_token: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context_path: The source context against which run has to be queued.
        :paramtype context_path: str
        :keyword file: The file against which run has to be queued.
        :paramtype file: str
        :keyword arguments: Gets or sets the collection of override arguments to be used when
         executing a build step.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Argument]
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        :keyword values: The collection of overridable values that can be passed when running a Task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SetValue]
        :keyword update_trigger_token: Base64 encoded update trigger token that will be attached with
         the base image trigger webhook.
        :paramtype update_trigger_token: str
        """
        super().__init__(**kwargs)
        self.context_path = context_path
        self.file = file
        self.arguments = arguments
        self.target = target
        self.values = values
        self.update_trigger_token = update_trigger_token


class PackageType(_serialization.Model):
    """The properties of a package type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the package type.
    :vartype name: str
    :ivar endpoint: The endpoint of the package type.
    :vartype endpoint: str
    """

    _validation = {
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the package type.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.endpoint: Optional[str] = None


class ParentProperties(_serialization.Model):
    """The properties of the connected registry parent.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID of the parent to which the connected registry will be associated.
    :vartype id: str
    :ivar sync_properties: The sync properties of the connected registry with its parent. Required.
    :vartype sync_properties:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SyncProperties
    """

    _validation = {
        "sync_properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "sync_properties": {"key": "syncProperties", "type": "SyncProperties"},
    }

    def __init__(
        self,
        *,
        sync_properties: "_models.SyncProperties",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The resource ID of the parent to which the connected registry will be associated.
        :paramtype id: str
        :keyword sync_properties: The sync properties of the connected registry with its parent.
         Required.
        :paramtype sync_properties:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SyncProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.sync_properties = sync_properties


class PipelineRun(ProxyResource):
    """An object that represents a pipeline run for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar provisioning_state: The provisioning state of a pipeline run. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar request: The request parameters for a pipeline run.
    :vartype request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunRequest
    :ivar response: The response of a pipeline run.
    :vartype response: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunResponse
    :ivar force_update_tag: How the pipeline run should be forced to recreate even if the pipeline
     run configuration has not changed.
    :vartype force_update_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "response": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "request": {"key": "properties.request", "type": "PipelineRunRequest"},
        "response": {"key": "properties.response", "type": "PipelineRunResponse"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        request: Optional["_models.PipelineRunRequest"] = None,
        force_update_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword request: The request parameters for a pipeline run.
        :paramtype request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunRequest
        :keyword force_update_tag: How the pipeline run should be forced to recreate even if the
         pipeline run configuration has not changed.
        :paramtype force_update_tag: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.request = request
        self.response: Optional["_models.PipelineRunResponse"] = None
        self.force_update_tag = force_update_tag


class PipelineRunListResult(_serialization.Model):
    """The result of a request to list pipeline runs for a container registry.

    :ivar value: The list of pipeline runs. Since this list may be incomplete, the nextLink field
     should be used to request the next list of pipeline runs.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRun]
    :ivar next_link: The URI that can be used to request the next list of pipeline runs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PipelineRun]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PipelineRun"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of pipeline runs. Since this list may be incomplete, the nextLink
         field should be used to request the next list of pipeline runs.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRun]
        :keyword next_link: The URI that can be used to request the next list of pipeline runs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PipelineRunRequest(_serialization.Model):
    """The request properties provided for a pipeline run.

    :ivar pipeline_resource_id: The resource ID of the pipeline to run.
    :vartype pipeline_resource_id: str
    :ivar artifacts: List of source artifacts to be transferred by the pipeline.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
    :vartype artifacts: list[str]
    :ivar source: The source properties of the pipeline run.
    :vartype source:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunSourceProperties
    :ivar target: The target properties of the pipeline run.
    :vartype target:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunTargetProperties
    :ivar catalog_digest: The digest of the tar used to transfer the artifacts.
    :vartype catalog_digest: str
    """

    _attribute_map = {
        "pipeline_resource_id": {"key": "pipelineResourceId", "type": "str"},
        "artifacts": {"key": "artifacts", "type": "[str]"},
        "source": {"key": "source", "type": "PipelineRunSourceProperties"},
        "target": {"key": "target", "type": "PipelineRunTargetProperties"},
        "catalog_digest": {"key": "catalogDigest", "type": "str"},
    }

    def __init__(
        self,
        *,
        pipeline_resource_id: Optional[str] = None,
        artifacts: Optional[List[str]] = None,
        source: Optional["_models.PipelineRunSourceProperties"] = None,
        target: Optional["_models.PipelineRunTargetProperties"] = None,
        catalog_digest: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pipeline_resource_id: The resource ID of the pipeline to run.
        :paramtype pipeline_resource_id: str
        :keyword artifacts: List of source artifacts to be transferred by the pipeline.
         Specify an image by repository ('hello-world'). This will use the 'latest' tag.
         Specify an image by tag ('hello-world:latest').
         Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
        :paramtype artifacts: list[str]
        :keyword source: The source properties of the pipeline run.
        :paramtype source:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunSourceProperties
        :keyword target: The target properties of the pipeline run.
        :paramtype target:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunTargetProperties
        :keyword catalog_digest: The digest of the tar used to transfer the artifacts.
        :paramtype catalog_digest: str
        """
        super().__init__(**kwargs)
        self.pipeline_resource_id = pipeline_resource_id
        self.artifacts = artifacts
        self.source = source
        self.target = target
        self.catalog_digest = catalog_digest


class PipelineRunResponse(_serialization.Model):
    """The response properties returned for a pipeline run.

    :ivar status: The current status of the pipeline run.
    :vartype status: str
    :ivar imported_artifacts: The artifacts imported in the pipeline run.
    :vartype imported_artifacts: list[str]
    :ivar progress: The current progress of the copy operation.
    :vartype progress: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProgressProperties
    :ivar start_time: The time the pipeline run started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The time the pipeline run finished.
    :vartype finish_time: ~datetime.datetime
    :ivar source: The source of the pipeline run.
    :vartype source:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportPipelineSourceProperties
    :ivar target: The target of the pipeline run.
    :vartype target:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPipelineTargetProperties
    :ivar catalog_digest: The digest of the tar used to transfer the artifacts.
    :vartype catalog_digest: str
    :ivar trigger: The trigger that caused the pipeline run.
    :vartype trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineTriggerDescriptor
    :ivar pipeline_run_error_message: The detailed error message for the pipeline run in the case
     of failure.
    :vartype pipeline_run_error_message: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "imported_artifacts": {"key": "importedArtifacts", "type": "[str]"},
        "progress": {"key": "progress", "type": "ProgressProperties"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "finish_time": {"key": "finishTime", "type": "iso-8601"},
        "source": {"key": "source", "type": "ImportPipelineSourceProperties"},
        "target": {"key": "target", "type": "ExportPipelineTargetProperties"},
        "catalog_digest": {"key": "catalogDigest", "type": "str"},
        "trigger": {"key": "trigger", "type": "PipelineTriggerDescriptor"},
        "pipeline_run_error_message": {"key": "pipelineRunErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        imported_artifacts: Optional[List[str]] = None,
        progress: Optional["_models.ProgressProperties"] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        source: Optional["_models.ImportPipelineSourceProperties"] = None,
        target: Optional["_models.ExportPipelineTargetProperties"] = None,
        catalog_digest: Optional[str] = None,
        trigger: Optional["_models.PipelineTriggerDescriptor"] = None,
        pipeline_run_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The current status of the pipeline run.
        :paramtype status: str
        :keyword imported_artifacts: The artifacts imported in the pipeline run.
        :paramtype imported_artifacts: list[str]
        :keyword progress: The current progress of the copy operation.
        :paramtype progress:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProgressProperties
        :keyword start_time: The time the pipeline run started.
        :paramtype start_time: ~datetime.datetime
        :keyword finish_time: The time the pipeline run finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword source: The source of the pipeline run.
        :paramtype source:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImportPipelineSourceProperties
        :keyword target: The target of the pipeline run.
        :paramtype target:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPipelineTargetProperties
        :keyword catalog_digest: The digest of the tar used to transfer the artifacts.
        :paramtype catalog_digest: str
        :keyword trigger: The trigger that caused the pipeline run.
        :paramtype trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineTriggerDescriptor
        :keyword pipeline_run_error_message: The detailed error message for the pipeline run in the
         case of failure.
        :paramtype pipeline_run_error_message: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.imported_artifacts = imported_artifacts
        self.progress = progress
        self.start_time = start_time
        self.finish_time = finish_time
        self.source = source
        self.target = target
        self.catalog_digest = catalog_digest
        self.trigger = trigger
        self.pipeline_run_error_message = pipeline_run_error_message


class PipelineRunSourceProperties(_serialization.Model):
    """PipelineRunSourceProperties.

    :ivar type: The type of the source. "AzureStorageBlob"
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunSourceType
    :ivar name: The name of the source.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.PipelineRunSourceType"] = "AzureStorageBlob",
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the source. "AzureStorageBlob"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunSourceType
        :keyword name: The name of the source.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class PipelineRunTargetProperties(_serialization.Model):
    """PipelineRunTargetProperties.

    :ivar type: The type of the target. "AzureStorageBlob"
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunTargetType
    :ivar name: The name of the target.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.PipelineRunTargetType"] = "AzureStorageBlob",
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the target. "AzureStorageBlob"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineRunTargetType
        :keyword name: The name of the target.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class PipelineSourceTriggerDescriptor(_serialization.Model):
    """PipelineSourceTriggerDescriptor.

    :ivar timestamp: The timestamp when the source update happened.
    :vartype timestamp: ~datetime.datetime
    """

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(self, *, timestamp: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword timestamp: The timestamp when the source update happened.
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp


class PipelineSourceTriggerProperties(_serialization.Model):
    """PipelineSourceTriggerProperties.

    All required parameters must be populated in order to send to server.

    :ivar status: The current status of the source trigger. Required. Known values are: "Enabled"
     and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Union[str, "_models.TriggerStatus"], **kwargs: Any) -> None:
        """
        :keyword status: The current status of the source trigger. Required. Known values are:
         "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        """
        super().__init__(**kwargs)
        self.status = status


class PipelineTriggerDescriptor(_serialization.Model):
    """PipelineTriggerDescriptor.

    :ivar source_trigger: The source trigger that caused the pipeline run.
    :vartype source_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineSourceTriggerDescriptor
    """

    _attribute_map = {
        "source_trigger": {"key": "sourceTrigger", "type": "PipelineSourceTriggerDescriptor"},
    }

    def __init__(
        self, *, source_trigger: Optional["_models.PipelineSourceTriggerDescriptor"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source_trigger: The source trigger that caused the pipeline run.
        :paramtype source_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineSourceTriggerDescriptor
        """
        super().__init__(**kwargs)
        self.source_trigger = source_trigger


class PipelineTriggerProperties(_serialization.Model):
    """PipelineTriggerProperties.

    :ivar source_trigger: The source trigger properties of the pipeline.
    :vartype source_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineSourceTriggerProperties
    """

    _attribute_map = {
        "source_trigger": {"key": "sourceTrigger", "type": "PipelineSourceTriggerProperties"},
    }

    def __init__(
        self, *, source_trigger: Optional["_models.PipelineSourceTriggerProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source_trigger: The source trigger properties of the pipeline.
        :paramtype source_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PipelineSourceTriggerProperties
        """
        super().__init__(**kwargs)
        self.source_trigger = source_trigger


class PlatformProperties(_serialization.Model):
    """The platform properties against which the run has to happen.

    All required parameters must be populated in order to send to server.

    :ivar os: The operating system type required for the run. Required. Known values are: "Windows"
     and "Linux".
    :vartype os: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OS
    :ivar architecture: The OS architecture. Known values are: "amd64", "x86", "386", "arm", and
     "arm64".
    :vartype architecture: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Architecture
    :ivar variant: Variant of the CPU. Known values are: "v6", "v7", and "v8".
    :vartype variant: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Variant
    """

    _validation = {
        "os": {"required": True},
    }

    _attribute_map = {
        "os": {"key": "os", "type": "str"},
        "architecture": {"key": "architecture", "type": "str"},
        "variant": {"key": "variant", "type": "str"},
    }

    def __init__(
        self,
        *,
        os: Union[str, "_models.OS"],
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        variant: Optional[Union[str, "_models.Variant"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os: The operating system type required for the run. Required. Known values are:
         "Windows" and "Linux".
        :paramtype os: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OS
        :keyword architecture: The OS architecture. Known values are: "amd64", "x86", "386", "arm", and
         "arm64".
        :paramtype architecture: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Architecture
        :keyword variant: Variant of the CPU. Known values are: "v6", "v7", and "v8".
        :paramtype variant: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Variant
        """
        super().__init__(**kwargs)
        self.os = os
        self.architecture = architecture
        self.variant = variant


class PlatformUpdateParameters(_serialization.Model):
    """The properties for updating the platform configuration.

    :ivar os: The operating system type required for the run. Known values are: "Windows" and
     "Linux".
    :vartype os: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OS
    :ivar architecture: The OS architecture. Known values are: "amd64", "x86", "386", "arm", and
     "arm64".
    :vartype architecture: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Architecture
    :ivar variant: Variant of the CPU. Known values are: "v6", "v7", and "v8".
    :vartype variant: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Variant
    """

    _attribute_map = {
        "os": {"key": "os", "type": "str"},
        "architecture": {"key": "architecture", "type": "str"},
        "variant": {"key": "variant", "type": "str"},
    }

    def __init__(
        self,
        *,
        os: Optional[Union[str, "_models.OS"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        variant: Optional[Union[str, "_models.Variant"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os: The operating system type required for the run. Known values are: "Windows" and
         "Linux".
        :paramtype os: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OS
        :keyword architecture: The OS architecture. Known values are: "amd64", "x86", "386", "arm", and
         "arm64".
        :paramtype architecture: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Architecture
        :keyword variant: Variant of the CPU. Known values are: "v6", "v7", and "v8".
        :paramtype variant: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Variant
        """
        super().__init__(**kwargs)
        self.os = os
        self.architecture = architecture
        self.variant = variant


class Policies(_serialization.Model):
    """The policies for a container registry.

    :ivar quarantine_policy: The quarantine policy for a container registry.
    :vartype quarantine_policy:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.QuarantinePolicy
    :ivar trust_policy: The content trust policy for a container registry.
    :vartype trust_policy: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TrustPolicy
    :ivar retention_policy: The retention policy for a container registry.
    :vartype retention_policy:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RetentionPolicy
    :ivar export_policy: The export policy for a container registry.
    :vartype export_policy: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPolicy
    :ivar azure_ad_authentication_as_arm_policy: The policy for using ARM audience token for a
     container registry.
    :vartype azure_ad_authentication_as_arm_policy:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AzureADAuthenticationAsArmPolicy
    :ivar soft_delete_policy: The soft delete policy for a container registry.
    :vartype soft_delete_policy:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SoftDeletePolicy
    """

    _attribute_map = {
        "quarantine_policy": {"key": "quarantinePolicy", "type": "QuarantinePolicy"},
        "trust_policy": {"key": "trustPolicy", "type": "TrustPolicy"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
        "export_policy": {"key": "exportPolicy", "type": "ExportPolicy"},
        "azure_ad_authentication_as_arm_policy": {
            "key": "azureADAuthenticationAsArmPolicy",
            "type": "AzureADAuthenticationAsArmPolicy",
        },
        "soft_delete_policy": {"key": "softDeletePolicy", "type": "SoftDeletePolicy"},
    }

    def __init__(
        self,
        *,
        quarantine_policy: Optional["_models.QuarantinePolicy"] = None,
        trust_policy: Optional["_models.TrustPolicy"] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        export_policy: Optional["_models.ExportPolicy"] = None,
        azure_ad_authentication_as_arm_policy: Optional["_models.AzureADAuthenticationAsArmPolicy"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword quarantine_policy: The quarantine policy for a container registry.
        :paramtype quarantine_policy:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.QuarantinePolicy
        :keyword trust_policy: The content trust policy for a container registry.
        :paramtype trust_policy: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TrustPolicy
        :keyword retention_policy: The retention policy for a container registry.
        :paramtype retention_policy:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RetentionPolicy
        :keyword export_policy: The export policy for a container registry.
        :paramtype export_policy: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ExportPolicy
        :keyword azure_ad_authentication_as_arm_policy: The policy for using ARM audience token for a
         container registry.
        :paramtype azure_ad_authentication_as_arm_policy:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AzureADAuthenticationAsArmPolicy
        :keyword soft_delete_policy: The soft delete policy for a container registry.
        :paramtype soft_delete_policy:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SoftDeletePolicy
        """
        super().__init__(**kwargs)
        self.quarantine_policy = quarantine_policy
        self.trust_policy = trust_policy
        self.retention_policy = retention_policy
        self.export_policy = export_policy
        self.azure_ad_authentication_as_arm_policy = azure_ad_authentication_as_arm_policy
        self.soft_delete_policy = soft_delete_policy


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    :ivar id: This is private endpoint resource created with Microsoft.Network resource provider.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: This is private endpoint resource created with Microsoft.Network resource
         provider.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(ProxyResource):
    """An object that represents a private endpoint connection for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of private endpoint connection resource. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private endpoint.
        :paramtype private_endpoint:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """The result of a request to list private endpoint connections for a container registry.

    :ivar value: The list of private endpoint connections. Since this list may be incomplete, the
     nextLink field should be used to request the next list of private endpoint connections.
    :vartype value:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateEndpointConnection]
    :ivar next_link: The URI that can be used to request the next list of private endpoint
     connections.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of private endpoint connections. Since this list may be incomplete,
         the nextLink field should be used to request the next list of private endpoint connections.
        :paramtype value:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateEndpointConnection]
        :keyword next_link: The URI that can be used to request the next list of private endpoint
         connections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """A resource that supports private link capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The resource type is private link resource.
    :vartype type: str
    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The resource ID.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword required_members: The private link resource required member names.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id = id
        self.name = name
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """The result of a request to list private link resources for a container registry.

    :ivar value: The list of private link resources. Since this list may be incomplete, the
     nextLink field should be used to request the next list of private link resources.
    :vartype value:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateLinkResource]
    :ivar next_link: The URI that can be used to request the next list of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of private link resources. Since this list may be incomplete, the
         nextLink field should be used to request the next list of private link resources.
        :paramtype value:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateLinkResource]
        :keyword next_link: The URI that can be used to request the next list of private link
         resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The state of a private link service connection.

    :ivar status: The private link service connection status. Known values are: "Approved",
     "Pending", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectionStatus
    :ivar description: The description for connection status. For example if connection is rejected
     it can indicate reason for rejection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. Known values are: "None" and "Recreate".
    :vartype actions_required: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ActionsRequired
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "_models.ActionsRequired"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The private link service connection status. Known values are: "Approved",
         "Pending", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ConnectionStatus
        :keyword description: The description for connection status. For example if connection is
         rejected it can indicate reason for rejection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer. Known values are: "None" and "Recreate".
        :paramtype actions_required: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ActionsRequired
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProgressProperties(_serialization.Model):
    """ProgressProperties.

    :ivar percentage: The percentage complete of the copy operation.
    :vartype percentage: str
    """

    _attribute_map = {
        "percentage": {"key": "percentage", "type": "str"},
    }

    def __init__(self, *, percentage: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword percentage: The percentage complete of the copy operation.
        :paramtype percentage: str
        """
        super().__init__(**kwargs)
        self.percentage = percentage


class QuarantinePolicy(_serialization.Model):
    """The quarantine policy for a container registry.

    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[Union[str, "_models.PolicyStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.status = status


class RegenerateCredentialParameters(_serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to server.

    :ivar name: Specifies name of the password which should be regenerated -- password or
     password2. Required. Known values are: "password" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PasswordName
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.PasswordName"], **kwargs: Any) -> None:
        """
        :keyword name: Specifies name of the password which should be regenerated -- password or
         password2. Required. Known values are: "password" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PasswordName
        """
        super().__init__(**kwargs)
        self.name = name


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar sku: The SKU of the container registry. Required.
    :vartype sku: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Sku
    :ivar identity: The identity of the container registry.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Known values are: "Creating", "Updating", "Deleting", "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar status: The status of the container registry at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Status
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar network_rule_set: The network rule set for a container registry.
    :vartype network_rule_set:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleSet
    :ivar policies: The policies for a container registry.
    :vartype policies: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Policies
    :ivar encryption: The encryption settings of container registry.
    :vartype encryption:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EncryptionProperty
    :ivar data_endpoint_enabled: Enable a single data endpoint per region for serving data.
    :vartype data_endpoint_enabled: bool
    :ivar data_endpoint_host_names: List of host names that will serve data when
     dataEndpointEnabled is true.
    :vartype data_endpoint_host_names: list[str]
    :ivar private_endpoint_connections: List of private endpoint connections for a container
     registry.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.PrivateEndpointConnection]
    :ivar public_network_access: Whether or not public network access is allowed for the container
     registry. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PublicNetworkAccess
    :ivar network_rule_bypass_options: Whether to allow trusted Azure services to access a network
     restricted registry. Known values are: "AzureServices" and "None".
    :vartype network_rule_bypass_options: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleBypassOptions
    :ivar zone_redundancy: Whether or not zone redundancy is enabled for this container registry.
     Known values are: "Enabled" and "Disabled".
    :vartype zone_redundancy: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ZoneRedundancy
    :ivar anonymous_pull_enabled: Enables registry-wide pull from unauthenticated clients.
    :vartype anonymous_pull_enabled: bool
    :ivar metadata_search: Determines whether registry artifacts are indexed for metadata search.
     Known values are: "Enabled" and "Disabled".
    :vartype metadata_search: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.MetadataSearch
    :ivar auto_generated_domain_name_label_scope: Determines the domain name label reuse scope.
     Known values are: "Unsecure", "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and
     "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AutoGeneratedDomainNameLabelScope
    :ivar role_assignment_mode: Determines registry role assignment mode. Known values are:
     "AbacRepositoryPermissions" and "LegacyRegistryPermissions".
    :vartype role_assignment_mode: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RoleAssignmentMode
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "login_server": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "data_endpoint_host_names": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "login_server": {"key": "properties.loginServer", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "Status"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "network_rule_set": {"key": "properties.networkRuleSet", "type": "NetworkRuleSet"},
        "policies": {"key": "properties.policies", "type": "Policies"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperty"},
        "data_endpoint_enabled": {"key": "properties.dataEndpointEnabled", "type": "bool"},
        "data_endpoint_host_names": {"key": "properties.dataEndpointHostNames", "type": "[str]"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "network_rule_bypass_options": {"key": "properties.networkRuleBypassOptions", "type": "str"},
        "zone_redundancy": {"key": "properties.zoneRedundancy", "type": "str"},
        "anonymous_pull_enabled": {"key": "properties.anonymousPullEnabled", "type": "bool"},
        "metadata_search": {"key": "properties.metadataSearch", "type": "str"},
        "auto_generated_domain_name_label_scope": {
            "key": "properties.autoGeneratedDomainNameLabelScope",
            "type": "str",
        },
        "role_assignment_mode": {"key": "properties.roleAssignmentMode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        admin_user_enabled: bool = False,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        policies: Optional["_models.Policies"] = None,
        encryption: Optional["_models.EncryptionProperty"] = None,
        data_endpoint_enabled: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        network_rule_bypass_options: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = None,
        anonymous_pull_enabled: bool = False,
        metadata_search: Optional[Union[str, "_models.MetadataSearch"]] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        role_assignment_mode: Optional[Union[str, "_models.RoleAssignmentMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the container registry. Required.
        :paramtype sku: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Sku
        :keyword identity: The identity of the container registry.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword network_rule_set: The network rule set for a container registry.
        :paramtype network_rule_set:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleSet
        :keyword policies: The policies for a container registry.
        :paramtype policies: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Policies
        :keyword encryption: The encryption settings of container registry.
        :paramtype encryption:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EncryptionProperty
        :keyword data_endpoint_enabled: Enable a single data endpoint per region for serving data.
        :paramtype data_endpoint_enabled: bool
        :keyword public_network_access: Whether or not public network access is allowed for the
         container registry. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PublicNetworkAccess
        :keyword network_rule_bypass_options: Whether to allow trusted Azure services to access a
         network restricted registry. Known values are: "AzureServices" and "None".
        :paramtype network_rule_bypass_options: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleBypassOptions
        :keyword zone_redundancy: Whether or not zone redundancy is enabled for this container
         registry. Known values are: "Enabled" and "Disabled".
        :paramtype zone_redundancy: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ZoneRedundancy
        :keyword anonymous_pull_enabled: Enables registry-wide pull from unauthenticated clients.
        :paramtype anonymous_pull_enabled: bool
        :keyword metadata_search: Determines whether registry artifacts are indexed for metadata
         search. Known values are: "Enabled" and "Disabled".
        :paramtype metadata_search: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.MetadataSearch
        :keyword auto_generated_domain_name_label_scope: Determines the domain name label reuse scope.
         Known values are: "Unsecure", "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and
         "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AutoGeneratedDomainNameLabelScope
        :keyword role_assignment_mode: Determines registry role assignment mode. Known values are:
         "AbacRepositoryPermissions" and "LegacyRegistryPermissions".
        :paramtype role_assignment_mode: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RoleAssignmentMode
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.login_server: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.status: Optional["_models.Status"] = None
        self.admin_user_enabled = admin_user_enabled
        self.network_rule_set = network_rule_set
        self.policies = policies
        self.encryption = encryption
        self.data_endpoint_enabled = data_endpoint_enabled
        self.data_endpoint_host_names: Optional[List[str]] = None
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.public_network_access = public_network_access
        self.network_rule_bypass_options = network_rule_bypass_options
        self.zone_redundancy = zone_redundancy
        self.anonymous_pull_enabled = anonymous_pull_enabled
        self.metadata_search = metadata_search
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.role_assignment_mode = role_assignment_mode


class RegistryListCredentialsResult(_serialization.Model):
    """The response from the ListCredentials operation.

    :ivar username: The username for a container registry.
    :vartype username: str
    :ivar passwords: The list of passwords for a container registry.
    :vartype passwords:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.RegistryPassword]
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "passwords": {"key": "passwords", "type": "[RegistryPassword]"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        passwords: Optional[List["_models.RegistryPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: The username for a container registry.
        :paramtype username: str
        :keyword passwords: The list of passwords for a container registry.
        :paramtype passwords:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.RegistryPassword]
        """
        super().__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class RegistryListResult(_serialization.Model):
    """The result of a request to list container registries.

    :ivar value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Registry]
    :ivar next_link: The URI that can be used to request the next list of container registries.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Registry]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Registry"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of container registries. Since this list may be incomplete, the
         nextLink field should be used to request the next list of container registries.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Registry]
        :keyword next_link: The URI that can be used to request the next list of container registries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegistryNameCheckRequest(_serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the container registry. Required.
    :vartype name: str
    :ivar type: The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Required. Default value is
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    :ivar resource_group_name: The resource group name of the container registry.
    :vartype resource_group_name: str
    :ivar auto_generated_domain_name_label_scope: The auto generated domain name label of the
     container registry. This value defaults to "Unsecure". Known values are: "Unsecure",
     "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        "name": {"required": True, "max_length": 50, "min_length": 5, "pattern": r"^[a-zA-Z0-9]*$"},
        "type": {"required": True, "constant": True},
        "resource_group_name": {"max_length": 90, "min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "auto_generated_domain_name_label_scope": {"key": "autoGeneratedDomainNameLabelScope", "type": "str"},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(
        self,
        *,
        name: str,
        resource_group_name: Optional[str] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the container registry. Required.
        :paramtype name: str
        :keyword resource_group_name: The resource group name of the container registry.
        :paramtype resource_group_name: str
        :keyword auto_generated_domain_name_label_scope: The auto generated domain name label of the
         container registry. This value defaults to "Unsecure". Known values are: "Unsecure",
         "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AutoGeneratedDomainNameLabelScope
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_group_name = resource_group_name
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class RegistryNameStatus(_serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :ivar available_login_server_name: The complete login server name with domain name label (DNL)
     hash, if available.
    :vartype available_login_server_name: str
    :ivar name_available: The value that indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: If any, the reason that the name is not available.
    :vartype reason: str
    :ivar message: If any, the error message that provides more detail for the reason that the name
     is not available.
    :vartype message: str
    """

    _attribute_map = {
        "available_login_server_name": {"key": "availableLoginServerName", "type": "str"},
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        available_login_server_name: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_login_server_name: The complete login server name with domain name label
         (DNL) hash, if available.
        :paramtype available_login_server_name: str
        :keyword name_available: The value that indicates whether the name is available.
        :paramtype name_available: bool
        :keyword reason: If any, the reason that the name is not available.
        :paramtype reason: str
        :keyword message: If any, the error message that provides more detail for the reason that the
         name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.available_login_server_name = available_login_server_name
        self.name_available = name_available
        self.reason = reason
        self.message = message


class RegistryPassword(_serialization.Model):
    """The login password for the container registry.

    :ivar name: The password name. Known values are: "password" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.PasswordName"]] = None, value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The password name. Known values are: "password" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PasswordName
        :keyword value: The password value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class RegistryUpdateParameters(_serialization.Model):
    """The parameters for updating a container registry.

    :ivar identity: The identity of the container registry.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar tags: The tags for the container registry.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU of the container registry.
    :vartype sku: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Sku
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar network_rule_set: The network rule set for a container registry.
    :vartype network_rule_set:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleSet
    :ivar policies: The policies for a container registry.
    :vartype policies: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Policies
    :ivar encryption: The encryption settings of container registry.
    :vartype encryption:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EncryptionProperty
    :ivar data_endpoint_enabled: Enable a single data endpoint per region for serving data.
    :vartype data_endpoint_enabled: bool
    :ivar public_network_access: Whether or not public network access is allowed for the container
     registry. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PublicNetworkAccess
    :ivar network_rule_bypass_options: Whether to allow trusted Azure services to access a network
     restricted registry. Known values are: "AzureServices" and "None".
    :vartype network_rule_bypass_options: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleBypassOptions
    :ivar anonymous_pull_enabled: Enables registry-wide pull from unauthenticated clients.
    :vartype anonymous_pull_enabled: bool
    :ivar metadata_search: Determines whether registry artifacts are indexed for metadata search.
     Known values are: "Enabled" and "Disabled".
    :vartype metadata_search: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.MetadataSearch
    :ivar role_assignment_mode: Determines registry role assignment mode. Known values are:
     "AbacRepositoryPermissions" and "LegacyRegistryPermissions".
    :vartype role_assignment_mode: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RoleAssignmentMode
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "network_rule_set": {"key": "properties.networkRuleSet", "type": "NetworkRuleSet"},
        "policies": {"key": "properties.policies", "type": "Policies"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperty"},
        "data_endpoint_enabled": {"key": "properties.dataEndpointEnabled", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "network_rule_bypass_options": {"key": "properties.networkRuleBypassOptions", "type": "str"},
        "anonymous_pull_enabled": {"key": "properties.anonymousPullEnabled", "type": "bool"},
        "metadata_search": {"key": "properties.metadataSearch", "type": "str"},
        "role_assignment_mode": {"key": "properties.roleAssignmentMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        admin_user_enabled: Optional[bool] = None,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        policies: Optional["_models.Policies"] = None,
        encryption: Optional["_models.EncryptionProperty"] = None,
        data_endpoint_enabled: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        network_rule_bypass_options: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        anonymous_pull_enabled: Optional[bool] = None,
        metadata_search: Optional[Union[str, "_models.MetadataSearch"]] = None,
        role_assignment_mode: Optional[Union[str, "_models.RoleAssignmentMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the container registry.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword tags: The tags for the container registry.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the container registry.
        :paramtype sku: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Sku
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword network_rule_set: The network rule set for a container registry.
        :paramtype network_rule_set:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleSet
        :keyword policies: The policies for a container registry.
        :paramtype policies: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Policies
        :keyword encryption: The encryption settings of container registry.
        :paramtype encryption:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.EncryptionProperty
        :keyword data_endpoint_enabled: Enable a single data endpoint per region for serving data.
        :paramtype data_endpoint_enabled: bool
        :keyword public_network_access: Whether or not public network access is allowed for the
         container registry. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PublicNetworkAccess
        :keyword network_rule_bypass_options: Whether to allow trusted Azure services to access a
         network restricted registry. Known values are: "AzureServices" and "None".
        :paramtype network_rule_bypass_options: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.NetworkRuleBypassOptions
        :keyword anonymous_pull_enabled: Enables registry-wide pull from unauthenticated clients.
        :paramtype anonymous_pull_enabled: bool
        :keyword metadata_search: Determines whether registry artifacts are indexed for metadata
         search. Known values are: "Enabled" and "Disabled".
        :paramtype metadata_search: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.MetadataSearch
        :keyword role_assignment_mode: Determines registry role assignment mode. Known values are:
         "AbacRepositoryPermissions" and "LegacyRegistryPermissions".
        :paramtype role_assignment_mode: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RoleAssignmentMode
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.sku = sku
        self.admin_user_enabled = admin_user_enabled
        self.network_rule_set = network_rule_set
        self.policies = policies
        self.encryption = encryption
        self.data_endpoint_enabled = data_endpoint_enabled
        self.public_network_access = public_network_access
        self.network_rule_bypass_options = network_rule_bypass_options
        self.anonymous_pull_enabled = anonymous_pull_enabled
        self.metadata_search = metadata_search
        self.role_assignment_mode = role_assignment_mode


class RegistryUsage(_serialization.Model):
    """The quota usage for a container registry.

    :ivar name: The name of the usage.
    :vartype name: str
    :ivar limit: The limit of the usage.
    :vartype limit: int
    :ivar current_value: The current value of the usage.
    :vartype current_value: int
    :ivar unit: The unit of measurement. Known values are: "Count" and "Bytes".
    :vartype unit: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RegistryUsageUnit
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "limit": {"key": "limit", "type": "int"},
        "current_value": {"key": "currentValue", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        limit: Optional[int] = None,
        current_value: Optional[int] = None,
        unit: Optional[Union[str, "_models.RegistryUsageUnit"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the usage.
        :paramtype name: str
        :keyword limit: The limit of the usage.
        :paramtype limit: int
        :keyword current_value: The current value of the usage.
        :paramtype current_value: int
        :keyword unit: The unit of measurement. Known values are: "Count" and "Bytes".
        :paramtype unit: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RegistryUsageUnit
        """
        super().__init__(**kwargs)
        self.name = name
        self.limit = limit
        self.current_value = current_value
        self.unit = unit


class RegistryUsageListResult(_serialization.Model):
    """The result of a request to get container registry quota usages.

    :ivar value: The list of container registry quota usages.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.RegistryUsage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RegistryUsage]"},
    }

    def __init__(self, *, value: Optional[List["_models.RegistryUsage"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of container registry quota usages.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.RegistryUsage]
        """
        super().__init__(**kwargs)
        self.value = value


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar provisioning_state: The provisioning state of the replication at the time the operation
     was called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Status
    :ivar region_endpoint_enabled: Specifies whether the replication's regional endpoint is
     enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
     however its data will continue to be synced with other replications.
    :vartype region_endpoint_enabled: bool
    :ivar zone_redundancy: Whether or not zone redundancy is enabled for this container registry
     replication. Known values are: "Enabled" and "Disabled".
    :vartype zone_redundancy: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ZoneRedundancy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "Status"},
        "region_endpoint_enabled": {"key": "properties.regionEndpointEnabled", "type": "bool"},
        "zone_redundancy": {"key": "properties.zoneRedundancy", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        region_endpoint_enabled: bool = True,
        zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword region_endpoint_enabled: Specifies whether the replication's regional endpoint is
         enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
         however its data will continue to be synced with other replications.
        :paramtype region_endpoint_enabled: bool
        :keyword zone_redundancy: Whether or not zone redundancy is enabled for this container registry
         replication. Known values are: "Enabled" and "Disabled".
        :paramtype zone_redundancy: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ZoneRedundancy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.status: Optional["_models.Status"] = None
        self.region_endpoint_enabled = region_endpoint_enabled
        self.zone_redundancy = zone_redundancy


class ReplicationListResult(_serialization.Model):
    """The result of a request to list replications for a container registry.

    :ivar value: The list of replications. Since this list may be incomplete, the nextLink field
     should be used to request the next list of replications.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Replication]
    :ivar next_link: The URI that can be used to request the next list of replications.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Replication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Replication"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of replications. Since this list may be incomplete, the nextLink field
         should be used to request the next list of replications.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Replication]
        :keyword next_link: The URI that can be used to request the next list of replications.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReplicationUpdateParameters(_serialization.Model):
    """The parameters for updating a replication.

    :ivar tags: The tags for the replication.
    :vartype tags: dict[str, str]
    :ivar region_endpoint_enabled: Specifies whether the replication's regional endpoint is
     enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
     however its data will continue to be synced with other replications.
    :vartype region_endpoint_enabled: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "region_endpoint_enabled": {"key": "properties.regionEndpointEnabled", "type": "bool"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, region_endpoint_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the replication.
        :paramtype tags: dict[str, str]
        :keyword region_endpoint_enabled: Specifies whether the replication's regional endpoint is
         enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
         however its data will continue to be synced with other replications.
        :paramtype region_endpoint_enabled: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.region_endpoint_enabled = region_endpoint_enabled


class Request(_serialization.Model):
    """The request that generated the event.

    :ivar id: The ID of the request that initiated the event.
    :vartype id: str
    :ivar addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :vartype addr: str
    :ivar host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :vartype host: str
    :ivar method: The request method that generated the event.
    :vartype method: str
    :ivar useragent: The user agent header of the request.
    :vartype useragent: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "addr": {"key": "addr", "type": "str"},
        "host": {"key": "host", "type": "str"},
        "method": {"key": "method", "type": "str"},
        "useragent": {"key": "useragent", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        addr: Optional[str] = None,
        host: Optional[str] = None,
        method: Optional[str] = None,
        useragent: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the request that initiated the event.
        :paramtype id: str
        :keyword addr: The IP or hostname and possibly port of the client connection that initiated the
         event. This is the RemoteAddr from the standard http request.
        :paramtype addr: str
        :keyword host: The externally accessible hostname of the registry instance, as specified by the
         http host header on incoming requests.
        :paramtype host: str
        :keyword method: The request method that generated the event.
        :paramtype method: str
        :keyword useragent: The user agent header of the request.
        :paramtype useragent: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.addr = addr
        self.host = host
        self.method = method
        self.useragent = useragent


class RetentionPolicy(_serialization.Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar days: The number of days to retain an untagged manifest after which it gets purged.
    :vartype days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
    """

    _validation = {
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "days": {"key": "days", "type": "int"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, days: int = 7, status: Optional[Union[str, "_models.PolicyStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword days: The number of days to retain an untagged manifest after which it gets purged.
        :paramtype days: int
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.days = days
        self.last_updated_time: Optional[datetime.datetime] = None
        self.status = status


class Run(ProxyResource):
    """Run resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar run_id: The unique identifier for the run.
    :vartype run_id: str
    :ivar status: The current status of the run. Known values are: "Queued", "Started", "Running",
     "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunStatus
    :ivar last_updated_time: The last updated time for the run.
    :vartype last_updated_time: ~datetime.datetime
    :ivar run_type: The type of run. Known values are: "QuickBuild", "QuickRun", "AutoBuild", and
     "AutoRun".
    :vartype run_type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunType
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar create_time: The time the run was scheduled.
    :vartype create_time: ~datetime.datetime
    :ivar start_time: The time the run started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The time the run finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_images: The list of all images that were generated from the run. This is
     applicable if the run generates base image dependencies.
    :vartype output_images:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageDescriptor]
    :ivar task: The task against which run was scheduled.
    :vartype task: str
    :ivar image_update_trigger: The image update trigger that caused the run. This is applicable if
     the task has base image trigger configured.
    :vartype image_update_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageUpdateTrigger
    :ivar source_trigger: The source trigger that caused the run.
    :vartype source_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerDescriptor
    :ivar timer_trigger: The timer trigger that caused the run.
    :vartype timer_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TimerTriggerDescriptor
    :ivar platform: The platform properties against which the run will happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
    :ivar source_registry_auth: The scope of the credentials that were used to login to the source
     registry during this run.
    :vartype source_registry_auth: str
    :ivar custom_registries: The list of custom registries that were logged in during this run.
    :vartype custom_registries: list[str]
    :ivar run_error_message: The error message received from backend systems after the run is
     scheduled.
    :vartype run_error_message: str
    :ivar update_trigger_token: The update trigger token passed for the Run.
    :vartype update_trigger_token: str
    :ivar log_artifact: The image description for the log artifact.
    :vartype log_artifact: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageDescriptor
    :ivar provisioning_state: The provisioning state of a run. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "run_error_message": {"readonly": True},
        "log_artifact": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "run_id": {"key": "properties.runId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "run_type": {"key": "properties.runType", "type": "str"},
        "agent_pool_name": {"key": "properties.agentPoolName", "type": "str"},
        "create_time": {"key": "properties.createTime", "type": "iso-8601"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "finish_time": {"key": "properties.finishTime", "type": "iso-8601"},
        "output_images": {"key": "properties.outputImages", "type": "[ImageDescriptor]"},
        "task": {"key": "properties.task", "type": "str"},
        "image_update_trigger": {"key": "properties.imageUpdateTrigger", "type": "ImageUpdateTrigger"},
        "source_trigger": {"key": "properties.sourceTrigger", "type": "SourceTriggerDescriptor"},
        "timer_trigger": {"key": "properties.timerTrigger", "type": "TimerTriggerDescriptor"},
        "platform": {"key": "properties.platform", "type": "PlatformProperties"},
        "agent_configuration": {"key": "properties.agentConfiguration", "type": "AgentProperties"},
        "source_registry_auth": {"key": "properties.sourceRegistryAuth", "type": "str"},
        "custom_registries": {"key": "properties.customRegistries", "type": "[str]"},
        "run_error_message": {"key": "properties.runErrorMessage", "type": "str"},
        "update_trigger_token": {"key": "properties.updateTriggerToken", "type": "str"},
        "log_artifact": {"key": "properties.logArtifact", "type": "ImageDescriptor"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "is_archive_enabled": {"key": "properties.isArchiveEnabled", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        run_id: Optional[str] = None,
        status: Optional[Union[str, "_models.RunStatus"]] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        run_type: Optional[Union[str, "_models.RunType"]] = None,
        agent_pool_name: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_images: Optional[List["_models.ImageDescriptor"]] = None,
        task: Optional[str] = None,
        image_update_trigger: Optional["_models.ImageUpdateTrigger"] = None,
        source_trigger: Optional["_models.SourceTriggerDescriptor"] = None,
        timer_trigger: Optional["_models.TimerTriggerDescriptor"] = None,
        platform: Optional["_models.PlatformProperties"] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_registry_auth: Optional[str] = None,
        custom_registries: Optional[List[str]] = None,
        update_trigger_token: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        is_archive_enabled: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword run_id: The unique identifier for the run.
        :paramtype run_id: str
        :keyword status: The current status of the run. Known values are: "Queued", "Started",
         "Running", "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunStatus
        :keyword last_updated_time: The last updated time for the run.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword run_type: The type of run. Known values are: "QuickBuild", "QuickRun", "AutoBuild",
         and "AutoRun".
        :paramtype run_type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunType
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword create_time: The time the run was scheduled.
        :paramtype create_time: ~datetime.datetime
        :keyword start_time: The time the run started.
        :paramtype start_time: ~datetime.datetime
        :keyword finish_time: The time the run finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword output_images: The list of all images that were generated from the run. This is
         applicable if the run generates base image dependencies.
        :paramtype output_images:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageDescriptor]
        :keyword task: The task against which run was scheduled.
        :paramtype task: str
        :keyword image_update_trigger: The image update trigger that caused the run. This is applicable
         if the task has base image trigger configured.
        :paramtype image_update_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ImageUpdateTrigger
        :keyword source_trigger: The source trigger that caused the run.
        :paramtype source_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerDescriptor
        :keyword timer_trigger: The timer trigger that caused the run.
        :paramtype timer_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TimerTriggerDescriptor
        :keyword platform: The platform properties against which the run will happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
        :keyword source_registry_auth: The scope of the credentials that were used to login to the
         source registry during this run.
        :paramtype source_registry_auth: str
        :keyword custom_registries: The list of custom registries that were logged in during this run.
        :paramtype custom_registries: list[str]
        :keyword update_trigger_token: The update trigger token passed for the Run.
        :paramtype update_trigger_token: str
        :keyword provisioning_state: The provisioning state of a run. Known values are: "Creating",
         "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        """
        super().__init__(**kwargs)
        self.run_id = run_id
        self.status = status
        self.last_updated_time = last_updated_time
        self.run_type = run_type
        self.agent_pool_name = agent_pool_name
        self.create_time = create_time
        self.start_time = start_time
        self.finish_time = finish_time
        self.output_images = output_images
        self.task = task
        self.image_update_trigger = image_update_trigger
        self.source_trigger = source_trigger
        self.timer_trigger = timer_trigger
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_registry_auth = source_registry_auth
        self.custom_registries = custom_registries
        self.run_error_message: Optional[str] = None
        self.update_trigger_token = update_trigger_token
        self.log_artifact: Optional["_models.ImageDescriptor"] = None
        self.provisioning_state = provisioning_state
        self.is_archive_enabled = is_archive_enabled


class RunFilter(_serialization.Model):
    """Properties that are enabled for Odata querying on runs.

    :ivar run_id: The unique identifier for the run.
    :vartype run_id: str
    :ivar run_type: The type of run. Known values are: "QuickBuild", "QuickRun", "AutoBuild", and
     "AutoRun".
    :vartype run_type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunType
    :ivar status: The current status of the run. Known values are: "Queued", "Started", "Running",
     "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunStatus
    :ivar create_time: The create time for a run.
    :vartype create_time: ~datetime.datetime
    :ivar finish_time: The time the run finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_image_manifests: The list of comma-separated image manifests that were generated
     from the run. This is applicable if the run is of
     build type.
    :vartype output_image_manifests: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    :ivar task_name: The name of the task that the run corresponds to.
    :vartype task_name: str
    :ivar agent_pool_name: The name of the agent pool that the run corresponds to.
    :vartype agent_pool_name: str
    """

    _attribute_map = {
        "run_id": {"key": "runId", "type": "str"},
        "run_type": {"key": "runType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "create_time": {"key": "createTime", "type": "iso-8601"},
        "finish_time": {"key": "finishTime", "type": "iso-8601"},
        "output_image_manifests": {"key": "outputImageManifests", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "task_name": {"key": "taskName", "type": "str"},
        "agent_pool_name": {"key": "agentPoolName", "type": "str"},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        run_type: Optional[Union[str, "_models.RunType"]] = None,
        status: Optional[Union[str, "_models.RunStatus"]] = None,
        create_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_image_manifests: Optional[str] = None,
        is_archive_enabled: Optional[bool] = None,
        task_name: Optional[str] = None,
        agent_pool_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword run_id: The unique identifier for the run.
        :paramtype run_id: str
        :keyword run_type: The type of run. Known values are: "QuickBuild", "QuickRun", "AutoBuild",
         and "AutoRun".
        :paramtype run_type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunType
        :keyword status: The current status of the run. Known values are: "Queued", "Started",
         "Running", "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunStatus
        :keyword create_time: The create time for a run.
        :paramtype create_time: ~datetime.datetime
        :keyword finish_time: The time the run finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword output_image_manifests: The list of comma-separated image manifests that were
         generated from the run. This is applicable if the run is of
         build type.
        :paramtype output_image_manifests: str
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        :keyword task_name: The name of the task that the run corresponds to.
        :paramtype task_name: str
        :keyword agent_pool_name: The name of the agent pool that the run corresponds to.
        :paramtype agent_pool_name: str
        """
        super().__init__(**kwargs)
        self.run_id = run_id
        self.run_type = run_type
        self.status = status
        self.create_time = create_time
        self.finish_time = finish_time
        self.output_image_manifests = output_image_manifests
        self.is_archive_enabled = is_archive_enabled
        self.task_name = task_name
        self.agent_pool_name = agent_pool_name


class RunGetLogResult(_serialization.Model):
    """The result of get log link operation.

    :ivar log_link: The link to logs for a run on a azure container registry.
    :vartype log_link: str
    :ivar log_artifact_link: The link to logs in registry for a run on a azure container registry.
    :vartype log_artifact_link: str
    """

    _attribute_map = {
        "log_link": {"key": "logLink", "type": "str"},
        "log_artifact_link": {"key": "logArtifactLink", "type": "str"},
    }

    def __init__(
        self, *, log_link: Optional[str] = None, log_artifact_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword log_link: The link to logs for a run on a azure container registry.
        :paramtype log_link: str
        :keyword log_artifact_link: The link to logs in registry for a run on a azure container
         registry.
        :paramtype log_artifact_link: str
        """
        super().__init__(**kwargs)
        self.log_link = log_link
        self.log_artifact_link = log_artifact_link


class RunListResult(_serialization.Model):
    """Collection of runs.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Run]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Run]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Run"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Run]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunUpdateParameters(_serialization.Model):
    """The set of run properties that can be updated.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    _attribute_map = {
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
    }

    def __init__(self, *, is_archive_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_archive_enabled = is_archive_enabled


class ScopeMap(ProxyResource):
    """An object that represents a scope map for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar description: The user friendly description of the scope map.
    :vartype description: str
    :ivar type_properties_type: The type of the scope map. E.g. BuildIn scope map.
    :vartype type_properties_type: str
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar actions: The list of scoped permissions for registry artifacts.
     E.g. repositories/repository-name/content/read,
     repositories/repository-name/metadata/write.
    :vartype actions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "type_properties_type": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self, *, description: Optional[str] = None, actions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: The user friendly description of the scope map.
        :paramtype description: str
        :keyword actions: The list of scoped permissions for registry artifacts.
         E.g. repositories/repository-name/content/read,
         repositories/repository-name/metadata/write.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.type_properties_type: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.actions = actions


class ScopeMapListResult(_serialization.Model):
    """The result of a request to list scope maps for a container registry.

    :ivar value: The list of scope maps. Since this list may be incomplete, the nextLink field
     should be used to request the next list of scope maps.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ScopeMap]
    :ivar next_link: The URI that can be used to request the next list of scope maps.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ScopeMap]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ScopeMap"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of scope maps. Since this list may be incomplete, the nextLink field
         should be used to request the next list of scope maps.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.ScopeMap]
        :keyword next_link: The URI that can be used to request the next list of scope maps.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ScopeMapUpdateParameters(_serialization.Model):
    """The properties for updating the scope map.

    :ivar description: The user friendly description of the scope map.
    :vartype description: str
    :ivar actions: The list of scope permissions for registry artifacts.
     E.g. repositories/repository-name/pull,
     repositories/repository-name/delete.
    :vartype actions: list[str]
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self, *, description: Optional[str] = None, actions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: The user friendly description of the scope map.
        :paramtype description: str
        :keyword actions: The list of scope permissions for registry artifacts.
         E.g. repositories/repository-name/pull,
         repositories/repository-name/delete.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.actions = actions


class SecretObject(_serialization.Model):
    """Describes the properties of a secret object value.

    :ivar value: The value of the secret. The format of this value will be determined
     based on the type of the secret object. If the type is Opaque, the value will be
     used as is without any modification.
    :vartype value: str
    :ivar type: The type of the secret object which determines how the value of the secret object
     has to be
     interpreted. Known values are: "Opaque" and "Vaultsecret".
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SecretObjectType
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        type: Optional[Union[str, "_models.SecretObjectType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The value of the secret. The format of this value will be determined
         based on the type of the secret object. If the type is Opaque, the value will be
         used as is without any modification.
        :paramtype value: str
        :keyword type: The type of the secret object which determines how the value of the secret
         object has to be
         interpreted. Known values are: "Opaque" and "Vaultsecret".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SecretObjectType
        """
        super().__init__(**kwargs)
        self.value = value
        self.type = type


class SetValue(_serialization.Model):
    """The properties of a overridable value that can be passed to a task template.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the overridable value. Required.
    :vartype name: str
    :ivar value: The overridable value. Required.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the value represents a secret or not.
    :vartype is_secret: bool
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "is_secret": {"key": "isSecret", "type": "bool"},
    }

    def __init__(self, *, name: str, value: str, is_secret: bool = False, **kwargs: Any) -> None:
        """
        :keyword name: The name of the overridable value. Required.
        :paramtype name: str
        :keyword value: The overridable value. Required.
        :paramtype value: str
        :keyword is_secret: Flag to indicate whether the value represents a secret or not.
        :paramtype is_secret: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.is_secret = is_secret


class Sku(_serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The SKU name of the container registry. Required for registry creation. Required.
     Known values are: "Classic", "Basic", "Standard", and "Premium".
    :vartype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Known values are: "Classic", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SkuTier
    """

    _validation = {
        "name": {"required": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.SkuName"], **kwargs: Any) -> None:
        """
        :keyword name: The SKU name of the container registry. Required for registry creation.
         Required. Known values are: "Classic", "Basic", "Standard", and "Premium".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier: Optional[Union[str, "_models.SkuTier"]] = None


class SoftDeletePolicy(_serialization.Model):
    """The soft delete policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar retention_days: The number of days after which a soft-deleted item is permanently
     deleted.
    :vartype retention_days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
    """

    _validation = {
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "retention_days": {"key": "retentionDays", "type": "int"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, retention_days: int = 7, status: Optional[Union[str, "_models.PolicyStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword retention_days: The number of days after which a soft-deleted item is permanently
         deleted.
        :paramtype retention_days: int
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.retention_days = retention_days
        self.last_updated_time: Optional[datetime.datetime] = None
        self.status = status


class Source(_serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the
    event, the source generates it.

    :ivar addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :vartype addr: str
    :ivar instance_id: The running instance of an application. Changes after each restart.
    :vartype instance_id: str
    """

    _attribute_map = {
        "addr": {"key": "addr", "type": "str"},
        "instance_id": {"key": "instanceID", "type": "str"},
    }

    def __init__(self, *, addr: Optional[str] = None, instance_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword addr: The IP or hostname and the port of the registry node that generated the event.
         Generally, this will be resolved by os.Hostname() along with the running port.
        :paramtype addr: str
        :keyword instance_id: The running instance of an application. Changes after each restart.
        :paramtype instance_id: str
        """
        super().__init__(**kwargs)
        self.addr = addr
        self.instance_id = instance_id


class SourceProperties(_serialization.Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to server.

    :ivar source_control_type: The type of source control service. Required. Known values are:
     "Github" and "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceControlType
    :ivar repository_url: The full URL to the source code repository. Required.
    :vartype repository_url: str
    :ivar branch: The branch name of the source code.
    :vartype branch: str
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthInfo
    """

    _validation = {
        "source_control_type": {"required": True},
        "repository_url": {"required": True},
    }

    _attribute_map = {
        "source_control_type": {"key": "sourceControlType", "type": "str"},
        "repository_url": {"key": "repositoryUrl", "type": "str"},
        "branch": {"key": "branch", "type": "str"},
        "source_control_auth_properties": {"key": "sourceControlAuthProperties", "type": "AuthInfo"},
    }

    def __init__(
        self,
        *,
        source_control_type: Union[str, "_models.SourceControlType"],
        repository_url: str,
        branch: Optional[str] = None,
        source_control_auth_properties: Optional["_models.AuthInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_control_type: The type of source control service. Required. Known values are:
         "Github" and "VisualStudioTeamService".
        :paramtype source_control_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceControlType
        :keyword repository_url: The full URL to the source code repository. Required.
        :paramtype repository_url: str
        :keyword branch: The branch name of the source code.
        :paramtype branch: str
        :keyword source_control_auth_properties: The authorization properties for accessing the source
         code repository and to set up
         webhooks for notifications.
        :paramtype source_control_auth_properties:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthInfo
        """
        super().__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.branch = branch
        self.source_control_auth_properties = source_control_auth_properties


class SourceRegistryCredentials(_serialization.Model):
    """Describes the credential parameters for accessing the source registry.

    :ivar identity: The Entra identity used for source registry login.
     The value is ``[system]`` for system-assigned managed identity, ``[caller]`` for caller
     identity,
     and client ID for user-assigned managed identity.
    :vartype identity: str
    :ivar login_mode: The authentication mode which determines the source registry login scope. The
     credentials for the source registry
     will be generated using the given scope. These credentials will be used to login to
     the source registry during the run. Known values are: "None" and "Default".
    :vartype login_mode: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceRegistryLoginMode
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
        "login_mode": {"key": "loginMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional[str] = None,
        login_mode: Optional[Union[str, "_models.SourceRegistryLoginMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The Entra identity used for source registry login.
         The value is ``[system]`` for system-assigned managed identity, ``[caller]`` for caller
         identity,
         and client ID for user-assigned managed identity.
        :paramtype identity: str
        :keyword login_mode: The authentication mode which determines the source registry login scope.
         The credentials for the source registry
         will be generated using the given scope. These credentials will be used to login to
         the source registry during the run. Known values are: "None" and "Default".
        :paramtype login_mode: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceRegistryLoginMode
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.login_mode = login_mode


class SourceTrigger(_serialization.Model):
    """The properties of a source based trigger.

    All required parameters must be populated in order to send to server.

    :ivar source_repository: The properties that describes the source(code) for the task. Required.
    :vartype source_repository:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceProperties
    :ivar source_trigger_events: The source event corresponding to the trigger. Required.
    :vartype source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerEvent]
    :ivar status: The current status of trigger. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    _validation = {
        "source_repository": {"required": True},
        "source_trigger_events": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "source_repository": {"key": "sourceRepository", "type": "SourceProperties"},
        "source_trigger_events": {"key": "sourceTriggerEvents", "type": "[str]"},
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_repository: "_models.SourceProperties",
        source_trigger_events: List[Union[str, "_models.SourceTriggerEvent"]],
        name: str,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_repository: The properties that describes the source(code) for the task.
         Required.
        :paramtype source_repository:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceProperties
        :keyword source_trigger_events: The source event corresponding to the trigger. Required.
        :paramtype source_trigger_events: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerEvent]
        :keyword status: The current status of trigger. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        :keyword name: The name of the trigger. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.source_repository = source_repository
        self.source_trigger_events = source_trigger_events
        self.status = status
        self.name = name


class SourceTriggerDescriptor(_serialization.Model):
    """The source trigger that caused a run.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar event_type: The event type of the trigger.
    :vartype event_type: str
    :ivar commit_id: The unique ID that identifies a commit.
    :vartype commit_id: str
    :ivar pull_request_id: The unique ID that identifies pull request.
    :vartype pull_request_id: str
    :ivar repository_url: The repository URL.
    :vartype repository_url: str
    :ivar branch_name: The branch name in the repository.
    :vartype branch_name: str
    :ivar provider_type: The source control provider type.
    :vartype provider_type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "commit_id": {"key": "commitId", "type": "str"},
        "pull_request_id": {"key": "pullRequestId", "type": "str"},
        "repository_url": {"key": "repositoryUrl", "type": "str"},
        "branch_name": {"key": "branchName", "type": "str"},
        "provider_type": {"key": "providerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        event_type: Optional[str] = None,
        commit_id: Optional[str] = None,
        pull_request_id: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch_name: Optional[str] = None,
        provider_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The unique ID of the trigger.
        :paramtype id: str
        :keyword event_type: The event type of the trigger.
        :paramtype event_type: str
        :keyword commit_id: The unique ID that identifies a commit.
        :paramtype commit_id: str
        :keyword pull_request_id: The unique ID that identifies pull request.
        :paramtype pull_request_id: str
        :keyword repository_url: The repository URL.
        :paramtype repository_url: str
        :keyword branch_name: The branch name in the repository.
        :paramtype branch_name: str
        :keyword provider_type: The source control provider type.
        :paramtype provider_type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.event_type = event_type
        self.commit_id = commit_id
        self.pull_request_id = pull_request_id
        self.repository_url = repository_url
        self.branch_name = branch_name
        self.provider_type = provider_type


class SourceTriggerUpdateParameters(_serialization.Model):
    """The properties for updating a source based trigger.

    All required parameters must be populated in order to send to server.

    :ivar source_repository: The properties that describes the source(code) for the task.
    :vartype source_repository:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceUpdateParameters
    :ivar source_trigger_events: The source event corresponding to the trigger.
    :vartype source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerEvent]
    :ivar status: The current status of trigger. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "source_repository": {"key": "sourceRepository", "type": "SourceUpdateParameters"},
        "source_trigger_events": {"key": "sourceTriggerEvents", "type": "[str]"},
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        source_repository: Optional["_models.SourceUpdateParameters"] = None,
        source_trigger_events: Optional[List[Union[str, "_models.SourceTriggerEvent"]]] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_repository: The properties that describes the source(code) for the task.
        :paramtype source_repository:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceUpdateParameters
        :keyword source_trigger_events: The source event corresponding to the trigger.
        :paramtype source_trigger_events: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerEvent]
        :keyword status: The current status of trigger. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        :keyword name: The name of the trigger. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.source_repository = source_repository
        self.source_trigger_events = source_trigger_events
        self.status = status
        self.name = name


class SourceUpdateParameters(_serialization.Model):
    """The properties for updating the source code repository.

    :ivar source_control_type: The type of source control service. Known values are: "Github" and
     "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceControlType
    :ivar repository_url: The full URL to the source code repository.
    :vartype repository_url: str
    :ivar branch: The branch name of the source code.
    :vartype branch: str
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthInfoUpdateParameters
    """

    _attribute_map = {
        "source_control_type": {"key": "sourceControlType", "type": "str"},
        "repository_url": {"key": "repositoryUrl", "type": "str"},
        "branch": {"key": "branch", "type": "str"},
        "source_control_auth_properties": {"key": "sourceControlAuthProperties", "type": "AuthInfoUpdateParameters"},
    }

    def __init__(
        self,
        *,
        source_control_type: Optional[Union[str, "_models.SourceControlType"]] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        source_control_auth_properties: Optional["_models.AuthInfoUpdateParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_control_type: The type of source control service. Known values are: "Github"
         and "VisualStudioTeamService".
        :paramtype source_control_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceControlType
        :keyword repository_url: The full URL to the source code repository.
        :paramtype repository_url: str
        :keyword branch: The branch name of the source code.
        :paramtype branch: str
        :keyword source_control_auth_properties: The authorization properties for accessing the source
         code repository and to set up
         webhooks for notifications.
        :paramtype source_control_auth_properties:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AuthInfoUpdateParameters
        """
        super().__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.branch = branch
        self.source_control_auth_properties = source_control_auth_properties


class SourceUploadDefinition(_serialization.Model):
    """The properties of a response to source upload request.

    :ivar upload_url: The URL where the client can upload the source.
    :vartype upload_url: str
    :ivar relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :vartype relative_path: str
    """

    _attribute_map = {
        "upload_url": {"key": "uploadUrl", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
    }

    def __init__(self, *, upload_url: Optional[str] = None, relative_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword upload_url: The URL where the client can upload the source.
        :paramtype upload_url: str
        :keyword relative_path: The relative path to the source. This is used to submit the subsequent
         queue build request.
        :paramtype relative_path: str
        """
        super().__init__(**kwargs)
        self.upload_url = upload_url
        self.relative_path = relative_path


class Status(_serialization.Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current value.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        "display_status": {"readonly": True},
        "message": {"readonly": True},
        "timestamp": {"readonly": True},
    }

    _attribute_map = {
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_status: Optional[str] = None
        self.message: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None


class StatusDetailProperties(_serialization.Model):
    """The status detail properties of the connected registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The component of the connected registry corresponding to the status.
    :vartype type: str
    :ivar code: The code of the status.
    :vartype code: str
    :ivar description: The description of the status.
    :vartype description: str
    :ivar timestamp: The timestamp of the status.
    :vartype timestamp: ~datetime.datetime
    :ivar correlation_id: The correlation ID of the status.
    :vartype correlation_id: str
    """

    _validation = {
        "type": {"readonly": True},
        "code": {"readonly": True},
        "description": {"readonly": True},
        "timestamp": {"readonly": True},
        "correlation_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "correlation_id": {"key": "correlationId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.code: Optional[str] = None
        self.description: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None
        self.correlation_id: Optional[str] = None


class StorageAccountProperties(_serialization.Model):
    """The properties of a storage account for a container registry. Only applicable to Classic SKU.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID of the storage account. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource ID of the storage account. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SyncProperties(_serialization.Model):
    """The sync properties of the connected registry with its parent.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar token_id: The resource ID of the ACR token used to authenticate the connected registry to
     its parent during sync. Required.
    :vartype token_id: str
    :ivar schedule: The cron expression indicating the schedule that the connected registry will
     sync with its parent.
    :vartype schedule: str
    :ivar sync_window: The time window during which sync is enabled for each schedule occurrence.
     Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
    :vartype sync_window: ~datetime.timedelta
    :ivar message_ttl: The period of time for which a message is available to sync before it is
     expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     Required.
    :vartype message_ttl: ~datetime.timedelta
    :ivar last_sync_time: The last time a sync occurred between the connected registry and its
     parent.
    :vartype last_sync_time: ~datetime.datetime
    :ivar gateway_endpoint: The gateway endpoint used by the connected registry to communicate with
     its parent.
    :vartype gateway_endpoint: str
    """

    _validation = {
        "token_id": {"required": True},
        "message_ttl": {"required": True},
        "last_sync_time": {"readonly": True},
        "gateway_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "token_id": {"key": "tokenId", "type": "str"},
        "schedule": {"key": "schedule", "type": "str"},
        "sync_window": {"key": "syncWindow", "type": "duration"},
        "message_ttl": {"key": "messageTtl", "type": "duration"},
        "last_sync_time": {"key": "lastSyncTime", "type": "iso-8601"},
        "gateway_endpoint": {"key": "gatewayEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        token_id: str,
        message_ttl: datetime.timedelta,
        schedule: Optional[str] = None,
        sync_window: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword token_id: The resource ID of the ACR token used to authenticate the connected registry
         to its parent during sync. Required.
        :paramtype token_id: str
        :keyword schedule: The cron expression indicating the schedule that the connected registry will
         sync with its parent.
        :paramtype schedule: str
        :keyword sync_window: The time window during which sync is enabled for each schedule
         occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        :paramtype sync_window: ~datetime.timedelta
        :keyword message_ttl: The period of time for which a message is available to sync before it is
         expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
         Required.
        :paramtype message_ttl: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.token_id = token_id
        self.schedule = schedule
        self.sync_window = sync_window
        self.message_ttl = message_ttl
        self.last_sync_time: Optional[datetime.datetime] = None
        self.gateway_endpoint: Optional[str] = None


class SyncUpdateProperties(_serialization.Model):
    """The parameters for updating the sync properties of the connected registry with its parent.

    :ivar schedule: The cron expression indicating the schedule that the connected registry will
     sync with its parent.
    :vartype schedule: str
    :ivar sync_window: The time window during which sync is enabled for each schedule occurrence.
     Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
    :vartype sync_window: ~datetime.timedelta
    :ivar message_ttl: The period of time for which a message is available to sync before it is
     expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
    :vartype message_ttl: ~datetime.timedelta
    """

    _attribute_map = {
        "schedule": {"key": "schedule", "type": "str"},
        "sync_window": {"key": "syncWindow", "type": "duration"},
        "message_ttl": {"key": "messageTtl", "type": "duration"},
    }

    def __init__(
        self,
        *,
        schedule: Optional[str] = None,
        sync_window: Optional[datetime.timedelta] = None,
        message_ttl: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule: The cron expression indicating the schedule that the connected registry will
         sync with its parent.
        :paramtype schedule: str
        :keyword sync_window: The time window during which sync is enabled for each schedule
         occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        :paramtype sync_window: ~datetime.timedelta
        :keyword message_ttl: The period of time for which a message is available to sync before it is
         expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        :paramtype message_ttl: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.schedule = schedule
        self.sync_window = sync_window
        self.message_ttl = message_ttl


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LastModifiedByType
    :ivar last_modified_at: The timestamp of resource modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.LastModifiedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.LastModifiedByType
        :keyword last_modified_at: The timestamp of resource modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Target(_serialization.Model):
    """The target of the event.

    :ivar media_type: The MIME type of the referenced object.
    :vartype media_type: str
    :ivar size: The number of bytes of the content. Same as Length field.
    :vartype size: int
    :ivar digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :vartype digest: str
    :ivar length: The number of bytes of the content. Same as Size field.
    :vartype length: int
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar url: The direct URL to the content.
    :vartype url: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar name: The name of the artifact.
    :vartype name: str
    :ivar version: The version of the artifact.
    :vartype version: str
    """

    _attribute_map = {
        "media_type": {"key": "mediaType", "type": "str"},
        "size": {"key": "size", "type": "int"},
        "digest": {"key": "digest", "type": "str"},
        "length": {"key": "length", "type": "int"},
        "repository": {"key": "repository", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        length: Optional[int] = None,
        repository: Optional[str] = None,
        url: Optional[str] = None,
        tag: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword media_type: The MIME type of the referenced object.
        :paramtype media_type: str
        :keyword size: The number of bytes of the content. Same as Length field.
        :paramtype size: int
        :keyword digest: The digest of the content, as defined by the Registry V2 HTTP API
         Specification.
        :paramtype digest: str
        :keyword length: The number of bytes of the content. Same as Size field.
        :paramtype length: int
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword url: The direct URL to the content.
        :paramtype url: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword name: The name of the artifact.
        :paramtype name: str
        :keyword version: The version of the artifact.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.length = length
        self.repository = repository
        self.url = url
        self.tag = tag
        self.name = name
        self.version = version


class Task(Resource):
    """The task that has the ARM resource and task properties.
    The task will have all information to schedule a run against it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar provisioning_state: The provisioning state of the task. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar creation_date: The creation date of task.
    :vartype creation_date: ~datetime.datetime
    :ivar status: The current status of task. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStatus
    :ivar platform: The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
    :ivar agent_pool_name: The dedicated agent pool for the task.
    :vartype agent_pool_name: str
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar step: The properties of a task step.
    :vartype step: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStepProperties
    :ivar trigger: The properties that describe all triggers for the task.
    :vartype trigger: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerProperties
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar is_system_task: The value of this property indicates whether the task resource is system
     task or not.
    :vartype is_system_task: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "creation_date": {"readonly": True},
        "timeout": {"maximum": 28800, "minimum": 300},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "status": {"key": "properties.status", "type": "str"},
        "platform": {"key": "properties.platform", "type": "PlatformProperties"},
        "agent_configuration": {"key": "properties.agentConfiguration", "type": "AgentProperties"},
        "agent_pool_name": {"key": "properties.agentPoolName", "type": "str"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "step": {"key": "properties.step", "type": "TaskStepProperties"},
        "trigger": {"key": "properties.trigger", "type": "TriggerProperties"},
        "credentials": {"key": "properties.credentials", "type": "Credentials"},
        "log_template": {"key": "properties.logTemplate", "type": "str"},
        "is_system_task": {"key": "properties.isSystemTask", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        status: Optional[Union[str, "_models.TaskStatus"]] = None,
        platform: Optional["_models.PlatformProperties"] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        agent_pool_name: Optional[str] = None,
        timeout: int = 3600,
        step: Optional["_models.TaskStepProperties"] = None,
        trigger: Optional["_models.TriggerProperties"] = None,
        credentials: Optional["_models.Credentials"] = None,
        log_template: Optional[str] = None,
        is_system_task: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword status: The current status of task. Known values are: "Disabled" and "Enabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStatus
        :keyword platform: The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
        :keyword agent_pool_name: The dedicated agent pool for the task.
        :paramtype agent_pool_name: str
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword step: The properties of a task step.
        :paramtype step: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStepProperties
        :keyword trigger: The properties that describe all triggers for the task.
        :paramtype trigger: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerProperties
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword is_system_task: The value of this property indicates whether the task resource is
         system task or not.
        :paramtype is_system_task: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.status = status
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.agent_pool_name = agent_pool_name
        self.timeout = timeout
        self.step = step
        self.trigger = trigger
        self.credentials = credentials
        self.log_template = log_template
        self.is_system_task = is_system_task


class TaskListResult(_serialization.Model):
    """The collection of tasks.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Task]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Task]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Task"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Task]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TaskRun(ProxyResource):
    """The task run that has the ARM resource and properties.
    The task run will have the information of request and result of a run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of this task run. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar run_request: The request (parameters) for the run.
    :vartype run_request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunRequest
    :ivar run_result: The result of this task run.
    :vartype run_result: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Run
    :ivar force_update_tag: How the run should be forced to rerun even if the run request
     configuration has not changed.
    :vartype force_update_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "run_result": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "run_request": {"key": "properties.runRequest", "type": "RunRequest"},
        "run_result": {"key": "properties.runResult", "type": "Run"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        location: Optional[str] = None,
        run_request: Optional["_models.RunRequest"] = None,
        force_update_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword run_request: The request (parameters) for the run.
        :paramtype run_request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunRequest
        :keyword force_update_tag: How the run should be forced to rerun even if the run request
         configuration has not changed.
        :paramtype force_update_tag: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.run_request = run_request
        self.run_result: Optional["_models.Run"] = None
        self.force_update_tag = force_update_tag


class TaskRunListResult(_serialization.Model):
    """The collection of task runs.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskRun]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[TaskRun]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.TaskRun"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskRun]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TaskRunRequest(RunRequest):
    """The parameters for a task run request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the run request. Required.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar task_id: The resource ID of task against which run has to be queued. Required.
    :vartype task_id: str
    :ivar override_task_step_properties: Set of overridable parameters that can be passed when
     running a Task.
    :vartype override_task_step_properties:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OverrideTaskStepProperties
    """

    _validation = {
        "type": {"required": True},
        "task_id": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "agent_pool_name": {"key": "agentPoolName", "type": "str"},
        "log_template": {"key": "logTemplate", "type": "str"},
        "task_id": {"key": "taskId", "type": "str"},
        "override_task_step_properties": {"key": "overrideTaskStepProperties", "type": "OverrideTaskStepProperties"},
    }

    def __init__(
        self,
        *,
        task_id: str,
        is_archive_enabled: bool = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        override_task_step_properties: Optional["_models.OverrideTaskStepProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword task_id: The resource ID of task against which run has to be queued. Required.
        :paramtype task_id: str
        :keyword override_task_step_properties: Set of overridable parameters that can be passed when
         running a Task.
        :paramtype override_task_step_properties:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.OverrideTaskStepProperties
        """
        super().__init__(
            is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs
        )
        self.type: str = "TaskRunRequest"
        self.task_id = task_id
        self.override_task_step_properties = override_task_step_properties


class TaskRunUpdateParameters(_serialization.Model):
    """The parameters for updating a task run.

    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar run_request: The request (parameters) for the new run.
    :vartype run_request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunRequest
    :ivar force_update_tag: How the run should be forced to rerun even if the run request
     configuration has not changed.
    :vartype force_update_tag: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "run_request": {"key": "properties.runRequest", "type": "RunRequest"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        run_request: Optional["_models.RunRequest"] = None,
        force_update_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword run_request: The request (parameters) for the new run.
        :paramtype run_request: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.RunRequest
        :keyword force_update_tag: How the run should be forced to rerun even if the run request
         configuration has not changed.
        :paramtype force_update_tag: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.run_request = run_request
        self.force_update_tag = force_update_tag


class TaskUpdateParameters(_serialization.Model):
    """The parameters for updating a task.

    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar status: The current status of task. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStatus
    :ivar platform: The platform properties against which the run has to happen.
    :vartype platform:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformUpdateParameters
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
    :ivar agent_pool_name: The dedicated agent pool for the task.
    :vartype agent_pool_name: str
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar step: The properties for updating a task step.
    :vartype step:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStepUpdateParameters
    :ivar trigger: The properties for updating trigger properties.
    :vartype trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerUpdateParameters
    :ivar credentials: The parameters that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "platform": {"key": "properties.platform", "type": "PlatformUpdateParameters"},
        "agent_configuration": {"key": "properties.agentConfiguration", "type": "AgentProperties"},
        "agent_pool_name": {"key": "properties.agentPoolName", "type": "str"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "step": {"key": "properties.step", "type": "TaskStepUpdateParameters"},
        "trigger": {"key": "properties.trigger", "type": "TriggerUpdateParameters"},
        "credentials": {"key": "properties.credentials", "type": "Credentials"},
        "log_template": {"key": "properties.logTemplate", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.TaskStatus"]] = None,
        platform: Optional["_models.PlatformUpdateParameters"] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        agent_pool_name: Optional[str] = None,
        timeout: Optional[int] = None,
        step: Optional["_models.TaskStepUpdateParameters"] = None,
        trigger: Optional["_models.TriggerUpdateParameters"] = None,
        credentials: Optional["_models.Credentials"] = None,
        log_template: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.IdentityProperties
        :keyword tags: The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword status: The current status of task. Known values are: "Disabled" and "Enabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStatus
        :keyword platform: The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PlatformUpdateParameters
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.AgentProperties
        :keyword agent_pool_name: The dedicated agent pool for the task.
        :paramtype agent_pool_name: str
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword step: The properties for updating a task step.
        :paramtype step:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TaskStepUpdateParameters
        :keyword trigger: The properties for updating trigger properties.
        :paramtype trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerUpdateParameters
        :keyword credentials: The parameters that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.Credentials
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.status = status
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.agent_pool_name = agent_pool_name
        self.timeout = timeout
        self.step = step
        self.trigger = trigger
        self.credentials = credentials
        self.log_template = log_template


class TimerTrigger(_serialization.Model):
    """The properties of a timer trigger.

    All required parameters must be populated in order to send to server.

    :ivar schedule: The CRON expression for the task schedule. Required.
    :vartype schedule: str
    :ivar status: The current status of trigger. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    _validation = {
        "schedule": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "schedule": {"key": "schedule", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, schedule: str, name: str, status: Optional[Union[str, "_models.TriggerStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword schedule: The CRON expression for the task schedule. Required.
        :paramtype schedule: str
        :keyword status: The current status of trigger. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        :keyword name: The name of the trigger. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.schedule = schedule
        self.status = status
        self.name = name


class TimerTriggerDescriptor(_serialization.Model):
    """TimerTriggerDescriptor.

    :ivar timer_trigger_name: The timer trigger name that caused the run.
    :vartype timer_trigger_name: str
    :ivar schedule_occurrence: The occurrence that triggered the run.
    :vartype schedule_occurrence: str
    """

    _attribute_map = {
        "timer_trigger_name": {"key": "timerTriggerName", "type": "str"},
        "schedule_occurrence": {"key": "scheduleOccurrence", "type": "str"},
    }

    def __init__(
        self, *, timer_trigger_name: Optional[str] = None, schedule_occurrence: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword timer_trigger_name: The timer trigger name that caused the run.
        :paramtype timer_trigger_name: str
        :keyword schedule_occurrence: The occurrence that triggered the run.
        :paramtype schedule_occurrence: str
        """
        super().__init__(**kwargs)
        self.timer_trigger_name = timer_trigger_name
        self.schedule_occurrence = schedule_occurrence


class TimerTriggerUpdateParameters(_serialization.Model):
    """The properties for updating a timer trigger.

    All required parameters must be populated in order to send to server.

    :ivar schedule: The CRON expression for the task schedule.
    :vartype schedule: str
    :ivar status: The current status of trigger. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "schedule": {"key": "schedule", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        schedule: Optional[str] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule: The CRON expression for the task schedule.
        :paramtype schedule: str
        :keyword status: The current status of trigger. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TriggerStatus
        :keyword name: The name of the trigger. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.schedule = schedule
        self.status = status
        self.name = name


class TlsCertificateProperties(_serialization.Model):
    """The TLS certificate properties of the connected registry login server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of certificate location. "LocalDirectory"
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.CertificateType
    :ivar location: Indicates the location of the certificates.
    :vartype location: str
    """

    _validation = {
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.CertificateType"]] = None
        self.location: Optional[str] = None


class TlsProperties(_serialization.Model):
    """The TLS properties of the connected registry login server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Indicates whether HTTPS is enabled for the login server. Known values are:
     "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TlsStatus
    :ivar certificate: The certificate used to configure HTTPS for the login server.
    :vartype certificate:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TlsCertificateProperties
    """

    _validation = {
        "status": {"readonly": True},
        "certificate": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "certificate": {"key": "certificate", "type": "TlsCertificateProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.TlsStatus"]] = None
        self.certificate: Optional["_models.TlsCertificateProperties"] = None


class Token(ProxyResource):
    """An object that represents a token for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    :ivar scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :vartype scope_map_id: str
    :ivar credentials: The credentials that can be used for authenticating the token.
    :vartype credentials:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCredentialsProperties
    :ivar status: The status of the token example enabled or disabled. Known values are: "enabled"
     and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "scope_map_id": {"key": "properties.scopeMapId", "type": "str"},
        "credentials": {"key": "properties.credentials", "type": "TokenCredentialsProperties"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope_map_id: Optional[str] = None,
        credentials: Optional["_models.TokenCredentialsProperties"] = None,
        status: Optional[Union[str, "_models.TokenStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope_map_id: The resource ID of the scope map to which the token will be associated
         with.
        :paramtype scope_map_id: str
        :keyword credentials: The credentials that can be used for authenticating the token.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCredentialsProperties
        :keyword status: The status of the token example enabled or disabled. Known values are:
         "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenStatus
        """
        super().__init__(**kwargs)
        self.creation_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.scope_map_id = scope_map_id
        self.credentials = credentials
        self.status = status


class TokenCertificate(_serialization.Model):
    """The properties of a certificate used for authenticating a token.

    :ivar name: Known values are: "certificate1" and "certificate2".
    :vartype name: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCertificateName
    :ivar expiry: The expiry datetime of the certificate.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The thumbprint of the certificate.
    :vartype thumbprint: str
    :ivar encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format
     that will be used for authenticating the token.
    :vartype encoded_pem_certificate: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "encoded_pem_certificate": {"key": "encodedPemCertificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.TokenCertificateName"]] = None,
        expiry: Optional[datetime.datetime] = None,
        thumbprint: Optional[str] = None,
        encoded_pem_certificate: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Known values are: "certificate1" and "certificate2".
        :paramtype name: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCertificateName
        :keyword expiry: The expiry datetime of the certificate.
        :paramtype expiry: ~datetime.datetime
        :keyword thumbprint: The thumbprint of the certificate.
        :paramtype thumbprint: str
        :keyword encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM
         format that will be used for authenticating the token.
        :paramtype encoded_pem_certificate: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.encoded_pem_certificate = encoded_pem_certificate


class TokenCredentialsProperties(_serialization.Model):
    """The properties of the credentials that can be used for authenticating the token.

    :ivar certificates:
    :vartype certificates:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCertificate]
    :ivar passwords:
    :vartype passwords:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        "certificates": {"key": "certificates", "type": "[TokenCertificate]"},
        "passwords": {"key": "passwords", "type": "[TokenPassword]"},
    }

    def __init__(
        self,
        *,
        certificates: Optional[List["_models.TokenCertificate"]] = None,
        passwords: Optional[List["_models.TokenPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificates:
        :paramtype certificates:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCertificate]
        :keyword passwords:
        :paramtype passwords:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPassword]
        """
        super().__init__(**kwargs)
        self.certificates = certificates
        self.passwords = passwords


class TokenListResult(_serialization.Model):
    """The result of a request to list tokens for a container registry.

    :ivar value: The list of tokens. Since this list may be incomplete, the nextLink field should
     be used to request the next list of tokens.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Token]
    :ivar next_link: The URI that can be used to request the next list of tokens.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Token]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Token"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of tokens. Since this list may be incomplete, the nextLink field
         should be used to request the next list of tokens.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Token]
        :keyword next_link: The URI that can be used to request the next list of tokens.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TokenPassword(_serialization.Model):
    """The password that will be used for authenticating the token of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar creation_time: The creation datetime of the password.
    :vartype creation_time: ~datetime.datetime
    :ivar expiry: The expiry datetime of the password.
    :vartype expiry: ~datetime.datetime
    :ivar name: The password name "password1" or "password2". Known values are: "password1" and
     "password2".
    :vartype name: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        creation_time: Optional[datetime.datetime] = None,
        expiry: Optional[datetime.datetime] = None,
        name: Optional[Union[str, "_models.TokenPasswordName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword creation_time: The creation datetime of the password.
        :paramtype creation_time: ~datetime.datetime
        :keyword expiry: The expiry datetime of the password.
        :paramtype expiry: ~datetime.datetime
        :keyword name: The password name "password1" or "password2". Known values are: "password1" and
         "password2".
        :paramtype name: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenPasswordName
        """
        super().__init__(**kwargs)
        self.creation_time = creation_time
        self.expiry = expiry
        self.name = name
        self.value: Optional[str] = None


class TokenUpdateParameters(_serialization.Model):
    """The parameters for updating a token.

    :ivar scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :vartype scope_map_id: str
    :ivar status: The status of the token example enabled or disabled. Known values are: "enabled"
     and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenStatus
    :ivar credentials: The credentials that can be used for authenticating the token.
    :vartype credentials:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCredentialsProperties
    """

    _attribute_map = {
        "scope_map_id": {"key": "properties.scopeMapId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "credentials": {"key": "properties.credentials", "type": "TokenCredentialsProperties"},
    }

    def __init__(
        self,
        *,
        scope_map_id: Optional[str] = None,
        status: Optional[Union[str, "_models.TokenStatus"]] = None,
        credentials: Optional["_models.TokenCredentialsProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope_map_id: The resource ID of the scope map to which the token will be associated
         with.
        :paramtype scope_map_id: str
        :keyword status: The status of the token example enabled or disabled. Known values are:
         "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenStatus
        :keyword credentials: The credentials that can be used for authenticating the token.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TokenCredentialsProperties
        """
        super().__init__(**kwargs)
        self.scope_map_id = scope_map_id
        self.status = status
        self.credentials = credentials


class TriggerProperties(_serialization.Model):
    """The properties of a trigger.

    :ivar timer_triggers: The collection of timer triggers.
    :vartype timer_triggers:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TimerTrigger]
    :ivar source_triggers: The collection of triggers based on source code repository.
    :vartype source_triggers:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTrigger]
    :ivar base_image_trigger: The trigger based on base image dependencies.
    :vartype base_image_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTrigger
    """

    _attribute_map = {
        "timer_triggers": {"key": "timerTriggers", "type": "[TimerTrigger]"},
        "source_triggers": {"key": "sourceTriggers", "type": "[SourceTrigger]"},
        "base_image_trigger": {"key": "baseImageTrigger", "type": "BaseImageTrigger"},
    }

    def __init__(
        self,
        *,
        timer_triggers: Optional[List["_models.TimerTrigger"]] = None,
        source_triggers: Optional[List["_models.SourceTrigger"]] = None,
        base_image_trigger: Optional["_models.BaseImageTrigger"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timer_triggers: The collection of timer triggers.
        :paramtype timer_triggers:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TimerTrigger]
        :keyword source_triggers: The collection of triggers based on source code repository.
        :paramtype source_triggers:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTrigger]
        :keyword base_image_trigger: The trigger based on base image dependencies.
        :paramtype base_image_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTrigger
        """
        super().__init__(**kwargs)
        self.timer_triggers = timer_triggers
        self.source_triggers = source_triggers
        self.base_image_trigger = base_image_trigger


class TriggerUpdateParameters(_serialization.Model):
    """The properties for updating triggers.

    :ivar timer_triggers: The collection of timer triggers.
    :vartype timer_triggers:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TimerTriggerUpdateParameters]
    :ivar source_triggers: The collection of triggers based on source code repository.
    :vartype source_triggers:
     list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerUpdateParameters]
    :ivar base_image_trigger: The trigger based on base image dependencies.
    :vartype base_image_trigger:
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTriggerUpdateParameters
    """

    _attribute_map = {
        "timer_triggers": {"key": "timerTriggers", "type": "[TimerTriggerUpdateParameters]"},
        "source_triggers": {"key": "sourceTriggers", "type": "[SourceTriggerUpdateParameters]"},
        "base_image_trigger": {"key": "baseImageTrigger", "type": "BaseImageTriggerUpdateParameters"},
    }

    def __init__(
        self,
        *,
        timer_triggers: Optional[List["_models.TimerTriggerUpdateParameters"]] = None,
        source_triggers: Optional[List["_models.SourceTriggerUpdateParameters"]] = None,
        base_image_trigger: Optional["_models.BaseImageTriggerUpdateParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timer_triggers: The collection of timer triggers.
        :paramtype timer_triggers:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.TimerTriggerUpdateParameters]
        :keyword source_triggers: The collection of triggers based on source code repository.
        :paramtype source_triggers:
         list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.SourceTriggerUpdateParameters]
        :keyword base_image_trigger: The trigger based on base image dependencies.
        :paramtype base_image_trigger:
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.BaseImageTriggerUpdateParameters
        """
        super().__init__(**kwargs)
        self.timer_triggers = timer_triggers
        self.source_triggers = source_triggers
        self.base_image_trigger = base_image_trigger


class TrustPolicy(_serialization.Model):
    """The content trust policy for a container registry.

    :ivar type: The type of trust policy. "Notary"
    :vartype type: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TrustPolicyType
    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.TrustPolicyType"] = "Notary",
        status: Optional[Union[str, "_models.PolicyStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of trust policy. "Notary"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.TrustPolicyType
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.type = type
        self.status = status


class UserIdentityProperties(_serialization.Model):
    """UserIdentityProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2025_03_01_preview.models.SystemData
    :ivar status: The status of the webhook at the time the operation was called. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "properties.status", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "_models.WebhookAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookAction]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.scope = scope
        self.actions = actions
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class WebhookCreateParameters(_serialization.Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to server.

    :ivar tags: The tags for the webhook.
    :vartype tags: dict[str, str]
    :ivar location: The location of the webhook. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar service_uri: The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookAction]
    """

    _validation = {
        "location": {"required": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "service_uri": {"key": "properties.serviceUri", "type": "str"},
        "custom_headers": {"key": "properties.customHeaders", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        service_uri: Optional[str] = None,
        custom_headers: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "_models.WebhookAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the webhook.
        :paramtype tags: dict[str, str]
        :keyword location: The location of the webhook. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword service_uri: The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookAction]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions


class WebhookListResult(_serialization.Model):
    """The result of a request to list webhooks for a container registry.

    :ivar value: The list of webhooks. Since this list may be incomplete, the nextLink field should
     be used to request the next list of webhooks.
    :vartype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Webhook]
    :ivar next_link: The URI that can be used to request the next list of webhooks.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Webhook]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Webhook"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of webhooks. Since this list may be incomplete, the nextLink field
         should be used to request the next list of webhooks.
        :paramtype value: list[~azure.mgmt.containerregistry.v2025_03_01_preview.models.Webhook]
        :keyword next_link: The URI that can be used to request the next list of webhooks.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebhookUpdateParameters(_serialization.Model):
    """The parameters for updating a webhook.

    :ivar tags: The tags for the webhook.
    :vartype tags: dict[str, str]
    :ivar service_uri: The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or
     ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookAction]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "service_uri": {"key": "properties.serviceUri", "type": "str"},
        "custom_headers": {"key": "properties.customHeaders", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        service_uri: Optional[str] = None,
        custom_headers: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "_models.WebhookAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the webhook.
        :paramtype tags: dict[str, str]
        :keyword service_uri: The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or
         ~azure.mgmt.containerregistry.v2025_03_01_preview.models.WebhookAction]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions
