// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC18xx.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc18xx

/*
// Register cmsis file for LPC18xx parts
*/

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC18xx"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Digital-to-Analog Converter (DAC)
	IRQ_DAC = 0

	// General Purpose DMA (GPDMA)
	IRQ_DMA = 2

	// EEPROM
	IRQ_FLASH = 4

	// Ethernet
	IRQ_ETHERNET = 5

	// SD/MMC
	IRQ_SDIO = 6

	// LCD controller
	IRQ_LCD = 7

	// USB0 Host/Device/OTG controller
	IRQ_USB0 = 8

	// USB1 Host/Device controller
	IRQ_USB1 = 9

	// State Configurable Timer (SCT) with dither engine
	IRQ_SCT = 10

	// Repetitive Interrupt Timer (RIT)
	IRQ_RITIMER = 11

	// Timer0/1/2/3
	IRQ_TIMER0 = 12

	IRQ_TIMER1 = 13

	IRQ_TIMER2 = 14

	IRQ_TIMER3 = 15

	// Motor Control PWM (MOTOCONPWM)
	IRQ_MCPWM = 16

	// 10-bit Analog-to-Digital Converter (ADC)
	IRQ_ADC0 = 17

	// I2C-bus interface
	IRQ_I2C0 = 18

	IRQ_I2C1 = 19

	IRQ_ADC1 = 21

	// SSP0/1
	IRQ_SSP0 = 22

	IRQ_SSP1 = 23

	// USART0_2_3
	IRQ_USART0 = 24

	// UART1
	IRQ_UART1 = 25

	IRQ_USART2 = 26

	IRQ_USART3 = 27

	// I2S interface
	IRQ_I2S0 = 28

	IRQ_I2S1 = 29

	// SPI Flash Interface (SPIFI)
	IRQ_SPIFI = 30

	// GPIO pin interrupt
	IRQ_PIN_INT0 = 32

	// GPIO pin interrupt
	IRQ_PIN_INT1 = 33

	// GPIO pin interrupt
	IRQ_PIN_INT2 = 34

	// GPIO pin interrupt
	IRQ_PIN_INT3 = 35

	// GPIO pin interrupt
	IRQ_PIN_INT4 = 36

	// GPIO pin interrupt
	IRQ_PIN_INT5 = 37

	// GPIO pin interrupt
	IRQ_PIN_INT6 = 38

	// GPIO pin interrupt
	IRQ_PIN_INT7 = 39

	// GPIO group interrupt 0
	IRQ_GINT0 = 40

	IRQ_GINT1 = 41

	// Event router
	IRQ_EVENTROUTER = 42

	// C_CAN
	IRQ_C_CAN1 = 43

	// Alarm timer
	IRQ_ATIMER = 46

	// Real-Time Clock (RTC) and event recorder
	IRQ_RTC = 47

	// Windowed Watchdog timer (WWDT)
	IRQ_WWDT = 49

	IRQ_C_CAN0 = 51

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 52

	// Highest interrupt number on this device.
	IRQ_max = 52
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export DAC_IRQHandler
func interruptDAC() {
	callHandlers(IRQ_DAC)
}

//export DMA_IRQHandler
func interruptDMA() {
	callHandlers(IRQ_DMA)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export ETHERNET_IRQHandler
func interruptETHERNET() {
	callHandlers(IRQ_ETHERNET)
}

//export SDIO_IRQHandler
func interruptSDIO() {
	callHandlers(IRQ_SDIO)
}

//export LCD_IRQHandler
func interruptLCD() {
	callHandlers(IRQ_LCD)
}

//export USB0_IRQHandler
func interruptUSB0() {
	callHandlers(IRQ_USB0)
}

//export USB1_IRQHandler
func interruptUSB1() {
	callHandlers(IRQ_USB1)
}

//export SCT_IRQHandler
func interruptSCT() {
	callHandlers(IRQ_SCT)
}

//export RITIMER_IRQHandler
func interruptRITIMER() {
	callHandlers(IRQ_RITIMER)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export TIMER3_IRQHandler
func interruptTIMER3() {
	callHandlers(IRQ_TIMER3)
}

//export MCPWM_IRQHandler
func interruptMCPWM() {
	callHandlers(IRQ_MCPWM)
}

//export ADC0_IRQHandler
func interruptADC0() {
	callHandlers(IRQ_ADC0)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export ADC1_IRQHandler
func interruptADC1() {
	callHandlers(IRQ_ADC1)
}

//export SSP0_IRQHandler
func interruptSSP0() {
	callHandlers(IRQ_SSP0)
}

//export SSP1_IRQHandler
func interruptSSP1() {
	callHandlers(IRQ_SSP1)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export I2S0_IRQHandler
func interruptI2S0() {
	callHandlers(IRQ_I2S0)
}

//export I2S1_IRQHandler
func interruptI2S1() {
	callHandlers(IRQ_I2S1)
}

//export SPIFI_IRQHandler
func interruptSPIFI() {
	callHandlers(IRQ_SPIFI)
}

//export PIN_INT0_IRQHandler
func interruptPIN_INT0() {
	callHandlers(IRQ_PIN_INT0)
}

//export PIN_INT1_IRQHandler
func interruptPIN_INT1() {
	callHandlers(IRQ_PIN_INT1)
}

//export PIN_INT2_IRQHandler
func interruptPIN_INT2() {
	callHandlers(IRQ_PIN_INT2)
}

//export PIN_INT3_IRQHandler
func interruptPIN_INT3() {
	callHandlers(IRQ_PIN_INT3)
}

//export PIN_INT4_IRQHandler
func interruptPIN_INT4() {
	callHandlers(IRQ_PIN_INT4)
}

//export PIN_INT5_IRQHandler
func interruptPIN_INT5() {
	callHandlers(IRQ_PIN_INT5)
}

//export PIN_INT6_IRQHandler
func interruptPIN_INT6() {
	callHandlers(IRQ_PIN_INT6)
}

//export PIN_INT7_IRQHandler
func interruptPIN_INT7() {
	callHandlers(IRQ_PIN_INT7)
}

//export GINT0_IRQHandler
func interruptGINT0() {
	callHandlers(IRQ_GINT0)
}

//export GINT1_IRQHandler
func interruptGINT1() {
	callHandlers(IRQ_GINT1)
}

//export EVENTROUTER_IRQHandler
func interruptEVENTROUTER() {
	callHandlers(IRQ_EVENTROUTER)
}

//export C_CAN1_IRQHandler
func interruptC_CAN1() {
	callHandlers(IRQ_C_CAN1)
}

//export ATIMER_IRQHandler
func interruptATIMER() {
	callHandlers(IRQ_ATIMER)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export WWDT_IRQHandler
func interruptWWDT() {
	callHandlers(IRQ_WWDT)
}

//export C_CAN0_IRQHandler
func interruptC_CAN0() {
	callHandlers(IRQ_C_CAN0)
}

//export QEI_IRQHandler
func interruptQEI() {
	callHandlers(IRQ_QEI)
}

// Peripherals.
var (
	// State Configurable Timer (SCT) with dither engine
	SCT = (*SCT_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General Purpose DMA (GPDMA)
	GPDMA = (*GPDMA_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// SPI Flash Interface (SPIFI)
	SPIFI = (*SPIFI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// SD/MMC
	SDMMC = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// External Memory Controller (EMC)
	EMC = (*EMC_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// USB0 Host/Device/OTG controller
	USB0 = (*USB0_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// USB1 Host/Device controller
	USB1 = (*USB1_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// LCD controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// EEPROM
	EEPROM = (*EEPROM_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Ethernet
	ETHERNET = (*ETHERNET_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Alarm timer
	ATIMER = (*ATIMER_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// RTC REGFILE
	REGFILE = (*REGFILE_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// Power Management Controller (PMC)
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x40042000)))

	// Configuration Registers (CREG)
	CREG = (*CREG_Type)(unsafe.Pointer(uintptr(0x40043000)))

	// Event router
	EVENTROUTER = (*EVENTROUTER_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Real-Time Clock (RTC) and event recorder
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40046000)))

	// Clock Generation Unit (CGU)
	CGU = (*CGU_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Clock Control Unit (CCU)
	CCU1 = (*CCU1_Type)(unsafe.Pointer(uintptr(0x40051000)))

	// Clock Control Unit (CCU2)
	CCU2 = (*CCU2_Type)(unsafe.Pointer(uintptr(0x40052000)))

	// Reset Generation Unit (RGU)
	RGU = (*RGU_Type)(unsafe.Pointer(uintptr(0x40053000)))

	// Windowed Watchdog timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// USART0_2_3
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40081000)))

	// UART1
	UART1 = (*UART1_Type)(unsafe.Pointer(uintptr(0x40082000)))

	// SSP0/1
	SSP0 = (*SSP_Type)(unsafe.Pointer(uintptr(0x40083000)))

	// Timer0/1/2/3
	TIMER0 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// System Control Unit (SCU) I/O configuration
	SCU = (*SCU_Type)(unsafe.Pointer(uintptr(0x40086000)))

	// GPIO pin interrupt
	GPIO_PIN_INT = (*GPIO_PIN_INT_Type)(unsafe.Pointer(uintptr(0x40087000)))

	// GPIO group interrupt 0
	GPIO_GROUP_INT0 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// GPIO group interrupt 0
	GPIO_GROUP_INT1 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x40089000)))

	// Motor Control PWM (MOTOCONPWM)
	MCPWM = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// I2C-bus interface
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400a1000)))

	// I2S interface
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a2000)))

	// C_CAN
	C_CAN1 = (*C_CAN1_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// Repetitive Interrupt Timer (RIT)
	RITIMER = (*RITIMER_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x400c6000)))

	// Global Input Multiplexer Array (GIMA)
	GIMA = (*GIMA_Type)(unsafe.Pointer(uintptr(0x400c7000)))

	// Digital-to-Analog Converter (DAC)
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// C_CAN
	C_CAN0 = (*C_CAN1_Type)(unsafe.Pointer(uintptr(0x400e2000)))

	// 10-bit Analog-to-Digital Converter (ADC)
	ADC0 = (*ADC_Type)(unsafe.Pointer(uintptr(0x400e3000)))

	// GPIO port
	GPIO_PORT = (*GPIO_PORT_Type)(unsafe.Pointer(uintptr(0x400f4000)))

	// USART0_2_3
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x400c1000)))

	// USART0_2_3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x400c2000)))

	// SSP0/1
	SSP1 = (*SSP_Type)(unsafe.Pointer(uintptr(0x400c5000)))

	// Timer0/1/2/3
	TIMER1 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40085000)))

	// Timer0/1/2/3
	TIMER2 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x400c3000)))

	// Timer0/1/2/3
	TIMER3 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x400c4000)))

	// I2C-bus interface
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400e0000)))

	// I2S interface
	I2S1 = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a3000)))

	// 10-bit Analog-to-Digital Converter (ADC)
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x400e4000)))
)

// State Configurable Timer (SCT) with dither engine
type SCT_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	DITHER        volatile.Register32 // 0x18
	_             [36]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	MATCH8        volatile.Register32 // 0x120
	MATCH9        volatile.Register32 // 0x124
	MATCH10       volatile.Register32 // 0x128
	MATCH11       volatile.Register32 // 0x12C
	MATCH12       volatile.Register32 // 0x130
	MATCH13       volatile.Register32 // 0x134
	MATCH14       volatile.Register32 // 0x138
	MATCH15       volatile.Register32 // 0x13C
	FRACMAT0      volatile.Register32 // 0x140
	FRACMAT1      volatile.Register32 // 0x144
	FRACMAT2      volatile.Register32 // 0x148
	FRACMAT3      volatile.Register32 // 0x14C
	FRACMAT4      volatile.Register32 // 0x150
	FRACMAT5      volatile.Register32 // 0x154
	_             [168]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	MATCHREL8     volatile.Register32 // 0x220
	MATCHREL9     volatile.Register32 // 0x224
	MATCHREL10    volatile.Register32 // 0x228
	MATCHREL11    volatile.Register32 // 0x22C
	MATCHREL12    volatile.Register32 // 0x230
	MATCHREL13    volatile.Register32 // 0x234
	MATCHREL14    volatile.Register32 // 0x238
	MATCHREL15    volatile.Register32 // 0x23C
	FRACMATREL0   volatile.Register32 // 0x240
	FRACMATREL1   volatile.Register32 // 0x244
	FRACMATREL2   volatile.Register32 // 0x248
	FRACMATREL3   volatile.Register32 // 0x24C
	FRACMATREL4   volatile.Register32 // 0x250
	FRACMATREL5   volatile.Register32 // 0x254
	_             [168]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	EV10_STATE    volatile.Register32 // 0x350
	EV10_CTRL     volatile.Register32 // 0x354
	EV11_STATE    volatile.Register32 // 0x358
	EV11_CTRL     volatile.Register32 // 0x35C
	EV12_STATE    volatile.Register32 // 0x360
	EV12_CTRL     volatile.Register32 // 0x364
	EV13_STATE    volatile.Register32 // 0x368
	EV13_CTRL     volatile.Register32 // 0x36C
	EV14_STATE    volatile.Register32 // 0x370
	EV14_CTRL     volatile.Register32 // 0x374
	EV15_STATE    volatile.Register32 // 0x378
	EV15_CTRL     volatile.Register32 // 0x37C
	_             [384]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
	OUT6_SET      volatile.Register32 // 0x530
	OUT6_CLR      volatile.Register32 // 0x534
	OUT7_SET      volatile.Register32 // 0x538
	OUT7_CLR      volatile.Register32 // 0x53C
	OUT8_SET      volatile.Register32 // 0x540
	OUT8_CLR      volatile.Register32 // 0x544
	OUT9_SET      volatile.Register32 // 0x548
	OUT9_CLR      volatile.Register32 // 0x54C
	OUT10_SET     volatile.Register32 // 0x550
	OUT10_CLR     volatile.Register32 // 0x554
	OUT11_SET     volatile.Register32 // 0x558
	OUT11_CLR     volatile.Register32 // 0x55C
	OUT12_SET     volatile.Register32 // 0x560
	OUT12_CLR     volatile.Register32 // 0x564
	OUT13_SET     volatile.Register32 // 0x568
	OUT13_CLR     volatile.Register32 // 0x56C
	OUT14_SET     volatile.Register32 // 0x570
	OUT14_CLR     volatile.Register32 // 0x574
	OUT15_SET     volatile.Register32 // 0x578
	OUT15_CLR     volatile.Register32 // 0x57C
}

// SCT.CONFIG: SCT configuration register
func (o *SCT_Type) SetCONFIG_UNIFY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetCONFIG_UNIFY() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SCT_Type) SetCONFIG_CLKMODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *SCT_Type) GetCONFIG_CLKMODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x6) >> 1
}
func (o *SCT_Type) SetCONFIG_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x78)|value<<3)
}
func (o *SCT_Type) GetCONFIG_CKSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x78) >> 3
}
func (o *SCT_Type) SetCONFIG_NORELAOD_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetCONFIG_NORELAOD_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetCONFIG_NORELOAD_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetCONFIG_NORELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetCONFIG_INSYNC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1fe00)|value<<9)
}
func (o *SCT_Type) GetCONFIG_INSYNC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1fe00) >> 9
}
func (o *SCT_Type) SetCONFIG_AUTOLIMIT_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetCONFIG_AUTOLIMIT_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetCONFIG_AUTOLIMIT_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetCONFIG_AUTOLIMIT_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *SCT_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfff80000) >> 19
}

// SCT.CTRL: SCT control register
func (o *SCT_Type) SetCTRL_DOWN_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetCTRL_DOWN_L() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *SCT_Type) SetCTRL_STOP_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetCTRL_STOP_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetCTRL_HALT_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetCTRL_HALT_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetCTRL_CLRCTR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetCTRL_CLRCTR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetCTRL_BIDIR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetCTRL_BIDIR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetCTRL_PRE_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe0)|value<<5)
}
func (o *SCT_Type) GetCTRL_PRE_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe0) >> 5
}
func (o *SCT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe000)|value<<13)
}
func (o *SCT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe000) >> 13
}
func (o *SCT_Type) SetCTRL_DOWN_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetCTRL_DOWN_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetCTRL_STOP_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetCTRL_STOP_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetCTRL_HALT_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetCTRL_HALT_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetCTRL_CLRCTR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetCTRL_CLRCTR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetCTRL_BIDIR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetCTRL_BIDIR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetCTRL_PRE_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe00000)|value<<21)
}
func (o *SCT_Type) GetCTRL_PRE_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe00000) >> 21
}
func (o *SCT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe0000000)|value<<29)
}
func (o *SCT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe0000000) >> 29
}

// SCT.LIMIT: SCT limit register
func (o *SCT_Type) SetLIMIT_LIMMSK_L(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetLIMIT_LIMMSK_L() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff
}
func (o *SCT_Type) SetLIMIT_LIMMSK_H(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetLIMIT_LIMMSK_H() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff0000) >> 16
}

// SCT.HALT: SCT halt condition register
func (o *SCT_Type) SetHALT_HALTMSK_L(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetHALT_HALTMSK_L() uint32 {
	return volatile.LoadUint32(&o.HALT.Reg) & 0xffff
}
func (o *SCT_Type) SetHALT_HALTMSK_H(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetHALT_HALTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffff0000) >> 16
}

// SCT.STOP: SCT stop condition register
func (o *SCT_Type) SetSTOP_STOPMSK_L(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetSTOP_STOPMSK_L() uint32 {
	return volatile.LoadUint32(&o.STOP.Reg) & 0xffff
}
func (o *SCT_Type) SetSTOP_STOPMSK_H(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetSTOP_STOPMSK_H() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffff0000) >> 16
}

// SCT.START: SCT start condition register
func (o *SCT_Type) SetSTART_STARTMSK_L(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetSTART_STARTMSK_L() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0xffff
}
func (o *SCT_Type) SetSTART_STARTMSK_H(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetSTART_STARTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffff0000) >> 16
}

// SCT.DITHER: SCT dither condition register
func (o *SCT_Type) SetDITHER_DITHMSK_L(value uint32) {
	volatile.StoreUint32(&o.DITHER.Reg, volatile.LoadUint32(&o.DITHER.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetDITHER_DITHMSK_L() uint32 {
	return volatile.LoadUint32(&o.DITHER.Reg) & 0xffff
}
func (o *SCT_Type) SetDITHER_DITHMSK_H(value uint32) {
	volatile.StoreUint32(&o.DITHER.Reg, volatile.LoadUint32(&o.DITHER.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetDITHER_DITHMSK_H() uint32 {
	return (volatile.LoadUint32(&o.DITHER.Reg) & 0xffff0000) >> 16
}

// SCT.COUNT: SCT counter register
func (o *SCT_Type) SetCOUNT_CTR_L(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetCOUNT_CTR_L() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffff
}
func (o *SCT_Type) SetCOUNT_CTR_H(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetCOUNT_CTR_H() uint32 {
	return (volatile.LoadUint32(&o.COUNT.Reg) & 0xffff0000) >> 16
}

// SCT.STATE: SCT state register
func (o *SCT_Type) SetSTATE_STATE_L(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f)|value)
}
func (o *SCT_Type) GetSTATE_STATE_L() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1f
}
func (o *SCT_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe0) >> 5
}
func (o *SCT_Type) SetSTATE_STATE_H(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT_Type) GetSTATE_STATE_H() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x1f0000) >> 16
}
func (o *SCT_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe00000) >> 21
}

// SCT.INPUT: SCT input register
func (o *SCT_Type) SetINPUT_AIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetINPUT_AIN0() uint32 {
	return volatile.LoadUint32(&o.INPUT.Reg) & 0x1
}
func (o *SCT_Type) SetINPUT_AIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetINPUT_AIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetINPUT_AIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetINPUT_AIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetINPUT_AIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetINPUT_AIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetINPUT_AIN4(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetINPUT_AIN4() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetINPUT_AIN5(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetINPUT_AIN5() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetINPUT_AIN6(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetINPUT_AIN6() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetINPUT_AIN7(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetINPUT_AIN7() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xff00)|value<<8)
}
func (o *SCT_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xff00) >> 8
}
func (o *SCT_Type) SetINPUT_SIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetINPUT_SIN0() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetINPUT_SIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetINPUT_SIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetINPUT_SIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetINPUT_SIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetINPUT_SIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetINPUT_SIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetINPUT_SIN4(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetINPUT_SIN4() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetINPUT_SIN5(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetINPUT_SIN5() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetINPUT_SIN6(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetINPUT_SIN6() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetINPUT_SIN7(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetINPUT_SIN7() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xff000000)|value<<24)
}
func (o *SCT_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xff000000) >> 24
}

// SCT.REGMODE: SCT match/capture registers mode register
func (o *SCT_Type) SetREGMODE_REGMOD_L(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetREGMODE_REGMOD_L() uint32 {
	return volatile.LoadUint32(&o.REGMODE.Reg) & 0xffff
}
func (o *SCT_Type) SetREGMODE_REGMOD_H(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetREGMODE_REGMOD_H() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xffff0000) >> 16
}

// SCT.OUTPUT: SCT output register
func (o *SCT_Type) SetOUTPUT_OUT(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetOUTPUT_OUT() uint32 {
	return volatile.LoadUint32(&o.OUTPUT.Reg) & 0xffff
}
func (o *SCT_Type) SetOUTPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUTPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT.Reg) & 0xffff0000) >> 16
}

// SCT.OUTPUTDIRCTRL: SCT output counter direction control register
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR0(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR0() uint32 {
	return volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR1(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR1() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc) >> 2
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR2(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30)|value<<4)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR2() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30) >> 4
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR3(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR3() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0) >> 6
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR4(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x300)|value<<8)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR4() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x300) >> 8
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR5(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR5() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR6(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR6() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR7(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc000)|value<<14)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR7() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc000) >> 14
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR8(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30000)|value<<16)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR8() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30000) >> 16
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR9(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0000)|value<<18)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR9() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0000) >> 18
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR10(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x300000)|value<<20)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR10() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x300000) >> 20
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR11(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc00000)|value<<22)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR11() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc00000) >> 22
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR12(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3000000)|value<<24)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR12() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3000000) >> 24
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR13(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc000000)|value<<26)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR13() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc000000) >> 26
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR14(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR14() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30000000) >> 28
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR15(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR15() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0000000) >> 30
}

// SCT.RES: SCT conflict resolution register
func (o *SCT_Type) SetRES_O0RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetRES_O0RES() uint32 {
	return volatile.LoadUint32(&o.RES.Reg) & 0x3
}
func (o *SCT_Type) SetRES_O1RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc)|value<<2)
}
func (o *SCT_Type) GetRES_O1RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc) >> 2
}
func (o *SCT_Type) SetRES_O2RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30)|value<<4)
}
func (o *SCT_Type) GetRES_O2RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30) >> 4
}
func (o *SCT_Type) SetRES_O3RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0)|value<<6)
}
func (o *SCT_Type) GetRES_O3RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0) >> 6
}
func (o *SCT_Type) SetRES_O4RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x300)|value<<8)
}
func (o *SCT_Type) GetRES_O4RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x300) >> 8
}
func (o *SCT_Type) SetRES_O5RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetRES_O5RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetRES_O6RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetRES_O6RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetRES_O7RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc000)|value<<14)
}
func (o *SCT_Type) GetRES_O7RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc000) >> 14
}
func (o *SCT_Type) SetRES_O8RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30000)|value<<16)
}
func (o *SCT_Type) GetRES_O8RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30000) >> 16
}
func (o *SCT_Type) SetRES_O9RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0000)|value<<18)
}
func (o *SCT_Type) GetRES_O9RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0000) >> 18
}
func (o *SCT_Type) SetRES_O10RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x300000)|value<<20)
}
func (o *SCT_Type) GetRES_O10RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x300000) >> 20
}
func (o *SCT_Type) SetRES_O11RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc00000)|value<<22)
}
func (o *SCT_Type) GetRES_O11RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc00000) >> 22
}
func (o *SCT_Type) SetRES_O12RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3000000)|value<<24)
}
func (o *SCT_Type) GetRES_O12RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x3000000) >> 24
}
func (o *SCT_Type) SetRES_O13RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc000000)|value<<26)
}
func (o *SCT_Type) GetRES_O13RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc000000) >> 26
}
func (o *SCT_Type) SetRES_O14RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30000000)|value<<28)
}
func (o *SCT_Type) GetRES_O14RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30000000) >> 28
}
func (o *SCT_Type) SetRES_O15RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0000000)|value<<30)
}
func (o *SCT_Type) GetRES_O15RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0000000) >> 30
}

// SCT.DMAREQ0: SCT DMA request 0 register
func (o *SCT_Type) SetDMAREQ0_DEV_00(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetDMAREQ0_DEV_00() uint32 {
	return volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x1
}
func (o *SCT_Type) SetDMAREQ0_DEV_01(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetDMAREQ0_DEV_01() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetDMAREQ0_DEV_02(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetDMAREQ0_DEV_02() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetDMAREQ0_DEV_03(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetDMAREQ0_DEV_03() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetDMAREQ0_DEV_04(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetDMAREQ0_DEV_04() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetDMAREQ0_DEV_05(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetDMAREQ0_DEV_05() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetDMAREQ0_DEV_06(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetDMAREQ0_DEV_06() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetDMAREQ0_DEV_07(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetDMAREQ0_DEV_07() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetDMAREQ0_DEV_08(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetDMAREQ0_DEV_08() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetDMAREQ0_DEV_09(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetDMAREQ0_DEV_09() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetDMAREQ0_DEV_010(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetDMAREQ0_DEV_010() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetDMAREQ0_DEV_011(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetDMAREQ0_DEV_011() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetDMAREQ0_DEV_012(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetDMAREQ0_DEV_012() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetDMAREQ0_DEV_013(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetDMAREQ0_DEV_013() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetDMAREQ0_DEV_014(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetDMAREQ0_DEV_014() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetDMAREQ0_DEV_015(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetDMAREQ0_DEV_015() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetDMAREQ0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT_Type) GetDMAREQ0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x3fff0000) >> 16
}
func (o *SCT_Type) SetDMAREQ0_DRL0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetDMAREQ0_DRL0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetDMAREQ0_DRQ0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetDMAREQ0_DRQ0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x80000000) >> 31
}

// SCT.DMAREQ1: SCT DMA request 1 register
func (o *SCT_Type) SetDMAREQ1_DEV_10(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetDMAREQ1_DEV_10() uint32 {
	return volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x1
}
func (o *SCT_Type) SetDMAREQ1_DEV_11(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetDMAREQ1_DEV_11() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetDMAREQ1_DEV_12(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetDMAREQ1_DEV_12() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetDMAREQ1_DEV_13(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetDMAREQ1_DEV_13() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetDMAREQ1_DEV_14(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetDMAREQ1_DEV_14() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetDMAREQ1_DEV_15(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetDMAREQ1_DEV_15() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetDMAREQ1_DEV_16(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetDMAREQ1_DEV_16() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetDMAREQ1_DEV_17(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetDMAREQ1_DEV_17() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetDMAREQ1_DEV_18(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetDMAREQ1_DEV_18() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetDMAREQ1_DEV_19(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetDMAREQ1_DEV_19() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetDMAREQ1_DEV_110(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetDMAREQ1_DEV_110() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetDMAREQ1_DEV_111(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetDMAREQ1_DEV_111() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetDMAREQ1_DEV_112(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetDMAREQ1_DEV_112() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetDMAREQ1_DEV_113(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetDMAREQ1_DEV_113() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetDMAREQ1_DEV_114(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetDMAREQ1_DEV_114() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetDMAREQ1_DEV_115(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetDMAREQ1_DEV_115() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetDMAREQ1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT_Type) GetDMAREQ1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x3fff0000) >> 16
}
func (o *SCT_Type) SetDMAREQ1_DRL1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetDMAREQ1_DRL1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetDMAREQ1_DRQ1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetDMAREQ1_DRQ1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x80000000) >> 31
}

// SCT.EVEN: SCT event enable register
func (o *SCT_Type) SetEVEN_IEN0(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEVEN_IEN0() uint32 {
	return volatile.LoadUint32(&o.EVEN.Reg) & 0x1
}
func (o *SCT_Type) SetEVEN_IEN1(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEVEN_IEN1() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEVEN_IEN2(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEVEN_IEN2() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEVEN_IEN3(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEVEN_IEN3() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEVEN_IEN4(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEVEN_IEN4() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEVEN_IEN5(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEVEN_IEN5() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEVEN_IEN6(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEVEN_IEN6() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEVEN_IEN7(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEVEN_IEN7() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEVEN_IEN8(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEVEN_IEN8() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEVEN_IEN9(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEVEN_IEN9() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEVEN_IEN10(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEVEN_IEN10() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEVEN_IEN11(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEVEN_IEN11() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEVEN_IEN12(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEVEN_IEN12() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEVEN_IEN13(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEVEN_IEN13() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEVEN_IEN14(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEVEN_IEN14() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEVEN_IEN15(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEVEN_IEN15() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEVEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetEVEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0xffff0000) >> 16
}

// SCT.EVFLAG: SCT event flag register
func (o *SCT_Type) SetEVFLAG_FLAG0(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEVFLAG_FLAG0() uint32 {
	return volatile.LoadUint32(&o.EVFLAG.Reg) & 0x1
}
func (o *SCT_Type) SetEVFLAG_FLAG1(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEVFLAG_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEVFLAG_FLAG2(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEVFLAG_FLAG2() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEVFLAG_FLAG3(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEVFLAG_FLAG3() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEVFLAG_FLAG4(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEVFLAG_FLAG4() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEVFLAG_FLAG5(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEVFLAG_FLAG5() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEVFLAG_FLAG6(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEVFLAG_FLAG6() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEVFLAG_FLAG7(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEVFLAG_FLAG7() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEVFLAG_FLAG8(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEVFLAG_FLAG8() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEVFLAG_FLAG9(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEVFLAG_FLAG9() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEVFLAG_FLAG10(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEVFLAG_FLAG10() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEVFLAG_FLAG11(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEVFLAG_FLAG11() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEVFLAG_FLAG12(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEVFLAG_FLAG12() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEVFLAG_FLAG13(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEVFLAG_FLAG13() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEVFLAG_FLAG14(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEVFLAG_FLAG14() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEVFLAG_FLAG15(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEVFLAG_FLAG15() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEVFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetEVFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffff0000) >> 16
}

// SCT.CONEN: SCT conflict enable register
func (o *SCT_Type) SetCONEN_NCEN0(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetCONEN_NCEN0() uint32 {
	return volatile.LoadUint32(&o.CONEN.Reg) & 0x1
}
func (o *SCT_Type) SetCONEN_NCEN1(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetCONEN_NCEN1() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetCONEN_NCEN2(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetCONEN_NCEN2() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetCONEN_NCEN3(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetCONEN_NCEN3() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetCONEN_NCEN4(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetCONEN_NCEN4() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetCONEN_NCEN5(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetCONEN_NCEN5() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetCONEN_NCEN6(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetCONEN_NCEN6() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetCONEN_NCEN7(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetCONEN_NCEN7() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetCONEN_NCEN8(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetCONEN_NCEN8() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetCONEN_NCEN9(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetCONEN_NCEN9() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetCONEN_NCEN10(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetCONEN_NCEN10() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetCONEN_NCEN11(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetCONEN_NCEN11() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetCONEN_NCEN12(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetCONEN_NCEN12() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetCONEN_NCEN13(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetCONEN_NCEN13() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetCONEN_NCEN14(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetCONEN_NCEN14() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetCONEN_NCEN15(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetCONEN_NCEN15() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetCONEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetCONEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0xffff0000) >> 16
}

// SCT.CONFLAG: SCT conflict flag register
func (o *SCT_Type) SetCONFLAG_NCFLAG0(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG0() uint32 {
	return volatile.LoadUint32(&o.CONFLAG.Reg) & 0x1
}
func (o *SCT_Type) SetCONFLAG_NCFLAG1(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG1() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetCONFLAG_NCFLAG2(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG2() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetCONFLAG_NCFLAG3(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG3() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetCONFLAG_NCFLAG4(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG4() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetCONFLAG_NCFLAG5(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG5() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetCONFLAG_NCFLAG6(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG6() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetCONFLAG_NCFLAG7(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG7() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetCONFLAG_NCFLAG8(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG8() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetCONFLAG_NCFLAG9(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG9() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetCONFLAG_NCFLAG10(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG10() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetCONFLAG_NCFLAG11(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG11() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetCONFLAG_NCFLAG12(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG12() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetCONFLAG_NCFLAG13(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG13() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetCONFLAG_NCFLAG14(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG14() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetCONFLAG_NCFLAG15(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG15() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetCONFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3fff0000)|value<<16)
}
func (o *SCT_Type) GetCONFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3fff0000) >> 16
}
func (o *SCT_Type) SetCONFLAG_BUSERRL(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetCONFLAG_BUSERRL() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetCONFLAG_BUSERRH(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetCONFLAG_BUSERRH() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x80000000) >> 31
}

// SCT.MATCH0: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH0_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH0_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH0_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH0_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH1: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH1_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH1_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH1_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH1_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH2: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH2_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH2_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH2_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH2_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH3: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH3_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH3_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH3_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH3_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH4: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH4_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH4_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH4_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH4_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH5: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH5_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH5.Reg, volatile.LoadUint32(&o.MATCH5.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH5_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH5.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH5_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH5.Reg, volatile.LoadUint32(&o.MATCH5.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH5_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH5.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH6: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH6_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH6.Reg, volatile.LoadUint32(&o.MATCH6.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH6_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH6.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH6_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH6.Reg, volatile.LoadUint32(&o.MATCH6.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH6_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH6.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH7: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH7_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH7.Reg, volatile.LoadUint32(&o.MATCH7.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH7_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH7.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH7_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH7.Reg, volatile.LoadUint32(&o.MATCH7.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH7_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH7.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH8: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH8_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH8.Reg, volatile.LoadUint32(&o.MATCH8.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH8_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH8.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH8_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH8.Reg, volatile.LoadUint32(&o.MATCH8.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH8_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH8.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH9: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH9_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH9.Reg, volatile.LoadUint32(&o.MATCH9.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH9_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH9.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH9_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH9.Reg, volatile.LoadUint32(&o.MATCH9.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH9_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH9.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH10: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH10_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH10.Reg, volatile.LoadUint32(&o.MATCH10.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH10_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH10.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH10_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH10.Reg, volatile.LoadUint32(&o.MATCH10.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH10_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH10.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH11: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH11_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH11.Reg, volatile.LoadUint32(&o.MATCH11.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH11_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH11.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH11_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH11.Reg, volatile.LoadUint32(&o.MATCH11.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH11_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH11.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH12: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH12_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH12.Reg, volatile.LoadUint32(&o.MATCH12.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH12_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH12.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH12_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH12.Reg, volatile.LoadUint32(&o.MATCH12.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH12_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH12.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH13: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH13_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH13.Reg, volatile.LoadUint32(&o.MATCH13.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH13_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH13.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH13_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH13.Reg, volatile.LoadUint32(&o.MATCH13.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH13_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH13.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH14: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH14_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH14.Reg, volatile.LoadUint32(&o.MATCH14.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH14_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH14.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH14_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH14.Reg, volatile.LoadUint32(&o.MATCH14.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH14_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH14.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH15: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCH15_MATCH_L(value uint32) {
	volatile.StoreUint32(&o.MATCH15.Reg, volatile.LoadUint32(&o.MATCH15.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH15_MATCH_L() uint32 {
	return volatile.LoadUint32(&o.MATCH15.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH15_MATCH_H(value uint32) {
	volatile.StoreUint32(&o.MATCH15.Reg, volatile.LoadUint32(&o.MATCH15.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH15_MATCH_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH15.Reg) & 0xffff0000) >> 16
}

// SCT.FRACMAT0: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMAT0_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMAT0_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMAT0_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMAT0_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT0.Reg, volatile.LoadUint32(&o.FRACMAT0.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT0.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMAT1: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMAT1_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMAT1_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMAT1_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMAT1_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT1.Reg, volatile.LoadUint32(&o.FRACMAT1.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT1.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMAT2: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMAT2_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMAT2_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMAT2_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMAT2_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT2.Reg, volatile.LoadUint32(&o.FRACMAT2.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT2.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMAT3: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMAT3_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMAT3_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMAT3_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMAT3_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT3.Reg, volatile.LoadUint32(&o.FRACMAT3.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT3.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMAT4: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMAT4_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMAT4_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMAT4_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMAT4_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT4.Reg, volatile.LoadUint32(&o.FRACMAT4.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT4.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMAT5: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMAT5_FRACMAT_L(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMAT5_FRACMAT_L() uint32 {
	return volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMAT5_FRACMAT_H(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMAT5_FRACMAT_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMAT5.Reg, volatile.LoadUint32(&o.FRACMAT5.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMAT5.Reg) & 0xfff00000) >> 20
}

// SCT.MATCHREL0: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL0_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL0_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL0_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL0_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL1: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL1_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL1_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL1_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL1_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL2: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL2_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL2_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL2_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL2_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL3: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL3_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL3_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL3_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL3_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL4: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL4_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL4_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL4_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL4_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL5: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL5_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL5.Reg, volatile.LoadUint32(&o.MATCHREL5.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL5_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL5.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL5_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL5.Reg, volatile.LoadUint32(&o.MATCHREL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL5_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL5.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL6: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL6_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL6.Reg, volatile.LoadUint32(&o.MATCHREL6.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL6_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL6.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL6_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL6.Reg, volatile.LoadUint32(&o.MATCHREL6.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL6_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL6.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL7: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL7_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL7.Reg, volatile.LoadUint32(&o.MATCHREL7.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL7_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL7.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL7_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL7.Reg, volatile.LoadUint32(&o.MATCHREL7.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL7_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL7.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL8: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL8_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL8.Reg, volatile.LoadUint32(&o.MATCHREL8.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL8_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL8.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL8_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL8.Reg, volatile.LoadUint32(&o.MATCHREL8.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL8_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL8.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL9: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL9_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL9.Reg, volatile.LoadUint32(&o.MATCHREL9.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL9_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL9.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL9_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL9.Reg, volatile.LoadUint32(&o.MATCHREL9.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL9_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL9.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL10: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL10_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL10.Reg, volatile.LoadUint32(&o.MATCHREL10.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL10_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL10.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL10_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL10.Reg, volatile.LoadUint32(&o.MATCHREL10.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL10_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL10.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL11: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL11_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL11.Reg, volatile.LoadUint32(&o.MATCHREL11.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL11_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL11.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL11_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL11.Reg, volatile.LoadUint32(&o.MATCHREL11.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL11_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL11.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL12: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL12_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL12.Reg, volatile.LoadUint32(&o.MATCHREL12.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL12_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL12.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL12_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL12.Reg, volatile.LoadUint32(&o.MATCHREL12.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL12_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL12.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL13: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL13_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL13.Reg, volatile.LoadUint32(&o.MATCHREL13.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL13_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL13.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL13_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL13.Reg, volatile.LoadUint32(&o.MATCHREL13.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL13_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL13.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL14: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL14_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL14.Reg, volatile.LoadUint32(&o.MATCHREL14.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL14_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL14.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL14_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL14.Reg, volatile.LoadUint32(&o.MATCHREL14.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL14_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL14.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL15: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
func (o *SCT_Type) SetMATCHREL15_RELOAD_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL15.Reg, volatile.LoadUint32(&o.MATCHREL15.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL15_RELOAD_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL15.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL15_RELOAD_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL15.Reg, volatile.LoadUint32(&o.MATCHREL15.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL15_RELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL15.Reg) & 0xffff0000) >> 16
}

// SCT.FRACMATREL0: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMATREL0_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMATREL0_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMATREL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMATREL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMATREL0_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMATREL0_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMATREL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL0.Reg, volatile.LoadUint32(&o.FRACMATREL0.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMATREL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL0.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMATREL1: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMATREL1_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMATREL1_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMATREL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMATREL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMATREL1_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMATREL1_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMATREL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL1.Reg, volatile.LoadUint32(&o.FRACMATREL1.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMATREL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL1.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMATREL2: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMATREL2_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMATREL2_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMATREL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMATREL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMATREL2_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMATREL2_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMATREL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL2.Reg, volatile.LoadUint32(&o.FRACMATREL2.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMATREL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL2.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMATREL3: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMATREL3_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMATREL3_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMATREL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMATREL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMATREL3_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMATREL3_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMATREL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL3.Reg, volatile.LoadUint32(&o.FRACMATREL3.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMATREL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL3.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMATREL4: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMATREL4_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMATREL4_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMATREL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMATREL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMATREL4_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMATREL4_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMATREL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL4.Reg, volatile.LoadUint32(&o.FRACMATREL4.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMATREL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL4.Reg) & 0xfff00000) >> 20
}

// SCT.FRACMATREL5: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
func (o *SCT_Type) SetFRACMATREL5_RELFRAC_L(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetFRACMATREL5_RELFRAC_L() uint32 {
	return volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xf
}
func (o *SCT_Type) SetFRACMATREL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetFRACMATREL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetFRACMATREL5_RELFRAC_H(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetFRACMATREL5_RELFRAC_H() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetFRACMATREL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRACMATREL5.Reg, volatile.LoadUint32(&o.FRACMATREL5.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetFRACMATREL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRACMATREL5.Reg) & 0xfff00000) >> 20
}

// SCT.EV0_STATE: SCT event state register 0
func (o *SCT_Type) SetEV0_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV0_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV0_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV0_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV0_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV0_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV0_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV0_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV0_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV0_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV0_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV0_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV0_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV0_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV0_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV0_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV0_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV0_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV0_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV0_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV0_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV0_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV0_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV0_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV0_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV1_STATE: SCT event state register 0
func (o *SCT_Type) SetEV1_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV1_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV1_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV1_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV1_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV1_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV1_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV1_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV1_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV1_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV1_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV1_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV1_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV1_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV1_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV1_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV1_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV1_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV1_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV1_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV1_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV1_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV1_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV1_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV1_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV2_STATE: SCT event state register 0
func (o *SCT_Type) SetEV2_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV2_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV2_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV2_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV2_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV2_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV2_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV2_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV2_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV2_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV2_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV2_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV2_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV2_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV2_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV2_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV2_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV2_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV2_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV2_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV2_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV2_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV2_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV2_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV2_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV3_STATE: SCT event state register 0
func (o *SCT_Type) SetEV3_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV3_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV3_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV3_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV3_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV3_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV3_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV3_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV3_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV3_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV3_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV3_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV3_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV3_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV3_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV3_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV3_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV3_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV3_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV3_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV3_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV3_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV3_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV3_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV3_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV4_STATE: SCT event state register 0
func (o *SCT_Type) SetEV4_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV4_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV4_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV4_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV4_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV4_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV4_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV4_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV4_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV4_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV4_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV4_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV4_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV4_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV4_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV4_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV4_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV4_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV4_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV4_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV4_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV4_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV4_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV4_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV4_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV5_STATE: SCT event state register 0
func (o *SCT_Type) SetEV5_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV5_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV5_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV5_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV5_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV5_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV5_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV5_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV5_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV5_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV5_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV5_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV5_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV5_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV5_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV5_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV5_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV5_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV5_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV5_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV5_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV5_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV5_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV5_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV5_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV6_STATE: SCT event state register 0
func (o *SCT_Type) SetEV6_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV6_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV6_STATE.Reg, volatile.LoadUint32(&o.EV6_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV6_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV6_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV6_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV6_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV6_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV6_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV6_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV6_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV6_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV6_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV6_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV6_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV6_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV6_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV6_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV6_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV6_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV6_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV6_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV6_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV6_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV6_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV6_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV6_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV6_CTRL.Reg, volatile.LoadUint32(&o.EV6_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV6_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV6_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV7_STATE: SCT event state register 0
func (o *SCT_Type) SetEV7_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV7_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV7_STATE.Reg, volatile.LoadUint32(&o.EV7_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV7_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV7_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV7_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV7_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV7_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV7_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV7_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV7_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV7_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV7_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV7_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV7_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV7_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV7_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV7_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV7_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV7_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV7_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV7_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV7_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV7_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV7_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV7_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV7_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV7_CTRL.Reg, volatile.LoadUint32(&o.EV7_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV7_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV7_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV8_STATE: SCT event state register 0
func (o *SCT_Type) SetEV8_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV8_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV8_STATE.Reg, volatile.LoadUint32(&o.EV8_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV8_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV8_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV8_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV8_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV8_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV8_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV8_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV8_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV8_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV8_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV8_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV8_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV8_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV8_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV8_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV8_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV8_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV8_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV8_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV8_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV8_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV8_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV8_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV8_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV8_CTRL.Reg, volatile.LoadUint32(&o.EV8_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV8_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV8_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV9_STATE: SCT event state register 0
func (o *SCT_Type) SetEV9_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV9_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV9_STATE.Reg, volatile.LoadUint32(&o.EV9_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV9_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV9_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV9_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV9_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV9_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV9_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV9_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV9_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV9_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV9_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV9_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV9_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV9_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV9_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV9_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV9_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV9_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV9_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV9_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV9_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV9_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV9_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV9_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV9_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV9_CTRL.Reg, volatile.LoadUint32(&o.EV9_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV9_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV9_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV10_STATE: SCT event state register 0
func (o *SCT_Type) SetEV10_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV10_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV10_STATE.Reg, volatile.LoadUint32(&o.EV10_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV10_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV10_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV10_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV10_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV10_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV10_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV10_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV10_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV10_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV10_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV10_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV10_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV10_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV10_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV10_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV10_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV10_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV10_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV10_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV10_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV10_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV10_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV10_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV10_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV10_CTRL.Reg, volatile.LoadUint32(&o.EV10_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV10_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV10_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV11_STATE: SCT event state register 0
func (o *SCT_Type) SetEV11_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV11_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV11_STATE.Reg, volatile.LoadUint32(&o.EV11_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV11_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV11_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV11_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV11_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV11_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV11_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV11_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV11_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV11_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV11_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV11_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV11_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV11_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV11_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV11_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV11_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV11_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV11_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV11_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV11_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV11_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV11_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV11_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV11_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV11_CTRL.Reg, volatile.LoadUint32(&o.EV11_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV11_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV11_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV12_STATE: SCT event state register 0
func (o *SCT_Type) SetEV12_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV12_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV12_STATE.Reg, volatile.LoadUint32(&o.EV12_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV12_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV12_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV12_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV12_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV12_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV12_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV12_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV12_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV12_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV12_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV12_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV12_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV12_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV12_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV12_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV12_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV12_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV12_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV12_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV12_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV12_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV12_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV12_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV12_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV12_CTRL.Reg, volatile.LoadUint32(&o.EV12_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV12_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV12_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV13_STATE: SCT event state register 0
func (o *SCT_Type) SetEV13_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV13_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV13_STATE.Reg, volatile.LoadUint32(&o.EV13_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV13_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV13_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV13_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV13_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV13_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV13_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV13_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV13_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV13_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV13_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV13_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV13_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV13_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV13_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV13_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV13_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV13_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV13_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV13_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV13_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV13_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV13_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV13_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV13_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV13_CTRL.Reg, volatile.LoadUint32(&o.EV13_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV13_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV13_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV14_STATE: SCT event state register 0
func (o *SCT_Type) SetEV14_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV14_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV14_STATE.Reg, volatile.LoadUint32(&o.EV14_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV14_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV14_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV14_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV14_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV14_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV14_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV14_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV14_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV14_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV14_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV14_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV14_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV14_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV14_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV14_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV14_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV14_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV14_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV14_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV14_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV14_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV14_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV14_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV14_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV14_CTRL.Reg, volatile.LoadUint32(&o.EV14_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV14_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV14_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV15_STATE: SCT event state register 0
func (o *SCT_Type) SetEV15_STATE_STATEMSK0(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK0() uint32 {
	return volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x1
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK1(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK1() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK2(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK2() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK3(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK3() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK4(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK4() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK5(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK5() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK6(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK6() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK7(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK7() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK8(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK8() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK9(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK9() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK10(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK10() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK11(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK11() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK12(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK12() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK13(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK13() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK14(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK14() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK15(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK15() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK16(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK16() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK17(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK17() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK18(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK18() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK19(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK19() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK20(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK20() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK21(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK21() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x200000) >> 21
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK22(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK22() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x400000) >> 22
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK23(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK23() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x800000) >> 23
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK24(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK24() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x1000000) >> 24
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK25(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK25() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x2000000) >> 25
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK26(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x4000000)|value<<26)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK26() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x4000000) >> 26
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK27(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x8000000)|value<<27)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK27() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x8000000) >> 27
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK28(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x10000000)|value<<28)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK28() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x10000000) >> 28
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK29(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x20000000)|value<<29)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK29() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x20000000) >> 29
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK30(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK30() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetEV15_STATE_STATEMSK31(value uint32) {
	volatile.StoreUint32(&o.EV15_STATE.Reg, volatile.LoadUint32(&o.EV15_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetEV15_STATE_STATEMSK31() uint32 {
	return (volatile.LoadUint32(&o.EV15_STATE.Reg) & 0x80000000) >> 31
}

// SCT.EV15_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV15_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV15_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV15_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV15_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV15_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV15_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV15_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV15_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV15_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV15_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV15_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV15_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV15_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV15_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV15_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV15_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV15_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV15_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV15_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV15_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV15_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV15_CTRL.Reg, volatile.LoadUint32(&o.EV15_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV15_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV15_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.OUT0_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT0_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT0_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT0_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT0_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT0_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT0_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT0_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT0_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT0_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT0_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT0_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT0_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT0_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT0_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT0_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT0_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT0_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT0_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT0_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT0_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT0_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT0_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT0_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT0_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT0_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT0_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT0_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT0_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT0_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT0_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT0_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT0_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT0_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT0_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT0_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT0_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT0_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT0_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT0_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT0_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT0_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT0_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT0_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT0_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT0_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT0_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT0_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT0_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT0_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT0_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT0_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT0_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT0_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT0_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT0_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT0_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT0_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT0_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT0_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT0_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT0_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT0_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT0_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT0_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT0_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT0_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT0_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT0_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT0_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT1_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT1_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT1_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT1_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT1_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT1_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT1_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT1_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT1_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT1_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT1_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT1_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT1_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT1_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT1_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT1_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT1_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT1_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT1_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT1_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT1_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT1_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT1_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT1_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT1_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT1_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT1_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT1_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT1_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT1_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT1_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT1_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT1_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT1_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT1_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT1_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT1_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT1_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT1_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT1_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT1_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT1_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT1_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT1_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT1_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT1_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT1_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT1_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT1_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT1_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT1_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT1_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT1_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT1_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT1_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT1_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT1_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT1_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT1_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT1_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT1_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT1_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT1_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT1_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT1_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT1_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT1_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT1_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT1_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT1_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT2_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT2_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT2_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT2_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT2_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT2_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT2_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT2_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT2_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT2_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT2_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT2_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT2_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT2_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT2_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT2_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT2_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT2_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT2_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT2_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT2_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT2_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT2_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT2_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT2_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT2_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT2_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT2_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT2_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT2_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT2_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT2_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT2_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT2_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT2_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT2_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT2_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT2_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT2_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT2_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT2_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT2_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT2_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT2_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT2_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT2_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT2_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT2_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT2_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT2_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT2_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT2_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT2_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT2_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT2_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT2_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT2_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT2_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT2_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT2_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT2_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT2_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT2_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT2_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT2_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT2_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT2_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT2_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT2_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT2_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT3_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT3_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT3_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT3_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT3_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT3_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT3_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT3_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT3_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT3_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT3_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT3_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT3_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT3_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT3_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT3_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT3_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT3_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT3_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT3_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT3_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT3_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT3_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT3_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT3_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT3_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT3_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT3_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT3_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT3_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT3_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT3_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT3_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT3_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT3_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT3_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT3_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT3_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT3_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT3_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT3_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT3_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT3_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT3_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT3_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT3_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT3_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT3_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT3_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT3_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT3_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT3_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT3_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT3_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT3_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT3_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT3_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT3_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT3_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT3_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT3_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT3_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT3_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT3_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT3_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT3_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT3_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT3_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT3_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT3_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT4_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT4_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT4_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT4_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT4_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT4_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT4_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT4_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT4_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT4_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT4_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT4_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT4_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT4_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT4_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT4_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT4_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT4_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT4_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT4_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT4_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT4_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT4_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT4_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT4_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT4_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT4_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT4_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT4_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT4_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT4_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT4_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT4_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT4_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT4_SET.Reg, volatile.LoadUint32(&o.OUT4_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT4_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT4_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT4_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT4_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT4_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT4_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT4_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT4_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT4_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT4_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT4_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT4_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT4_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT4_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT4_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT4_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT4_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT4_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT4_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT4_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT4_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT4_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT4_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT4_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT4_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT4_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT4_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT4_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT4_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT4_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT4_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT4_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT4_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT4_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT4_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT4_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT4_CLR.Reg, volatile.LoadUint32(&o.OUT4_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT4_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT4_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT5_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT5_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT5_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT5_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT5_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT5_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT5_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT5_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT5_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT5_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT5_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT5_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT5_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT5_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT5_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT5_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT5_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT5_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT5_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT5_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT5_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT5_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT5_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT5_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT5_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT5_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT5_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT5_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT5_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT5_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT5_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT5_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT5_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT5_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT5_SET.Reg, volatile.LoadUint32(&o.OUT5_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT5_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT5_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT5_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT5_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT5_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT5_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT5_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT5_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT5_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT5_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT5_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT5_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT5_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT5_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT5_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT5_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT5_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT5_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT5_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT5_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT5_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT5_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT5_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT5_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT5_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT5_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT5_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT5_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT5_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT5_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT5_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT5_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT5_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT5_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT5_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT5_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT5_CLR.Reg, volatile.LoadUint32(&o.OUT5_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT5_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT5_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT6_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT6_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT6_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT6_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT6_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT6_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT6_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT6_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT6_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT6_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT6_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT6_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT6_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT6_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT6_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT6_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT6_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT6_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT6_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT6_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT6_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT6_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT6_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT6_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT6_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT6_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT6_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT6_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT6_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT6_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT6_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT6_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT6_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT6_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT6_SET.Reg, volatile.LoadUint32(&o.OUT6_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT6_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT6_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT6_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT6_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT6_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT6_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT6_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT6_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT6_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT6_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT6_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT6_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT6_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT6_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT6_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT6_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT6_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT6_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT6_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT6_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT6_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT6_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT6_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT6_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT6_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT6_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT6_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT6_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT6_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT6_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT6_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT6_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT6_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT6_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT6_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT6_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT6_CLR.Reg, volatile.LoadUint32(&o.OUT6_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT6_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT6_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT7_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT7_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT7_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT7_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT7_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT7_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT7_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT7_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT7_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT7_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT7_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT7_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT7_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT7_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT7_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT7_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT7_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT7_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT7_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT7_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT7_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT7_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT7_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT7_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT7_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT7_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT7_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT7_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT7_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT7_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT7_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT7_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT7_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT7_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT7_SET.Reg, volatile.LoadUint32(&o.OUT7_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT7_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT7_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT7_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT7_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT7_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT7_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT7_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT7_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT7_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT7_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT7_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT7_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT7_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT7_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT7_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT7_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT7_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT7_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT7_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT7_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT7_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT7_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT7_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT7_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT7_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT7_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT7_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT7_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT7_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT7_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT7_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT7_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT7_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT7_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT7_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT7_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT7_CLR.Reg, volatile.LoadUint32(&o.OUT7_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT7_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT7_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT8_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT8_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT8_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT8_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT8_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT8_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT8_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT8_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT8_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT8_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT8_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT8_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT8_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT8_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT8_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT8_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT8_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT8_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT8_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT8_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT8_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT8_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT8_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT8_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT8_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT8_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT8_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT8_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT8_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT8_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT8_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT8_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT8_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT8_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT8_SET.Reg, volatile.LoadUint32(&o.OUT8_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT8_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT8_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT8_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT8_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT8_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT8_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT8_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT8_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT8_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT8_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT8_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT8_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT8_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT8_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT8_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT8_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT8_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT8_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT8_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT8_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT8_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT8_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT8_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT8_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT8_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT8_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT8_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT8_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT8_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT8_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT8_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT8_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT8_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT8_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT8_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT8_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT8_CLR.Reg, volatile.LoadUint32(&o.OUT8_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT8_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT8_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT9_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT9_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT9_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT9_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT9_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT9_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT9_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT9_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT9_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT9_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT9_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT9_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT9_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT9_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT9_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT9_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT9_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT9_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT9_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT9_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT9_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT9_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT9_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT9_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT9_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT9_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT9_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT9_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT9_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT9_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT9_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT9_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT9_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT9_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT9_SET.Reg, volatile.LoadUint32(&o.OUT9_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT9_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT9_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT9_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT9_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT9_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT9_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT9_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT9_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT9_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT9_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT9_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT9_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT9_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT9_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT9_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT9_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT9_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT9_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT9_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT9_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT9_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT9_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT9_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT9_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT9_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT9_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT9_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT9_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT9_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT9_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT9_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT9_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT9_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT9_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT9_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT9_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT9_CLR.Reg, volatile.LoadUint32(&o.OUT9_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT9_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT9_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT10_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT10_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT10_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT10_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT10_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT10_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT10_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT10_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT10_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT10_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT10_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT10_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT10_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT10_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT10_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT10_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT10_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT10_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT10_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT10_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT10_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT10_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT10_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT10_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT10_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT10_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT10_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT10_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT10_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT10_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT10_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT10_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT10_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT10_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT10_SET.Reg, volatile.LoadUint32(&o.OUT10_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT10_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT10_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT10_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT10_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT10_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT10_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT10_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT10_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT10_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT10_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT10_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT10_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT10_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT10_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT10_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT10_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT10_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT10_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT10_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT10_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT10_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT10_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT10_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT10_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT10_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT10_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT10_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT10_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT10_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT10_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT10_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT10_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT10_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT10_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT10_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT10_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT10_CLR.Reg, volatile.LoadUint32(&o.OUT10_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT10_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT10_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT11_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT11_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT11_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT11_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT11_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT11_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT11_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT11_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT11_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT11_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT11_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT11_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT11_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT11_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT11_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT11_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT11_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT11_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT11_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT11_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT11_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT11_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT11_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT11_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT11_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT11_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT11_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT11_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT11_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT11_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT11_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT11_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT11_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT11_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT11_SET.Reg, volatile.LoadUint32(&o.OUT11_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT11_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT11_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT11_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT11_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT11_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT11_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT11_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT11_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT11_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT11_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT11_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT11_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT11_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT11_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT11_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT11_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT11_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT11_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT11_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT11_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT11_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT11_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT11_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT11_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT11_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT11_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT11_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT11_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT11_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT11_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT11_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT11_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT11_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT11_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT11_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT11_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT11_CLR.Reg, volatile.LoadUint32(&o.OUT11_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT11_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT11_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT12_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT12_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT12_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT12_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT12_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT12_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT12_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT12_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT12_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT12_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT12_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT12_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT12_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT12_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT12_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT12_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT12_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT12_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT12_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT12_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT12_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT12_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT12_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT12_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT12_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT12_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT12_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT12_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT12_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT12_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT12_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT12_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT12_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT12_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT12_SET.Reg, volatile.LoadUint32(&o.OUT12_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT12_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT12_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT12_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT12_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT12_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT12_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT12_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT12_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT12_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT12_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT12_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT12_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT12_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT12_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT12_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT12_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT12_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT12_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT12_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT12_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT12_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT12_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT12_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT12_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT12_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT12_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT12_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT12_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT12_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT12_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT12_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT12_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT12_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT12_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT12_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT12_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT12_CLR.Reg, volatile.LoadUint32(&o.OUT12_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT12_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT12_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT13_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT13_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT13_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT13_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT13_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT13_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT13_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT13_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT13_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT13_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT13_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT13_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT13_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT13_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT13_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT13_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT13_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT13_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT13_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT13_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT13_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT13_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT13_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT13_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT13_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT13_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT13_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT13_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT13_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT13_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT13_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT13_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT13_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT13_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT13_SET.Reg, volatile.LoadUint32(&o.OUT13_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT13_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT13_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT13_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT13_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT13_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT13_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT13_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT13_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT13_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT13_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT13_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT13_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT13_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT13_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT13_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT13_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT13_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT13_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT13_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT13_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT13_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT13_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT13_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT13_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT13_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT13_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT13_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT13_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT13_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT13_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT13_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT13_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT13_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT13_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT13_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT13_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT13_CLR.Reg, volatile.LoadUint32(&o.OUT13_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT13_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT13_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT14_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT14_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT14_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT14_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT14_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT14_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT14_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT14_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT14_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT14_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT14_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT14_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT14_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT14_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT14_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT14_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT14_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT14_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT14_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT14_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT14_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT14_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT14_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT14_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT14_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT14_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT14_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT14_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT14_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT14_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT14_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT14_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT14_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT14_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT14_SET.Reg, volatile.LoadUint32(&o.OUT14_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT14_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT14_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT14_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT14_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT14_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT14_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT14_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT14_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT14_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT14_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT14_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT14_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT14_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT14_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT14_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT14_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT14_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT14_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT14_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT14_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT14_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT14_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT14_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT14_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT14_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT14_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT14_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT14_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT14_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT14_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT14_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT14_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT14_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT14_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT14_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT14_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT14_CLR.Reg, volatile.LoadUint32(&o.OUT14_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT14_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT14_CLR.Reg) & 0xffff0000) >> 16
}

// SCT.OUT15_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT15_SET_SET0(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT15_SET_SET0() uint32 {
	return volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x1
}
func (o *SCT_Type) SetOUT15_SET_SET1(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT15_SET_SET1() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT15_SET_SET2(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT15_SET_SET2() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT15_SET_SET3(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT15_SET_SET3() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT15_SET_SET4(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT15_SET_SET4() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT15_SET_SET5(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT15_SET_SET5() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT15_SET_SET6(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT15_SET_SET6() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT15_SET_SET7(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT15_SET_SET7() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT15_SET_SET8(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT15_SET_SET8() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT15_SET_SET9(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT15_SET_SET9() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT15_SET_SET10(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT15_SET_SET10() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT15_SET_SET11(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT15_SET_SET11() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT15_SET_SET12(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT15_SET_SET12() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT15_SET_SET13(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT15_SET_SET13() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT15_SET_SET14(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT15_SET_SET14() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT15_SET_SET15(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT15_SET_SET15() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT15_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT15_SET.Reg, volatile.LoadUint32(&o.OUT15_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT15_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT15_SET.Reg) & 0xffff0000) >> 16
}

// SCT.OUT15_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT15_CLR_CLR0(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetOUT15_CLR_CLR0() uint32 {
	return volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x1
}
func (o *SCT_Type) SetOUT15_CLR_CLR1(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetOUT15_CLR_CLR1() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetOUT15_CLR_CLR2(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetOUT15_CLR_CLR2() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetOUT15_CLR_CLR3(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetOUT15_CLR_CLR3() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetOUT15_CLR_CLR4(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetOUT15_CLR_CLR4() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetOUT15_CLR_CLR5(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetOUT15_CLR_CLR5() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetOUT15_CLR_CLR6(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SCT_Type) GetOUT15_CLR_CLR6() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x40) >> 6
}
func (o *SCT_Type) SetOUT15_CLR_CLR7(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetOUT15_CLR_CLR7() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetOUT15_CLR_CLR8(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetOUT15_CLR_CLR8() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetOUT15_CLR_CLR9(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SCT_Type) GetOUT15_CLR_CLR9() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x200) >> 9
}
func (o *SCT_Type) SetOUT15_CLR_CLR10(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SCT_Type) GetOUT15_CLR_CLR10() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x400) >> 10
}
func (o *SCT_Type) SetOUT15_CLR_CLR11(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SCT_Type) GetOUT15_CLR_CLR11() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x800) >> 11
}
func (o *SCT_Type) SetOUT15_CLR_CLR12(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SCT_Type) GetOUT15_CLR_CLR12() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x1000) >> 12
}
func (o *SCT_Type) SetOUT15_CLR_CLR13(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SCT_Type) GetOUT15_CLR_CLR13() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x2000) >> 13
}
func (o *SCT_Type) SetOUT15_CLR_CLR14(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetOUT15_CLR_CLR14() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetOUT15_CLR_CLR15(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SCT_Type) GetOUT15_CLR_CLR15() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0x8000) >> 15
}
func (o *SCT_Type) SetOUT15_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT15_CLR.Reg, volatile.LoadUint32(&o.OUT15_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetOUT15_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT15_CLR.Reg) & 0xffff0000) >> 16
}

// General Purpose DMA (GPDMA)
type GPDMA_Type struct {
	INTSTAT       volatile.Register32 // 0x0
	INTTCSTAT     volatile.Register32 // 0x4
	INTTCCLEAR    volatile.Register32 // 0x8
	INTERRSTAT    volatile.Register32 // 0xC
	INTERRCLR     volatile.Register32 // 0x10
	RAWINTTCSTAT  volatile.Register32 // 0x14
	RAWINTERRSTAT volatile.Register32 // 0x18
	ENBLDCHNS     volatile.Register32 // 0x1C
	SOFTBREQ      volatile.Register32 // 0x20
	SOFTSREQ      volatile.Register32 // 0x24
	SOFTLBREQ     volatile.Register32 // 0x28
	SOFTLSREQ     volatile.Register32 // 0x2C
	CONFIG        volatile.Register32 // 0x30
	SYNC          volatile.Register32 // 0x34
	_             [200]byte
	C0SRCADDR     volatile.Register32 // 0x100
	C0DESTADDR    volatile.Register32 // 0x104
	C0LLI         volatile.Register32 // 0x108
	C0CONTROL     volatile.Register32 // 0x10C
	C0CONFIG      volatile.Register32 // 0x110
	_             [12]byte
	C1SRCADDR     volatile.Register32 // 0x120
	C1DESTADDR    volatile.Register32 // 0x124
	C1LLI         volatile.Register32 // 0x128
	C1CONTROL     volatile.Register32 // 0x12C
	C1CONFIG      volatile.Register32 // 0x130
	_             [12]byte
	C2SRCADDR     volatile.Register32 // 0x140
	C2DESTADDR    volatile.Register32 // 0x144
	C2LLI         volatile.Register32 // 0x148
	C2CONTROL     volatile.Register32 // 0x14C
	C2CONFIG      volatile.Register32 // 0x150
	_             [12]byte
	C3SRCADDR     volatile.Register32 // 0x160
	C3DESTADDR    volatile.Register32 // 0x164
	C3LLI         volatile.Register32 // 0x168
	C3CONTROL     volatile.Register32 // 0x16C
	C3CONFIG      volatile.Register32 // 0x170
	_             [12]byte
	C4SRCADDR     volatile.Register32 // 0x180
	C4DESTADDR    volatile.Register32 // 0x184
	C4LLI         volatile.Register32 // 0x188
	C4CONTROL     volatile.Register32 // 0x18C
	C4CONFIG      volatile.Register32 // 0x190
	_             [12]byte
	C5SRCADDR     volatile.Register32 // 0x1A0
	C5DESTADDR    volatile.Register32 // 0x1A4
	C5LLI         volatile.Register32 // 0x1A8
	C5CONTROL     volatile.Register32 // 0x1AC
	C5CONFIG      volatile.Register32 // 0x1B0
	_             [12]byte
	C6SRCADDR     volatile.Register32 // 0x1C0
	C6DESTADDR    volatile.Register32 // 0x1C4
	C6LLI         volatile.Register32 // 0x1C8
	C6CONTROL     volatile.Register32 // 0x1CC
	C6CONFIG      volatile.Register32 // 0x1D0
	_             [12]byte
	C7SRCADDR     volatile.Register32 // 0x1E0
	C7DESTADDR    volatile.Register32 // 0x1E4
	C7LLI         volatile.Register32 // 0x1E8
	C7CONTROL     volatile.Register32 // 0x1EC
	C7CONFIG      volatile.Register32 // 0x1F0
}

// GPDMA.INTSTAT: DMA Interrupt Status Register
func (o *GPDMA_Type) SetINTSTAT_INTSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTTCSTAT: DMA Interrupt Terminal Count Request Status Register
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTTCSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTTCSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTTCCLEAR: DMA Interrupt Terminal Count Request Clear Register
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR0(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR0() uint32 {
	return volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR1(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR1() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR2(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR2() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR3(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR3() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR4(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR4() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR5(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR5() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR6(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR6() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR7(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR7() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTTCCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTTCCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTERRSTAT: DMA Interrupt Error Status Register
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTERRSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTERRSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTERRCLR: DMA Interrupt Error Clear Register
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR0(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR0() uint32 {
	return volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR1(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR1() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR2(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR2() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR3(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR3() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR4(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR4() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR5(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR5() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR6(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR6() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR7(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR7() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTERRCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTERRCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0xffffff00) >> 8
}

// GPDMA.RAWINTTCSTAT: DMA Raw Interrupt Terminal Count Status Register
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT0(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT0() uint32 {
	return volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT1(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT1() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT2(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT2() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT3(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT3() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT4(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT4() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT5(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT5() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT6(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT6() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT7(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT7() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.RAWINTERRSTAT: DMA Raw Error Interrupt Status Register
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT0(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT0() uint32 {
	return volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT1(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT1() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT2(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT2() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT3(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT3() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT4(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT4() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT5(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT5() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT6(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT6() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT7(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT7() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.ENBLDCHNS: DMA Enabled Channel Register
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS0(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS0() uint32 {
	return volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x1
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS1(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS1() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS2(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS2() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS3(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS3() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS4(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS4() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS5(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS5() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS6(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS6() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS7(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS7() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetENBLDCHNS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetENBLDCHNS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0xffffff00) >> 8
}

// GPDMA.SOFTBREQ: DMA Software Burst Request Register
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTBREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTBREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTSREQ: DMA Software Single Request Register
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTSREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTSREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTLBREQ: DMA Software Last Burst Request Register
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTLBREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTLBREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTLSREQ: DMA Software Last Single Request Register
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTLSREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTLSREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.CONFIG: DMA Configuration Register
func (o *GPDMA_Type) SetCONFIG_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG_M0(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG_M0() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetCONFIG_M1(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetCONFIG_M1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfffffff8)|value<<3)
}
func (o *GPDMA_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfffffff8) >> 3
}

// GPDMA.SYNC: DMA Synchronization Register
func (o *GPDMA_Type) SetSYNC_DMACSYNC0(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC0() uint32 {
	return volatile.LoadUint32(&o.SYNC.Reg) & 0x1
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC1(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC1() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC2(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC2() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC3(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC3() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC4(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC4() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC5(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC5() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC6(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC6() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC7(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC7() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC8(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC8() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC9(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC9() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC10(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC10() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC11(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC11() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC12(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC12() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC13(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC13() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC14(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC14() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC15(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC15() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSYNC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSYNC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0xffff0000) >> 16
}

// GPDMA.C0SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC0SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C0SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC0SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C0SRCADDR.Reg)
}

// GPDMA.C0DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC0DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C0DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC0DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C0DESTADDR.Reg)
}

// GPDMA.C0LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC0LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C0LLI.Reg, volatile.LoadUint32(&o.C0LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC0LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C0LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC0LLI_R(value uint32) {
	volatile.StoreUint32(&o.C0LLI.Reg, volatile.LoadUint32(&o.C0LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC0LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C0LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC0LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C0LLI.Reg, volatile.LoadUint32(&o.C0LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC0LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C0LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C0CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC0CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC0CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C0CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC0CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC0CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC0CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC0CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC0CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC0CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC0CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC0CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC0CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC0CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC0CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC0CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC0CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC0CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC0CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC0CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC0CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC0CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC0CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC0CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC0CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC0CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC0CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C0CONTROL.Reg, volatile.LoadUint32(&o.C0CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC0CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C0CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C0CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC0CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC0CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC0CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC0CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC0CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC0CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC0CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC0CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC0CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC0CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC0CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC0CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC0CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC0CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC0CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC0CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC0CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC0CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC0CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C0CONFIG.Reg, volatile.LoadUint32(&o.C0CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC0CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C0CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C1SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC1SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C1SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC1SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C1SRCADDR.Reg)
}

// GPDMA.C1DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC1DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C1DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC1DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C1DESTADDR.Reg)
}

// GPDMA.C1LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC1LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C1LLI.Reg, volatile.LoadUint32(&o.C1LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC1LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C1LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC1LLI_R(value uint32) {
	volatile.StoreUint32(&o.C1LLI.Reg, volatile.LoadUint32(&o.C1LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC1LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C1LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC1LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C1LLI.Reg, volatile.LoadUint32(&o.C1LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC1LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C1LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C1CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC1CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC1CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C1CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC1CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC1CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC1CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC1CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC1CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC1CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC1CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC1CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC1CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC1CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC1CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC1CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC1CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC1CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC1CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC1CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC1CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC1CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC1CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC1CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC1CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC1CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC1CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C1CONTROL.Reg, volatile.LoadUint32(&o.C1CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC1CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C1CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C1CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC1CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC1CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC1CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC1CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC1CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC1CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC1CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC1CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC1CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC1CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC1CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC1CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC1CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC1CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC1CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC1CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC1CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC1CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC1CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C1CONFIG.Reg, volatile.LoadUint32(&o.C1CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC1CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C1CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C2SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC2SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C2SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC2SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C2SRCADDR.Reg)
}

// GPDMA.C2DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC2DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C2DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC2DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C2DESTADDR.Reg)
}

// GPDMA.C2LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC2LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C2LLI.Reg, volatile.LoadUint32(&o.C2LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC2LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C2LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC2LLI_R(value uint32) {
	volatile.StoreUint32(&o.C2LLI.Reg, volatile.LoadUint32(&o.C2LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC2LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C2LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC2LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C2LLI.Reg, volatile.LoadUint32(&o.C2LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC2LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C2LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C2CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC2CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC2CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C2CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC2CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC2CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC2CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC2CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC2CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC2CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC2CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC2CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC2CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC2CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC2CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC2CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC2CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC2CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC2CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC2CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC2CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC2CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC2CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC2CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC2CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC2CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC2CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C2CONTROL.Reg, volatile.LoadUint32(&o.C2CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC2CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C2CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C2CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC2CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC2CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC2CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC2CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC2CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC2CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC2CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC2CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC2CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC2CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC2CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC2CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC2CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC2CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC2CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC2CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC2CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC2CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC2CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C2CONFIG.Reg, volatile.LoadUint32(&o.C2CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC2CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C2CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C3SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC3SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C3SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC3SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C3SRCADDR.Reg)
}

// GPDMA.C3DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC3DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C3DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC3DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C3DESTADDR.Reg)
}

// GPDMA.C3LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC3LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C3LLI.Reg, volatile.LoadUint32(&o.C3LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC3LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C3LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC3LLI_R(value uint32) {
	volatile.StoreUint32(&o.C3LLI.Reg, volatile.LoadUint32(&o.C3LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC3LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C3LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC3LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C3LLI.Reg, volatile.LoadUint32(&o.C3LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC3LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C3LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C3CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC3CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC3CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C3CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC3CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC3CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC3CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC3CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC3CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC3CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC3CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC3CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC3CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC3CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC3CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC3CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC3CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC3CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC3CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC3CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC3CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC3CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC3CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC3CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC3CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC3CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC3CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C3CONTROL.Reg, volatile.LoadUint32(&o.C3CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC3CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C3CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C3CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC3CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC3CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC3CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC3CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC3CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC3CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC3CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC3CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC3CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC3CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC3CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC3CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC3CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC3CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC3CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC3CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC3CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC3CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC3CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C3CONFIG.Reg, volatile.LoadUint32(&o.C3CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC3CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C3CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C4SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC4SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C4SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC4SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C4SRCADDR.Reg)
}

// GPDMA.C4DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC4DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C4DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC4DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C4DESTADDR.Reg)
}

// GPDMA.C4LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC4LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C4LLI.Reg, volatile.LoadUint32(&o.C4LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC4LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C4LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC4LLI_R(value uint32) {
	volatile.StoreUint32(&o.C4LLI.Reg, volatile.LoadUint32(&o.C4LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC4LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C4LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC4LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C4LLI.Reg, volatile.LoadUint32(&o.C4LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC4LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C4LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C4CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC4CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC4CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C4CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC4CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC4CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC4CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC4CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC4CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC4CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC4CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC4CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC4CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC4CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC4CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC4CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC4CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC4CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC4CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC4CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC4CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC4CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC4CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC4CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC4CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC4CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC4CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C4CONTROL.Reg, volatile.LoadUint32(&o.C4CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC4CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C4CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C4CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC4CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC4CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC4CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC4CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC4CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC4CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC4CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC4CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC4CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC4CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC4CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC4CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC4CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC4CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC4CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC4CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC4CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC4CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC4CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C4CONFIG.Reg, volatile.LoadUint32(&o.C4CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC4CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C4CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C5SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC5SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C5SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC5SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C5SRCADDR.Reg)
}

// GPDMA.C5DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC5DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C5DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC5DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C5DESTADDR.Reg)
}

// GPDMA.C5LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC5LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C5LLI.Reg, volatile.LoadUint32(&o.C5LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC5LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C5LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC5LLI_R(value uint32) {
	volatile.StoreUint32(&o.C5LLI.Reg, volatile.LoadUint32(&o.C5LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC5LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C5LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC5LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C5LLI.Reg, volatile.LoadUint32(&o.C5LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC5LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C5LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C5CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC5CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC5CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C5CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC5CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC5CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC5CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC5CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC5CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC5CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC5CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC5CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC5CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC5CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC5CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC5CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC5CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC5CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC5CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC5CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC5CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC5CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC5CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC5CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC5CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC5CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC5CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C5CONTROL.Reg, volatile.LoadUint32(&o.C5CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC5CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C5CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C5CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC5CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC5CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC5CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC5CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC5CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC5CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC5CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC5CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC5CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC5CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC5CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC5CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC5CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC5CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC5CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC5CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC5CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC5CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC5CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C5CONFIG.Reg, volatile.LoadUint32(&o.C5CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC5CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C5CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C6SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC6SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C6SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC6SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C6SRCADDR.Reg)
}

// GPDMA.C6DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC6DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C6DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC6DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C6DESTADDR.Reg)
}

// GPDMA.C6LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC6LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C6LLI.Reg, volatile.LoadUint32(&o.C6LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC6LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C6LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC6LLI_R(value uint32) {
	volatile.StoreUint32(&o.C6LLI.Reg, volatile.LoadUint32(&o.C6LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC6LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C6LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC6LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C6LLI.Reg, volatile.LoadUint32(&o.C6LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC6LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C6LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C6CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC6CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC6CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C6CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC6CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC6CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC6CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC6CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC6CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC6CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC6CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC6CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC6CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC6CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC6CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC6CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC6CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC6CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC6CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC6CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC6CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC6CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC6CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC6CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC6CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC6CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC6CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C6CONTROL.Reg, volatile.LoadUint32(&o.C6CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC6CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C6CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C6CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC6CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC6CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC6CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC6CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC6CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC6CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC6CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC6CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC6CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC6CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC6CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC6CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC6CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC6CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC6CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC6CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC6CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC6CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC6CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C6CONFIG.Reg, volatile.LoadUint32(&o.C6CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC6CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C6CONFIG.Reg) & 0xfff80000) >> 19
}

// GPDMA.C7SRCADDR: DMA Channel Source Address Register
func (o *GPDMA_Type) SetC7SRCADDR(value uint32) {
	volatile.StoreUint32(&o.C7SRCADDR.Reg, value)
}
func (o *GPDMA_Type) GetC7SRCADDR() uint32 {
	return volatile.LoadUint32(&o.C7SRCADDR.Reg)
}

// GPDMA.C7DESTADDR: DMA Channel Destination Address Register
func (o *GPDMA_Type) SetC7DESTADDR(value uint32) {
	volatile.StoreUint32(&o.C7DESTADDR.Reg, value)
}
func (o *GPDMA_Type) GetC7DESTADDR() uint32 {
	return volatile.LoadUint32(&o.C7DESTADDR.Reg)
}

// GPDMA.C7LLI: DMA Channel Linked List Item Register
func (o *GPDMA_Type) SetC7LLI_LM(value uint32) {
	volatile.StoreUint32(&o.C7LLI.Reg, volatile.LoadUint32(&o.C7LLI.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC7LLI_LM() uint32 {
	return volatile.LoadUint32(&o.C7LLI.Reg) & 0x1
}
func (o *GPDMA_Type) SetC7LLI_R(value uint32) {
	volatile.StoreUint32(&o.C7LLI.Reg, volatile.LoadUint32(&o.C7LLI.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetC7LLI_R() uint32 {
	return (volatile.LoadUint32(&o.C7LLI.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetC7LLI_LLI(value uint32) {
	volatile.StoreUint32(&o.C7LLI.Reg, volatile.LoadUint32(&o.C7LLI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetC7LLI_LLI() uint32 {
	return (volatile.LoadUint32(&o.C7LLI.Reg) & 0xfffffffc) >> 2
}

// GPDMA.C7CONTROL: DMA Channel Control Register
func (o *GPDMA_Type) SetC7CONTROL_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetC7CONTROL_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.C7CONTROL.Reg) & 0xfff
}
func (o *GPDMA_Type) SetC7CONTROL_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetC7CONTROL_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetC7CONTROL_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetC7CONTROL_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetC7CONTROL_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetC7CONTROL_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetC7CONTROL_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetC7CONTROL_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetC7CONTROL_S(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPDMA_Type) GetC7CONTROL_S() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x1000000) >> 24
}
func (o *GPDMA_Type) SetC7CONTROL_D(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPDMA_Type) GetC7CONTROL_D() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x2000000) >> 25
}
func (o *GPDMA_Type) SetC7CONTROL_SI(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetC7CONTROL_SI() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetC7CONTROL_DI(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetC7CONTROL_DI() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetC7CONTROL_PROT1(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetC7CONTROL_PROT1() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetC7CONTROL_PROT2(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetC7CONTROL_PROT2() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetC7CONTROL_PROT3(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetC7CONTROL_PROT3() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetC7CONTROL_I(value uint32) {
	volatile.StoreUint32(&o.C7CONTROL.Reg, volatile.LoadUint32(&o.C7CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetC7CONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.C7CONTROL.Reg) & 0x80000000) >> 31
}

// GPDMA.C7CONFIG: DMA Channel Configuration Register
func (o *GPDMA_Type) SetC7CONFIG_E(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetC7CONFIG_E() uint32 {
	return volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetC7CONFIG_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetC7CONFIG_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetC7CONFIG_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetC7CONFIG_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetC7CONFIG_FLOWCNTRL(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetC7CONFIG_FLOWCNTRL() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetC7CONFIG_IE(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetC7CONFIG_IE() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetC7CONFIG_ITC(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetC7CONFIG_ITC() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetC7CONFIG_L(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetC7CONFIG_L() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetC7CONFIG_A(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetC7CONFIG_A() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetC7CONFIG_H(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetC7CONFIG_H() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetC7CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.C7CONFIG.Reg, volatile.LoadUint32(&o.C7CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetC7CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.C7CONFIG.Reg) & 0xfff80000) >> 19
}

// SPI Flash Interface (SPIFI)
type SPIFI_Type struct {
	CTRL   volatile.Register32 // 0x0
	CMD    volatile.Register32 // 0x4
	ADDR   volatile.Register32 // 0x8
	IDATA  volatile.Register32 // 0xC
	CLIMIT volatile.Register32 // 0x10
	DATA   volatile.Register32 // 0x14
	MCMD   volatile.Register32 // 0x18
	STAT   volatile.Register32 // 0x1C
}

// SPIFI.CTRL: SPIFI control register
func (o *SPIFI_Type) SetCTRL_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffff)|value)
}
func (o *SPIFI_Type) GetCTRL_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xffff
}
func (o *SPIFI_Type) SetCTRL_CSHIGH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf0000)|value<<16)
}
func (o *SPIFI_Type) GetCTRL_CSHIGH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf0000) >> 16
}
func (o *SPIFI_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SPIFI_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SPIFI_Type) SetCTRL_D_PRFTCH_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *SPIFI_Type) GetCTRL_D_PRFTCH_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *SPIFI_Type) SetCTRL_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *SPIFI_Type) GetCTRL_INTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *SPIFI_Type) SetCTRL_MODE3(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *SPIFI_Type) GetCTRL_MODE3() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *SPIFI_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7000000)|value<<24)
}
func (o *SPIFI_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x7000000) >> 24
}
func (o *SPIFI_Type) SetCTRL_PRFTCH_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *SPIFI_Type) GetCTRL_PRFTCH_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000000) >> 27
}
func (o *SPIFI_Type) SetCTRL_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *SPIFI_Type) GetCTRL_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000000) >> 28
}
func (o *SPIFI_Type) SetCTRL_RFCLK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *SPIFI_Type) GetCTRL_RFCLK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000000) >> 29
}
func (o *SPIFI_Type) SetCTRL_FBCLK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *SPIFI_Type) GetCTRL_FBCLK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000000) >> 30
}
func (o *SPIFI_Type) SetCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIFI_Type) GetCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000000) >> 31
}

// SPIFI.CMD: SPIFI command register
func (o *SPIFI_Type) SetCMD_DATALEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3fff)|value)
}
func (o *SPIFI_Type) GetCMD_DATALEN() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3fff
}
func (o *SPIFI_Type) SetCMD_POLL(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SPIFI_Type) GetCMD_POLL() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SPIFI_Type) SetCMD_DOUT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x8000)|value<<15)
}
func (o *SPIFI_Type) GetCMD_DOUT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x8000) >> 15
}
func (o *SPIFI_Type) SetCMD_INTLEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x70000)|value<<16)
}
func (o *SPIFI_Type) GetCMD_INTLEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x70000) >> 16
}
func (o *SPIFI_Type) SetCMD_FIELDFORM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x180000)|value<<19)
}
func (o *SPIFI_Type) GetCMD_FIELDFORM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x180000) >> 19
}
func (o *SPIFI_Type) SetCMD_FRAMEFORM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xe00000)|value<<21)
}
func (o *SPIFI_Type) GetCMD_FRAMEFORM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xe00000) >> 21
}
func (o *SPIFI_Type) SetCMD_OPCODE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xff000000)|value<<24)
}
func (o *SPIFI_Type) GetCMD_OPCODE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xff000000) >> 24
}

// SPIFI.ADDR: SPIFI address register
func (o *SPIFI_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *SPIFI_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// SPIFI.IDATA: SPIFI intermediate data register
func (o *SPIFI_Type) SetIDATA(value uint32) {
	volatile.StoreUint32(&o.IDATA.Reg, value)
}
func (o *SPIFI_Type) GetIDATA() uint32 {
	return volatile.LoadUint32(&o.IDATA.Reg)
}

// SPIFI.CLIMIT: SPIFI cache limit register
func (o *SPIFI_Type) SetCLIMIT(value uint32) {
	volatile.StoreUint32(&o.CLIMIT.Reg, value)
}
func (o *SPIFI_Type) GetCLIMIT() uint32 {
	return volatile.LoadUint32(&o.CLIMIT.Reg)
}

// SPIFI.DATA: SPIFI data register
func (o *SPIFI_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *SPIFI_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// SPIFI.MCMD: SPIFI memory command register
func (o *SPIFI_Type) SetMCMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x3fff)|value)
}
func (o *SPIFI_Type) GetMCMD_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MCMD.Reg) & 0x3fff
}
func (o *SPIFI_Type) SetMCMD_POLL(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x4000)|value<<14)
}
func (o *SPIFI_Type) GetMCMD_POLL() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0x4000) >> 14
}
func (o *SPIFI_Type) SetMCMD_DOUT(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x8000)|value<<15)
}
func (o *SPIFI_Type) GetMCMD_DOUT() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0x8000) >> 15
}
func (o *SPIFI_Type) SetMCMD_INTLEN(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x70000)|value<<16)
}
func (o *SPIFI_Type) GetMCMD_INTLEN() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0x70000) >> 16
}
func (o *SPIFI_Type) SetMCMD_FIELDFORM(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x180000)|value<<19)
}
func (o *SPIFI_Type) GetMCMD_FIELDFORM() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0x180000) >> 19
}
func (o *SPIFI_Type) SetMCMD_FRAMEFORM(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0xe00000)|value<<21)
}
func (o *SPIFI_Type) GetMCMD_FRAMEFORM() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0xe00000) >> 21
}
func (o *SPIFI_Type) SetMCMD_OPCODE(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0xff000000)|value<<24)
}
func (o *SPIFI_Type) GetMCMD_OPCODE() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0xff000000) >> 24
}

// SPIFI.STAT: SPIFI status register
func (o *SPIFI_Type) SetSTAT_MCINIT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *SPIFI_Type) GetSTAT_MCINIT() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *SPIFI_Type) SetSTAT_CMD(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *SPIFI_Type) GetSTAT_CMD() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *SPIFI_Type) SetSTAT_RESET(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *SPIFI_Type) GetSTAT_RESET() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *SPIFI_Type) SetSTAT_INTRQ(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *SPIFI_Type) GetSTAT_INTRQ() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *SPIFI_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffffc0)|value<<6)
}
func (o *SPIFI_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffffc0) >> 6
}
func (o *SPIFI_Type) SetSTAT_VERSION(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xff000000)|value<<24)
}
func (o *SPIFI_Type) GetSTAT_VERSION() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xff000000) >> 24
}

// SD/MMC
type SDMMC_Type struct {
	CTRL    volatile.Register32 // 0x0
	PWREN   volatile.Register32 // 0x4
	CLKDIV  volatile.Register32 // 0x8
	CLKSRC  volatile.Register32 // 0xC
	CLKENA  volatile.Register32 // 0x10
	TMOUT   volatile.Register32 // 0x14
	CTYPE   volatile.Register32 // 0x18
	BLKSIZ  volatile.Register32 // 0x1C
	BYTCNT  volatile.Register32 // 0x20
	INTMASK volatile.Register32 // 0x24
	CMDARG  volatile.Register32 // 0x28
	CMD     volatile.Register32 // 0x2C
	RESP0   volatile.Register32 // 0x30
	RESP1   volatile.Register32 // 0x34
	RESP2   volatile.Register32 // 0x38
	RESP3   volatile.Register32 // 0x3C
	MINTSTS volatile.Register32 // 0x40
	RINTSTS volatile.Register32 // 0x44
	STATUS  volatile.Register32 // 0x48
	FIFOTH  volatile.Register32 // 0x4C
	CDETECT volatile.Register32 // 0x50
	WRTPRT  volatile.Register32 // 0x54
	_       [4]byte
	TCBCNT  volatile.Register32 // 0x5C
	TBBCNT  volatile.Register32 // 0x60
	DEBNCE  volatile.Register32 // 0x64
	_       [16]byte
	RST_N   volatile.Register32 // 0x78
	_       [4]byte
	BMOD    volatile.Register32 // 0x80
	PLDMND  volatile.Register32 // 0x84
	DBADDR  volatile.Register32 // 0x88
	IDSTS   volatile.Register32 // 0x8C
	IDINTEN volatile.Register32 // 0x90
	DSCADDR volatile.Register32 // 0x94
	BUFADDR volatile.Register32 // 0x98
}

// SDMMC.CTRL: Control Register
func (o *SDMMC_Type) SetCTRL_CONTROLLER_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetCTRL_CONTROLLER_RESET() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *SDMMC_Type) SetCTRL_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetCTRL_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetCTRL_DMA_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetCTRL_DMA_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetCTRL_INT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetCTRL_INT_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetCTRL_READ_WAIT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetCTRL_READ_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetCTRL_SEND_IRQ_RESPONSE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetCTRL_SEND_IRQ_RESPONSE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetCTRL_ABORT_READ_DATA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetCTRL_ABORT_READ_DATA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetCTRL_SEND_CCSD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetCTRL_SEND_CCSD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetCTRL_SEND_AUTO_STOP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCTRL_SEND_AUTO_STOP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCTRL_CEATA_DEVICE_INTERRUPT_STATUS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetCTRL_CEATA_DEVICE_INTERRUPT_STATUS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *SDMMC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf000) >> 12
}
func (o *SDMMC_Type) SetCTRL_CARD_VOLTAGE_A0(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetCTRL_CARD_VOLTAGE_A0() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetCTRL_CARD_VOLTAGE_A1(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetCTRL_CARD_VOLTAGE_A1() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetCTRL_CARD_VOLTAGE_A2(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetCTRL_CARD_VOLTAGE_A2() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf80000)|value<<19)
}
func (o *SDMMC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf80000) >> 19
}
func (o *SDMMC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *SDMMC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *SDMMC_Type) SetCTRL_USE_INTERNAL_DMAC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *SDMMC_Type) GetCTRL_USE_INTERNAL_DMAC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *SDMMC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfc000000)|value<<26)
}
func (o *SDMMC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfc000000) >> 26
}

// SDMMC.PWREN: Power Enable Register
func (o *SDMMC_Type) SetPWREN_POWER_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PWREN.Reg, volatile.LoadUint32(&o.PWREN.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetPWREN_POWER_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PWREN.Reg) & 0x1
}
func (o *SDMMC_Type) SetPWREN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PWREN.Reg, volatile.LoadUint32(&o.PWREN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SDMMC_Type) GetPWREN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PWREN.Reg) & 0xfffffffe) >> 1
}

// SDMMC.CLKDIV: Clock Divider Register
func (o *SDMMC_Type) SetCLKDIV_CLK_DIVIDER0(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xff)|value)
}
func (o *SDMMC_Type) GetCLKDIV_CLK_DIVIDER0() uint32 {
	return volatile.LoadUint32(&o.CLKDIV.Reg) & 0xff
}
func (o *SDMMC_Type) SetCLKDIV_CLK_DIVIDER1(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xff00)|value<<8)
}
func (o *SDMMC_Type) GetCLKDIV_CLK_DIVIDER1() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xff00) >> 8
}
func (o *SDMMC_Type) SetCLKDIV_CLK_DIVIDER2(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xff0000)|value<<16)
}
func (o *SDMMC_Type) GetCLKDIV_CLK_DIVIDER2() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xff0000) >> 16
}
func (o *SDMMC_Type) SetCLKDIV_CLK_DIVIDER3(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xff000000)|value<<24)
}
func (o *SDMMC_Type) GetCLKDIV_CLK_DIVIDER3() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xff000000) >> 24
}

// SDMMC.CLKSRC: SD Clock Source Register
func (o *SDMMC_Type) SetCLKSRC_CLK_SOURCE(value uint32) {
	volatile.StoreUint32(&o.CLKSRC.Reg, volatile.LoadUint32(&o.CLKSRC.Reg)&^(0x3)|value)
}
func (o *SDMMC_Type) GetCLKSRC_CLK_SOURCE() uint32 {
	return volatile.LoadUint32(&o.CLKSRC.Reg) & 0x3
}
func (o *SDMMC_Type) SetCLKSRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKSRC.Reg, volatile.LoadUint32(&o.CLKSRC.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SDMMC_Type) GetCLKSRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKSRC.Reg) & 0xfffffffe) >> 1
}

// SDMMC.CLKENA: Clock Enable Register
func (o *SDMMC_Type) SetCLKENA_CCLK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLKENA.Reg, volatile.LoadUint32(&o.CLKENA.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetCLKENA_CCLK_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CLKENA.Reg) & 0x1
}
func (o *SDMMC_Type) SetCLKENA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKENA.Reg, volatile.LoadUint32(&o.CLKENA.Reg)&^(0xfffe)|value<<1)
}
func (o *SDMMC_Type) GetCLKENA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKENA.Reg) & 0xfffe) >> 1
}
func (o *SDMMC_Type) SetCLKENA_CCLK_LOW_POWER(value uint32) {
	volatile.StoreUint32(&o.CLKENA.Reg, volatile.LoadUint32(&o.CLKENA.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetCLKENA_CCLK_LOW_POWER() uint32 {
	return (volatile.LoadUint32(&o.CLKENA.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetCLKENA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKENA.Reg, volatile.LoadUint32(&o.CLKENA.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SDMMC_Type) GetCLKENA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKENA.Reg) & 0xfffe0000) >> 17
}

// SDMMC.TMOUT: Time-out Register
func (o *SDMMC_Type) SetTMOUT_RESPONSE_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.TMOUT.Reg, volatile.LoadUint32(&o.TMOUT.Reg)&^(0xff)|value)
}
func (o *SDMMC_Type) GetTMOUT_RESPONSE_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.TMOUT.Reg) & 0xff
}
func (o *SDMMC_Type) SetTMOUT_DATA_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.TMOUT.Reg, volatile.LoadUint32(&o.TMOUT.Reg)&^(0xffffff00)|value<<8)
}
func (o *SDMMC_Type) GetTMOUT_DATA_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.TMOUT.Reg) & 0xffffff00) >> 8
}

// SDMMC.CTYPE: Card Type Register
func (o *SDMMC_Type) SetCTYPE_CARD_WIDTH0(value uint32) {
	volatile.StoreUint32(&o.CTYPE.Reg, volatile.LoadUint32(&o.CTYPE.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetCTYPE_CARD_WIDTH0() uint32 {
	return volatile.LoadUint32(&o.CTYPE.Reg) & 0x1
}
func (o *SDMMC_Type) SetCTYPE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTYPE.Reg, volatile.LoadUint32(&o.CTYPE.Reg)&^(0xfffe)|value<<1)
}
func (o *SDMMC_Type) GetCTYPE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTYPE.Reg) & 0xfffe) >> 1
}
func (o *SDMMC_Type) SetCTYPE_CARD_WIDTH1(value uint32) {
	volatile.StoreUint32(&o.CTYPE.Reg, volatile.LoadUint32(&o.CTYPE.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetCTYPE_CARD_WIDTH1() uint32 {
	return (volatile.LoadUint32(&o.CTYPE.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetCTYPE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTYPE.Reg, volatile.LoadUint32(&o.CTYPE.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SDMMC_Type) GetCTYPE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTYPE.Reg) & 0xfffe0000) >> 17
}

// SDMMC.BLKSIZ: Block Size Register
func (o *SDMMC_Type) SetBLKSIZ_BLOCK_SIZE(value uint32) {
	volatile.StoreUint32(&o.BLKSIZ.Reg, volatile.LoadUint32(&o.BLKSIZ.Reg)&^(0xffff)|value)
}
func (o *SDMMC_Type) GetBLKSIZ_BLOCK_SIZE() uint32 {
	return volatile.LoadUint32(&o.BLKSIZ.Reg) & 0xffff
}
func (o *SDMMC_Type) SetBLKSIZ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BLKSIZ.Reg, volatile.LoadUint32(&o.BLKSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *SDMMC_Type) GetBLKSIZ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BLKSIZ.Reg) & 0xffff0000) >> 16
}

// SDMMC.BYTCNT: Byte Count Register
func (o *SDMMC_Type) SetBYTCNT(value uint32) {
	volatile.StoreUint32(&o.BYTCNT.Reg, value)
}
func (o *SDMMC_Type) GetBYTCNT() uint32 {
	return volatile.LoadUint32(&o.BYTCNT.Reg)
}

// SDMMC.INTMASK: Interrupt Mask Register
func (o *SDMMC_Type) SetINTMASK_CDET(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetINTMASK_CDET() uint32 {
	return volatile.LoadUint32(&o.INTMASK.Reg) & 0x1
}
func (o *SDMMC_Type) SetINTMASK_RE(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetINTMASK_RE() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetINTMASK_CDONE(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetINTMASK_CDONE() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetINTMASK_DTO(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetINTMASK_DTO() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetINTMASK_TXDR(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetINTMASK_TXDR() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetINTMASK_RXDR(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetINTMASK_RXDR() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetINTMASK_RCRC(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetINTMASK_RCRC() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetINTMASK_DCRC(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetINTMASK_DCRC() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetINTMASK_RTO(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetINTMASK_RTO() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetINTMASK_DRTO(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetINTMASK_DRTO() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetINTMASK_HTO(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetINTMASK_HTO() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetINTMASK_FRUN(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetINTMASK_FRUN() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetINTMASK_HLE(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetINTMASK_HLE() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetINTMASK_SBE(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetINTMASK_SBE() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetINTMASK_ACD(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetINTMASK_ACD() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetINTMASK_EBE(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetINTMASK_EBE() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetINTMASK_SDIO_INT_MASK(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetINTMASK_SDIO_INT_MASK() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetINTMASK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTMASK.Reg, volatile.LoadUint32(&o.INTMASK.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SDMMC_Type) GetINTMASK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTMASK.Reg) & 0xfffe0000) >> 17
}

// SDMMC.CMDARG: Command Argument Register
func (o *SDMMC_Type) SetCMDARG(value uint32) {
	volatile.StoreUint32(&o.CMDARG.Reg, value)
}
func (o *SDMMC_Type) GetCMDARG() uint32 {
	return volatile.LoadUint32(&o.CMDARG.Reg)
}

// SDMMC.CMD: Command Register
func (o *SDMMC_Type) SetCMD_CMD_INDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetCMD_CMD_INDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}
func (o *SDMMC_Type) SetCMD_RESPONSE_EXPECT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetCMD_RESPONSE_EXPECT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetCMD_RESPONSE_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetCMD_RESPONSE_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetCMD_CHECK_RESPONSE_CRC(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetCMD_CHECK_RESPONSE_CRC() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetCMD_DATA_EXPECTED(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetCMD_DATA_EXPECTED() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetCMD_READ_WRITE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCMD_READ_WRITE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCMD_TRANSFER_MODE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetCMD_TRANSFER_MODE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetCMD_SEND_AUTO_STOP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetCMD_SEND_AUTO_STOP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetCMD_WAIT_PRVDATA_COMPLETE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetCMD_WAIT_PRVDATA_COMPLETE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetCMD_STOP_ABORT_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetCMD_STOP_ABORT_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetCMD_SEND_INITIALIZATION(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetCMD_SEND_INITIALIZATION() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetCMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1f0000)|value<<16)
}
func (o *SDMMC_Type) GetCMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1f0000) >> 16
}
func (o *SDMMC_Type) SetCMD_UPDATE_CLOCK_REGISTERS_ONLY(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetCMD_UPDATE_CLOCK_REGISTERS_ONLY() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetCMD_READ_CEATA_DEVICE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetCMD_READ_CEATA_DEVICE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetCMD_CCS_EXPECTED(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800000)|value<<23)
}
func (o *SDMMC_Type) GetCMD_CCS_EXPECTED() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800000) >> 23
}
func (o *SDMMC_Type) SetCMD_ENABLE_BOOT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000000)|value<<24)
}
func (o *SDMMC_Type) GetCMD_ENABLE_BOOT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000000) >> 24
}
func (o *SDMMC_Type) SetCMD_EXPECT_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000000)|value<<25)
}
func (o *SDMMC_Type) GetCMD_EXPECT_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000000) >> 25
}
func (o *SDMMC_Type) SetCMD_DISABLE_BOOT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000000)|value<<26)
}
func (o *SDMMC_Type) GetCMD_DISABLE_BOOT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000000) >> 26
}
func (o *SDMMC_Type) SetCMD_BOOT_MODE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x8000000)|value<<27)
}
func (o *SDMMC_Type) GetCMD_BOOT_MODE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x8000000) >> 27
}
func (o *SDMMC_Type) SetCMD_VOLT_SWITCH(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x10000000)|value<<28)
}
func (o *SDMMC_Type) GetCMD_VOLT_SWITCH() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x10000000) >> 28
}
func (o *SDMMC_Type) SetCMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x60000000)|value<<29)
}
func (o *SDMMC_Type) GetCMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x60000000) >> 29
}
func (o *SDMMC_Type) SetCMD_START_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x80000000)|value<<31)
}
func (o *SDMMC_Type) GetCMD_START_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x80000000) >> 31
}

// SDMMC.RESP0: Response Register 0
func (o *SDMMC_Type) SetRESP0(value uint32) {
	volatile.StoreUint32(&o.RESP0.Reg, value)
}
func (o *SDMMC_Type) GetRESP0() uint32 {
	return volatile.LoadUint32(&o.RESP0.Reg)
}

// SDMMC.RESP1: Response Register 1
func (o *SDMMC_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDMMC_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDMMC.RESP2: Response Register 2
func (o *SDMMC_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDMMC_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDMMC.RESP3: Response Register 3
func (o *SDMMC_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDMMC_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDMMC.MINTSTS: Masked Interrupt Status Register
func (o *SDMMC_Type) SetMINTSTS_CDET(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetMINTSTS_CDET() uint32 {
	return volatile.LoadUint32(&o.MINTSTS.Reg) & 0x1
}
func (o *SDMMC_Type) SetMINTSTS_RE(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetMINTSTS_RE() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetMINTSTS_CDONE(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetMINTSTS_CDONE() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetMINTSTS_DTO(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetMINTSTS_DTO() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetMINTSTS_TXDR(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetMINTSTS_TXDR() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetMINTSTS_RXDR(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetMINTSTS_RXDR() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetMINTSTS_RCRC(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetMINTSTS_RCRC() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetMINTSTS_DCRC(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetMINTSTS_DCRC() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetMINTSTS_RTO(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetMINTSTS_RTO() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetMINTSTS_DRTO(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetMINTSTS_DRTO() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetMINTSTS_HTO(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetMINTSTS_HTO() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetMINTSTS_FRUN(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetMINTSTS_FRUN() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetMINTSTS_HLE(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetMINTSTS_HLE() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetMINTSTS_SBE(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetMINTSTS_SBE() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetMINTSTS_ACD(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetMINTSTS_ACD() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetMINTSTS_EBE(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetMINTSTS_EBE() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetMINTSTS_SDIO_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetMINTSTS_SDIO_INTERRUPT() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetMINTSTS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MINTSTS.Reg, volatile.LoadUint32(&o.MINTSTS.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SDMMC_Type) GetMINTSTS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MINTSTS.Reg) & 0xfffe0000) >> 17
}

// SDMMC.RINTSTS: Raw Interrupt Status Register
func (o *SDMMC_Type) SetRINTSTS_CDET(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetRINTSTS_CDET() uint32 {
	return volatile.LoadUint32(&o.RINTSTS.Reg) & 0x1
}
func (o *SDMMC_Type) SetRINTSTS_RE(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetRINTSTS_RE() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetRINTSTS_CDONE(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetRINTSTS_CDONE() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetRINTSTS_DTO(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetRINTSTS_DTO() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetRINTSTS_TXDR(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetRINTSTS_TXDR() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetRINTSTS_RXDR(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetRINTSTS_RXDR() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetRINTSTS_RCRC(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetRINTSTS_RCRC() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetRINTSTS_DCRC(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetRINTSTS_DCRC() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetRINTSTS_RTO_BAR(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetRINTSTS_RTO_BAR() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetRINTSTS_DRTO_BDS(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetRINTSTS_DRTO_BDS() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetRINTSTS_HTO(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetRINTSTS_HTO() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetRINTSTS_FRUN(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetRINTSTS_FRUN() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetRINTSTS_HLE(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetRINTSTS_HLE() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetRINTSTS_SBE(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetRINTSTS_SBE() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetRINTSTS_ACD(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetRINTSTS_ACD() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetRINTSTS_EBE(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetRINTSTS_EBE() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetRINTSTS_SDIO_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetRINTSTS_SDIO_INTERRUPT() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetRINTSTS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RINTSTS.Reg, volatile.LoadUint32(&o.RINTSTS.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SDMMC_Type) GetRINTSTS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RINTSTS.Reg) & 0xfffe0000) >> 17
}

// SDMMC.STATUS: Status Register
func (o *SDMMC_Type) SetSTATUS_FIFO_RX_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetSTATUS_FIFO_RX_WATERMARK() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SDMMC_Type) SetSTATUS_FIFO_TX_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetSTATUS_FIFO_TX_WATERMARK() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetSTATUS_FIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetSTATUS_FIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetSTATUS_FIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetSTATUS_FIFO_FULL() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetSTATUS_CMDFSMSTATES(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf0)|value<<4)
}
func (o *SDMMC_Type) GetSTATUS_CMDFSMSTATES() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xf0) >> 4
}
func (o *SDMMC_Type) SetSTATUS_DATA_3_STATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetSTATUS_DATA_3_STATUS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetSTATUS_DATA_BUSY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetSTATUS_DATA_BUSY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetSTATUS_DATA_STATE_MC_BUSY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetSTATUS_DATA_STATE_MC_BUSY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetSTATUS_RESPONSE_INDEX(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1f800)|value<<11)
}
func (o *SDMMC_Type) GetSTATUS_RESPONSE_INDEX() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1f800) >> 11
}
func (o *SDMMC_Type) SetSTATUS_FIFO_COUNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3ffe0000)|value<<17)
}
func (o *SDMMC_Type) GetSTATUS_FIFO_COUNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x3ffe0000) >> 17
}
func (o *SDMMC_Type) SetSTATUS_DMA_ACK(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000000)|value<<30)
}
func (o *SDMMC_Type) GetSTATUS_DMA_ACK() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000000) >> 30
}
func (o *SDMMC_Type) SetSTATUS_DMA_REQ(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000000)|value<<31)
}
func (o *SDMMC_Type) GetSTATUS_DMA_REQ() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000000) >> 31
}

// SDMMC.FIFOTH: FIFO Threshold Watermark Register
func (o *SDMMC_Type) SetFIFOTH_TX_WMARK(value uint32) {
	volatile.StoreUint32(&o.FIFOTH.Reg, volatile.LoadUint32(&o.FIFOTH.Reg)&^(0xfff)|value)
}
func (o *SDMMC_Type) GetFIFOTH_TX_WMARK() uint32 {
	return volatile.LoadUint32(&o.FIFOTH.Reg) & 0xfff
}
func (o *SDMMC_Type) SetFIFOTH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FIFOTH.Reg, volatile.LoadUint32(&o.FIFOTH.Reg)&^(0xf000)|value<<12)
}
func (o *SDMMC_Type) GetFIFOTH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FIFOTH.Reg) & 0xf000) >> 12
}
func (o *SDMMC_Type) SetFIFOTH_RX_WMARK(value uint32) {
	volatile.StoreUint32(&o.FIFOTH.Reg, volatile.LoadUint32(&o.FIFOTH.Reg)&^(0xfff0000)|value<<16)
}
func (o *SDMMC_Type) GetFIFOTH_RX_WMARK() uint32 {
	return (volatile.LoadUint32(&o.FIFOTH.Reg) & 0xfff0000) >> 16
}
func (o *SDMMC_Type) SetFIFOTH_DMA_MTS(value uint32) {
	volatile.StoreUint32(&o.FIFOTH.Reg, volatile.LoadUint32(&o.FIFOTH.Reg)&^(0x70000000)|value<<28)
}
func (o *SDMMC_Type) GetFIFOTH_DMA_MTS() uint32 {
	return (volatile.LoadUint32(&o.FIFOTH.Reg) & 0x70000000) >> 28
}
func (o *SDMMC_Type) SetFIFOTH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FIFOTH.Reg, volatile.LoadUint32(&o.FIFOTH.Reg)&^(0x80000000)|value<<31)
}
func (o *SDMMC_Type) GetFIFOTH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FIFOTH.Reg) & 0x80000000) >> 31
}

// SDMMC.CDETECT: Card Detect Register
func (o *SDMMC_Type) SetCDETECT_CARD_DETECT(value uint32) {
	volatile.StoreUint32(&o.CDETECT.Reg, volatile.LoadUint32(&o.CDETECT.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetCDETECT_CARD_DETECT() uint32 {
	return volatile.LoadUint32(&o.CDETECT.Reg) & 0x1
}
func (o *SDMMC_Type) SetCDETECT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CDETECT.Reg, volatile.LoadUint32(&o.CDETECT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SDMMC_Type) GetCDETECT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CDETECT.Reg) & 0xfffffffe) >> 1
}

// SDMMC.WRTPRT: Write Protect Register
func (o *SDMMC_Type) SetWRTPRT_WRITE_PROTECT(value uint32) {
	volatile.StoreUint32(&o.WRTPRT.Reg, volatile.LoadUint32(&o.WRTPRT.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetWRTPRT_WRITE_PROTECT() uint32 {
	return volatile.LoadUint32(&o.WRTPRT.Reg) & 0x1
}
func (o *SDMMC_Type) SetWRTPRT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WRTPRT.Reg, volatile.LoadUint32(&o.WRTPRT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SDMMC_Type) GetWRTPRT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WRTPRT.Reg) & 0xfffffffe) >> 1
}

// SDMMC.TCBCNT: Transferred CIU Card Byte Count Register
func (o *SDMMC_Type) SetTCBCNT(value uint32) {
	volatile.StoreUint32(&o.TCBCNT.Reg, value)
}
func (o *SDMMC_Type) GetTCBCNT() uint32 {
	return volatile.LoadUint32(&o.TCBCNT.Reg)
}

// SDMMC.TBBCNT: Transferred Host to BIU-FIFO Byte Count Register
func (o *SDMMC_Type) SetTBBCNT(value uint32) {
	volatile.StoreUint32(&o.TBBCNT.Reg, value)
}
func (o *SDMMC_Type) GetTBBCNT() uint32 {
	return volatile.LoadUint32(&o.TBBCNT.Reg)
}

// SDMMC.DEBNCE: Debounce Count Register
func (o *SDMMC_Type) SetDEBNCE_DEBOUNCE_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEBNCE.Reg, volatile.LoadUint32(&o.DEBNCE.Reg)&^(0xffffff)|value)
}
func (o *SDMMC_Type) GetDEBNCE_DEBOUNCE_COUNT() uint32 {
	return volatile.LoadUint32(&o.DEBNCE.Reg) & 0xffffff
}
func (o *SDMMC_Type) SetDEBNCE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEBNCE.Reg, volatile.LoadUint32(&o.DEBNCE.Reg)&^(0xff000000)|value<<24)
}
func (o *SDMMC_Type) GetDEBNCE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEBNCE.Reg) & 0xff000000) >> 24
}

// SDMMC.RST_N: Hardware Reset
func (o *SDMMC_Type) SetRST_N_CARD_RESET(value uint32) {
	volatile.StoreUint32(&o.RST_N.Reg, volatile.LoadUint32(&o.RST_N.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetRST_N_CARD_RESET() uint32 {
	return volatile.LoadUint32(&o.RST_N.Reg) & 0x1
}
func (o *SDMMC_Type) SetRST_N_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RST_N.Reg, volatile.LoadUint32(&o.RST_N.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SDMMC_Type) GetRST_N_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RST_N.Reg) & 0xfffffffe) >> 1
}

// SDMMC.BMOD: Bus Mode Register
func (o *SDMMC_Type) SetBMOD_SWR(value uint32) {
	volatile.StoreUint32(&o.BMOD.Reg, volatile.LoadUint32(&o.BMOD.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetBMOD_SWR() uint32 {
	return volatile.LoadUint32(&o.BMOD.Reg) & 0x1
}
func (o *SDMMC_Type) SetBMOD_FB(value uint32) {
	volatile.StoreUint32(&o.BMOD.Reg, volatile.LoadUint32(&o.BMOD.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetBMOD_FB() uint32 {
	return (volatile.LoadUint32(&o.BMOD.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetBMOD_DSL(value uint32) {
	volatile.StoreUint32(&o.BMOD.Reg, volatile.LoadUint32(&o.BMOD.Reg)&^(0x7c)|value<<2)
}
func (o *SDMMC_Type) GetBMOD_DSL() uint32 {
	return (volatile.LoadUint32(&o.BMOD.Reg) & 0x7c) >> 2
}
func (o *SDMMC_Type) SetBMOD_DE(value uint32) {
	volatile.StoreUint32(&o.BMOD.Reg, volatile.LoadUint32(&o.BMOD.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetBMOD_DE() uint32 {
	return (volatile.LoadUint32(&o.BMOD.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetBMOD_PBL(value uint32) {
	volatile.StoreUint32(&o.BMOD.Reg, volatile.LoadUint32(&o.BMOD.Reg)&^(0x700)|value<<8)
}
func (o *SDMMC_Type) GetBMOD_PBL() uint32 {
	return (volatile.LoadUint32(&o.BMOD.Reg) & 0x700) >> 8
}
func (o *SDMMC_Type) SetBMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BMOD.Reg, volatile.LoadUint32(&o.BMOD.Reg)&^(0xfffff800)|value<<11)
}
func (o *SDMMC_Type) GetBMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BMOD.Reg) & 0xfffff800) >> 11
}

// SDMMC.PLDMND: Poll Demand Register
func (o *SDMMC_Type) SetPLDMND(value uint32) {
	volatile.StoreUint32(&o.PLDMND.Reg, value)
}
func (o *SDMMC_Type) GetPLDMND() uint32 {
	return volatile.LoadUint32(&o.PLDMND.Reg)
}

// SDMMC.DBADDR: Descriptor List Base Address Register
func (o *SDMMC_Type) SetDBADDR(value uint32) {
	volatile.StoreUint32(&o.DBADDR.Reg, value)
}
func (o *SDMMC_Type) GetDBADDR() uint32 {
	return volatile.LoadUint32(&o.DBADDR.Reg)
}

// SDMMC.IDSTS: Internal DMAC Status Register
func (o *SDMMC_Type) SetIDSTS_TI(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetIDSTS_TI() uint32 {
	return volatile.LoadUint32(&o.IDSTS.Reg) & 0x1
}
func (o *SDMMC_Type) SetIDSTS_RI(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetIDSTS_RI() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetIDSTS_FBE(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetIDSTS_FBE() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetIDSTS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetIDSTS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetIDSTS_DU(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetIDSTS_DU() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetIDSTS_CES(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetIDSTS_CES() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetIDSTS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0xc0)|value<<6)
}
func (o *SDMMC_Type) GetIDSTS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0xc0) >> 6
}
func (o *SDMMC_Type) SetIDSTS_NIS(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetIDSTS_NIS() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetIDSTS_AIS(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetIDSTS_AIS() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetIDSTS_EB(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x1c00)|value<<10)
}
func (o *SDMMC_Type) GetIDSTS_EB() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x1c00) >> 10
}
func (o *SDMMC_Type) SetIDSTS_FSM(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0x1e000)|value<<13)
}
func (o *SDMMC_Type) GetIDSTS_FSM() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0x1e000) >> 13
}
func (o *SDMMC_Type) SetIDSTS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDSTS.Reg, volatile.LoadUint32(&o.IDSTS.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SDMMC_Type) GetIDSTS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDSTS.Reg) & 0xfffe0000) >> 17
}

// SDMMC.IDINTEN: Internal DMAC Interrupt Enable Register
func (o *SDMMC_Type) SetIDINTEN_TI(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetIDINTEN_TI() uint32 {
	return volatile.LoadUint32(&o.IDINTEN.Reg) & 0x1
}
func (o *SDMMC_Type) SetIDINTEN_RI(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetIDINTEN_RI() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetIDINTEN_FBE(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetIDINTEN_FBE() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetIDINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetIDINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetIDINTEN_DU(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetIDINTEN_DU() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetIDINTEN_CES(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetIDINTEN_CES() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetIDINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0xc0)|value<<6)
}
func (o *SDMMC_Type) GetIDINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0xc0) >> 6
}
func (o *SDMMC_Type) SetIDINTEN_NIS(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetIDINTEN_NIS() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetIDINTEN_AIS(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetIDINTEN_AIS() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetIDINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDINTEN.Reg, volatile.LoadUint32(&o.IDINTEN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SDMMC_Type) GetIDINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDINTEN.Reg) & 0xfffffc00) >> 10
}

// SDMMC.DSCADDR: Current Host Descriptor Address Register
func (o *SDMMC_Type) SetDSCADDR(value uint32) {
	volatile.StoreUint32(&o.DSCADDR.Reg, value)
}
func (o *SDMMC_Type) GetDSCADDR() uint32 {
	return volatile.LoadUint32(&o.DSCADDR.Reg)
}

// SDMMC.BUFADDR: Current Buffer Descriptor Address Register
func (o *SDMMC_Type) SetBUFADDR(value uint32) {
	volatile.StoreUint32(&o.BUFADDR.Reg, value)
}
func (o *SDMMC_Type) GetBUFADDR() uint32 {
	return volatile.LoadUint32(&o.BUFADDR.Reg)
}

// External Memory Controller (EMC)
type EMC_Type struct {
	CONTROL            volatile.Register32 // 0x0
	STATUS             volatile.Register32 // 0x4
	CONFIG             volatile.Register32 // 0x8
	_                  [20]byte
	DYNAMICCONTROL     volatile.Register32 // 0x20
	DYNAMICREFRESH     volatile.Register32 // 0x24
	DYNAMICREADCONFIG  volatile.Register32 // 0x28
	_                  [4]byte
	DYNAMICRP          volatile.Register32 // 0x30
	DYNAMICRAS         volatile.Register32 // 0x34
	DYNAMICSREX        volatile.Register32 // 0x38
	DYNAMICAPR         volatile.Register32 // 0x3C
	DYNAMICDAL         volatile.Register32 // 0x40
	DYNAMICWR          volatile.Register32 // 0x44
	DYNAMICRC          volatile.Register32 // 0x48
	DYNAMICRFC         volatile.Register32 // 0x4C
	DYNAMICXSR         volatile.Register32 // 0x50
	DYNAMICRRD         volatile.Register32 // 0x54
	DYNAMICMRD         volatile.Register32 // 0x58
	_                  [36]byte
	STATICEXTENDEDWAIT volatile.Register32 // 0x80
	_                  [124]byte
	DYNAMICCONFIG0     volatile.Register32 // 0x100
	DYNAMICRASCAS0     volatile.Register32 // 0x104
	_                  [24]byte
	DYNAMICCONFIG1     volatile.Register32 // 0x120
	DYNAMICRASCAS1     volatile.Register32 // 0x124
	_                  [24]byte
	DYNAMICCONFIG2     volatile.Register32 // 0x140
	DYNAMICRASCAS2     volatile.Register32 // 0x144
	_                  [24]byte
	DYNAMICCONFIG3     volatile.Register32 // 0x160
	DYNAMICRASCAS3     volatile.Register32 // 0x164
	_                  [152]byte
	STATICCONFIG0      volatile.Register32 // 0x200
	STATICWAITWEN0     volatile.Register32 // 0x204
	STATICWAITOEN0     volatile.Register32 // 0x208
	STATICWAITRD0      volatile.Register32 // 0x20C
	STATICWAITPAGE0    volatile.Register32 // 0x210
	STATICWAITWR0      volatile.Register32 // 0x214
	STATICWAITTURN0    volatile.Register32 // 0x218
	_                  [4]byte
	STATICCONFIG1      volatile.Register32 // 0x220
	STATICWAITWEN1     volatile.Register32 // 0x224
	STATICWAITOEN1     volatile.Register32 // 0x228
	STATICWAITRD1      volatile.Register32 // 0x22C
	STATICWAITPAGE1    volatile.Register32 // 0x230
	STATICWAITWR1      volatile.Register32 // 0x234
	STATICWAITTURN1    volatile.Register32 // 0x238
	_                  [4]byte
	STATICCONFIG2      volatile.Register32 // 0x240
	STATICWAITWEN2     volatile.Register32 // 0x244
	STATICWAITOEN2     volatile.Register32 // 0x248
	STATICWAITRD2      volatile.Register32 // 0x24C
	STATICWAITPAGE2    volatile.Register32 // 0x250
	STATICWAITWR2      volatile.Register32 // 0x254
	STATICWAITTURN2    volatile.Register32 // 0x258
	_                  [4]byte
	STATICCONFIG3      volatile.Register32 // 0x260
	STATICWAITWEN3     volatile.Register32 // 0x264
	STATICWAITOEN3     volatile.Register32 // 0x268
	STATICWAITRD3      volatile.Register32 // 0x26C
	STATICWAITPAGE3    volatile.Register32 // 0x270
	STATICWAITWR3      volatile.Register32 // 0x274
	STATICWAITTURN3    volatile.Register32 // 0x278
}

// EMC.CONTROL: Controls operation of the memory controller.
func (o *EMC_Type) SetCONTROL_E(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetCONTROL_E() uint32 {
	return volatile.LoadUint32(&o.CONTROL.Reg) & 0x1
}
func (o *EMC_Type) SetCONTROL_M(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *EMC_Type) GetCONTROL_M() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2) >> 1
}
func (o *EMC_Type) SetCONTROL_L(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetCONTROL_L() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EMC_Type) GetCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0xfffffff8) >> 3
}

// EMC.STATUS: Provides EMC status information.
func (o *EMC_Type) SetSTATUS_B(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetSTATUS_B() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *EMC_Type) SetSTATUS_S(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *EMC_Type) GetSTATUS_S() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *EMC_Type) SetSTATUS_SA(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATUS_SA() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EMC_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffff8) >> 3
}

// EMC.CONFIG: Configures operation of the memory controller.
func (o *EMC_Type) SetCONFIG_EM(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetCONFIG_EM() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *EMC_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfe)|value<<1)
}
func (o *EMC_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfe) >> 1
}
func (o *EMC_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfffffe00)|value<<9)
}
func (o *EMC_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfffffe00) >> 9
}

// EMC.DYNAMICCONTROL: Controls dynamic memory operation.
func (o *EMC_Type) SetDYNAMICCONTROL_CE(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetDYNAMICCONTROL_CE() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x1
}
func (o *EMC_Type) SetDYNAMICCONTROL_CS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x2)|value<<1)
}
func (o *EMC_Type) GetDYNAMICCONTROL_CS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x2) >> 1
}
func (o *EMC_Type) SetDYNAMICCONTROL_SR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetDYNAMICCONTROL_SR() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONTROL_MMC(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x20)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONTROL_MMC() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x20) >> 5
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetDYNAMICCONTROL_I(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x180)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x180) >> 7
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x3e00)|value<<9)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x3e00) >> 9
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0xffffc000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0xffffc000) >> 14
}

// EMC.DYNAMICREFRESH: Configures dynamic memory refresh operation.
func (o *EMC_Type) SetDYNAMICREFRESH_REFRESH(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREFRESH.Reg, volatile.LoadUint32(&o.DYNAMICREFRESH.Reg)&^(0x7ff)|value)
}
func (o *EMC_Type) GetDYNAMICREFRESH_REFRESH() uint32 {
	return volatile.LoadUint32(&o.DYNAMICREFRESH.Reg) & 0x7ff
}
func (o *EMC_Type) SetDYNAMICREFRESH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREFRESH.Reg, volatile.LoadUint32(&o.DYNAMICREFRESH.Reg)&^(0xfffff800)|value<<11)
}
func (o *EMC_Type) GetDYNAMICREFRESH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICREFRESH.Reg) & 0xfffff800) >> 11
}

// EMC.DYNAMICREADCONFIG: Configures the dynamic memory read strategy.
func (o *EMC_Type) SetDYNAMICREADCONFIG_RD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREADCONFIG.Reg, volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICREADCONFIG_RD() uint32 {
	return volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICREADCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREADCONFIG.Reg, volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICREADCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg) & 0xfffffffc) >> 2
}

// EMC.DYNAMICRP: Selects the precharge command period.
func (o *EMC_Type) SetDYNAMICRP_TRP(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRP.Reg, volatile.LoadUint32(&o.DYNAMICRP.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICRP_TRP() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRP.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICRP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRP.Reg, volatile.LoadUint32(&o.DYNAMICRP.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICRP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRP.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICRAS: Selects the active to precharge command period.
func (o *EMC_Type) SetDYNAMICRAS_TRAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRAS.Reg, volatile.LoadUint32(&o.DYNAMICRAS.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICRAS_TRAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRAS.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICRAS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRAS.Reg, volatile.LoadUint32(&o.DYNAMICRAS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICRAS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRAS.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICSREX: Selects the self-refresh exit time.
func (o *EMC_Type) SetDYNAMICSREX_TSREX(value uint32) {
	volatile.StoreUint32(&o.DYNAMICSREX.Reg, volatile.LoadUint32(&o.DYNAMICSREX.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICSREX_TSREX() uint32 {
	return volatile.LoadUint32(&o.DYNAMICSREX.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICSREX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICSREX.Reg, volatile.LoadUint32(&o.DYNAMICSREX.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICSREX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICSREX.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICAPR: Selects the last-data-out to active command time.
func (o *EMC_Type) SetDYNAMICAPR_TAPR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICAPR.Reg, volatile.LoadUint32(&o.DYNAMICAPR.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICAPR_TAPR() uint32 {
	return volatile.LoadUint32(&o.DYNAMICAPR.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICAPR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICAPR.Reg, volatile.LoadUint32(&o.DYNAMICAPR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICAPR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICAPR.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICDAL: Selects the data-in to active command time.
func (o *EMC_Type) SetDYNAMICDAL_TDAL(value uint32) {
	volatile.StoreUint32(&o.DYNAMICDAL.Reg, volatile.LoadUint32(&o.DYNAMICDAL.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICDAL_TDAL() uint32 {
	return volatile.LoadUint32(&o.DYNAMICDAL.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICDAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICDAL.Reg, volatile.LoadUint32(&o.DYNAMICDAL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICDAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICDAL.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICWR: Selects the write recovery time.
func (o *EMC_Type) SetDYNAMICWR_TWR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICWR.Reg, volatile.LoadUint32(&o.DYNAMICWR.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICWR_TWR() uint32 {
	return volatile.LoadUint32(&o.DYNAMICWR.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICWR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICWR.Reg, volatile.LoadUint32(&o.DYNAMICWR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICWR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICWR.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICRC: Selects the active to active command period.
func (o *EMC_Type) SetDYNAMICRC_TRC(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRC.Reg, volatile.LoadUint32(&o.DYNAMICRC.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetDYNAMICRC_TRC() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRC.Reg) & 0x1f
}
func (o *EMC_Type) SetDYNAMICRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRC.Reg, volatile.LoadUint32(&o.DYNAMICRC.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetDYNAMICRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRC.Reg) & 0xffffffe0) >> 5
}

// EMC.DYNAMICRFC: Selects the auto-refresh period.
func (o *EMC_Type) SetDYNAMICRFC_TRFC(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRFC.Reg, volatile.LoadUint32(&o.DYNAMICRFC.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetDYNAMICRFC_TRFC() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRFC.Reg) & 0x1f
}
func (o *EMC_Type) SetDYNAMICRFC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRFC.Reg, volatile.LoadUint32(&o.DYNAMICRFC.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetDYNAMICRFC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRFC.Reg) & 0xffffffe0) >> 5
}

// EMC.DYNAMICXSR: Selects the exit self-refresh to active command time.
func (o *EMC_Type) SetDYNAMICXSR_TXSR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICXSR.Reg, volatile.LoadUint32(&o.DYNAMICXSR.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetDYNAMICXSR_TXSR() uint32 {
	return volatile.LoadUint32(&o.DYNAMICXSR.Reg) & 0x1f
}
func (o *EMC_Type) SetDYNAMICXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICXSR.Reg, volatile.LoadUint32(&o.DYNAMICXSR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetDYNAMICXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICXSR.Reg) & 0xffffffe0) >> 5
}

// EMC.DYNAMICRRD: Selects the active bank A to active bank B latency.
func (o *EMC_Type) SetDYNAMICRRD_TRRD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRRD.Reg, volatile.LoadUint32(&o.DYNAMICRRD.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICRRD_TRRD() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRRD.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICRRD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRRD.Reg, volatile.LoadUint32(&o.DYNAMICRRD.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICRRD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRRD.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICMRD: Selects the load mode register to active command time.
func (o *EMC_Type) SetDYNAMICMRD_TMRD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICMRD.Reg, volatile.LoadUint32(&o.DYNAMICMRD.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICMRD_TMRD() uint32 {
	return volatile.LoadUint32(&o.DYNAMICMRD.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICMRD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICMRD.Reg, volatile.LoadUint32(&o.DYNAMICMRD.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICMRD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICMRD.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICEXTENDEDWAIT: Selects time for long static memory read and write transfers.
func (o *EMC_Type) SetSTATICEXTENDEDWAIT_EXTENDEDWAIT(value uint32) {
	volatile.StoreUint32(&o.STATICEXTENDEDWAIT.Reg, volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg)&^(0x3ff)|value)
}
func (o *EMC_Type) GetSTATICEXTENDEDWAIT_EXTENDEDWAIT() uint32 {
	return volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg) & 0x3ff
}
func (o *EMC_Type) SetSTATICEXTENDEDWAIT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICEXTENDEDWAIT.Reg, volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetSTATICEXTENDEDWAIT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG0: Selects the configuration information for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG0_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG0_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG0_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG0_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG0_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS0: Selects the RAS and CAS latencies for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICRASCAS0_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS0_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG1: Selects the configuration information for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG1_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG1_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG1_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG1_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG1_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS1: Selects the RAS and CAS latencies for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICRASCAS1_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS1_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG2: Selects the configuration information for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG2_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG2_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG2_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG2_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG2_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS2: Selects the RAS and CAS latencies for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICRASCAS2_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS2_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG3: Selects the configuration information for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG3_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG3_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG3_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG3_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG3_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS3: Selects the RAS and CAS latencies for dynamic memory chip select 0.
func (o *EMC_Type) SetDYNAMICRASCAS3_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS3_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0xfffffc00) >> 10
}

// EMC.STATICCONFIG0: Selects the memory configuration for static chip select 0.
func (o *EMC_Type) SetSTATICCONFIG0_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG0_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG0_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG0_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG0_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG0_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG0_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG0_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG0_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG0_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG0_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG0_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG0_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG0_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN0: Selects the delay from chip select 0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN0_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN0.Reg, volatile.LoadUint32(&o.STATICWAITWEN0.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN0_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN0.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN0.Reg, volatile.LoadUint32(&o.STATICWAITWEN0.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN0.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN0: Selects the delay from chip select 0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN0_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN0.Reg, volatile.LoadUint32(&o.STATICWAITOEN0.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN0_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN0.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN0.Reg, volatile.LoadUint32(&o.STATICWAITOEN0.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN0.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD0: Selects the delay from chip select 0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD0_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD0.Reg, volatile.LoadUint32(&o.STATICWAITRD0.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD0_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD0.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD0.Reg, volatile.LoadUint32(&o.STATICWAITRD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD0.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE0: Selects the delay for asynchronous page mode sequential accesses for chip select 0.
func (o *EMC_Type) SetSTATICWAITPAGE0_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE0.Reg, volatile.LoadUint32(&o.STATICWAITPAGE0.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE0_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE0.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE0.Reg, volatile.LoadUint32(&o.STATICWAITPAGE0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE0.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR0: Selects the delay from chip select 0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR0_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR0.Reg, volatile.LoadUint32(&o.STATICWAITWR0.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR0_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR0.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR0.Reg, volatile.LoadUint32(&o.STATICWAITWR0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR0.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN0: Selects the number of bus turnaround cycles for chip select 0.
func (o *EMC_Type) SetSTATICWAITTURN0_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN0.Reg, volatile.LoadUint32(&o.STATICWAITTURN0.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN0_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN0.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN0.Reg, volatile.LoadUint32(&o.STATICWAITTURN0.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN0.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICCONFIG1: Selects the memory configuration for static chip select 0.
func (o *EMC_Type) SetSTATICCONFIG1_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG1_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG1_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG1_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG1_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG1_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG1_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG1_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG1_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG1_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG1_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG1_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG1_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG1_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN1: Selects the delay from chip select 0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN1_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN1.Reg, volatile.LoadUint32(&o.STATICWAITWEN1.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN1_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN1.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN1.Reg, volatile.LoadUint32(&o.STATICWAITWEN1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN1.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN1: Selects the delay from chip select 0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN1_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN1.Reg, volatile.LoadUint32(&o.STATICWAITOEN1.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN1_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN1.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN1.Reg, volatile.LoadUint32(&o.STATICWAITOEN1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN1.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD1: Selects the delay from chip select 0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD1_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD1.Reg, volatile.LoadUint32(&o.STATICWAITRD1.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD1_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD1.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD1.Reg, volatile.LoadUint32(&o.STATICWAITRD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD1.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE1: Selects the delay for asynchronous page mode sequential accesses for chip select 0.
func (o *EMC_Type) SetSTATICWAITPAGE1_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE1.Reg, volatile.LoadUint32(&o.STATICWAITPAGE1.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE1_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE1.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE1.Reg, volatile.LoadUint32(&o.STATICWAITPAGE1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE1.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR1: Selects the delay from chip select 0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR1_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR1.Reg, volatile.LoadUint32(&o.STATICWAITWR1.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR1_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR1.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR1.Reg, volatile.LoadUint32(&o.STATICWAITWR1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR1.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN1: Selects the number of bus turnaround cycles for chip select 0.
func (o *EMC_Type) SetSTATICWAITTURN1_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN1.Reg, volatile.LoadUint32(&o.STATICWAITTURN1.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN1_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN1.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN1.Reg, volatile.LoadUint32(&o.STATICWAITTURN1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN1.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICCONFIG2: Selects the memory configuration for static chip select 0.
func (o *EMC_Type) SetSTATICCONFIG2_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG2_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG2_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG2_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG2_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG2_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG2_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG2_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG2_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG2_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG2_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG2_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG2_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG2_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN2: Selects the delay from chip select 0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN2_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN2.Reg, volatile.LoadUint32(&o.STATICWAITWEN2.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN2_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN2.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN2.Reg, volatile.LoadUint32(&o.STATICWAITWEN2.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN2.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN2: Selects the delay from chip select 0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN2_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN2.Reg, volatile.LoadUint32(&o.STATICWAITOEN2.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN2_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN2.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN2.Reg, volatile.LoadUint32(&o.STATICWAITOEN2.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN2.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD2: Selects the delay from chip select 0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD2_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD2.Reg, volatile.LoadUint32(&o.STATICWAITRD2.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD2_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD2.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD2.Reg, volatile.LoadUint32(&o.STATICWAITRD2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD2.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE2: Selects the delay for asynchronous page mode sequential accesses for chip select 0.
func (o *EMC_Type) SetSTATICWAITPAGE2_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE2.Reg, volatile.LoadUint32(&o.STATICWAITPAGE2.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE2_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE2.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE2.Reg, volatile.LoadUint32(&o.STATICWAITPAGE2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE2.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR2: Selects the delay from chip select 0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR2_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR2.Reg, volatile.LoadUint32(&o.STATICWAITWR2.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR2_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR2.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR2.Reg, volatile.LoadUint32(&o.STATICWAITWR2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR2.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN2: Selects the number of bus turnaround cycles for chip select 0.
func (o *EMC_Type) SetSTATICWAITTURN2_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN2.Reg, volatile.LoadUint32(&o.STATICWAITTURN2.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN2_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN2.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN2.Reg, volatile.LoadUint32(&o.STATICWAITTURN2.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN2.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICCONFIG3: Selects the memory configuration for static chip select 0.
func (o *EMC_Type) SetSTATICCONFIG3_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG3_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG3_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG3_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG3_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG3_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG3_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG3_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG3_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG3_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG3_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG3_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG3_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG3_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN3: Selects the delay from chip select 0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN3_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN3.Reg, volatile.LoadUint32(&o.STATICWAITWEN3.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN3_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN3.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN3.Reg, volatile.LoadUint32(&o.STATICWAITWEN3.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN3.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN3: Selects the delay from chip select 0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN3_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN3.Reg, volatile.LoadUint32(&o.STATICWAITOEN3.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN3_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN3.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN3.Reg, volatile.LoadUint32(&o.STATICWAITOEN3.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN3.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD3: Selects the delay from chip select 0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD3_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD3.Reg, volatile.LoadUint32(&o.STATICWAITRD3.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD3_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD3.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD3.Reg, volatile.LoadUint32(&o.STATICWAITRD3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD3.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE3: Selects the delay for asynchronous page mode sequential accesses for chip select 0.
func (o *EMC_Type) SetSTATICWAITPAGE3_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE3.Reg, volatile.LoadUint32(&o.STATICWAITPAGE3.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE3_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE3.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE3.Reg, volatile.LoadUint32(&o.STATICWAITPAGE3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE3.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR3: Selects the delay from chip select 0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR3_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR3.Reg, volatile.LoadUint32(&o.STATICWAITWR3.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR3_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR3.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR3.Reg, volatile.LoadUint32(&o.STATICWAITWR3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR3.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN3: Selects the number of bus turnaround cycles for chip select 0.
func (o *EMC_Type) SetSTATICWAITTURN3_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN3.Reg, volatile.LoadUint32(&o.STATICWAITTURN3.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN3_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN3.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN3.Reg, volatile.LoadUint32(&o.STATICWAITTURN3.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN3.Reg) & 0xfffffff0) >> 4
}

// USB0 Host/Device/OTG controller
type USB0_Type struct {
	_                [256]byte
	CAPLENGTH        volatile.Register32 // 0x100
	HCSPARAMS        volatile.Register32 // 0x104
	HCCPARAMS        volatile.Register32 // 0x108
	_                [20]byte
	DCIVERSION       volatile.Register32 // 0x120
	_                [28]byte
	USBCMD_D         volatile.Register32 // 0x140
	USBSTS_D         volatile.Register32 // 0x144
	USBINTR_D        volatile.Register32 // 0x148
	FRINDEX_D        volatile.Register32 // 0x14C
	_                [4]byte
	DEVICEADDR       volatile.Register32 // 0x154
	ENDPOINTLISTADDR volatile.Register32 // 0x158
	TTCTRL           volatile.Register32 // 0x15C
	BURSTSIZE        volatile.Register32 // 0x160
	TXFILLTUNING     volatile.Register32 // 0x164
	_                [12]byte
	BINTERVAL        volatile.Register32 // 0x174
	ENDPTNAK         volatile.Register32 // 0x178
	ENDPTNAKEN       volatile.Register32 // 0x17C
	_                [4]byte
	PORTSC1_D        volatile.Register32 // 0x184
	_                [28]byte
	OTGSC            volatile.Register32 // 0x1A4
	USBMODE_D        volatile.Register32 // 0x1A8
	ENDPTSETUPSTAT   volatile.Register32 // 0x1AC
	ENDPTPRIME       volatile.Register32 // 0x1B0
	ENDPTFLUSH       volatile.Register32 // 0x1B4
	ENDPTSTAT        volatile.Register32 // 0x1B8
	ENDPTCOMPLETE    volatile.Register32 // 0x1BC
	ENDPTCTRL0       volatile.Register32 // 0x1C0
	ENDPTCTRL1       volatile.Register32 // 0x1C4
	ENDPTCTRL2       volatile.Register32 // 0x1C8
	ENDPTCTRL3       volatile.Register32 // 0x1CC
	ENDPTCTRL4       volatile.Register32 // 0x1D0
	ENDPTCTRL5       volatile.Register32 // 0x1D4
}

// USB0.CAPLENGTH: Capability register length
func (o *USB0_Type) SetCAPLENGTH(value uint32) {
	volatile.StoreUint32(&o.CAPLENGTH.Reg, volatile.LoadUint32(&o.CAPLENGTH.Reg)&^(0xff)|value)
}
func (o *USB0_Type) GetCAPLENGTH() uint32 {
	return volatile.LoadUint32(&o.CAPLENGTH.Reg) & 0xff
}
func (o *USB0_Type) SetCAPLENGTH_HCIVERSION(value uint32) {
	volatile.StoreUint32(&o.CAPLENGTH.Reg, volatile.LoadUint32(&o.CAPLENGTH.Reg)&^(0xffff00)|value<<8)
}
func (o *USB0_Type) GetCAPLENGTH_HCIVERSION() uint32 {
	return (volatile.LoadUint32(&o.CAPLENGTH.Reg) & 0xffff00) >> 8
}
func (o *USB0_Type) SetCAPLENGTH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CAPLENGTH.Reg, volatile.LoadUint32(&o.CAPLENGTH.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetCAPLENGTH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CAPLENGTH.Reg) & 0xff000000) >> 24
}

// USB0.HCSPARAMS: Host controller structural parameters
func (o *USB0_Type) SetHCSPARAMS_N_PORTS(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf)|value)
}
func (o *USB0_Type) GetHCSPARAMS_N_PORTS() uint32 {
	return volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf
}
func (o *USB0_Type) SetHCSPARAMS_PPC(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetHCSPARAMS_PPC() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetHCSPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xe0)|value<<5)
}
func (o *USB0_Type) GetHCSPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xe0) >> 5
}
func (o *USB0_Type) SetHCSPARAMS_N_PCC(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf00)|value<<8)
}
func (o *USB0_Type) GetHCSPARAMS_N_PCC() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf00) >> 8
}
func (o *USB0_Type) SetHCSPARAMS_N_CC(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf000)|value<<12)
}
func (o *USB0_Type) GetHCSPARAMS_N_CC() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf000) >> 12
}
func (o *USB0_Type) SetHCSPARAMS_PI(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetHCSPARAMS_PI() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetHCSPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xe0000)|value<<17)
}
func (o *USB0_Type) GetHCSPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xe0000) >> 17
}
func (o *USB0_Type) SetHCSPARAMS_N_PTT(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf00000)|value<<20)
}
func (o *USB0_Type) GetHCSPARAMS_N_PTT() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf00000) >> 20
}
func (o *USB0_Type) SetHCSPARAMS_N_TT(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf000000)|value<<24)
}
func (o *USB0_Type) GetHCSPARAMS_N_TT() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf000000) >> 24
}
func (o *USB0_Type) SetHCSPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf0000000)|value<<28)
}
func (o *USB0_Type) GetHCSPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf0000000) >> 28
}

// USB0.HCCPARAMS: Host controller capability parameters
func (o *USB0_Type) SetHCCPARAMS_ADC(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetHCCPARAMS_ADC() uint32 {
	return volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0x1
}
func (o *USB0_Type) SetHCCPARAMS_PFL(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetHCCPARAMS_PFL() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetHCCPARAMS_ASP(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetHCCPARAMS_ASP() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetHCCPARAMS_IST(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0xf0)|value<<4)
}
func (o *USB0_Type) GetHCCPARAMS_IST() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0xf0) >> 4
}
func (o *USB0_Type) SetHCCPARAMS_EECP(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetHCCPARAMS_EECP() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetHCCPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB0_Type) GetHCCPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0xffff0000) >> 16
}

// USB0.DCIVERSION: Device interface version number
func (o *USB0_Type) SetDCIVERSION(value uint32) {
	volatile.StoreUint32(&o.DCIVERSION.Reg, volatile.LoadUint32(&o.DCIVERSION.Reg)&^(0xffff)|value)
}
func (o *USB0_Type) GetDCIVERSION() uint32 {
	return volatile.LoadUint32(&o.DCIVERSION.Reg) & 0xffff
}

// USB0.USBCMD_D: USB command (device mode)
func (o *USB0_Type) SetUSBCMD_D_RS(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetUSBCMD_D_RS() uint32 {
	return volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x1
}
func (o *USB0_Type) SetUSBCMD_D_RST(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetUSBCMD_D_RST() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x300)|value<<8)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x300) >> 8
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x400)|value<<10)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x400) >> 10
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x800)|value<<11)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x800) >> 11
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x1000)|value<<12)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x1000) >> 12
}
func (o *USB0_Type) SetUSBCMD_D_SUTW(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x2000)|value<<13)
}
func (o *USB0_Type) GetUSBCMD_D_SUTW() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x2000) >> 13
}
func (o *USB0_Type) SetUSBCMD_D_ATDTW(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x4000)|value<<14)
}
func (o *USB0_Type) GetUSBCMD_D_ATDTW() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x4000) >> 14
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x8000)|value<<15)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x8000) >> 15
}
func (o *USB0_Type) SetUSBCMD_D_ITC(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0xff0000)|value<<16)
}
func (o *USB0_Type) GetUSBCMD_D_ITC() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0xff0000) >> 16
}
func (o *USB0_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0xff000000) >> 24
}

// USB0.USBSTS_D: USB status (device mode)
func (o *USB0_Type) SetUSBSTS_D_UI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetUSBSTS_D_UI() uint32 {
	return volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x1
}
func (o *USB0_Type) SetUSBSTS_D_UEI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetUSBSTS_D_UEI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetUSBSTS_D_PCI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetUSBSTS_D_PCI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetUSBSTS_D_AAI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetUSBSTS_D_AAI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetUSBSTS_D_URI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetUSBSTS_D_URI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetUSBSTS_D_SRI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBSTS_D_SRI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetUSBSTS_D_SLI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x100)|value<<8)
}
func (o *USB0_Type) GetUSBSTS_D_SLI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x100) >> 8
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0xe00)|value<<9)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0xe00) >> 9
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x1000)|value<<12)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x1000) >> 12
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x2000)|value<<13)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x2000) >> 13
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x4000)|value<<14)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x4000) >> 14
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x8000)|value<<15)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x8000) >> 15
}
func (o *USB0_Type) SetUSBSTS_D_NAKI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetUSBSTS_D_NAKI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB0_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0xfff00000) >> 20
}

// USB0.USBINTR_D: USB interrupt enable (device mode)
func (o *USB0_Type) SetUSBINTR_D_UE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetUSBINTR_D_UE() uint32 {
	return volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x1
}
func (o *USB0_Type) SetUSBINTR_D_UEE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetUSBINTR_D_UEE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetUSBINTR_D_PCE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetUSBINTR_D_PCE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetUSBINTR_D_URE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetUSBINTR_D_URE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetUSBINTR_D_SRE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBINTR_D_SRE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetUSBINTR_D_SLE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x100)|value<<8)
}
func (o *USB0_Type) GetUSBINTR_D_SLE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x100) >> 8
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0xfe00)|value<<9)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0xfe00) >> 9
}
func (o *USB0_Type) SetUSBINTR_D_NAKE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetUSBINTR_D_NAKE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB0_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0xfff00000) >> 20
}

// USB0.FRINDEX_D: USB frame index (device mode)
func (o *USB0_Type) SetFRINDEX_D_FRINDEX2_0(value uint32) {
	volatile.StoreUint32(&o.FRINDEX_D.Reg, volatile.LoadUint32(&o.FRINDEX_D.Reg)&^(0x7)|value)
}
func (o *USB0_Type) GetFRINDEX_D_FRINDEX2_0() uint32 {
	return volatile.LoadUint32(&o.FRINDEX_D.Reg) & 0x7
}
func (o *USB0_Type) SetFRINDEX_D_FRINDEX13_3(value uint32) {
	volatile.StoreUint32(&o.FRINDEX_D.Reg, volatile.LoadUint32(&o.FRINDEX_D.Reg)&^(0x3ff8)|value<<3)
}
func (o *USB0_Type) GetFRINDEX_D_FRINDEX13_3() uint32 {
	return (volatile.LoadUint32(&o.FRINDEX_D.Reg) & 0x3ff8) >> 3
}
func (o *USB0_Type) SetFRINDEX_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRINDEX_D.Reg, volatile.LoadUint32(&o.FRINDEX_D.Reg)&^(0xffffc000)|value<<14)
}
func (o *USB0_Type) GetFRINDEX_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRINDEX_D.Reg) & 0xffffc000) >> 14
}

// USB0.DEVICEADDR: USB device address (device mode)
func (o *USB0_Type) SetDEVICEADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR.Reg, volatile.LoadUint32(&o.DEVICEADDR.Reg)&^(0xffffff)|value)
}
func (o *USB0_Type) GetDEVICEADDR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DEVICEADDR.Reg) & 0xffffff
}
func (o *USB0_Type) SetDEVICEADDR_USBADRA(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR.Reg, volatile.LoadUint32(&o.DEVICEADDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB0_Type) GetDEVICEADDR_USBADRA() uint32 {
	return (volatile.LoadUint32(&o.DEVICEADDR.Reg) & 0x1000000) >> 24
}
func (o *USB0_Type) SetDEVICEADDR_USBADR(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR.Reg, volatile.LoadUint32(&o.DEVICEADDR.Reg)&^(0xfe000000)|value<<25)
}
func (o *USB0_Type) GetDEVICEADDR_USBADR() uint32 {
	return (volatile.LoadUint32(&o.DEVICEADDR.Reg) & 0xfe000000) >> 25
}

// USB0.ENDPOINTLISTADDR: Address of endpoint list in memory
func (o *USB0_Type) SetENDPOINTLISTADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPOINTLISTADDR.Reg, volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg)&^(0x7ff)|value)
}
func (o *USB0_Type) GetENDPOINTLISTADDR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg) & 0x7ff
}
func (o *USB0_Type) SetENDPOINTLISTADDR_EPBASE31_11(value uint32) {
	volatile.StoreUint32(&o.ENDPOINTLISTADDR.Reg, volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg)&^(0xfffff800)|value<<11)
}
func (o *USB0_Type) GetENDPOINTLISTADDR_EPBASE31_11() uint32 {
	return (volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg) & 0xfffff800) >> 11
}

// USB0.TTCTRL: Asynchronous buffer status for embedded TT (host mode)
func (o *USB0_Type) SetTTCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TTCTRL.Reg, volatile.LoadUint32(&o.TTCTRL.Reg)&^(0xffffff)|value)
}
func (o *USB0_Type) GetTTCTRL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TTCTRL.Reg) & 0xffffff
}
func (o *USB0_Type) SetTTCTRL_TTHA(value uint32) {
	volatile.StoreUint32(&o.TTCTRL.Reg, volatile.LoadUint32(&o.TTCTRL.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB0_Type) GetTTCTRL_TTHA() uint32 {
	return (volatile.LoadUint32(&o.TTCTRL.Reg) & 0x7f000000) >> 24
}
func (o *USB0_Type) SetTTCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TTCTRL.Reg, volatile.LoadUint32(&o.TTCTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB0_Type) GetTTCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TTCTRL.Reg) & 0x80000000) >> 31
}

// USB0.BURSTSIZE: Programmable burst size
func (o *USB0_Type) SetBURSTSIZE_RXPBURST(value uint32) {
	volatile.StoreUint32(&o.BURSTSIZE.Reg, volatile.LoadUint32(&o.BURSTSIZE.Reg)&^(0xff)|value)
}
func (o *USB0_Type) GetBURSTSIZE_RXPBURST() uint32 {
	return volatile.LoadUint32(&o.BURSTSIZE.Reg) & 0xff
}
func (o *USB0_Type) SetBURSTSIZE_TXPBURST(value uint32) {
	volatile.StoreUint32(&o.BURSTSIZE.Reg, volatile.LoadUint32(&o.BURSTSIZE.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetBURSTSIZE_TXPBURST() uint32 {
	return (volatile.LoadUint32(&o.BURSTSIZE.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetBURSTSIZE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BURSTSIZE.Reg, volatile.LoadUint32(&o.BURSTSIZE.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB0_Type) GetBURSTSIZE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BURSTSIZE.Reg) & 0xffff0000) >> 16
}

// USB0.TXFILLTUNING: Host transmit pre-buffer packet tuning (host mode)
func (o *USB0_Type) SetTXFILLTUNING_TXSCHOH(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0xff)|value)
}
func (o *USB0_Type) GetTXFILLTUNING_TXSCHOH() uint32 {
	return volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0xff
}
func (o *USB0_Type) SetTXFILLTUNING_TXSCHEATLTH(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0x1f00)|value<<8)
}
func (o *USB0_Type) GetTXFILLTUNING_TXSCHEATLTH() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0x1f00) >> 8
}
func (o *USB0_Type) SetTXFILLTUNING_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0xe000)|value<<13)
}
func (o *USB0_Type) GetTXFILLTUNING_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0xe000) >> 13
}
func (o *USB0_Type) SetTXFILLTUNING_TXFIFOTHRES(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0x3f0000)|value<<16)
}
func (o *USB0_Type) GetTXFILLTUNING_TXFIFOTHRES() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0x3f0000) >> 16
}
func (o *USB0_Type) SetTXFILLTUNING_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetTXFILLTUNING_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0xffc00000) >> 22
}

// USB0.BINTERVAL: Length of virtual frame
func (o *USB0_Type) SetBINTERVAL_BINT(value uint32) {
	volatile.StoreUint32(&o.BINTERVAL.Reg, volatile.LoadUint32(&o.BINTERVAL.Reg)&^(0xf)|value)
}
func (o *USB0_Type) GetBINTERVAL_BINT() uint32 {
	return volatile.LoadUint32(&o.BINTERVAL.Reg) & 0xf
}
func (o *USB0_Type) SetBINTERVAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BINTERVAL.Reg, volatile.LoadUint32(&o.BINTERVAL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB0_Type) GetBINTERVAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BINTERVAL.Reg) & 0xfffffff0) >> 4
}

// USB0.ENDPTNAK: Endpoint NAK (device mode)
func (o *USB0_Type) SetENDPTNAK_EPRN0(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTNAK_EPRN0() uint32 {
	return volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTNAK_EPRN1(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTNAK_EPRN1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTNAK_EPRN2(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTNAK_EPRN2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTNAK_EPRN3(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTNAK_EPRN3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTNAK_EPRN4(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTNAK_EPRN4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTNAK_EPRN5(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTNAK_EPRN5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTNAK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0xffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTNAK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0xffc0) >> 6
}
func (o *USB0_Type) SetENDPTNAK_EPTN0(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTNAK_EPTN0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTNAK_EPTN1(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTNAK_EPTN1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTNAK_EPTN2(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetENDPTNAK_EPTN2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetENDPTNAK_EPTN3(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetENDPTNAK_EPTN3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetENDPTNAK_EPTN4(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTNAK_EPTN4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTNAK_EPTN5(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTNAK_EPTN5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTNAK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetENDPTNAK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0xffc00000) >> 22
}

// USB0.ENDPTNAKEN: Endpoint NAK Enable (device mode)
func (o *USB0_Type) SetENDPTNAKEN_EPRNE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTNAKEN_EPRNE0() uint32 {
	return volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTNAKEN_EPRNE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTNAKEN_EPRNE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTNAKEN_EPRNE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTNAKEN_EPRNE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTNAKEN_EPRNE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTNAKEN_EPRNE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTNAKEN_EPRNE4(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTNAKEN_EPRNE4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTNAKEN_EPRNE5(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTNAKEN_EPRNE5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTNAKEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0xffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTNAKEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0xffc0) >> 6
}
func (o *USB0_Type) SetENDPTNAKEN_EPTNE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTNAKEN_EPTNE0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTNAKEN_EPTNE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTNAKEN_EPTNE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTNAKEN_EPTNE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetENDPTNAKEN_EPTNE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetENDPTNAKEN_EPTNE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetENDPTNAKEN_EPTNE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetENDPTNAKEN_EPTNE4(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTNAKEN_EPTNE4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTNAKEN_EPTNE5(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTNAKEN_EPTNE5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTNAKEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetENDPTNAKEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0xffc00000) >> 22
}

// USB0.PORTSC1_D: Port 1 status/control (device mode)
func (o *USB0_Type) SetPORTSC1_D_CCS(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetPORTSC1_D_CCS() uint32 {
	return volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x1
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetPORTSC1_D_PE(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetPORTSC1_D_PE() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetPORTSC1_D_PEC(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetPORTSC1_D_PEC() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x30)|value<<4)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x30) >> 4
}
func (o *USB0_Type) SetPORTSC1_D_FPR(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetPORTSC1_D_FPR() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetPORTSC1_D_SUSP(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetPORTSC1_D_SUSP() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetPORTSC1_D_PR(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x100)|value<<8)
}
func (o *USB0_Type) GetPORTSC1_D_PR() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x100) >> 8
}
func (o *USB0_Type) SetPORTSC1_D_HSP(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x200)|value<<9)
}
func (o *USB0_Type) GetPORTSC1_D_HSP() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x200) >> 9
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc00)|value<<10)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc00) >> 10
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x1000)|value<<12)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x1000) >> 12
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x2000)|value<<13)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x2000) >> 13
}
func (o *USB0_Type) SetPORTSC1_D_PIC1_0(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc000)|value<<14)
}
func (o *USB0_Type) GetPORTSC1_D_PIC1_0() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc000) >> 14
}
func (o *USB0_Type) SetPORTSC1_D_PTC3_0(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xf0000)|value<<16)
}
func (o *USB0_Type) GetPORTSC1_D_PTC3_0() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xf0000) >> 16
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetPORTSC1_D_PHCD(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetPORTSC1_D_PHCD() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetPORTSC1_D_PFSC(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x1000000)|value<<24)
}
func (o *USB0_Type) GetPORTSC1_D_PFSC() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x1000000) >> 24
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x2000000)|value<<25)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x2000000) >> 25
}
func (o *USB0_Type) SetPORTSC1_D_PSPD(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc000000)|value<<26)
}
func (o *USB0_Type) GetPORTSC1_D_PSPD() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc000000) >> 26
}
func (o *USB0_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xf0000000)|value<<28)
}
func (o *USB0_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xf0000000) >> 28
}

// USB0.OTGSC: OTG status and control
func (o *USB0_Type) SetOTGSC_VD(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGSC_VD() uint32 {
	return volatile.LoadUint32(&o.OTGSC.Reg) & 0x1
}
func (o *USB0_Type) SetOTGSC_VC(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetOTGSC_VC() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetOTGSC_HAAR(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGSC_HAAR() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGSC_OT(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGSC_OT() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGSC_DP(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetOTGSC_DP() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetOTGSC_IDPU(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGSC_IDPU() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGSC_HADP(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGSC_HADP() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGSC_HABA(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGSC_HABA() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetOTGSC_ID(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x100)|value<<8)
}
func (o *USB0_Type) GetOTGSC_ID() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x100) >> 8
}
func (o *USB0_Type) SetOTGSC_AVV(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x200)|value<<9)
}
func (o *USB0_Type) GetOTGSC_AVV() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x200) >> 9
}
func (o *USB0_Type) SetOTGSC_ASV(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x400)|value<<10)
}
func (o *USB0_Type) GetOTGSC_ASV() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x400) >> 10
}
func (o *USB0_Type) SetOTGSC_BSV(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x800)|value<<11)
}
func (o *USB0_Type) GetOTGSC_BSV() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x800) >> 11
}
func (o *USB0_Type) SetOTGSC_BSE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x1000)|value<<12)
}
func (o *USB0_Type) GetOTGSC_BSE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x1000) >> 12
}
func (o *USB0_Type) SetOTGSC_MS1T(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x2000)|value<<13)
}
func (o *USB0_Type) GetOTGSC_MS1T() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x2000) >> 13
}
func (o *USB0_Type) SetOTGSC_DPS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x4000)|value<<14)
}
func (o *USB0_Type) GetOTGSC_DPS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x4000) >> 14
}
func (o *USB0_Type) SetOTGSC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x8000)|value<<15)
}
func (o *USB0_Type) GetOTGSC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x8000) >> 15
}
func (o *USB0_Type) SetOTGSC_IDIS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetOTGSC_IDIS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetOTGSC_AVVIS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetOTGSC_AVVIS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetOTGSC_ASVIS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetOTGSC_ASVIS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetOTGSC_BSVIS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetOTGSC_BSVIS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetOTGSC_BSEIS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetOTGSC_BSEIS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetOTGSC_MS1S(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetOTGSC_MS1S() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetOTGSC_DPIS(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetOTGSC_DPIS() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetOTGSC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetOTGSC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetOTGSC_IDIE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x1000000)|value<<24)
}
func (o *USB0_Type) GetOTGSC_IDIE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x1000000) >> 24
}
func (o *USB0_Type) SetOTGSC_AVVIE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x2000000)|value<<25)
}
func (o *USB0_Type) GetOTGSC_AVVIE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x2000000) >> 25
}
func (o *USB0_Type) SetOTGSC_ASVIE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x4000000)|value<<26)
}
func (o *USB0_Type) GetOTGSC_ASVIE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x4000000) >> 26
}
func (o *USB0_Type) SetOTGSC_BSVIE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x8000000)|value<<27)
}
func (o *USB0_Type) GetOTGSC_BSVIE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x8000000) >> 27
}
func (o *USB0_Type) SetOTGSC_BSEIE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x10000000)|value<<28)
}
func (o *USB0_Type) GetOTGSC_BSEIE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x10000000) >> 28
}
func (o *USB0_Type) SetOTGSC_MS1E(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x20000000)|value<<29)
}
func (o *USB0_Type) GetOTGSC_MS1E() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x20000000) >> 29
}
func (o *USB0_Type) SetOTGSC_DPIE(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x40000000)|value<<30)
}
func (o *USB0_Type) GetOTGSC_DPIE() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x40000000) >> 30
}
func (o *USB0_Type) SetOTGSC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OTGSC.Reg, volatile.LoadUint32(&o.OTGSC.Reg)&^(0x80000000)|value<<31)
}
func (o *USB0_Type) GetOTGSC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OTGSC.Reg) & 0x80000000) >> 31
}

// USB0.USBMODE_D: USB device mode (device mode)
func (o *USB0_Type) SetUSBMODE_D_CM1_0(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x3)|value)
}
func (o *USB0_Type) GetUSBMODE_D_CM1_0() uint32 {
	return volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x3
}
func (o *USB0_Type) SetUSBMODE_D_ES(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetUSBMODE_D_ES() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetUSBMODE_D_SLOM(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetUSBMODE_D_SLOM() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetUSBMODE_D_SDIS(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetUSBMODE_D_SDIS() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetUSBMODE_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetUSBMODE_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetUSBMODE_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USB0_Type) GetUSBMODE_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0xffffffc0) >> 6
}

// USB0.ENDPTSETUPSTAT: Endpoint setup status
func (o *USB0_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT0(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT0() uint32 {
	return volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT1(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT2(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT3(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT4(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT5(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTSETUPSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTSETUPSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0xffffffc0) >> 6
}

// USB0.ENDPTPRIME: Endpoint initialization
func (o *USB0_Type) SetENDPTPRIME_PERB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTPRIME_PERB0() uint32 {
	return volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTPRIME_PERB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTPRIME_PERB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTPRIME_PERB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTPRIME_PERB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTPRIME_PERB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTPRIME_PERB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTPRIME_PERB4(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTPRIME_PERB4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTPRIME_PERB5(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTPRIME_PERB5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTPRIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0xffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTPRIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0xffc0) >> 6
}
func (o *USB0_Type) SetENDPTPRIME_PETB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTPRIME_PETB0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTPRIME_PETB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTPRIME_PETB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTPRIME_PETB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetENDPTPRIME_PETB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetENDPTPRIME_PETB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetENDPTPRIME_PETB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetENDPTPRIME_PETB4(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTPRIME_PETB4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTPRIME_PETB5(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTPRIME_PETB5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTPRIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetENDPTPRIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0xffc00000) >> 22
}

// USB0.ENDPTFLUSH: Endpoint de-initialization
func (o *USB0_Type) SetENDPTFLUSH_FERB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTFLUSH_FERB0() uint32 {
	return volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTFLUSH_FERB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTFLUSH_FERB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTFLUSH_FERB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTFLUSH_FERB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTFLUSH_FERB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTFLUSH_FERB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTFLUSH_FERB4(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTFLUSH_FERB4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTFLUSH_FERB5(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTFLUSH_FERB5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTFLUSH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0xffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTFLUSH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0xffc0) >> 6
}
func (o *USB0_Type) SetENDPTFLUSH_FETB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTFLUSH_FETB0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTFLUSH_FETB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTFLUSH_FETB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTFLUSH_FETB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetENDPTFLUSH_FETB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetENDPTFLUSH_FETB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetENDPTFLUSH_FETB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetENDPTFLUSH_FETB4(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTFLUSH_FETB4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTFLUSH_FETB5(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTFLUSH_FETB5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTFLUSH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetENDPTFLUSH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0xffc00000) >> 22
}

// USB0.ENDPTSTAT: Endpoint status
func (o *USB0_Type) SetENDPTSTAT_ERBR0(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTSTAT_ERBR0() uint32 {
	return volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTSTAT_ERBR1(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTSTAT_ERBR1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTSTAT_ERBR2(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTSTAT_ERBR2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTSTAT_ERBR3(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTSTAT_ERBR3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTSTAT_ERBR4(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTSTAT_ERBR4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTSTAT_ERBR5(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTSTAT_ERBR5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0xffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0xffc0) >> 6
}
func (o *USB0_Type) SetENDPTSTAT_ETBR0(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTSTAT_ETBR0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTSTAT_ETBR1(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTSTAT_ETBR1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTSTAT_ETBR2(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetENDPTSTAT_ETBR2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetENDPTSTAT_ETBR3(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetENDPTSTAT_ETBR3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetENDPTSTAT_ETBR4(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTSTAT_ETBR4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTSTAT_ETBR5(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTSTAT_ETBR5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetENDPTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0xffc00000) >> 22
}

// USB0.ENDPTCOMPLETE: Endpoint complete
func (o *USB0_Type) SetENDPTCOMPLETE_ERCE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ERCE0() uint32 {
	return volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCOMPLETE_ERCE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ERCE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCOMPLETE_ERCE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ERCE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPTCOMPLETE_ERCE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ERCE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPTCOMPLETE_ERCE4(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ERCE4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTCOMPLETE_ERCE5(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ERCE5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTCOMPLETE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0xffc0)|value<<6)
}
func (o *USB0_Type) GetENDPTCOMPLETE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0xffc0) >> 6
}
func (o *USB0_Type) SetENDPTCOMPLETE_ETCE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ETCE0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCOMPLETE_ETCE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ETCE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCOMPLETE_ETCE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x40000)|value<<18)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ETCE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x40000) >> 18
}
func (o *USB0_Type) SetENDPTCOMPLETE_ETCE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x80000)|value<<19)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ETCE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x80000) >> 19
}
func (o *USB0_Type) SetENDPTCOMPLETE_ETCE4(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ETCE4() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTCOMPLETE_ETCE5(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTCOMPLETE_ETCE5() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTCOMPLETE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB0_Type) GetENDPTCOMPLETE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0xffc00000) >> 22
}

// USB0.ENDPTCTRL0: Endpoint control 0
func (o *USB0_Type) SetENDPTCTRL0_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCTRL0_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCTRL0_RXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetENDPTCTRL0_RXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x70)|value<<4)
}
func (o *USB0_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x70) >> 4
}
func (o *USB0_Type) SetENDPTCTRL0_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPTCTRL0_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetENDPTCTRL0_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCTRL0_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCTRL0_TXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB0_Type) GetENDPTCTRL0_TXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xc0000) >> 18
}
func (o *USB0_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x700000)|value<<20)
}
func (o *USB0_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x700000) >> 20
}
func (o *USB0_Type) SetENDPTCTRL0_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetENDPTCTRL0_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xff000000) >> 24
}

// USB0.ENDPTCTRL1: Endpoint control
func (o *USB0_Type) SetENDPTCTRL1_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCTRL1_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCTRL1_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetENDPTCTRL1_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTCTRL1_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTCTRL1_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTCTRL1_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPTCTRL1_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPTCTRL1_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPTCTRL1_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetENDPTCTRL1_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCTRL1_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCTRL1_TXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB0_Type) GetENDPTCTRL1_TXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xc0000) >> 18
}
func (o *USB0_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTCTRL1_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTCTRL1_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTCTRL1_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetENDPTCTRL1_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetENDPTCTRL1_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetENDPTCTRL1_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xff000000) >> 24
}

// USB0.ENDPTCTRL2: Endpoint control
func (o *USB0_Type) SetENDPTCTRL2_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCTRL2_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCTRL2_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetENDPTCTRL2_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTCTRL2_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTCTRL2_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTCTRL2_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPTCTRL2_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPTCTRL2_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPTCTRL2_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetENDPTCTRL2_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCTRL2_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCTRL2_TXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB0_Type) GetENDPTCTRL2_TXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xc0000) >> 18
}
func (o *USB0_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTCTRL2_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTCTRL2_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTCTRL2_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetENDPTCTRL2_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetENDPTCTRL2_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetENDPTCTRL2_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xff000000) >> 24
}

// USB0.ENDPTCTRL3: Endpoint control
func (o *USB0_Type) SetENDPTCTRL3_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCTRL3_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCTRL3_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetENDPTCTRL3_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTCTRL3_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTCTRL3_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTCTRL3_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPTCTRL3_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPTCTRL3_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPTCTRL3_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetENDPTCTRL3_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCTRL3_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCTRL3_TXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB0_Type) GetENDPTCTRL3_TXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xc0000) >> 18
}
func (o *USB0_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTCTRL3_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTCTRL3_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTCTRL3_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetENDPTCTRL3_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetENDPTCTRL3_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetENDPTCTRL3_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xff000000) >> 24
}

// USB0.ENDPTCTRL4: Endpoint control
func (o *USB0_Type) SetENDPTCTRL4_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCTRL4_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCTRL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCTRL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCTRL4_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetENDPTCTRL4_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetENDPTCTRL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTCTRL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTCTRL4_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTCTRL4_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTCTRL4_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPTCTRL4_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPTCTRL4_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPTCTRL4_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetENDPTCTRL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetENDPTCTRL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetENDPTCTRL4_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCTRL4_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCTRL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCTRL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCTRL4_TXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0xc0000)|value<<18)
}
func (o *USB0_Type) GetENDPTCTRL4_TXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0xc0000) >> 18
}
func (o *USB0_Type) SetENDPTCTRL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTCTRL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTCTRL4_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTCTRL4_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTCTRL4_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetENDPTCTRL4_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetENDPTCTRL4_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetENDPTCTRL4_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetENDPTCTRL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL4.Reg, volatile.LoadUint32(&o.ENDPTCTRL4.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetENDPTCTRL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL4.Reg) & 0xff000000) >> 24
}

// USB0.ENDPTCTRL5: Endpoint control
func (o *USB0_Type) SetENDPTCTRL5_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPTCTRL5_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x1
}
func (o *USB0_Type) SetENDPTCTRL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPTCTRL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPTCTRL5_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0xc)|value<<2)
}
func (o *USB0_Type) GetENDPTCTRL5_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0xc) >> 2
}
func (o *USB0_Type) SetENDPTCTRL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPTCTRL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPTCTRL5_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetENDPTCTRL5_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetENDPTCTRL5_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPTCTRL5_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPTCTRL5_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPTCTRL5_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x80) >> 7
}
func (o *USB0_Type) SetENDPTCTRL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0xff00)|value<<8)
}
func (o *USB0_Type) GetENDPTCTRL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0xff00) >> 8
}
func (o *USB0_Type) SetENDPTCTRL5_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x10000)|value<<16)
}
func (o *USB0_Type) GetENDPTCTRL5_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x10000) >> 16
}
func (o *USB0_Type) SetENDPTCTRL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x20000)|value<<17)
}
func (o *USB0_Type) GetENDPTCTRL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x20000) >> 17
}
func (o *USB0_Type) SetENDPTCTRL5_TXT1_0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0xc0000)|value<<18)
}
func (o *USB0_Type) GetENDPTCTRL5_TXT1_0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0xc0000) >> 18
}
func (o *USB0_Type) SetENDPTCTRL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x100000)|value<<20)
}
func (o *USB0_Type) GetENDPTCTRL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x100000) >> 20
}
func (o *USB0_Type) SetENDPTCTRL5_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x200000)|value<<21)
}
func (o *USB0_Type) GetENDPTCTRL5_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x200000) >> 21
}
func (o *USB0_Type) SetENDPTCTRL5_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x400000)|value<<22)
}
func (o *USB0_Type) GetENDPTCTRL5_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x400000) >> 22
}
func (o *USB0_Type) SetENDPTCTRL5_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0x800000)|value<<23)
}
func (o *USB0_Type) GetENDPTCTRL5_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0x800000) >> 23
}
func (o *USB0_Type) SetENDPTCTRL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL5.Reg, volatile.LoadUint32(&o.ENDPTCTRL5.Reg)&^(0xff000000)|value<<24)
}
func (o *USB0_Type) GetENDPTCTRL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL5.Reg) & 0xff000000) >> 24
}

// USB1 Host/Device controller
type USB1_Type struct {
	_                [256]byte
	CAPLENGTH        volatile.Register32 // 0x100
	HCSPARAMS        volatile.Register32 // 0x104
	HCCPARAMS        volatile.Register32 // 0x108
	_                [20]byte
	DCIVERSION       volatile.Register32 // 0x120
	_                [28]byte
	USBCMD_D         volatile.Register32 // 0x140
	USBSTS_D         volatile.Register32 // 0x144
	USBINTR_D        volatile.Register32 // 0x148
	FRINDEX_D        volatile.Register32 // 0x14C
	_                [4]byte
	DEVICEADDR       volatile.Register32 // 0x154
	ENDPOINTLISTADDR volatile.Register32 // 0x158
	TTCTRL           volatile.Register32 // 0x15C
	BURSTSIZE        volatile.Register32 // 0x160
	TXFILLTUNING     volatile.Register32 // 0x164
	_                [8]byte
	ULPIVIEWPORT     volatile.Register32 // 0x170
	BINTERVAL        volatile.Register32 // 0x174
	ENDPTNAK         volatile.Register32 // 0x178
	ENDPTNAKEN       volatile.Register32 // 0x17C
	_                [4]byte
	PORTSC1_D        volatile.Register32 // 0x184
	_                [32]byte
	USBMODE_D        volatile.Register32 // 0x1A8
	ENDPTSETUPSTAT   volatile.Register32 // 0x1AC
	ENDPTPRIME       volatile.Register32 // 0x1B0
	ENDPTFLUSH       volatile.Register32 // 0x1B4
	ENDPTSTAT        volatile.Register32 // 0x1B8
	ENDPTCOMPLETE    volatile.Register32 // 0x1BC
	ENDPTCTRL0       volatile.Register32 // 0x1C0
	ENDPTCTRL1       volatile.Register32 // 0x1C4
	ENDPTCTRL2       volatile.Register32 // 0x1C8
	ENDPTCTRL3       volatile.Register32 // 0x1CC
}

// USB1.CAPLENGTH: Capability register length
func (o *USB1_Type) SetCAPLENGTH(value uint32) {
	volatile.StoreUint32(&o.CAPLENGTH.Reg, volatile.LoadUint32(&o.CAPLENGTH.Reg)&^(0xff)|value)
}
func (o *USB1_Type) GetCAPLENGTH() uint32 {
	return volatile.LoadUint32(&o.CAPLENGTH.Reg) & 0xff
}
func (o *USB1_Type) SetCAPLENGTH_HCIVERSION(value uint32) {
	volatile.StoreUint32(&o.CAPLENGTH.Reg, volatile.LoadUint32(&o.CAPLENGTH.Reg)&^(0xffff00)|value<<8)
}
func (o *USB1_Type) GetCAPLENGTH_HCIVERSION() uint32 {
	return (volatile.LoadUint32(&o.CAPLENGTH.Reg) & 0xffff00) >> 8
}
func (o *USB1_Type) SetCAPLENGTH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CAPLENGTH.Reg, volatile.LoadUint32(&o.CAPLENGTH.Reg)&^(0xff000000)|value<<24)
}
func (o *USB1_Type) GetCAPLENGTH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CAPLENGTH.Reg) & 0xff000000) >> 24
}

// USB1.HCSPARAMS: Host controller structural parameters
func (o *USB1_Type) SetHCSPARAMS_N_PORTS(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf)|value)
}
func (o *USB1_Type) GetHCSPARAMS_N_PORTS() uint32 {
	return volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf
}
func (o *USB1_Type) SetHCSPARAMS_PPC(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetHCSPARAMS_PPC() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetHCSPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xe0)|value<<5)
}
func (o *USB1_Type) GetHCSPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xe0) >> 5
}
func (o *USB1_Type) SetHCSPARAMS_N_PCC(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf00)|value<<8)
}
func (o *USB1_Type) GetHCSPARAMS_N_PCC() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf00) >> 8
}
func (o *USB1_Type) SetHCSPARAMS_N_CC(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf000)|value<<12)
}
func (o *USB1_Type) GetHCSPARAMS_N_CC() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf000) >> 12
}
func (o *USB1_Type) SetHCSPARAMS_PI(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetHCSPARAMS_PI() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetHCSPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xe0000)|value<<17)
}
func (o *USB1_Type) GetHCSPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xe0000) >> 17
}
func (o *USB1_Type) SetHCSPARAMS_N_PTT(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf00000)|value<<20)
}
func (o *USB1_Type) GetHCSPARAMS_N_PTT() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf00000) >> 20
}
func (o *USB1_Type) SetHCSPARAMS_N_TT(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf000000)|value<<24)
}
func (o *USB1_Type) GetHCSPARAMS_N_TT() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf000000) >> 24
}
func (o *USB1_Type) SetHCSPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCSPARAMS.Reg, volatile.LoadUint32(&o.HCSPARAMS.Reg)&^(0xf0000000)|value<<28)
}
func (o *USB1_Type) GetHCSPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCSPARAMS.Reg) & 0xf0000000) >> 28
}

// USB1.HCCPARAMS: Host controller capability parameters
func (o *USB1_Type) SetHCCPARAMS_ADC(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetHCCPARAMS_ADC() uint32 {
	return volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0x1
}
func (o *USB1_Type) SetHCCPARAMS_PFL(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetHCCPARAMS_PFL() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetHCCPARAMS_ASP(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetHCCPARAMS_ASP() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetHCCPARAMS_IST(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0xf0)|value<<4)
}
func (o *USB1_Type) GetHCCPARAMS_IST() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0xf0) >> 4
}
func (o *USB1_Type) SetHCCPARAMS_EECP(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetHCCPARAMS_EECP() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetHCCPARAMS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HCCPARAMS.Reg, volatile.LoadUint32(&o.HCCPARAMS.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB1_Type) GetHCCPARAMS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HCCPARAMS.Reg) & 0xffff0000) >> 16
}

// USB1.DCIVERSION: Device interface version number
func (o *USB1_Type) SetDCIVERSION(value uint32) {
	volatile.StoreUint32(&o.DCIVERSION.Reg, volatile.LoadUint32(&o.DCIVERSION.Reg)&^(0xffff)|value)
}
func (o *USB1_Type) GetDCIVERSION() uint32 {
	return volatile.LoadUint32(&o.DCIVERSION.Reg) & 0xffff
}
func (o *USB1_Type) SetDCIVERSION_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DCIVERSION.Reg, volatile.LoadUint32(&o.DCIVERSION.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB1_Type) GetDCIVERSION_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DCIVERSION.Reg) & 0xffff0000) >> 16
}

// USB1.USBCMD_D: USB command (device mode)
func (o *USB1_Type) SetUSBCMD_D_RS(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetUSBCMD_D_RS() uint32 {
	return volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x1
}
func (o *USB1_Type) SetUSBCMD_D_RST(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetUSBCMD_D_RST() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0xc)|value<<2)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0xc) >> 2
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x300)|value<<8)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x300) >> 8
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x400)|value<<10)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x400) >> 10
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x800)|value<<11)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x800) >> 11
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x1000)|value<<12)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x1000) >> 12
}
func (o *USB1_Type) SetUSBCMD_D_SUTW(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x2000)|value<<13)
}
func (o *USB1_Type) GetUSBCMD_D_SUTW() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x2000) >> 13
}
func (o *USB1_Type) SetUSBCMD_D_ATDTW(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x4000)|value<<14)
}
func (o *USB1_Type) GetUSBCMD_D_ATDTW() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x4000) >> 14
}
func (o *USB1_Type) SetUSBCMD_D_FS2(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0x8000)|value<<15)
}
func (o *USB1_Type) GetUSBCMD_D_FS2() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0x8000) >> 15
}
func (o *USB1_Type) SetUSBCMD_D_ITC(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0xff0000)|value<<16)
}
func (o *USB1_Type) GetUSBCMD_D_ITC() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0xff0000) >> 16
}
func (o *USB1_Type) SetUSBCMD_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCMD_D.Reg, volatile.LoadUint32(&o.USBCMD_D.Reg)&^(0xff000000)|value<<24)
}
func (o *USB1_Type) GetUSBCMD_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCMD_D.Reg) & 0xff000000) >> 24
}

// USB1.USBSTS_D: USB status (device mode)
func (o *USB1_Type) SetUSBSTS_D_UI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetUSBSTS_D_UI() uint32 {
	return volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x1
}
func (o *USB1_Type) SetUSBSTS_D_UEI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetUSBSTS_D_UEI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetUSBSTS_D_PCI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetUSBSTS_D_PCI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetUSBSTS_D_URI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetUSBSTS_D_URI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetUSBSTS_D_SRI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetUSBSTS_D_SRI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetUSBSTS_D_SLI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x100)|value<<8)
}
func (o *USB1_Type) GetUSBSTS_D_SLI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x100) >> 8
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0xe00)|value<<9)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0xe00) >> 9
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x1000)|value<<12)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x1000) >> 12
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x2000)|value<<13)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x2000) >> 13
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x4000)|value<<14)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x4000) >> 14
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x8000)|value<<15)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x8000) >> 15
}
func (o *USB1_Type) SetUSBSTS_D_NAKI(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetUSBSTS_D_NAKI() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetUSBSTS_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBSTS_D.Reg, volatile.LoadUint32(&o.USBSTS_D.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetUSBSTS_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBSTS_D.Reg) & 0xfff00000) >> 20
}

// USB1.USBINTR_D: USB interrupt enable (device mode)
func (o *USB1_Type) SetUSBINTR_D_UE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetUSBINTR_D_UE() uint32 {
	return volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x1
}
func (o *USB1_Type) SetUSBINTR_D_UEE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetUSBINTR_D_UEE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetUSBINTR_D_PCE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetUSBINTR_D_PCE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetUSBINTR_D_URE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetUSBINTR_D_URE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetUSBINTR_D_SRE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetUSBINTR_D_SRE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetUSBINTR_D_SLE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x100)|value<<8)
}
func (o *USB1_Type) GetUSBINTR_D_SLE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x100) >> 8
}
func (o *USB1_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0xfe00)|value<<9)
}
func (o *USB1_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0xfe00) >> 9
}
func (o *USB1_Type) SetUSBINTR_D_NAKE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetUSBINTR_D_NAKE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetUSBINTR_D_UAIE(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetUSBINTR_D_UAIE() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetUSBINTR_D_UPIA(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetUSBINTR_D_UPIA() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetUSBINTR_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTR_D.Reg, volatile.LoadUint32(&o.USBINTR_D.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetUSBINTR_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTR_D.Reg) & 0xfff00000) >> 20
}

// USB1.FRINDEX_D: USB frame index (device mode)
func (o *USB1_Type) SetFRINDEX_D_FRINDEX2_0(value uint32) {
	volatile.StoreUint32(&o.FRINDEX_D.Reg, volatile.LoadUint32(&o.FRINDEX_D.Reg)&^(0x7)|value)
}
func (o *USB1_Type) GetFRINDEX_D_FRINDEX2_0() uint32 {
	return volatile.LoadUint32(&o.FRINDEX_D.Reg) & 0x7
}
func (o *USB1_Type) SetFRINDEX_D_FRINDEX13_3(value uint32) {
	volatile.StoreUint32(&o.FRINDEX_D.Reg, volatile.LoadUint32(&o.FRINDEX_D.Reg)&^(0x3ff8)|value<<3)
}
func (o *USB1_Type) GetFRINDEX_D_FRINDEX13_3() uint32 {
	return (volatile.LoadUint32(&o.FRINDEX_D.Reg) & 0x3ff8) >> 3
}
func (o *USB1_Type) SetFRINDEX_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRINDEX_D.Reg, volatile.LoadUint32(&o.FRINDEX_D.Reg)&^(0xffffc000)|value<<14)
}
func (o *USB1_Type) GetFRINDEX_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRINDEX_D.Reg) & 0xffffc000) >> 14
}

// USB1.DEVICEADDR: USB device address
func (o *USB1_Type) SetDEVICEADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR.Reg, volatile.LoadUint32(&o.DEVICEADDR.Reg)&^(0xffffff)|value)
}
func (o *USB1_Type) GetDEVICEADDR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DEVICEADDR.Reg) & 0xffffff
}
func (o *USB1_Type) SetDEVICEADDR_USBADRA(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR.Reg, volatile.LoadUint32(&o.DEVICEADDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB1_Type) GetDEVICEADDR_USBADRA() uint32 {
	return (volatile.LoadUint32(&o.DEVICEADDR.Reg) & 0x1000000) >> 24
}
func (o *USB1_Type) SetDEVICEADDR_USBADR(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR.Reg, volatile.LoadUint32(&o.DEVICEADDR.Reg)&^(0xfe000000)|value<<25)
}
func (o *USB1_Type) GetDEVICEADDR_USBADR() uint32 {
	return (volatile.LoadUint32(&o.DEVICEADDR.Reg) & 0xfe000000) >> 25
}

// USB1.ENDPOINTLISTADDR: Address of endpoint list in memory (device mode)
func (o *USB1_Type) SetENDPOINTLISTADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPOINTLISTADDR.Reg, volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg)&^(0x7ff)|value)
}
func (o *USB1_Type) GetENDPOINTLISTADDR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg) & 0x7ff
}
func (o *USB1_Type) SetENDPOINTLISTADDR_EPBASE31_11(value uint32) {
	volatile.StoreUint32(&o.ENDPOINTLISTADDR.Reg, volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg)&^(0xfffff800)|value<<11)
}
func (o *USB1_Type) GetENDPOINTLISTADDR_EPBASE31_11() uint32 {
	return (volatile.LoadUint32(&o.ENDPOINTLISTADDR.Reg) & 0xfffff800) >> 11
}

// USB1.TTCTRL: Asynchronous buffer status for embedded TT (host mode)
func (o *USB1_Type) SetTTCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TTCTRL.Reg, volatile.LoadUint32(&o.TTCTRL.Reg)&^(0xffffff)|value)
}
func (o *USB1_Type) GetTTCTRL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TTCTRL.Reg) & 0xffffff
}
func (o *USB1_Type) SetTTCTRL_TTHA(value uint32) {
	volatile.StoreUint32(&o.TTCTRL.Reg, volatile.LoadUint32(&o.TTCTRL.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB1_Type) GetTTCTRL_TTHA() uint32 {
	return (volatile.LoadUint32(&o.TTCTRL.Reg) & 0x7f000000) >> 24
}
func (o *USB1_Type) SetTTCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TTCTRL.Reg, volatile.LoadUint32(&o.TTCTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB1_Type) GetTTCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TTCTRL.Reg) & 0x80000000) >> 31
}

// USB1.BURSTSIZE: Programmable burst size
func (o *USB1_Type) SetBURSTSIZE_RXPBURST(value uint32) {
	volatile.StoreUint32(&o.BURSTSIZE.Reg, volatile.LoadUint32(&o.BURSTSIZE.Reg)&^(0xff)|value)
}
func (o *USB1_Type) GetBURSTSIZE_RXPBURST() uint32 {
	return volatile.LoadUint32(&o.BURSTSIZE.Reg) & 0xff
}
func (o *USB1_Type) SetBURSTSIZE_TXPBURST(value uint32) {
	volatile.StoreUint32(&o.BURSTSIZE.Reg, volatile.LoadUint32(&o.BURSTSIZE.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetBURSTSIZE_TXPBURST() uint32 {
	return (volatile.LoadUint32(&o.BURSTSIZE.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetBURSTSIZE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BURSTSIZE.Reg, volatile.LoadUint32(&o.BURSTSIZE.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB1_Type) GetBURSTSIZE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BURSTSIZE.Reg) & 0xffff0000) >> 16
}

// USB1.TXFILLTUNING: Host transmit pre-buffer packet tuning (host mode)
func (o *USB1_Type) SetTXFILLTUNING_TXSCHOH(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0xff)|value)
}
func (o *USB1_Type) GetTXFILLTUNING_TXSCHOH() uint32 {
	return volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0xff
}
func (o *USB1_Type) SetTXFILLTUNING_TXSCHEATLTH(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0x1f00)|value<<8)
}
func (o *USB1_Type) GetTXFILLTUNING_TXSCHEATLTH() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0x1f00) >> 8
}
func (o *USB1_Type) SetTXFILLTUNING_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0xe000)|value<<13)
}
func (o *USB1_Type) GetTXFILLTUNING_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0xe000) >> 13
}
func (o *USB1_Type) SetTXFILLTUNING_TXFIFOTHRES(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0x3f0000)|value<<16)
}
func (o *USB1_Type) GetTXFILLTUNING_TXFIFOTHRES() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0x3f0000) >> 16
}
func (o *USB1_Type) SetTXFILLTUNING_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXFILLTUNING.Reg, volatile.LoadUint32(&o.TXFILLTUNING.Reg)&^(0xffc00000)|value<<22)
}
func (o *USB1_Type) GetTXFILLTUNING_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXFILLTUNING.Reg) & 0xffc00000) >> 22
}

// USB1.ULPIVIEWPORT: ULPI viewport
func (o *USB1_Type) SetULPIVIEWPORT_ULPIDATWR(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0xff)|value)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIDATWR() uint32 {
	return volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0xff
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPIDATRD(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIDATRD() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPIADDR(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0xff0000)|value<<16)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIADDR() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0xff0000) >> 16
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPIPORT(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0x7000000)|value<<24)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIPORT() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0x7000000) >> 24
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPISS(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0x8000000)|value<<27)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPISS() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0x8000000) >> 27
}
func (o *USB1_Type) SetULPIVIEWPORT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0x10000000)|value<<28)
}
func (o *USB1_Type) GetULPIVIEWPORT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0x10000000) >> 28
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPIRW(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0x20000000)|value<<29)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIRW() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0x20000000) >> 29
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPIRUN(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0x40000000)|value<<30)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIRUN() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0x40000000) >> 30
}
func (o *USB1_Type) SetULPIVIEWPORT_ULPIWU(value uint32) {
	volatile.StoreUint32(&o.ULPIVIEWPORT.Reg, volatile.LoadUint32(&o.ULPIVIEWPORT.Reg)&^(0x80000000)|value<<31)
}
func (o *USB1_Type) GetULPIVIEWPORT_ULPIWU() uint32 {
	return (volatile.LoadUint32(&o.ULPIVIEWPORT.Reg) & 0x80000000) >> 31
}

// USB1.BINTERVAL: Length of virtual frame
func (o *USB1_Type) SetBINTERVAL_BINT(value uint32) {
	volatile.StoreUint32(&o.BINTERVAL.Reg, volatile.LoadUint32(&o.BINTERVAL.Reg)&^(0xf)|value)
}
func (o *USB1_Type) GetBINTERVAL_BINT() uint32 {
	return volatile.LoadUint32(&o.BINTERVAL.Reg) & 0xf
}
func (o *USB1_Type) SetBINTERVAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BINTERVAL.Reg, volatile.LoadUint32(&o.BINTERVAL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB1_Type) GetBINTERVAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BINTERVAL.Reg) & 0xfffffff0) >> 4
}

// USB1.ENDPTNAK: Endpoint NAK (device mode)
func (o *USB1_Type) SetENDPTNAK_EPRN0(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTNAK_EPRN0() uint32 {
	return volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTNAK_EPRN1(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTNAK_EPRN1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTNAK_EPRN2(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTNAK_EPRN2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTNAK_EPRN3(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTNAK_EPRN3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTNAK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0xfff0)|value<<4)
}
func (o *USB1_Type) GetENDPTNAK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0xfff0) >> 4
}
func (o *USB1_Type) SetENDPTNAK_EPTN16(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTNAK_EPTN16() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTNAK_EPTN17(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTNAK_EPTN17() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTNAK_EPTN18(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetENDPTNAK_EPTN18() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetENDPTNAK_EPTN19(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetENDPTNAK_EPTN19() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetENDPTNAK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAK.Reg, volatile.LoadUint32(&o.ENDPTNAK.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetENDPTNAK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAK.Reg) & 0xfff00000) >> 20
}

// USB1.ENDPTNAKEN: Endpoint NAK Enable (device mode)
func (o *USB1_Type) SetENDPTNAKEN_EPRNE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTNAKEN_EPRNE0() uint32 {
	return volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTNAKEN_EPRNE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTNAKEN_EPRNE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTNAKEN_EPRNE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTNAKEN_EPRNE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTNAKEN_EPRNE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTNAKEN_EPRNE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTNAKEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0xfff0)|value<<4)
}
func (o *USB1_Type) GetENDPTNAKEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0xfff0) >> 4
}
func (o *USB1_Type) SetENDPTNAKEN_EPTNE16(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTNAKEN_EPTNE16() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTNAKEN_EPTNE17(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTNAKEN_EPTNE17() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTNAKEN_EPTNE18(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetENDPTNAKEN_EPTNE18() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetENDPTNAKEN_EPTNE19(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetENDPTNAKEN_EPTNE19() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetENDPTNAKEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTNAKEN.Reg, volatile.LoadUint32(&o.ENDPTNAKEN.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetENDPTNAKEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTNAKEN.Reg) & 0xfff00000) >> 20
}

// USB1.PORTSC1_D: Port 1 status/control (device mode)
func (o *USB1_Type) SetPORTSC1_D_CCS(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetPORTSC1_D_CCS() uint32 {
	return volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x1
}
func (o *USB1_Type) SetPORTSC1_D_CSC(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetPORTSC1_D_CSC() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetPORTSC1_D_PE(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetPORTSC1_D_PE() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetPORTSC1_D_PEC(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetPORTSC1_D_PEC() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x30)|value<<4)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x30) >> 4
}
func (o *USB1_Type) SetPORTSC1_D_FPR(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetPORTSC1_D_FPR() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetPORTSC1_D_SUSP(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetPORTSC1_D_SUSP() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetPORTSC1_D_PR(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x100)|value<<8)
}
func (o *USB1_Type) GetPORTSC1_D_PR() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x100) >> 8
}
func (o *USB1_Type) SetPORTSC1_D_HSP(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x200)|value<<9)
}
func (o *USB1_Type) GetPORTSC1_D_HSP() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x200) >> 9
}
func (o *USB1_Type) SetPORTSC1_D_LS(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc00)|value<<10)
}
func (o *USB1_Type) GetPORTSC1_D_LS() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc00) >> 10
}
func (o *USB1_Type) SetPORTSC1_D_PP(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x1000)|value<<12)
}
func (o *USB1_Type) GetPORTSC1_D_PP() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x1000) >> 12
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x2000)|value<<13)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x2000) >> 13
}
func (o *USB1_Type) SetPORTSC1_D_PIC1_0(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc000)|value<<14)
}
func (o *USB1_Type) GetPORTSC1_D_PIC1_0() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc000) >> 14
}
func (o *USB1_Type) SetPORTSC1_D_PTC3_0(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xf0000)|value<<16)
}
func (o *USB1_Type) GetPORTSC1_D_PTC3_0() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xf0000) >> 16
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x100000)|value<<20)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x100000) >> 20
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x200000)|value<<21)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x200000) >> 21
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x400000)|value<<22)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x400000) >> 22
}
func (o *USB1_Type) SetPORTSC1_D_PHCD(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x800000)|value<<23)
}
func (o *USB1_Type) GetPORTSC1_D_PHCD() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x800000) >> 23
}
func (o *USB1_Type) SetPORTSC1_D_PFSC(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x1000000)|value<<24)
}
func (o *USB1_Type) GetPORTSC1_D_PFSC() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x1000000) >> 24
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x2000000)|value<<25)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x2000000) >> 25
}
func (o *USB1_Type) SetPORTSC1_D_PSPD(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc000000)|value<<26)
}
func (o *USB1_Type) GetPORTSC1_D_PSPD() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc000000) >> 26
}
func (o *USB1_Type) SetPORTSC1_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0x30000000)|value<<28)
}
func (o *USB1_Type) GetPORTSC1_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0x30000000) >> 28
}
func (o *USB1_Type) SetPORTSC1_D_PTS(value uint32) {
	volatile.StoreUint32(&o.PORTSC1_D.Reg, volatile.LoadUint32(&o.PORTSC1_D.Reg)&^(0xc0000000)|value<<30)
}
func (o *USB1_Type) GetPORTSC1_D_PTS() uint32 {
	return (volatile.LoadUint32(&o.PORTSC1_D.Reg) & 0xc0000000) >> 30
}

// USB1.USBMODE_D: USB mode (device mode)
func (o *USB1_Type) SetUSBMODE_D_CM1_0(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x3)|value)
}
func (o *USB1_Type) GetUSBMODE_D_CM1_0() uint32 {
	return volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x3
}
func (o *USB1_Type) SetUSBMODE_D_ES(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetUSBMODE_D_ES() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetUSBMODE_D_SLOM(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetUSBMODE_D_SLOM() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetUSBMODE_D_SDIS(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetUSBMODE_D_SDIS() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetUSBMODE_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetUSBMODE_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetUSBMODE_D_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBMODE_D.Reg, volatile.LoadUint32(&o.USBMODE_D.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USB1_Type) GetUSBMODE_D_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBMODE_D.Reg) & 0xffffffc0) >> 6
}

// USB1.ENDPTSETUPSTAT: Endpoint setup status
func (o *USB1_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT0(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT0() uint32 {
	return volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT1(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT2(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTSETUPSTAT_ENDPTSETUPSTAT3(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTSETUPSTAT_ENDPTSETUPSTAT3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTSETUPSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTSETUPSTAT.Reg, volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB1_Type) GetENDPTSETUPSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSETUPSTAT.Reg) & 0xfffffff0) >> 4
}

// USB1.ENDPTPRIME: Endpoint initialization
func (o *USB1_Type) SetENDPTPRIME_PERB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTPRIME_PERB0() uint32 {
	return volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTPRIME_PERB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTPRIME_PERB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTPRIME_PERB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTPRIME_PERB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTPRIME_PERB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTPRIME_PERB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTPRIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0xfff0)|value<<4)
}
func (o *USB1_Type) GetENDPTPRIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0xfff0) >> 4
}
func (o *USB1_Type) SetENDPTPRIME_PETB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTPRIME_PETB0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTPRIME_PETB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTPRIME_PETB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTPRIME_PETB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetENDPTPRIME_PETB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetENDPTPRIME_PETB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetENDPTPRIME_PETB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetENDPTPRIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTPRIME.Reg, volatile.LoadUint32(&o.ENDPTPRIME.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetENDPTPRIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTPRIME.Reg) & 0xfff00000) >> 20
}

// USB1.ENDPTFLUSH: Endpoint de-initialization
func (o *USB1_Type) SetENDPTFLUSH_FERB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTFLUSH_FERB0() uint32 {
	return volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTFLUSH_FERB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTFLUSH_FERB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTFLUSH_FERB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTFLUSH_FERB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTFLUSH_FERB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTFLUSH_FERB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTFLUSH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0xfff0)|value<<4)
}
func (o *USB1_Type) GetENDPTFLUSH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0xfff0) >> 4
}
func (o *USB1_Type) SetENDPTFLUSH_FETB0(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTFLUSH_FETB0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTFLUSH_FETB1(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTFLUSH_FETB1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTFLUSH_FETB2(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetENDPTFLUSH_FETB2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetENDPTFLUSH_FETB3(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetENDPTFLUSH_FETB3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetENDPTFLUSH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTFLUSH.Reg, volatile.LoadUint32(&o.ENDPTFLUSH.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetENDPTFLUSH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTFLUSH.Reg) & 0xfff00000) >> 20
}

// USB1.ENDPTSTAT: Endpoint status
func (o *USB1_Type) SetENDPTSTAT_ERBR0(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTSTAT_ERBR0() uint32 {
	return volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTSTAT_ERBR1(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTSTAT_ERBR1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTSTAT_ERBR2(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTSTAT_ERBR2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTSTAT_ERBR3(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTSTAT_ERBR3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0xfff0)|value<<4)
}
func (o *USB1_Type) GetENDPTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0xfff0) >> 4
}
func (o *USB1_Type) SetENDPTSTAT_ETBR0(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTSTAT_ETBR0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTSTAT_ETBR1(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTSTAT_ETBR1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTSTAT_ETBR2(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetENDPTSTAT_ETBR2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetENDPTSTAT_ETBR3(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetENDPTSTAT_ETBR3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetENDPTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTSTAT.Reg, volatile.LoadUint32(&o.ENDPTSTAT.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetENDPTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTSTAT.Reg) & 0xfff00000) >> 20
}

// USB1.ENDPTCOMPLETE: Endpoint complete
func (o *USB1_Type) SetENDPTCOMPLETE_ERCE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ERCE0() uint32 {
	return volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTCOMPLETE_ERCE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ERCE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTCOMPLETE_ERCE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x4)|value<<2)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ERCE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x4) >> 2
}
func (o *USB1_Type) SetENDPTCOMPLETE_ERCE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x8)|value<<3)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ERCE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x8) >> 3
}
func (o *USB1_Type) SetENDPTCOMPLETE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0xfff0)|value<<4)
}
func (o *USB1_Type) GetENDPTCOMPLETE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0xfff0) >> 4
}
func (o *USB1_Type) SetENDPTCOMPLETE_ETCE0(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ETCE0() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTCOMPLETE_ETCE1(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ETCE1() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTCOMPLETE_ETCE2(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x40000)|value<<18)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ETCE2() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x40000) >> 18
}
func (o *USB1_Type) SetENDPTCOMPLETE_ETCE3(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0x80000)|value<<19)
}
func (o *USB1_Type) GetENDPTCOMPLETE_ETCE3() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0x80000) >> 19
}
func (o *USB1_Type) SetENDPTCOMPLETE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCOMPLETE.Reg, volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg)&^(0xfff00000)|value<<20)
}
func (o *USB1_Type) GetENDPTCOMPLETE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCOMPLETE.Reg) & 0xfff00000) >> 20
}

// USB1.ENDPTCTRL0: Endpoint control 0
func (o *USB1_Type) SetENDPTCTRL0_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTCTRL0_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTCTRL0_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xc)|value<<2)
}
func (o *USB1_Type) GetENDPTCTRL0_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xc) >> 2
}
func (o *USB1_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x70)|value<<4)
}
func (o *USB1_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x70) >> 4
}
func (o *USB1_Type) SetENDPTCTRL0_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetENDPTCTRL0_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetENDPTCTRL0_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTCTRL0_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTCTRL0_TXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB1_Type) GetENDPTCTRL0_TXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xc0000) >> 18
}
func (o *USB1_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x700000)|value<<20)
}
func (o *USB1_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x700000) >> 20
}
func (o *USB1_Type) SetENDPTCTRL0_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *USB1_Type) GetENDPTCTRL0_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0x800000) >> 23
}
func (o *USB1_Type) SetENDPTCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL0.Reg, volatile.LoadUint32(&o.ENDPTCTRL0.Reg)&^(0xff000000)|value<<24)
}
func (o *USB1_Type) GetENDPTCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL0.Reg) & 0xff000000) >> 24
}

// USB1.ENDPTCTRL1: Endpoint control
func (o *USB1_Type) SetENDPTCTRL1_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTCTRL1_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTCTRL1_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xc)|value<<2)
}
func (o *USB1_Type) GetENDPTCTRL1_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xc) >> 2
}
func (o *USB1_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetENDPTCTRL1_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetENDPTCTRL1_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetENDPTCTRL1_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetENDPTCTRL1_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetENDPTCTRL1_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetENDPTCTRL1_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetENDPTCTRL1_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTCTRL1_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTCTRL1_TXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB1_Type) GetENDPTCTRL1_TXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xc0000) >> 18
}
func (o *USB1_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x100000)|value<<20)
}
func (o *USB1_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x100000) >> 20
}
func (o *USB1_Type) SetENDPTCTRL1_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB1_Type) GetENDPTCTRL1_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x200000) >> 21
}
func (o *USB1_Type) SetENDPTCTRL1_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *USB1_Type) GetENDPTCTRL1_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x400000) >> 22
}
func (o *USB1_Type) SetENDPTCTRL1_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *USB1_Type) GetENDPTCTRL1_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0x800000) >> 23
}
func (o *USB1_Type) SetENDPTCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL1.Reg, volatile.LoadUint32(&o.ENDPTCTRL1.Reg)&^(0xff000000)|value<<24)
}
func (o *USB1_Type) GetENDPTCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL1.Reg) & 0xff000000) >> 24
}

// USB1.ENDPTCTRL2: Endpoint control
func (o *USB1_Type) SetENDPTCTRL2_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTCTRL2_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTCTRL2_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xc)|value<<2)
}
func (o *USB1_Type) GetENDPTCTRL2_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xc) >> 2
}
func (o *USB1_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetENDPTCTRL2_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetENDPTCTRL2_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetENDPTCTRL2_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetENDPTCTRL2_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetENDPTCTRL2_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetENDPTCTRL2_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetENDPTCTRL2_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTCTRL2_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTCTRL2_TXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB1_Type) GetENDPTCTRL2_TXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xc0000) >> 18
}
func (o *USB1_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x100000)|value<<20)
}
func (o *USB1_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x100000) >> 20
}
func (o *USB1_Type) SetENDPTCTRL2_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB1_Type) GetENDPTCTRL2_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x200000) >> 21
}
func (o *USB1_Type) SetENDPTCTRL2_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x400000)|value<<22)
}
func (o *USB1_Type) GetENDPTCTRL2_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x400000) >> 22
}
func (o *USB1_Type) SetENDPTCTRL2_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0x800000)|value<<23)
}
func (o *USB1_Type) GetENDPTCTRL2_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0x800000) >> 23
}
func (o *USB1_Type) SetENDPTCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL2.Reg, volatile.LoadUint32(&o.ENDPTCTRL2.Reg)&^(0xff000000)|value<<24)
}
func (o *USB1_Type) GetENDPTCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL2.Reg) & 0xff000000) >> 24
}

// USB1.ENDPTCTRL3: Endpoint control
func (o *USB1_Type) SetENDPTCTRL3_RXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x1)|value)
}
func (o *USB1_Type) GetENDPTCTRL3_RXS() uint32 {
	return volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x1
}
func (o *USB1_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x2)|value<<1)
}
func (o *USB1_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x2) >> 1
}
func (o *USB1_Type) SetENDPTCTRL3_RXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xc)|value<<2)
}
func (o *USB1_Type) GetENDPTCTRL3_RXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xc) >> 2
}
func (o *USB1_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x10)|value<<4)
}
func (o *USB1_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x10) >> 4
}
func (o *USB1_Type) SetENDPTCTRL3_RXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x20)|value<<5)
}
func (o *USB1_Type) GetENDPTCTRL3_RXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x20) >> 5
}
func (o *USB1_Type) SetENDPTCTRL3_RXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x40)|value<<6)
}
func (o *USB1_Type) GetENDPTCTRL3_RXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x40) >> 6
}
func (o *USB1_Type) SetENDPTCTRL3_RXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x80)|value<<7)
}
func (o *USB1_Type) GetENDPTCTRL3_RXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x80) >> 7
}
func (o *USB1_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xff00)|value<<8)
}
func (o *USB1_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xff00) >> 8
}
func (o *USB1_Type) SetENDPTCTRL3_TXS(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB1_Type) GetENDPTCTRL3_TXS() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x10000) >> 16
}
func (o *USB1_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB1_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x20000) >> 17
}
func (o *USB1_Type) SetENDPTCTRL3_TXT(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB1_Type) GetENDPTCTRL3_TXT() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xc0000) >> 18
}
func (o *USB1_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x100000)|value<<20)
}
func (o *USB1_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x100000) >> 20
}
func (o *USB1_Type) SetENDPTCTRL3_TXI(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB1_Type) GetENDPTCTRL3_TXI() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x200000) >> 21
}
func (o *USB1_Type) SetENDPTCTRL3_TXR(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x400000)|value<<22)
}
func (o *USB1_Type) GetENDPTCTRL3_TXR() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x400000) >> 22
}
func (o *USB1_Type) SetENDPTCTRL3_TXE(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0x800000)|value<<23)
}
func (o *USB1_Type) GetENDPTCTRL3_TXE() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0x800000) >> 23
}
func (o *USB1_Type) SetENDPTCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDPTCTRL3.Reg, volatile.LoadUint32(&o.ENDPTCTRL3.Reg)&^(0xff000000)|value<<24)
}
func (o *USB1_Type) GetENDPTCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDPTCTRL3.Reg) & 0xff000000) >> 24
}

// LCD controller
type LCD_Type struct {
	TIMH         volatile.Register32 // 0x0
	TIMV         volatile.Register32 // 0x4
	POL          volatile.Register32 // 0x8
	LE           volatile.Register32 // 0xC
	UPBASE       volatile.Register32 // 0x10
	LPBASE       volatile.Register32 // 0x14
	CTRL         volatile.Register32 // 0x18
	INTMSK       volatile.Register32 // 0x1C
	INTRAW       volatile.Register32 // 0x20
	INTSTAT      volatile.Register32 // 0x24
	INTCLR       volatile.Register32 // 0x28
	UPCURR       volatile.Register32 // 0x2C
	LPCURR       volatile.Register32 // 0x30
	_            [460]byte
	PAL          [256]volatile.Register32 // 0x200
	_            [512]byte
	CRSR_IMG     [256]volatile.Register32 // 0x800
	CRSR_CTRL    volatile.Register32      // 0xC00
	CRSR_CFG     volatile.Register32      // 0xC04
	CRSR_PAL0    volatile.Register32      // 0xC08
	CRSR_PAL1    volatile.Register32      // 0xC0C
	CRSR_XY      volatile.Register32      // 0xC10
	CRSR_CLIP    volatile.Register32      // 0xC14
	_            [8]byte
	CRSR_INTMSK  volatile.Register32 // 0xC20
	CRSR_INTCLR  volatile.Register32 // 0xC24
	CRSR_INTRAW  volatile.Register32 // 0xC28
	CRSR_INTSTAT volatile.Register32 // 0xC2C
}

// LCD.TIMH: Horizontal Timing Control register
func (o *LCD_Type) SetTIMH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0x3)|value)
}
func (o *LCD_Type) GetTIMH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TIMH.Reg) & 0x3
}
func (o *LCD_Type) SetTIMH_PPL(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xfc)|value<<2)
}
func (o *LCD_Type) GetTIMH_PPL() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xfc) >> 2
}
func (o *LCD_Type) SetTIMH_HSW(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xff00)|value<<8)
}
func (o *LCD_Type) GetTIMH_HSW() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xff00) >> 8
}
func (o *LCD_Type) SetTIMH_HFP(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetTIMH_HFP() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetTIMH_HBP(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetTIMH_HBP() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xff000000) >> 24
}

// LCD.TIMV: Vertical Timing Control register
func (o *LCD_Type) SetTIMV_LPP(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0x3ff)|value)
}
func (o *LCD_Type) GetTIMV_LPP() uint32 {
	return volatile.LoadUint32(&o.TIMV.Reg) & 0x3ff
}
func (o *LCD_Type) SetTIMV_VSW(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0xfc00)|value<<10)
}
func (o *LCD_Type) GetTIMV_VSW() uint32 {
	return (volatile.LoadUint32(&o.TIMV.Reg) & 0xfc00) >> 10
}
func (o *LCD_Type) SetTIMV_VFP(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetTIMV_VFP() uint32 {
	return (volatile.LoadUint32(&o.TIMV.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetTIMV_VBP(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetTIMV_VBP() uint32 {
	return (volatile.LoadUint32(&o.TIMV.Reg) & 0xff000000) >> 24
}

// LCD.POL: Clock and Signal Polarity Control register
func (o *LCD_Type) SetPOL_PCD_LO(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1f)|value)
}
func (o *LCD_Type) GetPOL_PCD_LO() uint32 {
	return volatile.LoadUint32(&o.POL.Reg) & 0x1f
}
func (o *LCD_Type) SetPOL_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetPOL_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetPOL_ACB(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x7c0)|value<<6)
}
func (o *LCD_Type) GetPOL_ACB() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x7c0) >> 6
}
func (o *LCD_Type) SetPOL_IVS(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetPOL_IVS() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetPOL_IHS(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetPOL_IHS() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetPOL_IPC(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetPOL_IPC() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetPOL_IOE(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetPOL_IOE() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetPOL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetPOL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetPOL_CPL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x3ff0000)|value<<16)
}
func (o *LCD_Type) GetPOL_CPL() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x3ff0000) >> 16
}
func (o *LCD_Type) SetPOL_BCD(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetPOL_BCD() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetPOL_PCD_HI(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0xf8000000)|value<<27)
}
func (o *LCD_Type) GetPOL_PCD_HI() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0xf8000000) >> 27
}

// LCD.LE: Line End Control register
func (o *LCD_Type) SetLE_LED(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0x7f)|value)
}
func (o *LCD_Type) GetLE_LED() uint32 {
	return volatile.LoadUint32(&o.LE.Reg) & 0x7f
}
func (o *LCD_Type) SetLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0xff80)|value<<7)
}
func (o *LCD_Type) GetLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LE.Reg) & 0xff80) >> 7
}
func (o *LCD_Type) SetLE_LEE(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetLE_LEE() uint32 {
	return (volatile.LoadUint32(&o.LE.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0xfffe0000)|value<<17)
}
func (o *LCD_Type) GetLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LE.Reg) & 0xfffe0000) >> 17
}

// LCD.UPBASE: Upper Panel Frame Base Address register
func (o *LCD_Type) SetUPBASE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UPBASE.Reg, volatile.LoadUint32(&o.UPBASE.Reg)&^(0x7)|value)
}
func (o *LCD_Type) GetUPBASE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.UPBASE.Reg) & 0x7
}
func (o *LCD_Type) SetUPBASE_LCDUPBASE(value uint32) {
	volatile.StoreUint32(&o.UPBASE.Reg, volatile.LoadUint32(&o.UPBASE.Reg)&^(0xfffffff8)|value<<3)
}
func (o *LCD_Type) GetUPBASE_LCDUPBASE() uint32 {
	return (volatile.LoadUint32(&o.UPBASE.Reg) & 0xfffffff8) >> 3
}

// LCD.LPBASE: Lower Panel Frame Base Address register
func (o *LCD_Type) SetLPBASE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LPBASE.Reg, volatile.LoadUint32(&o.LPBASE.Reg)&^(0x7)|value)
}
func (o *LCD_Type) GetLPBASE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LPBASE.Reg) & 0x7
}
func (o *LCD_Type) SetLPBASE_LCDLPBASE(value uint32) {
	volatile.StoreUint32(&o.LPBASE.Reg, volatile.LoadUint32(&o.LPBASE.Reg)&^(0xfffffff8)|value<<3)
}
func (o *LCD_Type) GetLPBASE_LCDLPBASE() uint32 {
	return (volatile.LoadUint32(&o.LPBASE.Reg) & 0xfffffff8) >> 3
}

// LCD.CTRL: LCD Control register
func (o *LCD_Type) SetCTRL_LCDEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCTRL_LCDEN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *LCD_Type) SetCTRL_LCDBPP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe)|value<<1)
}
func (o *LCD_Type) GetCTRL_LCDBPP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe) >> 1
}
func (o *LCD_Type) SetCTRL_LCDBW(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetCTRL_LCDBW() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetCTRL_LCDTFT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetCTRL_LCDTFT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetCTRL_LCDMONO8(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetCTRL_LCDMONO8() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetCTRL_LCDDUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetCTRL_LCDDUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetCTRL_BGR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetCTRL_BGR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetCTRL_BEBO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetCTRL_BEBO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetCTRL_BEPO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetCTRL_BEPO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetCTRL_LCDPWR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetCTRL_LCDPWR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetCTRL_LCDVCOMP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *LCD_Type) GetCTRL_LCDVCOMP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3000) >> 12
}
func (o *LCD_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *LCD_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc000) >> 14
}
func (o *LCD_Type) SetCTRL_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetCTRL_WATERMARK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffe0000)|value<<17)
}
func (o *LCD_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffe0000) >> 17
}

// LCD.INTMSK: Interrupt Mask register
func (o *LCD_Type) SetINTMSK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTMSK_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTMSK.Reg) & 0x1
}
func (o *LCD_Type) SetINTMSK_FUFIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTMSK_FUFIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTMSK_LNBUIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTMSK_LNBUIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTMSK_VCOMPIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTMSK_VCOMPIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTMSK_BERIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTMSK_BERIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTMSK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTMSK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0xffffffe0) >> 5
}

// LCD.INTRAW: Raw Interrupt Status register
func (o *LCD_Type) SetINTRAW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTRAW_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTRAW.Reg) & 0x1
}
func (o *LCD_Type) SetINTRAW_FUFRIS(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTRAW_FUFRIS() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTRAW_LNBURIS(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTRAW_LNBURIS() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTRAW_VCOMPRIS(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTRAW_VCOMPRIS() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTRAW_BERRAW(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTRAW_BERRAW() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTRAW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTRAW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0xffffffe0) >> 5
}

// LCD.INTSTAT: Masked Interrupt Status register
func (o *LCD_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *LCD_Type) SetINTSTAT_FUFMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTSTAT_FUFMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTSTAT_LNBUMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTSTAT_LNBUMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTSTAT_VCOMPMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTSTAT_VCOMPMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTSTAT_BERMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTSTAT_BERMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffffe0) >> 5
}

// LCD.INTCLR: Interrupt Clear register
func (o *LCD_Type) SetINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTCLR.Reg) & 0x1
}
func (o *LCD_Type) SetINTCLR_FUFIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTCLR_FUFIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTCLR_LNBUIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTCLR_LNBUIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTCLR_VCOMPIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTCLR_VCOMPIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTCLR_BERIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTCLR_BERIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0xffffffe0) >> 5
}

// LCD.UPCURR: Upper Panel Current Address Value register
func (o *LCD_Type) SetUPCURR(value uint32) {
	volatile.StoreUint32(&o.UPCURR.Reg, value)
}
func (o *LCD_Type) GetUPCURR() uint32 {
	return volatile.LoadUint32(&o.UPCURR.Reg)
}

// LCD.LPCURR: Lower Panel Current Address Value register
func (o *LCD_Type) SetLPCURR(value uint32) {
	volatile.StoreUint32(&o.LPCURR.Reg, value)
}
func (o *LCD_Type) GetLPCURR() uint32 {
	return volatile.LoadUint32(&o.LPCURR.Reg)
}

// LCD.PAL: 256x16-bit Color Palette registers
func (o *LCD_Type) SetPAL_R04_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x1f)|value)
}
func (o *LCD_Type) GetPAL_R04_0(idx int) uint32 {
	return volatile.LoadUint32(&o.PAL[idx].Reg) & 0x1f
}
func (o *LCD_Type) SetPAL_G04_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x3e0)|value<<5)
}
func (o *LCD_Type) GetPAL_G04_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x3e0) >> 5
}
func (o *LCD_Type) SetPAL_B04_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x7c00)|value<<10)
}
func (o *LCD_Type) GetPAL_B04_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x7c00) >> 10
}
func (o *LCD_Type) SetPAL_I0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetPAL_I0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetPAL_R14_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x1f0000)|value<<16)
}
func (o *LCD_Type) GetPAL_R14_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x1f0000) >> 16
}
func (o *LCD_Type) SetPAL_G14_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x3e00000)|value<<21)
}
func (o *LCD_Type) GetPAL_G14_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x3e00000) >> 21
}
func (o *LCD_Type) SetPAL_B14_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x7c000000)|value<<26)
}
func (o *LCD_Type) GetPAL_B14_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x7c000000) >> 26
}
func (o *LCD_Type) SetPAL_I1(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetPAL_I1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x80000000) >> 31
}

// LCD.CRSR_IMG: Cursor Image registers
func (o *LCD_Type) SetCRSR_IMG(idx int, value uint32) {
	volatile.StoreUint32(&o.CRSR_IMG[idx].Reg, value)
}
func (o *LCD_Type) GetCRSR_IMG(idx int) uint32 {
	return volatile.LoadUint32(&o.CRSR_IMG[idx].Reg)
}

// LCD.CRSR_CTRL: Cursor Control register
func (o *LCD_Type) SetCRSR_CTRL_CrsrOn(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_CTRL_CrsrOn() uint32 {
	return volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0xe)|value<<1)
}
func (o *LCD_Type) GetCRSR_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0xe) >> 1
}
func (o *LCD_Type) SetCRSR_CTRL_CRSRNUM1_0(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0x30)|value<<4)
}
func (o *LCD_Type) GetCRSR_CTRL_CRSRNUM1_0() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0x30) >> 4
}
func (o *LCD_Type) SetCRSR_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *LCD_Type) GetCRSR_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0xffffffc0) >> 6
}

// LCD.CRSR_CFG: Cursor Configuration register
func (o *LCD_Type) SetCRSR_CFG_CrsrSize(value uint32) {
	volatile.StoreUint32(&o.CRSR_CFG.Reg, volatile.LoadUint32(&o.CRSR_CFG.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_CFG_CrsrSize() uint32 {
	return volatile.LoadUint32(&o.CRSR_CFG.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_CFG_FRAMESYNC(value uint32) {
	volatile.StoreUint32(&o.CRSR_CFG.Reg, volatile.LoadUint32(&o.CRSR_CFG.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCRSR_CFG_FRAMESYNC() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CFG.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetCRSR_CFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CFG.Reg, volatile.LoadUint32(&o.CRSR_CFG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCD_Type) GetCRSR_CFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CFG.Reg) & 0xfffffffc) >> 2
}

// LCD.CRSR_PAL0: Cursor Palette register 0
func (o *LCD_Type) SetCRSR_PAL0_RED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff)|value)
}
func (o *LCD_Type) GetCRSR_PAL0_RED() uint32 {
	return volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff
}
func (o *LCD_Type) SetCRSR_PAL0_GREEN(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff00)|value<<8)
}
func (o *LCD_Type) GetCRSR_PAL0_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff00) >> 8
}
func (o *LCD_Type) SetCRSR_PAL0_BLUE(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetCRSR_PAL0_BLUE() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetCRSR_PAL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetCRSR_PAL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff000000) >> 24
}

// LCD.CRSR_PAL1: Cursor Palette register 1
func (o *LCD_Type) SetCRSR_PAL1_RED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff)|value)
}
func (o *LCD_Type) GetCRSR_PAL1_RED() uint32 {
	return volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff
}
func (o *LCD_Type) SetCRSR_PAL1_GREEN(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff00)|value<<8)
}
func (o *LCD_Type) GetCRSR_PAL1_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff00) >> 8
}
func (o *LCD_Type) SetCRSR_PAL1_BLUE(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetCRSR_PAL1_BLUE() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetCRSR_PAL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetCRSR_PAL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff000000) >> 24
}

// LCD.CRSR_XY: Cursor XY Position register
func (o *LCD_Type) SetCRSR_XY_CRSRX(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0x3ff)|value)
}
func (o *LCD_Type) GetCRSR_XY_CRSRX() uint32 {
	return volatile.LoadUint32(&o.CRSR_XY.Reg) & 0x3ff
}
func (o *LCD_Type) SetCRSR_XY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0xfc00)|value<<10)
}
func (o *LCD_Type) GetCRSR_XY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_XY.Reg) & 0xfc00) >> 10
}
func (o *LCD_Type) SetCRSR_XY_CRSRY(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0x3ff0000)|value<<16)
}
func (o *LCD_Type) GetCRSR_XY_CRSRY() uint32 {
	return (volatile.LoadUint32(&o.CRSR_XY.Reg) & 0x3ff0000) >> 16
}
func (o *LCD_Type) SetCRSR_XY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0xfc000000)|value<<26)
}
func (o *LCD_Type) GetCRSR_XY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_XY.Reg) & 0xfc000000) >> 26
}

// LCD.CRSR_CLIP: Cursor Clip Position register
func (o *LCD_Type) SetCRSR_CLIP_CRSRCLIPX(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0x3f)|value)
}
func (o *LCD_Type) GetCRSR_CLIP_CRSRCLIPX() uint32 {
	return volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0x3f
}
func (o *LCD_Type) SetCRSR_CLIP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0xc0)|value<<6)
}
func (o *LCD_Type) GetCRSR_CLIP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0xc0) >> 6
}
func (o *LCD_Type) SetCRSR_CLIP_CRSRCLIPY(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0x3f00)|value<<8)
}
func (o *LCD_Type) GetCRSR_CLIP_CRSRCLIPY() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0x3f00) >> 8
}
func (o *LCD_Type) SetCRSR_CLIP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0xffffc000)|value<<14)
}
func (o *LCD_Type) GetCRSR_CLIP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0xffffc000) >> 14
}

// LCD.CRSR_INTMSK: Cursor Interrupt Mask register
func (o *LCD_Type) SetCRSR_INTMSK_CRSRIM(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTMSK.Reg, volatile.LoadUint32(&o.CRSR_INTMSK.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTMSK_CRSRIM() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTMSK.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTMSK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTMSK.Reg, volatile.LoadUint32(&o.CRSR_INTMSK.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTMSK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTMSK.Reg) & 0xfffffffe) >> 1
}

// LCD.CRSR_INTCLR: Cursor Interrupt Clear register
func (o *LCD_Type) SetCRSR_INTCLR_CRSRIC(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTCLR.Reg, volatile.LoadUint32(&o.CRSR_INTCLR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTCLR_CRSRIC() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTCLR.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTCLR.Reg, volatile.LoadUint32(&o.CRSR_INTCLR.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTCLR.Reg) & 0xfffffffe) >> 1
}

// LCD.CRSR_INTRAW: Cursor Raw Interrupt Status register
func (o *LCD_Type) SetCRSR_INTRAW_CRSRRIS(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTRAW.Reg, volatile.LoadUint32(&o.CRSR_INTRAW.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTRAW_CRSRRIS() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTRAW.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTRAW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTRAW.Reg, volatile.LoadUint32(&o.CRSR_INTRAW.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTRAW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTRAW.Reg) & 0xfffffffe) >> 1
}

// LCD.CRSR_INTSTAT: Cursor Masked Interrupt Status register
func (o *LCD_Type) SetCRSR_INTSTAT_CRSRMIS(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTSTAT.Reg, volatile.LoadUint32(&o.CRSR_INTSTAT.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTSTAT_CRSRMIS() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTSTAT.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTSTAT.Reg, volatile.LoadUint32(&o.CRSR_INTSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTSTAT.Reg) & 0xfffffffe) >> 1
}

// EEPROM
type EEPROM_Type struct {
	CMD        volatile.Register32 // 0x0
	_          [4]byte
	RWSTATE    volatile.Register32 // 0x8
	AUTOPROG   volatile.Register32 // 0xC
	WSTATE     volatile.Register32 // 0x10
	CLKDIV     volatile.Register32 // 0x14
	PWRDWN     volatile.Register32 // 0x18
	_          [4028]byte
	INTENCLR   volatile.Register32 // 0xFD8
	INTENSET   volatile.Register32 // 0xFDC
	INTSTAT    volatile.Register32 // 0xFE0
	INTEN      volatile.Register32 // 0xFE4
	INTSTATCLR volatile.Register32 // 0xFE8
	INTSTATSET volatile.Register32 // 0xFEC
}

// EEPROM.CMD: EEPROM command register
func (o *EEPROM_Type) SetCMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x7)|value)
}
func (o *EEPROM_Type) GetCMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x7
}
func (o *EEPROM_Type) SetCMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetCMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xfffffff8) >> 3
}

// EEPROM.RWSTATE: EEPROM read wait state register
func (o *EEPROM_Type) SetRWSTATE_RPHASE2(value uint32) {
	volatile.StoreUint32(&o.RWSTATE.Reg, volatile.LoadUint32(&o.RWSTATE.Reg)&^(0xff)|value)
}
func (o *EEPROM_Type) GetRWSTATE_RPHASE2() uint32 {
	return volatile.LoadUint32(&o.RWSTATE.Reg) & 0xff
}
func (o *EEPROM_Type) SetRWSTATE_RPHASE1(value uint32) {
	volatile.StoreUint32(&o.RWSTATE.Reg, volatile.LoadUint32(&o.RWSTATE.Reg)&^(0xff00)|value<<8)
}
func (o *EEPROM_Type) GetRWSTATE_RPHASE1() uint32 {
	return (volatile.LoadUint32(&o.RWSTATE.Reg) & 0xff00) >> 8
}
func (o *EEPROM_Type) SetRWSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RWSTATE.Reg, volatile.LoadUint32(&o.RWSTATE.Reg)&^(0xffff0000)|value<<16)
}
func (o *EEPROM_Type) GetRWSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RWSTATE.Reg) & 0xffff0000) >> 16
}

// EEPROM.AUTOPROG: EEPROM auto programming register
func (o *EEPROM_Type) SetAUTOPROG(value uint32) {
	volatile.StoreUint32(&o.AUTOPROG.Reg, volatile.LoadUint32(&o.AUTOPROG.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetAUTOPROG() uint32 {
	return volatile.LoadUint32(&o.AUTOPROG.Reg) & 0x3
}
func (o *EEPROM_Type) SetAUTOPROG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AUTOPROG.Reg, volatile.LoadUint32(&o.AUTOPROG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EEPROM_Type) GetAUTOPROG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AUTOPROG.Reg) & 0xfffffffc) >> 2
}

// EEPROM.WSTATE: EEPROM wait state register
func (o *EEPROM_Type) SetWSTATE_PHASE3(value uint32) {
	volatile.StoreUint32(&o.WSTATE.Reg, volatile.LoadUint32(&o.WSTATE.Reg)&^(0xff)|value)
}
func (o *EEPROM_Type) GetWSTATE_PHASE3() uint32 {
	return volatile.LoadUint32(&o.WSTATE.Reg) & 0xff
}
func (o *EEPROM_Type) SetWSTATE_PHASE2(value uint32) {
	volatile.StoreUint32(&o.WSTATE.Reg, volatile.LoadUint32(&o.WSTATE.Reg)&^(0xff00)|value<<8)
}
func (o *EEPROM_Type) GetWSTATE_PHASE2() uint32 {
	return (volatile.LoadUint32(&o.WSTATE.Reg) & 0xff00) >> 8
}
func (o *EEPROM_Type) SetWSTATE_PHASE1(value uint32) {
	volatile.StoreUint32(&o.WSTATE.Reg, volatile.LoadUint32(&o.WSTATE.Reg)&^(0xff0000)|value<<16)
}
func (o *EEPROM_Type) GetWSTATE_PHASE1() uint32 {
	return (volatile.LoadUint32(&o.WSTATE.Reg) & 0xff0000) >> 16
}
func (o *EEPROM_Type) SetWSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WSTATE.Reg, volatile.LoadUint32(&o.WSTATE.Reg)&^(0x7f000000)|value<<24)
}
func (o *EEPROM_Type) GetWSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WSTATE.Reg) & 0x7f000000) >> 24
}
func (o *EEPROM_Type) SetWSTATE_LCK_PARWEP(value uint32) {
	volatile.StoreUint32(&o.WSTATE.Reg, volatile.LoadUint32(&o.WSTATE.Reg)&^(0x80000000)|value<<31)
}
func (o *EEPROM_Type) GetWSTATE_LCK_PARWEP() uint32 {
	return (volatile.LoadUint32(&o.WSTATE.Reg) & 0x80000000) >> 31
}

// EEPROM.CLKDIV: EEPROM clock divider register
func (o *EEPROM_Type) SetCLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xffff)|value)
}
func (o *EEPROM_Type) GetCLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKDIV.Reg) & 0xffff
}
func (o *EEPROM_Type) SetCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *EEPROM_Type) GetCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xffff0000) >> 16
}

// EEPROM.PWRDWN: EEPROM power-down register
func (o *EEPROM_Type) SetPWRDWN(value uint32) {
	volatile.StoreUint32(&o.PWRDWN.Reg, volatile.LoadUint32(&o.PWRDWN.Reg)&^(0x1)|value)
}
func (o *EEPROM_Type) GetPWRDWN() uint32 {
	return volatile.LoadUint32(&o.PWRDWN.Reg) & 0x1
}
func (o *EEPROM_Type) SetPWRDWN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PWRDWN.Reg, volatile.LoadUint32(&o.PWRDWN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *EEPROM_Type) GetPWRDWN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PWRDWN.Reg) & 0xfffffffe) >> 1
}

// EEPROM.INTENCLR: EEPROM interrupt enable clear
func (o *EEPROM_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetINTENCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x3
}
func (o *EEPROM_Type) SetINTENCLR_PROG_CLR_EN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EEPROM_Type) GetINTENCLR_PROG_CLR_EN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EEPROM_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xfffffff8) >> 3
}

// EEPROM.INTENSET: EEPROM interrupt enable set
func (o *EEPROM_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetINTENSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x3
}
func (o *EEPROM_Type) SetINTENSET_PROG_SET_EN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EEPROM_Type) GetINTENSET_PROG_SET_EN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EEPROM_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xfffffff8) >> 3
}

// EEPROM.INTSTAT: EEPROM interrupt status
func (o *EEPROM_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetINTSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x3
}
func (o *EEPROM_Type) SetINTSTAT_END_OF_PROG(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *EEPROM_Type) GetINTSTAT_END_OF_PROG() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *EEPROM_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfffffff8) >> 3
}

// EEPROM.INTEN: EEPROM interrupt enable
func (o *EEPROM_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetINTEN_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x3
}
func (o *EEPROM_Type) SetINTEN_EE_PROG_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *EEPROM_Type) GetINTEN_EE_PROG_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *EEPROM_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xfffffff8) >> 3
}

// EEPROM.INTSTATCLR: EEPROM interrupt status clear
func (o *EEPROM_Type) SetINTSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATCLR.Reg, volatile.LoadUint32(&o.INTSTATCLR.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetINTSTATCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTATCLR.Reg) & 0x3
}
func (o *EEPROM_Type) SetINTSTATCLR_PROG_CLR_ST(value uint32) {
	volatile.StoreUint32(&o.INTSTATCLR.Reg, volatile.LoadUint32(&o.INTSTATCLR.Reg)&^(0x4)|value<<2)
}
func (o *EEPROM_Type) GetINTSTATCLR_PROG_CLR_ST() uint32 {
	return (volatile.LoadUint32(&o.INTSTATCLR.Reg) & 0x4) >> 2
}
func (o *EEPROM_Type) SetINTSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATCLR.Reg, volatile.LoadUint32(&o.INTSTATCLR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetINTSTATCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTATCLR.Reg) & 0xfffffff8) >> 3
}

// EEPROM.INTSTATSET: EEPROM interrupt status set
func (o *EEPROM_Type) SetINTSTATSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATSET.Reg, volatile.LoadUint32(&o.INTSTATSET.Reg)&^(0x3)|value)
}
func (o *EEPROM_Type) GetINTSTATSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTATSET.Reg) & 0x3
}
func (o *EEPROM_Type) SetINTSTATSET_PROG_SET_ST(value uint32) {
	volatile.StoreUint32(&o.INTSTATSET.Reg, volatile.LoadUint32(&o.INTSTATSET.Reg)&^(0x4)|value<<2)
}
func (o *EEPROM_Type) GetINTSTATSET_PROG_SET_ST() uint32 {
	return (volatile.LoadUint32(&o.INTSTATSET.Reg) & 0x4) >> 2
}
func (o *EEPROM_Type) SetINTSTATSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATSET.Reg, volatile.LoadUint32(&o.INTSTATSET.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EEPROM_Type) GetINTSTATSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTATSET.Reg) & 0xfffffff8) >> 3
}

// Ethernet
type ETHERNET_Type struct {
	MAC_CONFIG            volatile.Register32 // 0x0
	MAC_FRAME_FILTER      volatile.Register32 // 0x4
	MAC_HASHTABLE_HIGH    volatile.Register32 // 0x8
	MAC_HASHTABLE_LOW     volatile.Register32 // 0xC
	MAC_MII_ADDR          volatile.Register32 // 0x10
	MAC_MII_DATA          volatile.Register32 // 0x14
	MAC_FLOW_CTRL         volatile.Register32 // 0x18
	MAC_VLAN_TAG          volatile.Register32 // 0x1C
	_                     [4]byte
	MAC_DEBUG             volatile.Register32 // 0x24
	MAC_RWAKE_FRFLT       volatile.Register32 // 0x28
	MAC_PMT_CTRL_STAT     volatile.Register32 // 0x2C
	_                     [8]byte
	MAC_INTR              volatile.Register32 // 0x38
	MAC_INTR_MASK         volatile.Register32 // 0x3C
	MAC_ADDR0_HIGH        volatile.Register32 // 0x40
	MAC_ADDR0_LOW         volatile.Register32 // 0x44
	_                     [1720]byte
	MAC_TIMESTP_CTRL      volatile.Register32 // 0x700
	SUBSECOND_INCR        volatile.Register32 // 0x704
	SECONDS               volatile.Register32 // 0x708
	NANOSECONDS           volatile.Register32 // 0x70C
	SECONDSUPDATE         volatile.Register32 // 0x710
	NANOSECONDSUPDATE     volatile.Register32 // 0x714
	ADDEND                volatile.Register32 // 0x718
	TARGETSECONDS         volatile.Register32 // 0x71C
	TARGETNANOSECONDS     volatile.Register32 // 0x720
	HIGHWORD              volatile.Register32 // 0x724
	TIMESTAMPSTAT         volatile.Register32 // 0x728
	_                     [2260]byte
	DMA_BUS_MODE          volatile.Register32 // 0x1000
	DMA_TRANS_POLL_DEMAND volatile.Register32 // 0x1004
	DMA_REC_POLL_DEMAND   volatile.Register32 // 0x1008
	DMA_REC_DES_ADDR      volatile.Register32 // 0x100C
	DMA_TRANS_DES_ADDR    volatile.Register32 // 0x1010
	DMA_STAT              volatile.Register32 // 0x1014
	DMA_OP_MODE           volatile.Register32 // 0x1018
	DMA_INT_EN            volatile.Register32 // 0x101C
	DMA_MFRM_BUFOF        volatile.Register32 // 0x1020
	DMA_REC_INT_WDT       volatile.Register32 // 0x1024
	_                     [32]byte
	DMA_CURHOST_TRANS_DES volatile.Register32 // 0x1048
	DMA_CURHOST_REC_DES   volatile.Register32 // 0x104C
	DMA_CURHOST_TRANS_BUF volatile.Register32 // 0x1050
	DMA_CURHOST_REC_BUF   volatile.Register32 // 0x1054
}

// ETHERNET.MAC_CONFIG: MAC configuration register
func (o *ETHERNET_Type) SetMAC_CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x3
}
func (o *ETHERNET_Type) SetMAC_CONFIG_RE(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_RE() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC_CONFIG_TE(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_TE() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_CONFIG_DF(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_DF() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC_CONFIG_BL(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x60)|value<<5)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_BL() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x60) >> 5
}
func (o *ETHERNET_Type) SetMAC_CONFIG_ACS(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_ACS() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetMAC_CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC_CONFIG_DR(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_DR() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC_CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetMAC_CONFIG_DM(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_DM() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x800) >> 11
}
func (o *ETHERNET_Type) SetMAC_CONFIG_LM(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_LM() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetMAC_CONFIG_DO(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_DO() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetMAC_CONFIG_FES(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_FES() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetMAC_CONFIG_PS(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_PS() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetMAC_CONFIG_DCRS(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_DCRS() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetMAC_CONFIG_IFG(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0xe0000)|value<<17)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_IFG() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0xe0000) >> 17
}
func (o *ETHERNET_Type) SetMAC_CONFIG_JE(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x100000)|value<<20)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_JE() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x100000) >> 20
}
func (o *ETHERNET_Type) SetMAC_CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x200000)|value<<21)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x200000) >> 21
}
func (o *ETHERNET_Type) SetMAC_CONFIG_JD(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x400000)|value<<22)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_JD() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x400000) >> 22
}
func (o *ETHERNET_Type) SetMAC_CONFIG_WD(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0x800000)|value<<23)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_WD() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0x800000) >> 23
}
func (o *ETHERNET_Type) SetMAC_CONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_CONFIG.Reg, volatile.LoadUint32(&o.MAC_CONFIG.Reg)&^(0xff000000)|value<<24)
}
func (o *ETHERNET_Type) GetMAC_CONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_CONFIG.Reg) & 0xff000000) >> 24
}

// ETHERNET.MAC_FRAME_FILTER: MAC frame filter
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_PR(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_PR() uint32 {
	return volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_HUC(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_HUC() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_HMC(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_HMC() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_DAIF(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_DAIF() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_PM(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_PM() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_DBF(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_DBF() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_PCF(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0xc0)|value<<6)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_PCF() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0xc0) >> 6
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_HPF(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_HPF() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x7ffff800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x7ffff800) >> 11
}
func (o *ETHERNET_Type) SetMAC_FRAME_FILTER_RA(value uint32) {
	volatile.StoreUint32(&o.MAC_FRAME_FILTER.Reg, volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetMAC_FRAME_FILTER_RA() uint32 {
	return (volatile.LoadUint32(&o.MAC_FRAME_FILTER.Reg) & 0x80000000) >> 31
}

// ETHERNET.MAC_HASHTABLE_HIGH: Hash table high register
func (o *ETHERNET_Type) SetMAC_HASHTABLE_HIGH(value uint32) {
	volatile.StoreUint32(&o.MAC_HASHTABLE_HIGH.Reg, value)
}
func (o *ETHERNET_Type) GetMAC_HASHTABLE_HIGH() uint32 {
	return volatile.LoadUint32(&o.MAC_HASHTABLE_HIGH.Reg)
}

// ETHERNET.MAC_HASHTABLE_LOW: Hash table low register
func (o *ETHERNET_Type) SetMAC_HASHTABLE_LOW(value uint32) {
	volatile.StoreUint32(&o.MAC_HASHTABLE_LOW.Reg, value)
}
func (o *ETHERNET_Type) GetMAC_HASHTABLE_LOW() uint32 {
	return volatile.LoadUint32(&o.MAC_HASHTABLE_LOW.Reg)
}

// ETHERNET.MAC_MII_ADDR: MII address register
func (o *ETHERNET_Type) SetMAC_MII_ADDR_GB(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_ADDR.Reg, volatile.LoadUint32(&o.MAC_MII_ADDR.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC_MII_ADDR_GB() uint32 {
	return volatile.LoadUint32(&o.MAC_MII_ADDR.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC_MII_ADDR_W(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_ADDR.Reg, volatile.LoadUint32(&o.MAC_MII_ADDR.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC_MII_ADDR_W() uint32 {
	return (volatile.LoadUint32(&o.MAC_MII_ADDR.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC_MII_ADDR_CR(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_ADDR.Reg, volatile.LoadUint32(&o.MAC_MII_ADDR.Reg)&^(0x3c)|value<<2)
}
func (o *ETHERNET_Type) GetMAC_MII_ADDR_CR() uint32 {
	return (volatile.LoadUint32(&o.MAC_MII_ADDR.Reg) & 0x3c) >> 2
}
func (o *ETHERNET_Type) SetMAC_MII_ADDR_GR(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_ADDR.Reg, volatile.LoadUint32(&o.MAC_MII_ADDR.Reg)&^(0x7c0)|value<<6)
}
func (o *ETHERNET_Type) GetMAC_MII_ADDR_GR() uint32 {
	return (volatile.LoadUint32(&o.MAC_MII_ADDR.Reg) & 0x7c0) >> 6
}
func (o *ETHERNET_Type) SetMAC_MII_ADDR_PA(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_ADDR.Reg, volatile.LoadUint32(&o.MAC_MII_ADDR.Reg)&^(0xf800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC_MII_ADDR_PA() uint32 {
	return (volatile.LoadUint32(&o.MAC_MII_ADDR.Reg) & 0xf800) >> 11
}
func (o *ETHERNET_Type) SetMAC_MII_ADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_ADDR.Reg, volatile.LoadUint32(&o.MAC_MII_ADDR.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_MII_ADDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_MII_ADDR.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MAC_MII_DATA: MII data register
func (o *ETHERNET_Type) SetMAC_MII_DATA_GD(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_DATA.Reg, volatile.LoadUint32(&o.MAC_MII_DATA.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMAC_MII_DATA_GD() uint32 {
	return volatile.LoadUint32(&o.MAC_MII_DATA.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMAC_MII_DATA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_MII_DATA.Reg, volatile.LoadUint32(&o.MAC_MII_DATA.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_MII_DATA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_MII_DATA.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MAC_FLOW_CTRL: Flow control register
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_FCB(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_FCB() uint32 {
	return volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_TFE(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_TFE() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_RFE(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_RFE() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_UP(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_UP() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_PLT(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x30)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_PLT() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x30) >> 4
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_DZPQ(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_DZPQ() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetMAC_FLOW_CTRL_PT(value uint32) {
	volatile.StoreUint32(&o.MAC_FLOW_CTRL.Reg, volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_FLOW_CTRL_PT() uint32 {
	return (volatile.LoadUint32(&o.MAC_FLOW_CTRL.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MAC_VLAN_TAG: VLAN tag register
func (o *ETHERNET_Type) SetMAC_VLAN_TAG_VL(value uint32) {
	volatile.StoreUint32(&o.MAC_VLAN_TAG.Reg, volatile.LoadUint32(&o.MAC_VLAN_TAG.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMAC_VLAN_TAG_VL() uint32 {
	return volatile.LoadUint32(&o.MAC_VLAN_TAG.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMAC_VLAN_TAG_ETV(value uint32) {
	volatile.StoreUint32(&o.MAC_VLAN_TAG.Reg, volatile.LoadUint32(&o.MAC_VLAN_TAG.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_VLAN_TAG_ETV() uint32 {
	return (volatile.LoadUint32(&o.MAC_VLAN_TAG.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetMAC_VLAN_TAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_VLAN_TAG.Reg, volatile.LoadUint32(&o.MAC_VLAN_TAG.Reg)&^(0xfffe0000)|value<<17)
}
func (o *ETHERNET_Type) GetMAC_VLAN_TAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_VLAN_TAG.Reg) & 0xfffe0000) >> 17
}

// ETHERNET.MAC_DEBUG: Debug register
func (o *ETHERNET_Type) SetMAC_DEBUG_RXIDLESTAT(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RXIDLESTAT() uint32 {
	return volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC_DEBUG_FIFOSTAT0(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x6)|value<<1)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_FIFOSTAT0() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x6) >> 1
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RXFIFOSTAT1(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RXFIFOSTAT1() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RXFIFOSTAT(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x60)|value<<5)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RXFIFOSTAT() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x60) >> 5
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RXFIFOLVL(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x300)|value<<8)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RXFIFOLVL() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x300) >> 8
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0xfc00)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0xfc00) >> 10
}
func (o *ETHERNET_Type) SetMAC_DEBUG_TXIDLESTAT(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_TXIDLESTAT() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetMAC_DEBUG_TXSTAT(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x60000)|value<<17)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_TXSTAT() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x60000) >> 17
}
func (o *ETHERNET_Type) SetMAC_DEBUG_PAUSE(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x80000)|value<<19)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x80000) >> 19
}
func (o *ETHERNET_Type) SetMAC_DEBUG_TXFIFOSTAT(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x300000)|value<<20)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_TXFIFOSTAT() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x300000) >> 20
}
func (o *ETHERNET_Type) SetMAC_DEBUG_TXFIFOSTAT1(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x400000)|value<<22)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_TXFIFOSTAT1() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x400000) >> 22
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x800000)|value<<23)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x800000) >> 23
}
func (o *ETHERNET_Type) SetMAC_DEBUG_TXFIFOLVL(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x1000000)|value<<24)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_TXFIFOLVL() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x1000000) >> 24
}
func (o *ETHERNET_Type) SetMAC_DEBUG_TXFIFOFULL(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0x2000000)|value<<25)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_TXFIFOFULL() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0x2000000) >> 25
}
func (o *ETHERNET_Type) SetMAC_DEBUG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_DEBUG.Reg, volatile.LoadUint32(&o.MAC_DEBUG.Reg)&^(0xfc000000)|value<<26)
}
func (o *ETHERNET_Type) GetMAC_DEBUG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_DEBUG.Reg) & 0xfc000000) >> 26
}

// ETHERNET.MAC_RWAKE_FRFLT: Remote wake-up frame filter
func (o *ETHERNET_Type) SetMAC_RWAKE_FRFLT(value uint32) {
	volatile.StoreUint32(&o.MAC_RWAKE_FRFLT.Reg, value)
}
func (o *ETHERNET_Type) GetMAC_RWAKE_FRFLT() uint32 {
	return volatile.LoadUint32(&o.MAC_RWAKE_FRFLT.Reg)
}

// ETHERNET.MAC_PMT_CTRL_STAT: PMT control and status
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_PD(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_PD() uint32 {
	return volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_MPE(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_MPE() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_WFE(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_WFE() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x18)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x18) >> 3
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_MPR(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_MPR() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_WFR(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_WFR() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x180)|value<<7)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x180) >> 7
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_GU(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_GU() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x7ffffc00)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x7ffffc00) >> 10
}
func (o *ETHERNET_Type) SetMAC_PMT_CTRL_STAT_WFFRPR(value uint32) {
	volatile.StoreUint32(&o.MAC_PMT_CTRL_STAT.Reg, volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetMAC_PMT_CTRL_STAT_WFFRPR() uint32 {
	return (volatile.LoadUint32(&o.MAC_PMT_CTRL_STAT.Reg) & 0x80000000) >> 31
}

// ETHERNET.MAC_INTR: Interrupt status register
func (o *ETHERNET_Type) SetMAC_INTR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR.Reg, volatile.LoadUint32(&o.MAC_INTR.Reg)&^(0x7)|value)
}
func (o *ETHERNET_Type) GetMAC_INTR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MAC_INTR.Reg) & 0x7
}
func (o *ETHERNET_Type) SetMAC_INTR_PMT(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR.Reg, volatile.LoadUint32(&o.MAC_INTR.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_INTR_PMT() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_INTR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR.Reg, volatile.LoadUint32(&o.MAC_INTR.Reg)&^(0x1f0)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_INTR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR.Reg) & 0x1f0) >> 4
}
func (o *ETHERNET_Type) SetMAC_INTR_TS(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR.Reg, volatile.LoadUint32(&o.MAC_INTR.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC_INTR_TS() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC_INTR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR.Reg, volatile.LoadUint32(&o.MAC_INTR.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_INTR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetMAC_INTR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR.Reg, volatile.LoadUint32(&o.MAC_INTR.Reg)&^(0xfffff800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC_INTR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR.Reg) & 0xfffff800) >> 11
}

// ETHERNET.MAC_INTR_MASK: Interrupt mask register
func (o *ETHERNET_Type) SetMAC_INTR_MASK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MASK.Reg, volatile.LoadUint32(&o.MAC_INTR_MASK.Reg)&^(0x7)|value)
}
func (o *ETHERNET_Type) GetMAC_INTR_MASK_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MAC_INTR_MASK.Reg) & 0x7
}
func (o *ETHERNET_Type) SetMAC_INTR_MASK_PMTIM(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MASK.Reg, volatile.LoadUint32(&o.MAC_INTR_MASK.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_INTR_MASK_PMTIM() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR_MASK.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_INTR_MASK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MASK.Reg, volatile.LoadUint32(&o.MAC_INTR_MASK.Reg)&^(0x1f0)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_INTR_MASK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR_MASK.Reg) & 0x1f0) >> 4
}
func (o *ETHERNET_Type) SetMAC_INTR_MASK_TSIM(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MASK.Reg, volatile.LoadUint32(&o.MAC_INTR_MASK.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC_INTR_MASK_TSIM() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR_MASK.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC_INTR_MASK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MASK.Reg, volatile.LoadUint32(&o.MAC_INTR_MASK.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_INTR_MASK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_INTR_MASK.Reg) & 0x400) >> 10
}

// ETHERNET.MAC_ADDR0_HIGH: MAC address 0 high register
func (o *ETHERNET_Type) SetMAC_ADDR0_HIGH_A47_32(value uint32) {
	volatile.StoreUint32(&o.MAC_ADDR0_HIGH.Reg, volatile.LoadUint32(&o.MAC_ADDR0_HIGH.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMAC_ADDR0_HIGH_A47_32() uint32 {
	return volatile.LoadUint32(&o.MAC_ADDR0_HIGH.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMAC_ADDR0_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_ADDR0_HIGH.Reg, volatile.LoadUint32(&o.MAC_ADDR0_HIGH.Reg)&^(0x7fff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_ADDR0_HIGH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_ADDR0_HIGH.Reg) & 0x7fff0000) >> 16
}
func (o *ETHERNET_Type) SetMAC_ADDR0_HIGH_MO(value uint32) {
	volatile.StoreUint32(&o.MAC_ADDR0_HIGH.Reg, volatile.LoadUint32(&o.MAC_ADDR0_HIGH.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetMAC_ADDR0_HIGH_MO() uint32 {
	return (volatile.LoadUint32(&o.MAC_ADDR0_HIGH.Reg) & 0x80000000) >> 31
}

// ETHERNET.MAC_ADDR0_LOW: MAC address 0 low register
func (o *ETHERNET_Type) SetMAC_ADDR0_LOW(value uint32) {
	volatile.StoreUint32(&o.MAC_ADDR0_LOW.Reg, value)
}
func (o *ETHERNET_Type) GetMAC_ADDR0_LOW() uint32 {
	return volatile.LoadUint32(&o.MAC_ADDR0_LOW.Reg)
}

// ETHERNET.MAC_TIMESTP_CTRL: Time stamp control register
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSENA() uint32 {
	return volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSCFUPDT(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSCFUPDT() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSINIT(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSINIT() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSUPDT(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSUPDT() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSTRIG(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSTRIG() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSADDREG(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSADDREG() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0xc0) >> 6
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSENALL(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSENALL() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSCTRLSSR(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSCTRLSSR() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSVER2ENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSVER2ENA() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSIPENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSIPENA() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x800) >> 11
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSIPV6ENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSIPV6ENA() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSIPV4ENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSIPV4ENA() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSEVNTENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSEVNTENA() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSMSTRENA(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSMSTRENA() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSCLKTYPE(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSCLKTYPE() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x30000) >> 16
}
func (o *ETHERNET_Type) SetMAC_TIMESTP_CTRL_TSENMACADDR(value uint32) {
	volatile.StoreUint32(&o.MAC_TIMESTP_CTRL.Reg, volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *ETHERNET_Type) GetMAC_TIMESTP_CTRL_TSENMACADDR() uint32 {
	return (volatile.LoadUint32(&o.MAC_TIMESTP_CTRL.Reg) & 0x40000) >> 18
}

// ETHERNET.SUBSECOND_INCR: Sub-second increment register
func (o *ETHERNET_Type) SetSUBSECOND_INCR_SSINC(value uint32) {
	volatile.StoreUint32(&o.SUBSECOND_INCR.Reg, volatile.LoadUint32(&o.SUBSECOND_INCR.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSUBSECOND_INCR_SSINC() uint32 {
	return volatile.LoadUint32(&o.SUBSECOND_INCR.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSUBSECOND_INCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SUBSECOND_INCR.Reg, volatile.LoadUint32(&o.SUBSECOND_INCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ETHERNET_Type) GetSUBSECOND_INCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SUBSECOND_INCR.Reg) & 0xffffff00) >> 8
}

// ETHERNET.SECONDS: System time seconds register
func (o *ETHERNET_Type) SetSECONDS(value uint32) {
	volatile.StoreUint32(&o.SECONDS.Reg, value)
}
func (o *ETHERNET_Type) GetSECONDS() uint32 {
	return volatile.LoadUint32(&o.SECONDS.Reg)
}

// ETHERNET.NANOSECONDS: System time nanoseconds register
func (o *ETHERNET_Type) SetNANOSECONDS_TSSS(value uint32) {
	volatile.StoreUint32(&o.NANOSECONDS.Reg, volatile.LoadUint32(&o.NANOSECONDS.Reg)&^(0x7fffffff)|value)
}
func (o *ETHERNET_Type) GetNANOSECONDS_TSSS() uint32 {
	return volatile.LoadUint32(&o.NANOSECONDS.Reg) & 0x7fffffff
}
func (o *ETHERNET_Type) SetNANOSECONDS_PSNT(value uint32) {
	volatile.StoreUint32(&o.NANOSECONDS.Reg, volatile.LoadUint32(&o.NANOSECONDS.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetNANOSECONDS_PSNT() uint32 {
	return (volatile.LoadUint32(&o.NANOSECONDS.Reg) & 0x80000000) >> 31
}

// ETHERNET.SECONDSUPDATE: System time seconds update register
func (o *ETHERNET_Type) SetSECONDSUPDATE(value uint32) {
	volatile.StoreUint32(&o.SECONDSUPDATE.Reg, value)
}
func (o *ETHERNET_Type) GetSECONDSUPDATE() uint32 {
	return volatile.LoadUint32(&o.SECONDSUPDATE.Reg)
}

// ETHERNET.NANOSECONDSUPDATE: System time nanoseconds update register
func (o *ETHERNET_Type) SetNANOSECONDSUPDATE_TSSS(value uint32) {
	volatile.StoreUint32(&o.NANOSECONDSUPDATE.Reg, volatile.LoadUint32(&o.NANOSECONDSUPDATE.Reg)&^(0x7fffffff)|value)
}
func (o *ETHERNET_Type) GetNANOSECONDSUPDATE_TSSS() uint32 {
	return volatile.LoadUint32(&o.NANOSECONDSUPDATE.Reg) & 0x7fffffff
}
func (o *ETHERNET_Type) SetNANOSECONDSUPDATE_ADDSUB(value uint32) {
	volatile.StoreUint32(&o.NANOSECONDSUPDATE.Reg, volatile.LoadUint32(&o.NANOSECONDSUPDATE.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetNANOSECONDSUPDATE_ADDSUB() uint32 {
	return (volatile.LoadUint32(&o.NANOSECONDSUPDATE.Reg) & 0x80000000) >> 31
}

// ETHERNET.ADDEND: Time stamp addend register
func (o *ETHERNET_Type) SetADDEND(value uint32) {
	volatile.StoreUint32(&o.ADDEND.Reg, value)
}
func (o *ETHERNET_Type) GetADDEND() uint32 {
	return volatile.LoadUint32(&o.ADDEND.Reg)
}

// ETHERNET.TARGETSECONDS: Target time seconds register
func (o *ETHERNET_Type) SetTARGETSECONDS(value uint32) {
	volatile.StoreUint32(&o.TARGETSECONDS.Reg, value)
}
func (o *ETHERNET_Type) GetTARGETSECONDS() uint32 {
	return volatile.LoadUint32(&o.TARGETSECONDS.Reg)
}

// ETHERNET.TARGETNANOSECONDS: Target time nanoseconds register
func (o *ETHERNET_Type) SetTARGETNANOSECONDS_TSTR(value uint32) {
	volatile.StoreUint32(&o.TARGETNANOSECONDS.Reg, volatile.LoadUint32(&o.TARGETNANOSECONDS.Reg)&^(0x7fffffff)|value)
}
func (o *ETHERNET_Type) GetTARGETNANOSECONDS_TSTR() uint32 {
	return volatile.LoadUint32(&o.TARGETNANOSECONDS.Reg) & 0x7fffffff
}
func (o *ETHERNET_Type) SetTARGETNANOSECONDS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TARGETNANOSECONDS.Reg, volatile.LoadUint32(&o.TARGETNANOSECONDS.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetTARGETNANOSECONDS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TARGETNANOSECONDS.Reg) & 0x80000000) >> 31
}

// ETHERNET.HIGHWORD: System time higher word seconds register
func (o *ETHERNET_Type) SetHIGHWORD_TSHWR(value uint32) {
	volatile.StoreUint32(&o.HIGHWORD.Reg, volatile.LoadUint32(&o.HIGHWORD.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetHIGHWORD_TSHWR() uint32 {
	return volatile.LoadUint32(&o.HIGHWORD.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetHIGHWORD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HIGHWORD.Reg, volatile.LoadUint32(&o.HIGHWORD.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetHIGHWORD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HIGHWORD.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TIMESTAMPSTAT: Time stamp status register
func (o *ETHERNET_Type) SetTIMESTAMPSTAT_TSSOVF(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMPSTAT.Reg, volatile.LoadUint32(&o.TIMESTAMPSTAT.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetTIMESTAMPSTAT_TSSOVF() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMPSTAT.Reg) & 0x1
}
func (o *ETHERNET_Type) SetTIMESTAMPSTAT_TSTARGT(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMPSTAT.Reg, volatile.LoadUint32(&o.TIMESTAMPSTAT.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetTIMESTAMPSTAT_TSTARGT() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMPSTAT.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetTIMESTAMPSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMPSTAT.Reg, volatile.LoadUint32(&o.TIMESTAMPSTAT.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetTIMESTAMPSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMPSTAT.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.DMA_BUS_MODE: Bus Mode Register
func (o *ETHERNET_Type) SetDMA_BUS_MODE_SWR(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_SWR() uint32 {
	return volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x1
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_DA(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_DA() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_DSL(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x7c)|value<<2)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_DSL() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x7c) >> 2
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_ATDS(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_ATDS() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_PBL(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x3f00)|value<<8)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_PBL() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x3f00) >> 8
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_PR(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0xc000)|value<<14)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_PR() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0xc000) >> 14
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_FB(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_FB() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_RPBL(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x7e0000)|value<<17)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_RPBL() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x7e0000) >> 17
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_USP(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x800000)|value<<23)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_USP() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x800000) >> 23
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_PBL8X(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x1000000)|value<<24)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_PBL8X() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x1000000) >> 24
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_AAL(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x2000000)|value<<25)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_AAL() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x2000000) >> 25
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_MB(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x4000000)|value<<26)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_MB() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x4000000) >> 26
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_TXPR(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0x8000000)|value<<27)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_TXPR() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0x8000000) >> 27
}
func (o *ETHERNET_Type) SetDMA_BUS_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_BUS_MODE.Reg, volatile.LoadUint32(&o.DMA_BUS_MODE.Reg)&^(0xf0000000)|value<<28)
}
func (o *ETHERNET_Type) GetDMA_BUS_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_BUS_MODE.Reg) & 0xf0000000) >> 28
}

// ETHERNET.DMA_TRANS_POLL_DEMAND: Transmit poll demand register
func (o *ETHERNET_Type) SetDMA_TRANS_POLL_DEMAND(value uint32) {
	volatile.StoreUint32(&o.DMA_TRANS_POLL_DEMAND.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_TRANS_POLL_DEMAND() uint32 {
	return volatile.LoadUint32(&o.DMA_TRANS_POLL_DEMAND.Reg)
}

// ETHERNET.DMA_REC_POLL_DEMAND: Receive poll demand register
func (o *ETHERNET_Type) SetDMA_REC_POLL_DEMAND(value uint32) {
	volatile.StoreUint32(&o.DMA_REC_POLL_DEMAND.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_REC_POLL_DEMAND() uint32 {
	return volatile.LoadUint32(&o.DMA_REC_POLL_DEMAND.Reg)
}

// ETHERNET.DMA_REC_DES_ADDR: Receive descriptor list address register
func (o *ETHERNET_Type) SetDMA_REC_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_REC_DES_ADDR.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_REC_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.DMA_REC_DES_ADDR.Reg)
}

// ETHERNET.DMA_TRANS_DES_ADDR: Transmit descriptor list address register
func (o *ETHERNET_Type) SetDMA_TRANS_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_TRANS_DES_ADDR.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_TRANS_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.DMA_TRANS_DES_ADDR.Reg)
}

// ETHERNET.DMA_STAT: Status register
func (o *ETHERNET_Type) SetDMA_STAT_TI(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetDMA_STAT_TI() uint32 {
	return volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x1
}
func (o *ETHERNET_Type) SetDMA_STAT_TPS(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetDMA_STAT_TPS() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetDMA_STAT_TU(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetDMA_STAT_TU() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetDMA_STAT_TJT(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetDMA_STAT_TJT() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetDMA_STAT_OVF(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetDMA_STAT_OVF() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetDMA_STAT_UNF(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetDMA_STAT_UNF() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetDMA_STAT_RI(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetDMA_STAT_RI() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetDMA_STAT_RU(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetDMA_STAT_RU() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetDMA_STAT_RPS(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetDMA_STAT_RPS() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetDMA_STAT_RWT(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetDMA_STAT_RWT() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetDMA_STAT_ETI(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetDMA_STAT_ETI() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetDMA_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x1800)|value<<11)
}
func (o *ETHERNET_Type) GetDMA_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x1800) >> 11
}
func (o *ETHERNET_Type) SetDMA_STAT_FBI(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetDMA_STAT_FBI() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetDMA_STAT_ERI(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetDMA_STAT_ERI() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetDMA_STAT_AIE(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetDMA_STAT_AIE() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetDMA_STAT_NIS(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetDMA_STAT_NIS() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetDMA_STAT_RS(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0xe0000)|value<<17)
}
func (o *ETHERNET_Type) GetDMA_STAT_RS() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0xe0000) >> 17
}
func (o *ETHERNET_Type) SetDMA_STAT_TS(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x700000)|value<<20)
}
func (o *ETHERNET_Type) GetDMA_STAT_TS() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x700000) >> 20
}
func (o *ETHERNET_Type) SetDMA_STAT_EB1(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x800000)|value<<23)
}
func (o *ETHERNET_Type) GetDMA_STAT_EB1() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x800000) >> 23
}
func (o *ETHERNET_Type) SetDMA_STAT_EB2(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x1000000)|value<<24)
}
func (o *ETHERNET_Type) GetDMA_STAT_EB2() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x1000000) >> 24
}
func (o *ETHERNET_Type) SetDMA_STAT_EB3(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0x2000000)|value<<25)
}
func (o *ETHERNET_Type) GetDMA_STAT_EB3() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0x2000000) >> 25
}
func (o *ETHERNET_Type) SetDMA_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_STAT.Reg, volatile.LoadUint32(&o.DMA_STAT.Reg)&^(0xfc000000)|value<<26)
}
func (o *ETHERNET_Type) GetDMA_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_STAT.Reg) & 0xfc000000) >> 26
}

// ETHERNET.DMA_OP_MODE: Operation mode register
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x1
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_SR(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_SR() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_OSF(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_OSF() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RTC(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x18)|value<<3)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RTC() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x18) >> 3
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_FUF(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_FUF() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_FEF(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_FEF() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x1f00)|value<<8)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x1f00) >> 8
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_TTC(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x1c000)|value<<14)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_TTC() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x1c000) >> 14
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0xe0000)|value<<17)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0xe0000) >> 17
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_FTF(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x100000)|value<<20)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_FTF() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x100000) >> 20
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x200000)|value<<21)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x200000) >> 21
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0xc00000)|value<<22)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0xc00000) >> 22
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_DFF(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x1000000)|value<<24)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_DFF() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x1000000) >> 24
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x2000000)|value<<25)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x2000000) >> 25
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0x4000000)|value<<26)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0x4000000) >> 26
}
func (o *ETHERNET_Type) SetDMA_OP_MODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_OP_MODE.Reg, volatile.LoadUint32(&o.DMA_OP_MODE.Reg)&^(0xf8000000)|value<<27)
}
func (o *ETHERNET_Type) GetDMA_OP_MODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_OP_MODE.Reg) & 0xf8000000) >> 27
}

// ETHERNET.DMA_INT_EN: Interrupt enable register
func (o *ETHERNET_Type) SetDMA_INT_EN_TIE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_TIE() uint32 {
	return volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x1
}
func (o *ETHERNET_Type) SetDMA_INT_EN_TSE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_TSE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetDMA_INT_EN_TUE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_TUE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetDMA_INT_EN_TJE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_TJE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetDMA_INT_EN_OVE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_OVE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetDMA_INT_EN_UNE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_UNE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetDMA_INT_EN_RIE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_RIE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetDMA_INT_EN_RUE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_RUE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetDMA_INT_EN_RSE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_RSE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetDMA_INT_EN_RWE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_RWE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetDMA_INT_EN_ETE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_ETE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetDMA_INT_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x1800)|value<<11)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x1800) >> 11
}
func (o *ETHERNET_Type) SetDMA_INT_EN_FBE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_FBE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetDMA_INT_EN_ERE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_ERE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetDMA_INT_EN_AIE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_AIE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetDMA_INT_EN_NIE(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_NIE() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetDMA_INT_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_EN.Reg, volatile.LoadUint32(&o.DMA_INT_EN.Reg)&^(0xfffe0000)|value<<17)
}
func (o *ETHERNET_Type) GetDMA_INT_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_EN.Reg) & 0xfffe0000) >> 17
}

// ETHERNET.DMA_MFRM_BUFOF: Missed frame and buffer overflow register
func (o *ETHERNET_Type) SetDMA_MFRM_BUFOF_FMC(value uint32) {
	volatile.StoreUint32(&o.DMA_MFRM_BUFOF.Reg, volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetDMA_MFRM_BUFOF_FMC() uint32 {
	return volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetDMA_MFRM_BUFOF_OC(value uint32) {
	volatile.StoreUint32(&o.DMA_MFRM_BUFOF.Reg, volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetDMA_MFRM_BUFOF_OC() uint32 {
	return (volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetDMA_MFRM_BUFOF_FMA(value uint32) {
	volatile.StoreUint32(&o.DMA_MFRM_BUFOF.Reg, volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg)&^(0xffe0000)|value<<17)
}
func (o *ETHERNET_Type) GetDMA_MFRM_BUFOF_FMA() uint32 {
	return (volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg) & 0xffe0000) >> 17
}
func (o *ETHERNET_Type) SetDMA_MFRM_BUFOF_OF(value uint32) {
	volatile.StoreUint32(&o.DMA_MFRM_BUFOF.Reg, volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg)&^(0x10000000)|value<<28)
}
func (o *ETHERNET_Type) GetDMA_MFRM_BUFOF_OF() uint32 {
	return (volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg) & 0x10000000) >> 28
}
func (o *ETHERNET_Type) SetDMA_MFRM_BUFOF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_MFRM_BUFOF.Reg, volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg)&^(0xe0000000)|value<<29)
}
func (o *ETHERNET_Type) GetDMA_MFRM_BUFOF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_MFRM_BUFOF.Reg) & 0xe0000000) >> 29
}

// ETHERNET.DMA_REC_INT_WDT: Receive interrupt watchdog timer register
func (o *ETHERNET_Type) SetDMA_REC_INT_WDT_RIWT(value uint32) {
	volatile.StoreUint32(&o.DMA_REC_INT_WDT.Reg, volatile.LoadUint32(&o.DMA_REC_INT_WDT.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetDMA_REC_INT_WDT_RIWT() uint32 {
	return volatile.LoadUint32(&o.DMA_REC_INT_WDT.Reg) & 0xff
}
func (o *ETHERNET_Type) SetDMA_REC_INT_WDT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA_REC_INT_WDT.Reg, volatile.LoadUint32(&o.DMA_REC_INT_WDT.Reg)&^(0xffffff00)|value<<8)
}
func (o *ETHERNET_Type) GetDMA_REC_INT_WDT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA_REC_INT_WDT.Reg) & 0xffffff00) >> 8
}

// ETHERNET.DMA_CURHOST_TRANS_DES: Current host transmit descriptor register
func (o *ETHERNET_Type) SetDMA_CURHOST_TRANS_DES(value uint32) {
	volatile.StoreUint32(&o.DMA_CURHOST_TRANS_DES.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_CURHOST_TRANS_DES() uint32 {
	return volatile.LoadUint32(&o.DMA_CURHOST_TRANS_DES.Reg)
}

// ETHERNET.DMA_CURHOST_REC_DES: Current host receive descriptor register
func (o *ETHERNET_Type) SetDMA_CURHOST_REC_DES(value uint32) {
	volatile.StoreUint32(&o.DMA_CURHOST_REC_DES.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_CURHOST_REC_DES() uint32 {
	return volatile.LoadUint32(&o.DMA_CURHOST_REC_DES.Reg)
}

// ETHERNET.DMA_CURHOST_TRANS_BUF: Current host transmit buffer address register
func (o *ETHERNET_Type) SetDMA_CURHOST_TRANS_BUF(value uint32) {
	volatile.StoreUint32(&o.DMA_CURHOST_TRANS_BUF.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_CURHOST_TRANS_BUF() uint32 {
	return volatile.LoadUint32(&o.DMA_CURHOST_TRANS_BUF.Reg)
}

// ETHERNET.DMA_CURHOST_REC_BUF: Current host receive buffer address register
func (o *ETHERNET_Type) SetDMA_CURHOST_REC_BUF(value uint32) {
	volatile.StoreUint32(&o.DMA_CURHOST_REC_BUF.Reg, value)
}
func (o *ETHERNET_Type) GetDMA_CURHOST_REC_BUF() uint32 {
	return volatile.LoadUint32(&o.DMA_CURHOST_REC_BUF.Reg)
}

// Alarm timer
type ATIMER_Type struct {
	DOWNCOUNTER volatile.Register32 // 0x0
	PRESET      volatile.Register32 // 0x4
	_           [4048]byte
	CLR_EN      volatile.Register32 // 0xFD8
	SET_EN      volatile.Register32 // 0xFDC
	STATUS      volatile.Register32 // 0xFE0
	ENABLE      volatile.Register32 // 0xFE4
	CLR_STAT    volatile.Register32 // 0xFE8
	SET_STAT    volatile.Register32 // 0xFEC
}

// ATIMER.DOWNCOUNTER: Downcounter register
func (o *ATIMER_Type) SetDOWNCOUNTER_CVAL(value uint32) {
	volatile.StoreUint32(&o.DOWNCOUNTER.Reg, volatile.LoadUint32(&o.DOWNCOUNTER.Reg)&^(0xffff)|value)
}
func (o *ATIMER_Type) GetDOWNCOUNTER_CVAL() uint32 {
	return volatile.LoadUint32(&o.DOWNCOUNTER.Reg) & 0xffff
}
func (o *ATIMER_Type) SetDOWNCOUNTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOWNCOUNTER.Reg, volatile.LoadUint32(&o.DOWNCOUNTER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ATIMER_Type) GetDOWNCOUNTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOWNCOUNTER.Reg) & 0xffff0000) >> 16
}

// ATIMER.PRESET: Preset value register
func (o *ATIMER_Type) SetPRESET_PRESETVAL(value uint32) {
	volatile.StoreUint32(&o.PRESET.Reg, volatile.LoadUint32(&o.PRESET.Reg)&^(0xffff)|value)
}
func (o *ATIMER_Type) GetPRESET_PRESETVAL() uint32 {
	return volatile.LoadUint32(&o.PRESET.Reg) & 0xffff
}
func (o *ATIMER_Type) SetPRESET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESET.Reg, volatile.LoadUint32(&o.PRESET.Reg)&^(0xffff0000)|value<<16)
}
func (o *ATIMER_Type) GetPRESET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESET.Reg) & 0xffff0000) >> 16
}

// ATIMER.CLR_EN: Interrupt clear enable register
func (o *ATIMER_Type) SetCLR_EN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x1)|value)
}
func (o *ATIMER_Type) GetCLR_EN() uint32 {
	return volatile.LoadUint32(&o.CLR_EN.Reg) & 0x1
}
func (o *ATIMER_Type) SetCLR_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *ATIMER_Type) GetCLR_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0xfffffffe) >> 1
}

// ATIMER.SET_EN: Interrupt set enable register
func (o *ATIMER_Type) SetSET_EN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x1)|value)
}
func (o *ATIMER_Type) GetSET_EN() uint32 {
	return volatile.LoadUint32(&o.SET_EN.Reg) & 0x1
}
func (o *ATIMER_Type) SetSET_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *ATIMER_Type) GetSET_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0xfffffffe) >> 1
}

// ATIMER.STATUS: Status register
func (o *ATIMER_Type) SetSTATUS_STAT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *ATIMER_Type) GetSTATUS_STAT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *ATIMER_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffffe)|value<<1)
}
func (o *ATIMER_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffffe) >> 1
}

// ATIMER.ENABLE: Enable register
func (o *ATIMER_Type) SetENABLE_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *ATIMER_Type) GetENABLE_EN() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}
func (o *ATIMER_Type) SetENABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xfffffffe)|value<<1)
}
func (o *ATIMER_Type) GetENABLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0xfffffffe) >> 1
}

// ATIMER.CLR_STAT: Clear register
func (o *ATIMER_Type) SetCLR_STAT_CSTAT(value uint32) {
	volatile.StoreUint32(&o.CLR_STAT.Reg, volatile.LoadUint32(&o.CLR_STAT.Reg)&^(0x1)|value)
}
func (o *ATIMER_Type) GetCLR_STAT_CSTAT() uint32 {
	return volatile.LoadUint32(&o.CLR_STAT.Reg) & 0x1
}
func (o *ATIMER_Type) SetCLR_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR_STAT.Reg, volatile.LoadUint32(&o.CLR_STAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *ATIMER_Type) GetCLR_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR_STAT.Reg) & 0xfffffffe) >> 1
}

// ATIMER.SET_STAT: Set register
func (o *ATIMER_Type) SetSET_STAT_SSTAT(value uint32) {
	volatile.StoreUint32(&o.SET_STAT.Reg, volatile.LoadUint32(&o.SET_STAT.Reg)&^(0x1)|value)
}
func (o *ATIMER_Type) GetSET_STAT_SSTAT() uint32 {
	return volatile.LoadUint32(&o.SET_STAT.Reg) & 0x1
}
func (o *ATIMER_Type) SetSET_STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET_STAT.Reg, volatile.LoadUint32(&o.SET_STAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *ATIMER_Type) GetSET_STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET_STAT.Reg) & 0xfffffffe) >> 1
}

// RTC REGFILE
type REGFILE_Type struct {
	REGFILE [64]volatile.Register32 // 0x0
}

// REGFILE.REGFILE: General purpose storage register
func (o *REGFILE_Type) SetREGFILE(idx int, value uint32) {
	volatile.StoreUint32(&o.REGFILE[idx].Reg, value)
}
func (o *REGFILE_Type) GetREGFILE(idx int) uint32 {
	return volatile.LoadUint32(&o.REGFILE[idx].Reg)
}

// Power Management Controller (PMC)
type PMC_Type struct {
	PD0_SLEEP0_HW_ENA volatile.Register32 // 0x0
	_                 [24]byte
	PD0_SLEEP0_MODE   volatile.Register32 // 0x1C
}

// PMC.PD0_SLEEP0_HW_ENA: Hardware sleep event enable register
func (o *PMC_Type) SetPD0_SLEEP0_HW_ENA_ENA_EVENT0(value uint32) {
	volatile.StoreUint32(&o.PD0_SLEEP0_HW_ENA.Reg, volatile.LoadUint32(&o.PD0_SLEEP0_HW_ENA.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPD0_SLEEP0_HW_ENA_ENA_EVENT0() uint32 {
	return volatile.LoadUint32(&o.PD0_SLEEP0_HW_ENA.Reg) & 0x1
}
func (o *PMC_Type) SetPD0_SLEEP0_HW_ENA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PD0_SLEEP0_HW_ENA.Reg, volatile.LoadUint32(&o.PD0_SLEEP0_HW_ENA.Reg)&^(0xfffffffe)|value<<1)
}
func (o *PMC_Type) GetPD0_SLEEP0_HW_ENA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PD0_SLEEP0_HW_ENA.Reg) & 0xfffffffe) >> 1
}

// PMC.PD0_SLEEP0_MODE: Sleep power mode register
func (o *PMC_Type) SetPD0_SLEEP0_MODE(value uint32) {
	volatile.StoreUint32(&o.PD0_SLEEP0_MODE.Reg, value)
}
func (o *PMC_Type) GetPD0_SLEEP0_MODE() uint32 {
	return volatile.LoadUint32(&o.PD0_SLEEP0_MODE.Reg)
}

// Configuration Registers (CREG)
type CREG_Type struct {
	_         [4]byte
	CREG0     volatile.Register32 // 0x4
	_         [248]byte
	M3MEMMAP  volatile.Register32 // 0x100
	_         [20]byte
	CREG5     volatile.Register32 // 0x118
	DMAMUX    volatile.Register32 // 0x11C
	FLASHCFGA volatile.Register32 // 0x120
	FLASHCFGB volatile.Register32 // 0x124
	ETBCFG    volatile.Register32 // 0x128
	CREG6     volatile.Register32 // 0x12C
	_         [208]byte
	CHIPID    volatile.Register32 // 0x200
	_         [764]byte
	USB0FLADJ volatile.Register32 // 0x500
	_         [252]byte
	USB1FLADJ volatile.Register32 // 0x600
}

// CREG.CREG0: Chip configuration register 32 kHz oscillator output and BOD control register.
func (o *CREG_Type) SetCREG0_EN1KHZ(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x1)|value)
}
func (o *CREG_Type) GetCREG0_EN1KHZ() uint32 {
	return volatile.LoadUint32(&o.CREG0.Reg) & 0x1
}
func (o *CREG_Type) SetCREG0_EN32KHZ(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x2)|value<<1)
}
func (o *CREG_Type) GetCREG0_EN32KHZ() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x2) >> 1
}
func (o *CREG_Type) SetCREG0_RESET32KHZ(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x4)|value<<2)
}
func (o *CREG_Type) GetCREG0_RESET32KHZ() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x4) >> 2
}
func (o *CREG_Type) SetCREG0_PD32KHZ(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x8)|value<<3)
}
func (o *CREG_Type) GetCREG0_PD32KHZ() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x8) >> 3
}
func (o *CREG_Type) SetCREG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x10)|value<<4)
}
func (o *CREG_Type) GetCREG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x10) >> 4
}
func (o *CREG_Type) SetCREG0_USB0PHY(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x20)|value<<5)
}
func (o *CREG_Type) GetCREG0_USB0PHY() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x20) >> 5
}
func (o *CREG_Type) SetCREG0_ALARMCTRL(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0xc0)|value<<6)
}
func (o *CREG_Type) GetCREG0_ALARMCTRL() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0xc0) >> 6
}
func (o *CREG_Type) SetCREG0_BODLVL1(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x300)|value<<8)
}
func (o *CREG_Type) GetCREG0_BODLVL1() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x300) >> 8
}
func (o *CREG_Type) SetCREG0_BODLVL2(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0xc00)|value<<10)
}
func (o *CREG_Type) GetCREG0_BODLVL2() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0xc00) >> 10
}
func (o *CREG_Type) SetCREG0_SAMPLECTRL(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x3000)|value<<12)
}
func (o *CREG_Type) GetCREG0_SAMPLECTRL() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x3000) >> 12
}
func (o *CREG_Type) SetCREG0_WAKEUP0CTRL(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0xc000)|value<<14)
}
func (o *CREG_Type) GetCREG0_WAKEUP0CTRL() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0xc000) >> 14
}
func (o *CREG_Type) SetCREG0_WAKEUP1CTRL(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0x30000)|value<<16)
}
func (o *CREG_Type) GetCREG0_WAKEUP1CTRL() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0x30000) >> 16
}
func (o *CREG_Type) SetCREG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG0.Reg, volatile.LoadUint32(&o.CREG0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *CREG_Type) GetCREG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CREG0.Reg) & 0xfffc0000) >> 18
}

// CREG.M3MEMMAP: ARM Cortex-M3 memory mapping
func (o *CREG_Type) SetM3MEMMAP_M3MAP(value uint32) {
	volatile.StoreUint32(&o.M3MEMMAP.Reg, volatile.LoadUint32(&o.M3MEMMAP.Reg)&^(0xfffff000)|value<<12)
}
func (o *CREG_Type) GetM3MEMMAP_M3MAP() uint32 {
	return (volatile.LoadUint32(&o.M3MEMMAP.Reg) & 0xfffff000) >> 12
}

// CREG.CREG5: Chip configuration register 5. Controls JTAG access.
func (o *CREG_Type) SetCREG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG5.Reg, volatile.LoadUint32(&o.CREG5.Reg)&^(0x7ff)|value)
}
func (o *CREG_Type) GetCREG5_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CREG5.Reg) & 0x7ff
}
func (o *CREG_Type) SetCREG5_M3TAPSEL(value uint32) {
	volatile.StoreUint32(&o.CREG5.Reg, volatile.LoadUint32(&o.CREG5.Reg)&^(0x800)|value<<11)
}
func (o *CREG_Type) GetCREG5_M3TAPSEL() uint32 {
	return (volatile.LoadUint32(&o.CREG5.Reg) & 0x800) >> 11
}
func (o *CREG_Type) SetCREG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG5.Reg, volatile.LoadUint32(&o.CREG5.Reg)&^(0xfffff000)|value<<12)
}
func (o *CREG_Type) GetCREG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CREG5.Reg) & 0xfffff000) >> 12
}

// CREG.DMAMUX: DMA mux control
func (o *CREG_Type) SetDMAMUX_DMAMUXPER0(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x3)|value)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER0() uint32 {
	return volatile.LoadUint32(&o.DMAMUX.Reg) & 0x3
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER1(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc)|value<<2)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER1() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc) >> 2
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER2(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x30)|value<<4)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER2() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x30) >> 4
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER3(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc0)|value<<6)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER3() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc0) >> 6
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER4(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x300)|value<<8)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER4() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x300) >> 8
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER5(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc00)|value<<10)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER5() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc00) >> 10
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER6(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x3000)|value<<12)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER6() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x3000) >> 12
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER7(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc000)|value<<14)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER7() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc000) >> 14
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER8(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x30000)|value<<16)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER8() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x30000) >> 16
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER9(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc0000)|value<<18)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER9() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc0000) >> 18
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER10(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x300000)|value<<20)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER10() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x300000) >> 20
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER11(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc00000)|value<<22)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER11() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc00000) >> 22
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER12(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x3000000)|value<<24)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER12() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x3000000) >> 24
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER13(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc000000)|value<<26)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER13() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc000000) >> 26
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER14(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0x30000000)|value<<28)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER14() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0x30000000) >> 28
}
func (o *CREG_Type) SetDMAMUX_DMAMUXPER15(value uint32) {
	volatile.StoreUint32(&o.DMAMUX.Reg, volatile.LoadUint32(&o.DMAMUX.Reg)&^(0xc0000000)|value<<30)
}
func (o *CREG_Type) GetDMAMUX_DMAMUXPER15() uint32 {
	return (volatile.LoadUint32(&o.DMAMUX.Reg) & 0xc0000000) >> 30
}

// CREG.FLASHCFGA: Flash accelerator configuration register for flash bank A
func (o *CREG_Type) SetFLASHCFGA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGA.Reg, volatile.LoadUint32(&o.FLASHCFGA.Reg)&^(0xfff)|value)
}
func (o *CREG_Type) GetFLASHCFGA_RESERVED() uint32 {
	return volatile.LoadUint32(&o.FLASHCFGA.Reg) & 0xfff
}
func (o *CREG_Type) SetFLASHCFGA_FLASHTIM(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGA.Reg, volatile.LoadUint32(&o.FLASHCFGA.Reg)&^(0xf000)|value<<12)
}
func (o *CREG_Type) GetFLASHCFGA_FLASHTIM() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFGA.Reg) & 0xf000) >> 12
}
func (o *CREG_Type) SetFLASHCFGA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGA.Reg, volatile.LoadUint32(&o.FLASHCFGA.Reg)&^(0x7fff0000)|value<<16)
}
func (o *CREG_Type) GetFLASHCFGA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFGA.Reg) & 0x7fff0000) >> 16
}
func (o *CREG_Type) SetFLASHCFGA_POW(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGA.Reg, volatile.LoadUint32(&o.FLASHCFGA.Reg)&^(0x80000000)|value<<31)
}
func (o *CREG_Type) GetFLASHCFGA_POW() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFGA.Reg) & 0x80000000) >> 31
}

// CREG.FLASHCFGB: Flash accelerator configuration register for flash bank B
func (o *CREG_Type) SetFLASHCFGB_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGB.Reg, volatile.LoadUint32(&o.FLASHCFGB.Reg)&^(0xfff)|value)
}
func (o *CREG_Type) GetFLASHCFGB_RESERVED() uint32 {
	return volatile.LoadUint32(&o.FLASHCFGB.Reg) & 0xfff
}
func (o *CREG_Type) SetFLASHCFGB_FLASHTIM(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGB.Reg, volatile.LoadUint32(&o.FLASHCFGB.Reg)&^(0xf000)|value<<12)
}
func (o *CREG_Type) GetFLASHCFGB_FLASHTIM() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFGB.Reg) & 0xf000) >> 12
}
func (o *CREG_Type) SetFLASHCFGB_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGB.Reg, volatile.LoadUint32(&o.FLASHCFGB.Reg)&^(0x7fff0000)|value<<16)
}
func (o *CREG_Type) GetFLASHCFGB_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFGB.Reg) & 0x7fff0000) >> 16
}
func (o *CREG_Type) SetFLASHCFGB_POW(value uint32) {
	volatile.StoreUint32(&o.FLASHCFGB.Reg, volatile.LoadUint32(&o.FLASHCFGB.Reg)&^(0x80000000)|value<<31)
}
func (o *CREG_Type) GetFLASHCFGB_POW() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFGB.Reg) & 0x80000000) >> 31
}

// CREG.ETBCFG: ETB RAM configuration
func (o *CREG_Type) SetETBCFG_ETB(value uint32) {
	volatile.StoreUint32(&o.ETBCFG.Reg, volatile.LoadUint32(&o.ETBCFG.Reg)&^(0x1)|value)
}
func (o *CREG_Type) GetETBCFG_ETB() uint32 {
	return volatile.LoadUint32(&o.ETBCFG.Reg) & 0x1
}
func (o *CREG_Type) SetETBCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ETBCFG.Reg, volatile.LoadUint32(&o.ETBCFG.Reg)&^(0xfffffffe)|value<<1)
}
func (o *CREG_Type) GetETBCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ETBCFG.Reg) & 0xfffffffe) >> 1
}

// CREG.CREG6: Chip configuration register 6. Controls multiple functions : Ethernet interface, SCT output, I2S0/1 inputs, EMC clock.
func (o *CREG_Type) SetCREG6_ETHMODE(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x7)|value)
}
func (o *CREG_Type) GetCREG6_ETHMODE() uint32 {
	return volatile.LoadUint32(&o.CREG6.Reg) & 0x7
}
func (o *CREG_Type) SetCREG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x8)|value<<3)
}
func (o *CREG_Type) GetCREG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x8) >> 3
}
func (o *CREG_Type) SetCREG6_CTOUTCTRL(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x10)|value<<4)
}
func (o *CREG_Type) GetCREG6_CTOUTCTRL() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x10) >> 4
}
func (o *CREG_Type) SetCREG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0xfe0)|value<<5)
}
func (o *CREG_Type) GetCREG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0xfe0) >> 5
}
func (o *CREG_Type) SetCREG6_I2S0_TX_SCK_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x1000)|value<<12)
}
func (o *CREG_Type) GetCREG6_I2S0_TX_SCK_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x1000) >> 12
}
func (o *CREG_Type) SetCREG6_I2S0_RX_SCK_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x2000)|value<<13)
}
func (o *CREG_Type) GetCREG6_I2S0_RX_SCK_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x2000) >> 13
}
func (o *CREG_Type) SetCREG6_I2S1_TX_SCK_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x4000)|value<<14)
}
func (o *CREG_Type) GetCREG6_I2S1_TX_SCK_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x4000) >> 14
}
func (o *CREG_Type) SetCREG6_I2S1_RX_SCK_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x8000)|value<<15)
}
func (o *CREG_Type) GetCREG6_I2S1_RX_SCK_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x8000) >> 15
}
func (o *CREG_Type) SetCREG6_EMC_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0x10000)|value<<16)
}
func (o *CREG_Type) GetCREG6_EMC_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0x10000) >> 16
}
func (o *CREG_Type) SetCREG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CREG6.Reg, volatile.LoadUint32(&o.CREG6.Reg)&^(0xfffe0000)|value<<17)
}
func (o *CREG_Type) GetCREG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CREG6.Reg) & 0xfffe0000) >> 17
}

// CREG.CHIPID: Part ID
func (o *CREG_Type) SetCHIPID(value uint32) {
	volatile.StoreUint32(&o.CHIPID.Reg, value)
}
func (o *CREG_Type) GetCHIPID() uint32 {
	return volatile.LoadUint32(&o.CHIPID.Reg)
}

// CREG.USB0FLADJ: USB0 frame length adjust register
func (o *CREG_Type) SetUSB0FLADJ_FLTV(value uint32) {
	volatile.StoreUint32(&o.USB0FLADJ.Reg, volatile.LoadUint32(&o.USB0FLADJ.Reg)&^(0x3f)|value)
}
func (o *CREG_Type) GetUSB0FLADJ_FLTV() uint32 {
	return volatile.LoadUint32(&o.USB0FLADJ.Reg) & 0x3f
}
func (o *CREG_Type) SetUSB0FLADJ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USB0FLADJ.Reg, volatile.LoadUint32(&o.USB0FLADJ.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CREG_Type) GetUSB0FLADJ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USB0FLADJ.Reg) & 0xffffffc0) >> 6
}

// CREG.USB1FLADJ: USB1 frame length adjust register
func (o *CREG_Type) SetUSB1FLADJ_FLTV(value uint32) {
	volatile.StoreUint32(&o.USB1FLADJ.Reg, volatile.LoadUint32(&o.USB1FLADJ.Reg)&^(0x3f)|value)
}
func (o *CREG_Type) GetUSB1FLADJ_FLTV() uint32 {
	return volatile.LoadUint32(&o.USB1FLADJ.Reg) & 0x3f
}
func (o *CREG_Type) SetUSB1FLADJ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USB1FLADJ.Reg, volatile.LoadUint32(&o.USB1FLADJ.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CREG_Type) GetUSB1FLADJ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USB1FLADJ.Reg) & 0xffffffc0) >> 6
}

// Event router
type EVENTROUTER_Type struct {
	HILO     volatile.Register32 // 0x0
	EDGE     volatile.Register32 // 0x4
	_        [4048]byte
	CLR_EN   volatile.Register32 // 0xFD8
	SET_EN   volatile.Register32 // 0xFDC
	STATUS   volatile.Register32 // 0xFE0
	ENABLE   volatile.Register32 // 0xFE4
	CLR_STAT volatile.Register32 // 0xFE8
	SET_STAT volatile.Register32 // 0xFEC
}

// EVENTROUTER.HILO: Level configuration register
func (o *EVENTROUTER_Type) SetHILO_WAKEUP0_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x1)|value)
}
func (o *EVENTROUTER_Type) GetHILO_WAKEUP0_L() uint32 {
	return volatile.LoadUint32(&o.HILO.Reg) & 0x1
}
func (o *EVENTROUTER_Type) SetHILO_WAKEUP1_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x2)|value<<1)
}
func (o *EVENTROUTER_Type) GetHILO_WAKEUP1_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x2) >> 1
}
func (o *EVENTROUTER_Type) SetHILO_WAKEUP2_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x4)|value<<2)
}
func (o *EVENTROUTER_Type) GetHILO_WAKEUP2_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x4) >> 2
}
func (o *EVENTROUTER_Type) SetHILO_WAKEUP3_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x8)|value<<3)
}
func (o *EVENTROUTER_Type) GetHILO_WAKEUP3_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x8) >> 3
}
func (o *EVENTROUTER_Type) SetHILO_ATIMER_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x10)|value<<4)
}
func (o *EVENTROUTER_Type) GetHILO_ATIMER_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x10) >> 4
}
func (o *EVENTROUTER_Type) SetHILO_RTC_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x20)|value<<5)
}
func (o *EVENTROUTER_Type) GetHILO_RTC_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x20) >> 5
}
func (o *EVENTROUTER_Type) SetHILO_BOD_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x40)|value<<6)
}
func (o *EVENTROUTER_Type) GetHILO_BOD_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x40) >> 6
}
func (o *EVENTROUTER_Type) SetHILO_WWDT_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x80)|value<<7)
}
func (o *EVENTROUTER_Type) GetHILO_WWDT_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x80) >> 7
}
func (o *EVENTROUTER_Type) SetHILO_ETH_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x100)|value<<8)
}
func (o *EVENTROUTER_Type) GetHILO_ETH_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x100) >> 8
}
func (o *EVENTROUTER_Type) SetHILO_USB0_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x200)|value<<9)
}
func (o *EVENTROUTER_Type) GetHILO_USB0_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x200) >> 9
}
func (o *EVENTROUTER_Type) SetHILO_USB1_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x400)|value<<10)
}
func (o *EVENTROUTER_Type) GetHILO_USB1_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x400) >> 10
}
func (o *EVENTROUTER_Type) SetHILO_SDMMC_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x800)|value<<11)
}
func (o *EVENTROUTER_Type) GetHILO_SDMMC_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x800) >> 11
}
func (o *EVENTROUTER_Type) SetHILO_CAN_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x1000)|value<<12)
}
func (o *EVENTROUTER_Type) GetHILO_CAN_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x1000) >> 12
}
func (o *EVENTROUTER_Type) SetHILO_TIM2_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x2000)|value<<13)
}
func (o *EVENTROUTER_Type) GetHILO_TIM2_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x2000) >> 13
}
func (o *EVENTROUTER_Type) SetHILO_TIM6_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x4000)|value<<14)
}
func (o *EVENTROUTER_Type) GetHILO_TIM6_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x4000) >> 14
}
func (o *EVENTROUTER_Type) SetHILO_QEI_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x8000)|value<<15)
}
func (o *EVENTROUTER_Type) GetHILO_QEI_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x8000) >> 15
}
func (o *EVENTROUTER_Type) SetHILO_TIM14_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x10000)|value<<16)
}
func (o *EVENTROUTER_Type) GetHILO_TIM14_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x10000) >> 16
}
func (o *EVENTROUTER_Type) SetHILO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x60000)|value<<17)
}
func (o *EVENTROUTER_Type) GetHILO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x60000) >> 17
}
func (o *EVENTROUTER_Type) SetHILO_RESET_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x80000)|value<<19)
}
func (o *EVENTROUTER_Type) GetHILO_RESET_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x80000) >> 19
}
func (o *EVENTROUTER_Type) SetHILO_BODRESET_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x100000)|value<<20)
}
func (o *EVENTROUTER_Type) GetHILO_BODRESET_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x100000) >> 20
}
func (o *EVENTROUTER_Type) SetHILO_DPDRESET_L(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0x200000)|value<<21)
}
func (o *EVENTROUTER_Type) GetHILO_DPDRESET_L() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0x200000) >> 21
}
func (o *EVENTROUTER_Type) SetHILO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HILO.Reg, volatile.LoadUint32(&o.HILO.Reg)&^(0xffc00000)|value<<22)
}
func (o *EVENTROUTER_Type) GetHILO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HILO.Reg) & 0xffc00000) >> 22
}

// EVENTROUTER.EDGE: Edge configuration
func (o *EVENTROUTER_Type) SetEDGE_WAKEUP0_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x1)|value)
}
func (o *EVENTROUTER_Type) GetEDGE_WAKEUP0_E() uint32 {
	return volatile.LoadUint32(&o.EDGE.Reg) & 0x1
}
func (o *EVENTROUTER_Type) SetEDGE_WAKEUP1_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x2)|value<<1)
}
func (o *EVENTROUTER_Type) GetEDGE_WAKEUP1_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x2) >> 1
}
func (o *EVENTROUTER_Type) SetEDGE_WAKEUP2_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x4)|value<<2)
}
func (o *EVENTROUTER_Type) GetEDGE_WAKEUP2_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x4) >> 2
}
func (o *EVENTROUTER_Type) SetEDGE_WAKEUP3_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x8)|value<<3)
}
func (o *EVENTROUTER_Type) GetEDGE_WAKEUP3_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x8) >> 3
}
func (o *EVENTROUTER_Type) SetEDGE_ATIMER_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x10)|value<<4)
}
func (o *EVENTROUTER_Type) GetEDGE_ATIMER_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x10) >> 4
}
func (o *EVENTROUTER_Type) SetEDGE_RTC_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x20)|value<<5)
}
func (o *EVENTROUTER_Type) GetEDGE_RTC_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x20) >> 5
}
func (o *EVENTROUTER_Type) SetEDGE_BOD_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x40)|value<<6)
}
func (o *EVENTROUTER_Type) GetEDGE_BOD_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x40) >> 6
}
func (o *EVENTROUTER_Type) SetEDGE_WWDT_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x80)|value<<7)
}
func (o *EVENTROUTER_Type) GetEDGE_WWDT_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x80) >> 7
}
func (o *EVENTROUTER_Type) SetEDGE_ETH_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x100)|value<<8)
}
func (o *EVENTROUTER_Type) GetEDGE_ETH_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x100) >> 8
}
func (o *EVENTROUTER_Type) SetEDGE_USB0_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x200)|value<<9)
}
func (o *EVENTROUTER_Type) GetEDGE_USB0_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x200) >> 9
}
func (o *EVENTROUTER_Type) SetEDGE_USB1_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x400)|value<<10)
}
func (o *EVENTROUTER_Type) GetEDGE_USB1_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x400) >> 10
}
func (o *EVENTROUTER_Type) SetEDGE_SDMMC_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x800)|value<<11)
}
func (o *EVENTROUTER_Type) GetEDGE_SDMMC_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x800) >> 11
}
func (o *EVENTROUTER_Type) SetEDGE_CAN_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x1000)|value<<12)
}
func (o *EVENTROUTER_Type) GetEDGE_CAN_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x1000) >> 12
}
func (o *EVENTROUTER_Type) SetEDGE_TIM2_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x2000)|value<<13)
}
func (o *EVENTROUTER_Type) GetEDGE_TIM2_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x2000) >> 13
}
func (o *EVENTROUTER_Type) SetEDGE_TIM6_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x4000)|value<<14)
}
func (o *EVENTROUTER_Type) GetEDGE_TIM6_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x4000) >> 14
}
func (o *EVENTROUTER_Type) SetEDGE_QEI_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x8000)|value<<15)
}
func (o *EVENTROUTER_Type) GetEDGE_QEI_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x8000) >> 15
}
func (o *EVENTROUTER_Type) SetEDGE_TIM14_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x10000)|value<<16)
}
func (o *EVENTROUTER_Type) GetEDGE_TIM14_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x10000) >> 16
}
func (o *EVENTROUTER_Type) SetEDGE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x60000)|value<<17)
}
func (o *EVENTROUTER_Type) GetEDGE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x60000) >> 17
}
func (o *EVENTROUTER_Type) SetEDGE_RESET_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x80000)|value<<19)
}
func (o *EVENTROUTER_Type) GetEDGE_RESET_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x80000) >> 19
}
func (o *EVENTROUTER_Type) SetEDGE_BODRESET_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x100000)|value<<20)
}
func (o *EVENTROUTER_Type) GetEDGE_BODRESET_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x100000) >> 20
}
func (o *EVENTROUTER_Type) SetEDGE_DPDRESET_E(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0x200000)|value<<21)
}
func (o *EVENTROUTER_Type) GetEDGE_DPDRESET_E() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0x200000) >> 21
}
func (o *EVENTROUTER_Type) SetEDGE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EDGE.Reg, volatile.LoadUint32(&o.EDGE.Reg)&^(0xffc00000)|value<<22)
}
func (o *EVENTROUTER_Type) GetEDGE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EDGE.Reg) & 0xffc00000) >> 22
}

// EVENTROUTER.CLR_EN: Clear event enable register
func (o *EVENTROUTER_Type) SetCLR_EN_WAKEUP0_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x1)|value)
}
func (o *EVENTROUTER_Type) GetCLR_EN_WAKEUP0_CLREN() uint32 {
	return volatile.LoadUint32(&o.CLR_EN.Reg) & 0x1
}
func (o *EVENTROUTER_Type) SetCLR_EN_WAKEUP1_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x2)|value<<1)
}
func (o *EVENTROUTER_Type) GetCLR_EN_WAKEUP1_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x2) >> 1
}
func (o *EVENTROUTER_Type) SetCLR_EN_WAKEUP2_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x4)|value<<2)
}
func (o *EVENTROUTER_Type) GetCLR_EN_WAKEUP2_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x4) >> 2
}
func (o *EVENTROUTER_Type) SetCLR_EN_WAKEUP3_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x8)|value<<3)
}
func (o *EVENTROUTER_Type) GetCLR_EN_WAKEUP3_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x8) >> 3
}
func (o *EVENTROUTER_Type) SetCLR_EN_ATIMER_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x10)|value<<4)
}
func (o *EVENTROUTER_Type) GetCLR_EN_ATIMER_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x10) >> 4
}
func (o *EVENTROUTER_Type) SetCLR_EN_RTC_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x20)|value<<5)
}
func (o *EVENTROUTER_Type) GetCLR_EN_RTC_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x20) >> 5
}
func (o *EVENTROUTER_Type) SetCLR_EN_BOD_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x40)|value<<6)
}
func (o *EVENTROUTER_Type) GetCLR_EN_BOD_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x40) >> 6
}
func (o *EVENTROUTER_Type) SetCLR_EN_WWDT_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x80)|value<<7)
}
func (o *EVENTROUTER_Type) GetCLR_EN_WWDT_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x80) >> 7
}
func (o *EVENTROUTER_Type) SetCLR_EN_ETH_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x100)|value<<8)
}
func (o *EVENTROUTER_Type) GetCLR_EN_ETH_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x100) >> 8
}
func (o *EVENTROUTER_Type) SetCLR_EN_USB0_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x200)|value<<9)
}
func (o *EVENTROUTER_Type) GetCLR_EN_USB0_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x200) >> 9
}
func (o *EVENTROUTER_Type) SetCLR_EN_USB1_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x400)|value<<10)
}
func (o *EVENTROUTER_Type) GetCLR_EN_USB1_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x400) >> 10
}
func (o *EVENTROUTER_Type) SetCLR_EN_SDMMC_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x800)|value<<11)
}
func (o *EVENTROUTER_Type) GetCLR_EN_SDMMC_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x800) >> 11
}
func (o *EVENTROUTER_Type) SetCLR_EN_CAN_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x1000)|value<<12)
}
func (o *EVENTROUTER_Type) GetCLR_EN_CAN_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x1000) >> 12
}
func (o *EVENTROUTER_Type) SetCLR_EN_TIM2_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x2000)|value<<13)
}
func (o *EVENTROUTER_Type) GetCLR_EN_TIM2_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x2000) >> 13
}
func (o *EVENTROUTER_Type) SetCLR_EN_TIM6_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x4000)|value<<14)
}
func (o *EVENTROUTER_Type) GetCLR_EN_TIM6_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x4000) >> 14
}
func (o *EVENTROUTER_Type) SetCLR_EN_QEI_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x8000)|value<<15)
}
func (o *EVENTROUTER_Type) GetCLR_EN_QEI_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x8000) >> 15
}
func (o *EVENTROUTER_Type) SetCLR_EN_TIM14_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x10000)|value<<16)
}
func (o *EVENTROUTER_Type) GetCLR_EN_TIM14_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x10000) >> 16
}
func (o *EVENTROUTER_Type) SetCLR_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x60000)|value<<17)
}
func (o *EVENTROUTER_Type) GetCLR_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x60000) >> 17
}
func (o *EVENTROUTER_Type) SetCLR_EN_RESET_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x80000)|value<<19)
}
func (o *EVENTROUTER_Type) GetCLR_EN_RESET_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x80000) >> 19
}
func (o *EVENTROUTER_Type) SetCLR_EN_BODRESET_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x100000)|value<<20)
}
func (o *EVENTROUTER_Type) GetCLR_EN_BODRESET_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x100000) >> 20
}
func (o *EVENTROUTER_Type) SetCLR_EN_DPDRESET_CLREN(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0x200000)|value<<21)
}
func (o *EVENTROUTER_Type) GetCLR_EN_DPDRESET_CLREN() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0x200000) >> 21
}
func (o *EVENTROUTER_Type) SetCLR_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR_EN.Reg, volatile.LoadUint32(&o.CLR_EN.Reg)&^(0xffc00000)|value<<22)
}
func (o *EVENTROUTER_Type) GetCLR_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR_EN.Reg) & 0xffc00000) >> 22
}

// EVENTROUTER.SET_EN: Set event enable register
func (o *EVENTROUTER_Type) SetSET_EN_WAKEUP0_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x1)|value)
}
func (o *EVENTROUTER_Type) GetSET_EN_WAKEUP0_SETEN() uint32 {
	return volatile.LoadUint32(&o.SET_EN.Reg) & 0x1
}
func (o *EVENTROUTER_Type) SetSET_EN_WAKEUP1_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x2)|value<<1)
}
func (o *EVENTROUTER_Type) GetSET_EN_WAKEUP1_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x2) >> 1
}
func (o *EVENTROUTER_Type) SetSET_EN_WAKEUP2_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x4)|value<<2)
}
func (o *EVENTROUTER_Type) GetSET_EN_WAKEUP2_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x4) >> 2
}
func (o *EVENTROUTER_Type) SetSET_EN_WAKEUP3_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x8)|value<<3)
}
func (o *EVENTROUTER_Type) GetSET_EN_WAKEUP3_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x8) >> 3
}
func (o *EVENTROUTER_Type) SetSET_EN_ATIMER_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x10)|value<<4)
}
func (o *EVENTROUTER_Type) GetSET_EN_ATIMER_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x10) >> 4
}
func (o *EVENTROUTER_Type) SetSET_EN_RTC_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x20)|value<<5)
}
func (o *EVENTROUTER_Type) GetSET_EN_RTC_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x20) >> 5
}
func (o *EVENTROUTER_Type) SetSET_EN_BOD_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x40)|value<<6)
}
func (o *EVENTROUTER_Type) GetSET_EN_BOD_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x40) >> 6
}
func (o *EVENTROUTER_Type) SetSET_EN_WWDT_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x80)|value<<7)
}
func (o *EVENTROUTER_Type) GetSET_EN_WWDT_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x80) >> 7
}
func (o *EVENTROUTER_Type) SetSET_EN_ETH_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x100)|value<<8)
}
func (o *EVENTROUTER_Type) GetSET_EN_ETH_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x100) >> 8
}
func (o *EVENTROUTER_Type) SetSET_EN_USB0_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x200)|value<<9)
}
func (o *EVENTROUTER_Type) GetSET_EN_USB0_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x200) >> 9
}
func (o *EVENTROUTER_Type) SetSET_EN_USB1_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x400)|value<<10)
}
func (o *EVENTROUTER_Type) GetSET_EN_USB1_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x400) >> 10
}
func (o *EVENTROUTER_Type) SetSET_EN_SDMMC_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x800)|value<<11)
}
func (o *EVENTROUTER_Type) GetSET_EN_SDMMC_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x800) >> 11
}
func (o *EVENTROUTER_Type) SetSET_EN_CAN_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x1000)|value<<12)
}
func (o *EVENTROUTER_Type) GetSET_EN_CAN_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x1000) >> 12
}
func (o *EVENTROUTER_Type) SetSET_EN_TIM2_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x2000)|value<<13)
}
func (o *EVENTROUTER_Type) GetSET_EN_TIM2_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x2000) >> 13
}
func (o *EVENTROUTER_Type) SetSET_EN_TIM6_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x4000)|value<<14)
}
func (o *EVENTROUTER_Type) GetSET_EN_TIM6_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x4000) >> 14
}
func (o *EVENTROUTER_Type) SetSET_EN_QEI_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x8000)|value<<15)
}
func (o *EVENTROUTER_Type) GetSET_EN_QEI_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x8000) >> 15
}
func (o *EVENTROUTER_Type) SetSET_EN_TIM14_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x10000)|value<<16)
}
func (o *EVENTROUTER_Type) GetSET_EN_TIM14_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x10000) >> 16
}
func (o *EVENTROUTER_Type) SetSET_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x60000)|value<<17)
}
func (o *EVENTROUTER_Type) GetSET_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x60000) >> 17
}
func (o *EVENTROUTER_Type) SetSET_EN_RESET_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x80000)|value<<19)
}
func (o *EVENTROUTER_Type) GetSET_EN_RESET_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x80000) >> 19
}
func (o *EVENTROUTER_Type) SetSET_EN_BODRESET_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x100000)|value<<20)
}
func (o *EVENTROUTER_Type) GetSET_EN_BODRESET_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x100000) >> 20
}
func (o *EVENTROUTER_Type) SetSET_EN_DPDRESET_SETEN(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0x200000)|value<<21)
}
func (o *EVENTROUTER_Type) GetSET_EN_DPDRESET_SETEN() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0x200000) >> 21
}
func (o *EVENTROUTER_Type) SetSET_EN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET_EN.Reg, volatile.LoadUint32(&o.SET_EN.Reg)&^(0xffc00000)|value<<22)
}
func (o *EVENTROUTER_Type) GetSET_EN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET_EN.Reg) & 0xffc00000) >> 22
}

// EVENTROUTER.STATUS: Event Status register
func (o *EVENTROUTER_Type) SetSTATUS_WAKEUP0_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *EVENTROUTER_Type) GetSTATUS_WAKEUP0_ST() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *EVENTROUTER_Type) SetSTATUS_WAKEUP1_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *EVENTROUTER_Type) GetSTATUS_WAKEUP1_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *EVENTROUTER_Type) SetSTATUS_WAKEUP2_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *EVENTROUTER_Type) GetSTATUS_WAKEUP2_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *EVENTROUTER_Type) SetSTATUS_WAKEUP3_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *EVENTROUTER_Type) GetSTATUS_WAKEUP3_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *EVENTROUTER_Type) SetSTATUS_ATIMER_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *EVENTROUTER_Type) GetSTATUS_ATIMER_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *EVENTROUTER_Type) SetSTATUS_RTC_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *EVENTROUTER_Type) GetSTATUS_RTC_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *EVENTROUTER_Type) SetSTATUS_BOD_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *EVENTROUTER_Type) GetSTATUS_BOD_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *EVENTROUTER_Type) SetSTATUS_WWDT_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EVENTROUTER_Type) GetSTATUS_WWDT_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *EVENTROUTER_Type) SetSTATUS_ETH_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *EVENTROUTER_Type) GetSTATUS_ETH_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *EVENTROUTER_Type) SetSTATUS_USB0_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *EVENTROUTER_Type) GetSTATUS_USB0_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *EVENTROUTER_Type) SetSTATUS_USB1_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *EVENTROUTER_Type) GetSTATUS_USB1_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *EVENTROUTER_Type) SetSTATUS_SDMMC_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x800)|value<<11)
}
func (o *EVENTROUTER_Type) GetSTATUS_SDMMC_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x800) >> 11
}
func (o *EVENTROUTER_Type) SetSTATUS_CAN_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *EVENTROUTER_Type) GetSTATUS_CAN_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *EVENTROUTER_Type) SetSTATUS_TIM2_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *EVENTROUTER_Type) GetSTATUS_TIM2_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}
func (o *EVENTROUTER_Type) SetSTATUS_TIM6_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *EVENTROUTER_Type) GetSTATUS_TIM6_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000) >> 14
}
func (o *EVENTROUTER_Type) SetSTATUS_QEI_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *EVENTROUTER_Type) GetSTATUS_QEI_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000) >> 15
}
func (o *EVENTROUTER_Type) SetSTATUS_TIM14_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *EVENTROUTER_Type) GetSTATUS_TIM14_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10000) >> 16
}
func (o *EVENTROUTER_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x60000)|value<<17)
}
func (o *EVENTROUTER_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x60000) >> 17
}
func (o *EVENTROUTER_Type) SetSTATUS_RESET_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *EVENTROUTER_Type) GetSTATUS_RESET_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000) >> 19
}
func (o *EVENTROUTER_Type) SetSTATUS_BODRESET_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100000)|value<<20)
}
func (o *EVENTROUTER_Type) GetSTATUS_BODRESET_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100000) >> 20
}
func (o *EVENTROUTER_Type) SetSTATUS_DPDRESET_ST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200000)|value<<21)
}
func (o *EVENTROUTER_Type) GetSTATUS_DPDRESET_ST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200000) >> 21
}
func (o *EVENTROUTER_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xffc00000)|value<<22)
}
func (o *EVENTROUTER_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xffc00000) >> 22
}

// EVENTROUTER.ENABLE: Event Enable register
func (o *EVENTROUTER_Type) SetENABLE_WAKEUP0_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *EVENTROUTER_Type) GetENABLE_WAKEUP0_EN() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}
func (o *EVENTROUTER_Type) SetENABLE_WAKEUP1_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x2)|value<<1)
}
func (o *EVENTROUTER_Type) GetENABLE_WAKEUP1_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x2) >> 1
}
func (o *EVENTROUTER_Type) SetENABLE_WAKEUP2_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x4)|value<<2)
}
func (o *EVENTROUTER_Type) GetENABLE_WAKEUP2_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x4) >> 2
}
func (o *EVENTROUTER_Type) SetENABLE_WAKEUP3_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x8)|value<<3)
}
func (o *EVENTROUTER_Type) GetENABLE_WAKEUP3_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x8) >> 3
}
func (o *EVENTROUTER_Type) SetENABLE_ATIMER_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x10)|value<<4)
}
func (o *EVENTROUTER_Type) GetENABLE_ATIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x10) >> 4
}
func (o *EVENTROUTER_Type) SetENABLE_RTC_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x20)|value<<5)
}
func (o *EVENTROUTER_Type) GetENABLE_RTC_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x20) >> 5
}
func (o *EVENTROUTER_Type) SetENABLE_BOD_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x40)|value<<6)
}
func (o *EVENTROUTER_Type) GetENABLE_BOD_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x40) >> 6
}
func (o *EVENTROUTER_Type) SetENABLE_WWDT_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x80)|value<<7)
}
func (o *EVENTROUTER_Type) GetENABLE_WWDT_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x80) >> 7
}
func (o *EVENTROUTER_Type) SetENABLE_ETH_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x100)|value<<8)
}
func (o *EVENTROUTER_Type) GetENABLE_ETH_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x100) >> 8
}
func (o *EVENTROUTER_Type) SetENABLE_USB0_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x200)|value<<9)
}
func (o *EVENTROUTER_Type) GetENABLE_USB0_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x200) >> 9
}
func (o *EVENTROUTER_Type) SetENABLE_USB1_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x400)|value<<10)
}
func (o *EVENTROUTER_Type) GetENABLE_USB1_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x400) >> 10
}
func (o *EVENTROUTER_Type) SetENABLE_SDMMC_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x800)|value<<11)
}
func (o *EVENTROUTER_Type) GetENABLE_SDMMC_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x800) >> 11
}
func (o *EVENTROUTER_Type) SetENABLE_CAN_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1000)|value<<12)
}
func (o *EVENTROUTER_Type) GetENABLE_CAN_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x1000) >> 12
}
func (o *EVENTROUTER_Type) SetENABLE_TIM2_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x2000)|value<<13)
}
func (o *EVENTROUTER_Type) GetENABLE_TIM2_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x2000) >> 13
}
func (o *EVENTROUTER_Type) SetENABLE_TIM6_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x4000)|value<<14)
}
func (o *EVENTROUTER_Type) GetENABLE_TIM6_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x4000) >> 14
}
func (o *EVENTROUTER_Type) SetENABLE_QEI_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x8000)|value<<15)
}
func (o *EVENTROUTER_Type) GetENABLE_QEI_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x8000) >> 15
}
func (o *EVENTROUTER_Type) SetENABLE_TIM14_EN(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x10000)|value<<16)
}
func (o *EVENTROUTER_Type) GetENABLE_TIM14_EN() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x10000) >> 16
}
func (o *EVENTROUTER_Type) SetENABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x60000)|v