/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public abstract class Places {
    private static final Logger LOG = Logger.getLogger(Places.class.getName());

    public static synchronized File getUserDirectory() {
        Places places = (Places)Lookup.getDefault().lookup(Places.class);
        if (places != null) {
            return places.findUserDirectory();
        }
        String string = System.getProperty("netbeans.user");
        return string != null ? new File(string) : null;
    }

    public static synchronized File getCacheDirectory() {
        File file;
        Places places = (Places)Lookup.getDefault().lookup(Places.class);
        if (places != null && (file = places.findCacheDirectory()) != null) {
            return file;
        }
        file = Places.getUserDirectory();
        if (file != null) {
            return new File(new File(file, "var"), "cache");
        }
        return new File(System.getProperty("java.io.tmpdir"), "nbcache");
    }

    public static File getCacheSubdirectory(String string) {
        File file = new File(Places.getCacheDirectory(), string);
        if (!file.isDirectory() && !file.mkdirs()) {
            LOG.log(Level.WARNING, "could not create {0}", file);
        }
        return file;
    }

    public static File getCacheSubfile(String string) {
        File file = new File(Places.getCacheDirectory(), string);
        File file2 = file.getParentFile();
        if (!file2.isDirectory() && !file2.mkdirs()) {
            LOG.log(Level.WARNING, "could not create {0}", file2);
        }
        return file;
    }

    protected Places() {
    }

    protected abstract File findCacheDirectory();

    protected abstract File findUserDirectory();
}

