/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.ui.cpu.LiveCPUView;
import org.openide.util.Lookup;

public class LiveCPUViewUpdater {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private CCTHandler handler;
    private final LiveCPUView cpuView;
    private final ProfilerClient client;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LiveCPUViewUpdater(LiveCPUView cpuView, ProfilerClient client) {
        this.cpuView = cpuView;
        this.client = client;
        this.handler = CCTHandler.registerUpdater(this);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    public void update() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.forceRefresh || !this.paused && this.cpuView.getLastUpdate() + 1400L < System.currentTimeMillis()) {
            this.client.forceObtainedResultsDump(true);
        }
    }

    public void cleanup() {
        this.handler.unregisterUpdater(this);
        this.handler = null;
    }

    private void updateData() throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        if (!this.forceRefresh && (this.paused || this.cpuView.getLastUpdate() + 900L > System.currentTimeMillis())) {
            return;
        }
        boolean sampling = this.client.getCurrentInstrType() == 2;
        CPUResultsSnapshot data = this.client.getStatus().getInstrMethodClasses() == null ? null : this.client.getCPUProfilingResultsSnapshot(false);
        this.cpuView.setData(data, sampling);
        this.forceRefresh = false;
    }

    private void resetData() {
        this.cpuView.resetData();
    }

    public static class CCTHandler
    implements CPUCCTProvider.Listener {
        private final List<LiveCPUViewUpdater> updaters = new ArrayList<LiveCPUViewUpdater>();

        public static CCTHandler registerUpdater(LiveCPUViewUpdater updater) {
            CCTHandler handler = (CCTHandler)Lookup.getDefault().lookup(CCTHandler.class);
            handler.updaters.add(updater);
            return handler;
        }

        public void unregisterUpdater(LiveCPUViewUpdater updater) {
            this.updaters.remove(updater);
        }

        public final void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (!empty) {
                for (LiveCPUViewUpdater updater : this.updaters) {
                    try {
                        updater.updateData();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    }
                    catch (CPUResultsSnapshot.NoDataAvailableException ex) {
                        Logger.getLogger(LiveCPUView.class.getName()).log(Level.FINE, null, ex);
                    }
                }
            }
        }

        public final void cctReset() {
            for (LiveCPUViewUpdater updater : this.updaters) {
                updater.resetData();
            }
        }
    }
}

